/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.cf;

import com.sap.engine.library.bytecode.cf.CFException;
import com.sap.engine.library.bytecode.cf.CFNode;
import com.sap.engine.library.bytecode.cf.CPInfo;
import com.sap.engine.library.bytecode.cf.CodeAttribute;
import com.sap.engine.library.bytecode.cf.Constants;
import com.sap.engine.library.bytecode.cf.Instruction;
import com.sap.engine.library.bytecode.cf.LocalVariable;
import com.sap.engine.library.bytecode.cf.LocalVariableTableAttribute;

public final class LocalVariableTableEntry
extends CFNode {
    private CodeAttribute ownerCodeAttribute;
    private LocalVariableTableAttribute owner;
    private String startPCLabel;
    private String endPCLabel;
    private CPInfo name;
    private CPInfo descriptor;
    private LocalVariable localVariable;

    LocalVariableTableEntry(LocalVariableTableAttribute owner, CodeAttribute ownerCodeAttribute, String startPCLabel, String endPCLabel, CPInfo name, CPInfo descriptor, LocalVariable localVariable) {
        if (owner == null) {
            throw new CFException(69, "owner");
        }
        if (ownerCodeAttribute == null) {
            throw new CFException(69, "ownerCodeAttribute");
        }
        this.owner = owner;
        this.ownerCodeAttribute = ownerCodeAttribute;
        this.startPCLabel = startPCLabel;
        this.endPCLabel = endPCLabel;
        this.name = name;
        this.descriptor = descriptor;
        this.localVariable = localVariable;
    }

    public Instruction getStartPC() {
        return this.ownerCodeAttribute.getInstructionByLabel(this.startPCLabel);
    }

    public Instruction getEndPC() {
        return this.ownerCodeAttribute.getInstructionByLabel(this.endPCLabel);
    }

    public CPInfo getName() {
        return this.name;
    }

    public CPInfo getDescriptor() {
        return this.descriptor;
    }

    public LocalVariable getLocalVariable() {
        return this.localVariable;
    }

    public CFNode getParentNode() {
        return this.owner;
    }

    public CFNode[] getChildNodes() {
        return Constants.CF_NODE_ARRAY_0;
    }
}

