/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.cf;

import com.sap.engine.library.bytecode.cf.AttributeInfo;
import com.sap.engine.library.bytecode.cf.CFException;
import com.sap.engine.library.bytecode.cf.CFFactory;
import com.sap.engine.library.bytecode.cf.CPInfo;
import com.sap.engine.library.bytecode.cf.CodeAttribute;
import com.sap.engine.library.bytecode.cf.FieldInfo;
import com.sap.engine.library.bytecode.cf.LocalVariable;
import com.sap.engine.library.bytecode.cf.LocalVariableTableEntry;
import com.sap.engine.library.bytecode.misc.Debug;

public final class LocalVariableTableAttribute
extends AttributeInfo {
    private final CFFactory factory;
    private final CodeAttribute ownerCodeAttribute;
    private LocalVariableTableEntry[] entries = new LocalVariableTableEntry[16];
    private int nEntries;

    LocalVariableTableAttribute(CFFactory factory, CodeAttribute codeAttribute) {
        this.factory = factory;
        this.ownerCodeAttribute = codeAttribute;
    }

    public String getName() {
        return "LocalVariableTable";
    }

    public int getNEntries() {
        return this.nEntries;
    }

    public LocalVariableTableEntry getEntry(int index) {
        if (Debug.DEBUG_CF && (index < 0 || index >= this.nEntries)) {
            throw new CFException(14);
        }
        return this.entries[index];
    }

    public LocalVariableTableEntry[] getEntriesArray() {
        LocalVariableTableEntry[] r = new LocalVariableTableEntry[this.nEntries];
        System.arraycopy(this.entries, 0, r, 0, this.nEntries);
        return r;
    }

    public LocalVariableTableEntry addEntry(String startPCLabel, String endPCLabel, CPInfo name, CPInfo descriptor, LocalVariable localVariable) {
        if (Debug.DEBUG_CF) {
            if (startPCLabel == null || endPCLabel == null || name == null || descriptor == null || localVariable == null) {
                throw new CFException(14);
            }
            if (name.getTag() != 1) {
                throw new CFException(16);
            }
            if (descriptor.getTag() != 1) {
                throw new CFException(16);
            }
            FieldInfo.checkFieldDescriptor(descriptor.getString());
        }
        LocalVariableTableEntry entry = new LocalVariableTableEntry(this, this.ownerCodeAttribute, startPCLabel, endPCLabel, name, descriptor, localVariable);
        if (this.entries.length == this.nEntries) {
            LocalVariableTableEntry[] old = this.entries;
            this.entries = new LocalVariableTableEntry[this.nEntries * 2];
            System.arraycopy(old, 0, this.entries, 0, this.nEntries);
        }
        this.entries[this.nEntries++] = entry;
        return entry;
    }
}

