/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.cf;

import com.sap.engine.library.bytecode.cf.AttributeInfo;
import com.sap.engine.library.bytecode.cf.CFException;
import com.sap.engine.library.bytecode.cf.CFFactory;
import com.sap.engine.library.bytecode.cf.CodeAttribute;
import com.sap.engine.library.bytecode.cf.Instruction;
import com.sap.engine.library.bytecode.misc.Debug;

public final class LineNumberTableAttribute
extends AttributeInfo {
    private CFFactory factory;
    private CodeAttribute ownerCodeAttribute;
    private int nLineNumberEntries;
    private String[] startPCLabels;
    private int[] lineNumbers;

    LineNumberTableAttribute(CFFactory factory) {
        this.factory = factory;
    }

    public String getName() {
        return "LineNumberTable";
    }

    LineNumberTableAttribute init(CodeAttribute ownerCodeAttribute, String[] startPCLabels, int[] lineNumbers) {
        if (Debug.DEBUG_CF && startPCLabels.length != lineNumbers.length) {
            throw new CFException(14);
        }
        this.ownerCodeAttribute = ownerCodeAttribute;
        this.nLineNumberEntries = startPCLabels.length;
        this.startPCLabels = startPCLabels;
        this.lineNumbers = lineNumbers;
        return this;
    }

    public Instruction[] getStartPCsArray() {
        Instruction[] r = new Instruction[this.nLineNumberEntries];
        int i = 0;
        while (i < this.nLineNumberEntries) {
            r[i] = this.ownerCodeAttribute.getInstructionByLabel(this.startPCLabels[i]);
            if (Debug.DEBUG_CF && r[i] == null) {
                throw new CFException(18, this.startPCLabels[i]);
            }
            ++i;
        }
        return r;
    }

    public int[] getLineNumbersArray() {
        int[] r = new int[this.nLineNumberEntries];
        System.arraycopy(this.lineNumbers, 0, r, 0, this.nLineNumberEntries);
        return r;
    }

    public CodeAttribute getOwnerCodeAttribute() {
        return this.ownerCodeAttribute;
    }
}

