/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.cf;

import com.sap.engine.library.bytecode.cf.AbstractSwitchTable;
import com.sap.engine.library.bytecode.cf.CFException;
import com.sap.engine.library.bytecode.cf.CFFactory;
import com.sap.engine.library.bytecode.cf.CFNode;
import com.sap.engine.library.bytecode.cf.CPInfo;
import com.sap.engine.library.bytecode.cf.CodeAttribute;
import com.sap.engine.library.bytecode.cf.Constants;
import com.sap.engine.library.bytecode.cf.LocalVariable;
import com.sap.engine.library.bytecode.cf.LookupSwitchTable;
import com.sap.engine.library.bytecode.cf.TableSwitchTable;
import com.sap.engine.library.bytecode.misc.Debug;

public final class Instruction
extends CFNode
implements Constants {
    private static final int[][] OPTIMIZED_OPCODES = new int[256][];
    private CodeAttribute ownerCodeAttribute;
    private int index = -1;
    private int opcode = -1;
    private int lineNumber = 0;
    private int originalOffset = -1;
    private Object operand;

    Instruction(CFFactory factory, CodeAttribute owner) {
        this.ownerCodeAttribute = owner;
        this.opcode = 0;
    }

    public Instruction init(int opcode) {
        if (Debug.DEBUG_CF && Constants.INSTRUCTION_OPERANDS[opcode] != 1) {
            throw new CFException(14);
        }
        this.opcode = opcode;
        this.operand = null;
        return this;
    }

    public int getIndex() {
        return this.index;
    }

    void setIndex(int index) {
        this.index = index;
    }

    public int getLineNumber() {
        return this.lineNumber;
    }

    public void setLineNumber(int lineNumber) {
        if (Debug.DEBUG_CF && lineNumber < 0) {
            throw new CFException(14);
        }
        this.lineNumber = lineNumber;
    }

    public int getOriginalOffset() {
        return this.originalOffset;
    }

    void setOriginalOffset(int originalOffset) {
        this.originalOffset = originalOffset;
    }

    public Instruction init(int opcode, LocalVariable lv) {
        int lvIndex;
        if (Debug.DEBUG_CF && (Constants.INSTRUCTION_OPERANDS[opcode] != 4 || lv == null)) {
            throw new CFException(14);
        }
        if (OPTIMIZED_OPCODES[opcode] != null && (lvIndex = lv.getIndex()) < OPTIMIZED_OPCODES[opcode].length) {
            this.opcode = OPTIMIZED_OPCODES[opcode][lvIndex];
            this.operand = null;
            return this;
        }
        this.opcode = opcode;
        this.operand = lv;
        return this;
    }

    Instruction init(int opcode, Instruction branch) {
        if (Debug.DEBUG_CF && Constants.INSTRUCTION_OPERANDS[opcode] != 5) {
            throw new CFException(14);
        }
        this.opcode = opcode;
        throw new Error();
    }

    public Instruction init(int opcode, String label) {
        if (Debug.DEBUG_CF && label == null) {
            throw new CFException(14);
        }
        this.opcode = opcode;
        this.operand = label;
        return this;
    }

    public Instruction init(int opcode, int x) {
        if (Debug.DEBUG_CF && Constants.INSTRUCTION_OPERANDS[opcode] != 2) {
            throw new CFException(14);
        }
        this.opcode = opcode;
        this.operand = this.ownerCodeAttribute.getFactory().createInteger(x);
        return this;
    }

    public Instruction init(int opcode, CPInfo x) {
        if (Debug.DEBUG_CF && (Constants.INSTRUCTION_OPERANDS[opcode] != 3 || x == null)) {
            throw new CFException(14);
        }
        if (opcode == 18 || opcode == 19 || opcode == 20) {
            int index = x.getIndex();
            int tag = x.getTag();
            this.opcode = tag == 5 || tag == 6 ? 20 : (index > 255 ? 19 : 18);
        } else {
            this.opcode = opcode;
        }
        this.operand = x;
        return this;
    }

    public Instruction init(int opcode, LocalVariable lv, int x) {
        if (Debug.DEBUG_CF && Constants.INSTRUCTION_OPERANDS[opcode] != 8) {
            throw new CFException(14);
        }
        this.opcode = opcode;
        this.operand = new Object[]{lv, this.ownerCodeAttribute.getFactory().createInteger(x)};
        return this;
    }

    public Instruction init(int opcode, CPInfo cpInfo, int x) {
        if (Debug.DEBUG_CF && (Constants.INSTRUCTION_OPERANDS[opcode] != 9 || cpInfo == null)) {
            throw new CFException(14);
        }
        this.opcode = opcode;
        this.operand = new Object[]{cpInfo, this.ownerCodeAttribute.getFactory().createInteger(x)};
        return this;
    }

    Instruction init(int opcode, TableSwitchTable t) {
        if (Constants.INSTRUCTION_OPERANDS[opcode] != 6) {
            throw new CFException(14);
        }
        this.opcode = opcode;
        this.operand = t;
        return this;
    }

    Instruction init(int opcode, LookupSwitchTable t) {
        if (Constants.INSTRUCTION_OPERANDS[opcode] != 7) {
            throw new CFException(14);
        }
        this.opcode = opcode;
        this.operand = t;
        return this;
    }

    public int getOpcode() {
        return this.opcode;
    }

    public String getMnemonic() {
        try {
            return Constants.MNEMONIC[this.opcode];
        }
        catch (ArrayIndexOutOfBoundsException ae) {
            return "???(opcode=" + this.opcode + ")";
        }
    }

    public boolean isReturn() {
        switch (this.opcode) {
            case 172: 
            case 173: 
            case 174: 
            case 175: 
            case 176: 
            case 177: {
                return true;
            }
        }
        return false;
    }

    public Instruction getOperandInstruction() {
        try {
            return this.ownerCodeAttribute.getInstructionByLabel((String)this.operand, true);
        }
        catch (ClassCastException cce) {
            throw new CFException(19, "getOperandInstruction()");
        }
    }

    public int getOperandInt() {
        try {
            switch (this.opcode) {
                case 16: 
                case 17: 
                case 188: {
                    return (Integer)this.operand;
                }
                case 132: 
                case 185: 
                case 197: {
                    return (Integer)((Object[])this.operand)[1];
                }
            }
        }
        catch (ClassCastException classCastException) {
            // empty catch block
        }
        throw new CFException(19, "getOperandInt()");
    }

    public LocalVariable getOperandLocalVariable() {
        if (this.opcode == 132) {
            return (LocalVariable)((Object[])this.operand)[0];
        }
        try {
            return (LocalVariable)this.operand;
        }
        catch (ClassCastException cce) {
            throw new CFException(19, "getOperandLocalVariable()");
        }
    }

    public AbstractSwitchTable getOperandAbstractSwitchTable() {
        try {
            return (AbstractSwitchTable)this.operand;
        }
        catch (ClassCastException cce) {
            throw new CFException(19, "getOperandAbstractSwitchTable()");
        }
    }

    public TableSwitchTable getOperandTableSwitchTable() {
        try {
            return (TableSwitchTable)this.operand;
        }
        catch (ClassCastException cce) {
            throw new CFException(19, "getOperandTableSwitchTable()");
        }
    }

    public LookupSwitchTable getOperandLookupSwitchTable() {
        try {
            return (LookupSwitchTable)this.operand;
        }
        catch (ClassCastException cce) {
            throw new CFException(19, "getOperandLookupSwitchTable()");
        }
    }

    public CPInfo getOperandCPInfo() {
        if (this.opcode == 185 || this.opcode == 197) {
            return (CPInfo)((Object[])this.operand)[0];
        }
        try {
            return (CPInfo)this.operand;
        }
        catch (ClassCastException cce) {
            throw new CFException(19, "getOperandCPInfo()");
        }
    }

    public CodeAttribute getOwnerCodeAttribute() {
        return this.ownerCodeAttribute;
    }

    public String toString() {
        StringBuffer b = new StringBuffer();
        b.append(this.getMnemonic());
        if (this.operand != null && !(this.operand instanceof AbstractSwitchTable)) {
            if (this.operand instanceof Object[]) {
                Object[] x = (Object[])this.operand;
                b.append(' ').append(x[0]).append(' ').append(x[1]);
            } else if (this.operand instanceof Instruction) {
                b.append(" [").append(((Instruction)this.operand).getIndex()).append("]");
            } else {
                b.append(' ').append(this.operand);
            }
        }
        return b.toString();
    }

    int getLength(int offset) {
        switch (this.opcode) {
            case 170: {
                TableSwitchTable table = (TableSwitchTable)this.operand;
                int padding = 4 - (offset & 3) & 3;
                return padding + 12 + 4 * table.getNBranches();
            }
            case 171: {
                LookupSwitchTable table = (LookupSwitchTable)this.operand;
                int padding = 4 - (offset & 3) & 3;
                return padding + 8 + 8 * table.getNBranches();
            }
            case 132: {
                Object[] operandArray = (Object[])this.operand;
                int operand0 = ((LocalVariable)operandArray[0]).getIndex();
                int operand1 = (Integer)operandArray[1];
                return operand0 > 255 || operand1 > 255 ? 6 : 3;
            }
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 169: {
                int operand0 = ((LocalVariable)this.operand).getIndex();
                return operand0 > 255 ? 4 : 2;
            }
            case 167: 
            case 168: 
            case 200: 
            case 201: {
                return 3;
            }
        }
        return Constants.INSTRUCTION_LENGTH[this.opcode];
    }

    public boolean canBeWide() {
        switch (this.opcode) {
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 54: 
            case 55: 
            case 56: 
            case 57: 
            case 58: 
            case 132: 
            case 169: {
                return true;
            }
        }
        return false;
    }

    public Instruction initLDC(CPInfo x) {
        int tag;
        if (Debug.DEBUG_CF && (tag = x.getTag()) != 6 && tag != 4 && tag != 3 && tag != 5 && tag != 8) {
            throw new CFException(14);
        }
        tag = x.getTag();
        this.opcode = tag == 5 || tag == 6 ? 20 : (x.getIndex() > 255 ? 19 : 18);
        this.operand = x;
        return this;
    }

    public void init(int opcode, AbstractSwitchTable abstractSwitchTable) {
        if (opcode != 170 && opcode != 171) {
            throw new CFException(14);
        }
        this.opcode = opcode;
        this.operand = abstractSwitchTable;
    }

    public int getStackDecrease() {
        if (Constants.STACK_DECREASE[this.opcode] != -1) {
            return Constants.STACK_DECREASE[this.opcode];
        }
        switch (this.opcode) {
            case 179: {
                String d = ((CPInfo)this.operand).getValueNameAndType().getValueDescriptor().toPlainString();
                return d.equals("J") || d.equals("D") ? 2 : 1;
            }
            case 181: {
                String d = ((CPInfo)this.operand).getValueNameAndType().getValueDescriptor().toPlainString();
                return d.equals("J") || d.equals("D") ? 3 : 2;
            }
            case 185: {
                String d = ((CPInfo)((Object[])this.operand)[0]).getValueNameAndType().getValueDescriptor().toPlainString();
                return Instruction.getArgumentsSize(d, true);
            }
            case 182: 
            case 183: 
            case 184: {
                String d = ((CPInfo)this.operand).getValueNameAndType().getValueDescriptor().toPlainString();
                return Instruction.getArgumentsSize(d, this.opcode != 184);
            }
            case 197: {
                int dimensions = (Integer)((Object[])this.operand)[1];
                return dimensions;
            }
        }
        throw new CFException(87, new Object[]{Constants.MNEMONIC[this.opcode], new Integer(this.opcode)});
    }

    public int getStackIncrease() {
        if (Constants.STACK_INCREASE[this.opcode] != -1) {
            return Constants.STACK_INCREASE[this.opcode];
        }
        switch (this.opcode) {
            case 178: 
            case 180: {
                String d = ((CPInfo)this.operand).getValueNameAndType().getValueDescriptor().toPlainString();
                return d.equals("J") || d.equals("D") ? 2 : 1;
            }
            case 185: {
                String d = ((CPInfo)((Object[])this.operand)[0]).getValueNameAndType().getValueDescriptor().toPlainString();
                return Instruction.getReturnTypeSize(d);
            }
            case 182: 
            case 183: 
            case 184: {
                String d = ((CPInfo)this.operand).getValueNameAndType().getValueDescriptor().toPlainString();
                return Instruction.getReturnTypeSize(d);
            }
            case 197: {
                return (Integer)((Object[])this.operand)[0];
            }
        }
        throw new CFException(88, new Object[]{Constants.MNEMONIC[this.opcode], new Integer(this.opcode)});
    }

    private static int getReturnTypeSize(String methodDescriptor) {
        String s = methodDescriptor.substring(methodDescriptor.indexOf(41) + 1);
        return s.equals("J") || s.equals("D") ? 2 : (s.equals("V") ? 0 : 1);
    }

    private static int getArgumentsSize(String methodDescriptor, boolean countThisPointer) {
        int i = 1;
        int r = countThisPointer ? 1 : 0;
        boolean isArray = false;
        block6: while (true) {
            switch (methodDescriptor.charAt(i)) {
                case ')': {
                    return r;
                }
                case 'L': {
                    i = methodDescriptor.indexOf(59, i) + 1;
                    ++r;
                    isArray = false;
                    continue block6;
                }
                case '[': {
                    ++i;
                    isArray = true;
                    continue block6;
                }
                case 'D': 
                case 'J': {
                    ++i;
                    r += isArray ? 1 : 2;
                    isArray = false;
                    continue block6;
                }
            }
            ++i;
            ++r;
            isArray = false;
        }
    }

    public Instruction getPreviousInstruction() {
        if (this.index == 0) {
            return null;
        }
        return this.ownerCodeAttribute.getInstructionByIndex(this.index - 1);
    }

    public Instruction getNextInstruction() {
        if (this.index == this.ownerCodeAttribute.getNInstructions() - 1) {
            return null;
        }
        return this.ownerCodeAttribute.getInstructionByIndex(this.index + 1);
    }

    public Instruction addLabel(String label) {
        this.ownerCodeAttribute.addLabel(label, this);
        return this;
    }

    public Instruction cloneInstruction(String labelPrefix) {
        Instruction r = this.ownerCodeAttribute.createInstruction();
        r.opcode = this.opcode;
        switch (Constants.INSTRUCTION_OPERANDS[this.opcode]) {
            case 5: {
                r.operand = labelPrefix + this.ownerCodeAttribute.getCanonicalLabel((String)this.operand);
                break;
            }
            case 6: 
            case 7: {
                r.operand = ((AbstractSwitchTable)this.operand).cloneAbstractSwitchTable(this, labelPrefix);
                break;
            }
            default: {
                r.operand = this.operand;
            }
        }
        String canonicalLabel = this.ownerCodeAttribute.getCanonicalLabelOfInstruction(this);
        if (canonicalLabel != null) {
            r.addLabel(labelPrefix + canonicalLabel);
        }
        r.setLineNumber(this.getLineNumber());
        return r;
    }

    void checkBranches() {
        switch (Constants.INSTRUCTION_OPERANDS[this.opcode]) {
            case 5: {
                this.ownerCodeAttribute.getInstructionByLabel((String)this.operand, true);
                break;
            }
            case 6: 
            case 7: {
                ((AbstractSwitchTable)this.operand).checkBranches();
            }
        }
    }

    public CFNode getParentNode() {
        return this.ownerCodeAttribute;
    }

    public CFNode[] getChildNodes() {
        if (this.opcode == 170 || this.opcode == 171) {
            return new CFNode[]{(AbstractSwitchTable)this.operand};
        }
        return Constants.CF_NODE_ARRAY_0;
    }

    static {
        Instruction.OPTIMIZED_OPCODES[21] = new int[]{26, 27, 28, 29};
        Instruction.OPTIMIZED_OPCODES[22] = new int[]{30, 31, 32, 33};
        Instruction.OPTIMIZED_OPCODES[23] = new int[]{34, 35, 36, 37};
        Instruction.OPTIMIZED_OPCODES[24] = new int[]{38, 39, 40, 41};
        Instruction.OPTIMIZED_OPCODES[25] = new int[]{42, 43, 44, 45};
        Instruction.OPTIMIZED_OPCODES[54] = new int[]{59, 60, 61, 62};
        Instruction.OPTIMIZED_OPCODES[55] = new int[]{63, 64, 65, 66};
        Instruction.OPTIMIZED_OPCODES[56] = new int[]{67, 68, 69, 70};
        Instruction.OPTIMIZED_OPCODES[57] = new int[]{71, 72, 73, 74};
        Instruction.OPTIMIZED_OPCODES[58] = new int[]{75, 76, 77, 78};
    }
}

