/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.cf;

import com.sap.engine.library.bytecode.cf.AttributeInfo;
import com.sap.engine.library.bytecode.cf.CPInfo;
import com.sap.engine.library.bytecode.cf.ClassFile;
import com.sap.engine.library.bytecode.cf.InnerClassesAttributeEntry;

public final class InnerClassesAttribute
extends AttributeInfo {
    private static final String S_INNER_CLASSES = "InnerClasses";
    private ClassFile owner;
    private int nEntries = 0;
    private InnerClassesAttributeEntry[] entries = new InnerClassesAttributeEntry[8];

    InnerClassesAttribute(ClassFile owner) {
        this.owner = owner;
    }

    void init(ClassFile owner) {
        this.owner = owner;
    }

    public String getName() {
        return S_INNER_CLASSES;
    }

    public InnerClassesAttributeEntry addEntry(CPInfo innerClass, CPInfo outerClass, CPInfo innerName, int innerAccessFlags) {
        if (this.nEntries == this.entries.length) {
            InnerClassesAttributeEntry[] entriesOld = this.entries;
            this.entries = new InnerClassesAttributeEntry[2 * this.nEntries];
            System.arraycopy(entriesOld, 0, this.entries, 0, this.nEntries);
        }
        InnerClassesAttributeEntry entry = new InnerClassesAttributeEntry(this, innerClass, outerClass, innerName, innerAccessFlags);
        this.entries[this.nEntries++] = entry;
        return entry;
    }

    public int getNEntries() {
        return this.nEntries;
    }

    public InnerClassesAttributeEntry getEntry(int index) {
        return this.entries[index];
    }

    public InnerClassesAttributeEntry[] getEntries() {
        InnerClassesAttributeEntry[] r = new InnerClassesAttributeEntry[this.nEntries];
        System.arraycopy(this.entries, 0, r, 0, this.nEntries);
        return r;
    }
}

