/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.cf;

import com.sap.engine.library.bytecode.cf.CFException;
import com.sap.engine.library.bytecode.cf.CFFactory;
import com.sap.engine.library.bytecode.cf.CPInfo;
import com.sap.engine.library.bytecode.cf.ClassFile;
import com.sap.engine.library.bytecode.cf.ConstantValueAttribute;
import com.sap.engine.library.bytecode.cf.MemberInfo;

public final class FieldInfo
extends MemberInfo {
    FieldInfo(CFFactory factory, ClassFile ownerClassFile, int accessFlags, CPInfo name, CPInfo descriptor) {
        super(factory, ownerClassFile, accessFlags, name, descriptor);
    }

    public ConstantValueAttribute getConstantValueAttribute() {
        return (ConstantValueAttribute)super.getAttribute("ConstantValue");
    }

    public ConstantValueAttribute createConstantValueAttribute() {
        ConstantValueAttribute cva = this.getConstantValueAttribute();
        if (cva != null) {
            return cva;
        }
        cva = new ConstantValueAttribute();
        super.addAttribute(cva);
        return cva;
    }

    public CPInfo getConstantValue() {
        ConstantValueAttribute cva = this.getConstantValueAttribute();
        if (cva == null) {
            return null;
        }
        return cva.getConstantValue();
    }

    public void setConstantValue(CPInfo x) {
        this.createConstantValueAttribute().setConstantValue(x);
    }

    public static void checkFieldDescriptor(String s) {
        if (s == null) {
            throw new CFException(13);
        }
        int ls = s.length();
        int i = 0;
        while (i < ls && s.charAt(i) == '[') {
            ++i;
        }
        if (i == ls) {
            throw new CFException(12, s);
        }
        char ch = s.charAt(i);
        switch (ch) {
            case 'B': 
            case 'C': 
            case 'D': 
            case 'F': 
            case 'I': 
            case 'J': 
            case 'S': 
            case 'Z': {
                if (i != ls - 1) {
                    throw new CFException(12, s);
                }
                return;
            }
            case 'L': {
                int indexOfSemiColon = s.indexOf(59);
                if (indexOfSemiColon == ls - 1 && indexOfSemiColon > i + 1) break;
                throw new CFException(12, s);
            }
            default: {
                throw new CFException(12, s);
            }
        }
    }

    public static String convertTypeToJLS(String fieldDescriptor) {
        FieldInfo.checkFieldDescriptor(fieldDescriptor);
        int dimension = 0;
        while (fieldDescriptor.startsWith("[")) {
            ++dimension;
            fieldDescriptor = fieldDescriptor.substring(1);
        }
        StringBuffer buffer = new StringBuffer();
        switch (fieldDescriptor.charAt(0)) {
            case 'B': {
                buffer.append("byte");
                break;
            }
            case 'C': {
                buffer.append("char");
                break;
            }
            case 'D': {
                buffer.append("double");
                break;
            }
            case 'F': {
                buffer.append("float");
                break;
            }
            case 'I': {
                buffer.append("int");
                break;
            }
            case 'J': {
                buffer.append("long");
                break;
            }
            case 'S': {
                buffer.append("short");
                break;
            }
            case 'Z': {
                buffer.append("boolean");
                break;
            }
            case 'L': {
                buffer.append(fieldDescriptor.substring(1, fieldDescriptor.length() - 1).replace('/', '.'));
                break;
            }
            default: {
                throw new CFException(11, fieldDescriptor);
            }
        }
        int i = 0;
        while (i < dimension) {
            buffer.append("[]");
            ++i;
        }
        return buffer.toString();
    }

    public static String convertTypeFromJLS(String jlsType) {
        if (jlsType == null) {
            throw new CFException(69, "jlsType");
        }
        if (jlsType.indexOf(32) != -1) {
            throw new CFException(20);
        }
        StringBuffer arrayPrefixBuffer = new StringBuffer();
        while (jlsType.endsWith("[]")) {
            arrayPrefixBuffer.append('[');
            jlsType = jlsType.substring(0, jlsType.length() - 2);
        }
        String arrayPrefix = arrayPrefixBuffer.toString();
        if (jlsType.equals("int")) {
            return arrayPrefix + 'I';
        }
        if (jlsType.equals("short")) {
            return arrayPrefix + 'S';
        }
        if (jlsType.equals("char")) {
            return arrayPrefix + 'C';
        }
        if (jlsType.equals("byte")) {
            return arrayPrefix + 'B';
        }
        if (jlsType.equals("boolean")) {
            return arrayPrefix + 'Z';
        }
        if (jlsType.equals("long")) {
            return arrayPrefix + 'J';
        }
        if (jlsType.equals("float")) {
            return arrayPrefix + 'F';
        }
        if (jlsType.equals("double")) {
            return arrayPrefix + 'D';
        }
        return arrayPrefix + 'L' + jlsType.replace('.', '/') + ';';
    }

    public CPInfo toCPInfo(ClassFile cf) {
        return cf.createCPInfoMemberRef(9, this.getOwnerClassFile().getName(), super.getName(), super.getDescriptor());
    }

    public String toString() {
        return "[FIELD " + this.getDescriptor() + ' ' + this.getOwnerClassFile().getName() + '.' + ' ' + this.getName() + "]";
    }
}

