/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.cf;

import com.sap.engine.library.bytecode.cf.CFException;
import com.sap.engine.library.bytecode.cf.CFNode;
import com.sap.engine.library.bytecode.cf.CPInfo;
import com.sap.engine.library.bytecode.cf.CodeAttribute;
import com.sap.engine.library.bytecode.cf.Constants;
import com.sap.engine.library.bytecode.cf.Instruction;
import com.sap.engine.library.bytecode.misc.Debug;

public final class ExceptionHandler
extends CFNode {
    private CodeAttribute ownerCodeAttribute;
    private String startPCLabel;
    private String endPCLabel;
    private boolean isEndPCInclusive;
    private String handlerPCLabel;
    private CPInfo catchType;

    private ExceptionHandler() {
    }

    ExceptionHandler(CodeAttribute ownerCodeAttribute, String startPCLabel, String endPCLabel, boolean isEndPCInclusive, String handlerPCLabel, CPInfo catchType) {
        if (Debug.DEBUG_CF) {
            if (startPCLabel == null || endPCLabel == null || handlerPCLabel == null || catchType == null) {
                throw new CFException(14);
            }
            int tag = catchType.getTag();
            if (tag != 7 && tag != 0) {
                throw new CFException(14);
            }
        }
        this.ownerCodeAttribute = ownerCodeAttribute;
        this.startPCLabel = startPCLabel;
        this.endPCLabel = endPCLabel;
        this.isEndPCInclusive = isEndPCInclusive;
        this.handlerPCLabel = handlerPCLabel;
        this.catchType = catchType;
    }

    public Instruction getStartPC() {
        return this.ownerCodeAttribute.getInstructionByLabel(this.startPCLabel);
    }

    public Instruction getHandlerPC() {
        return this.ownerCodeAttribute.getInstructionByLabel(this.handlerPCLabel);
    }

    public Instruction getEndPCExclusive() {
        Instruction x = this.ownerCodeAttribute.getInstructionByLabel(this.endPCLabel);
        if (this.isEndPCInclusive) {
            return x.getNextInstruction();
        }
        return x;
    }

    public Instruction getEndPCInclusive() {
        Instruction x = this.ownerCodeAttribute.getInstructionByLabel(this.endPCLabel);
        if (this.isEndPCInclusive) {
            return x;
        }
        return x == null ? this.ownerCodeAttribute.getLastInstruction() : x.getPreviousInstruction();
    }

    public CPInfo getCatchType() {
        return this.catchType;
    }

    public ExceptionHandler cloneExceptionHandler(String prefix) {
        ExceptionHandler r = new ExceptionHandler();
        r.ownerCodeAttribute = this.ownerCodeAttribute;
        r.startPCLabel = prefix + this.ownerCodeAttribute.getCanonicalLabel(this.startPCLabel);
        r.endPCLabel = prefix + this.ownerCodeAttribute.getCanonicalLabel(this.endPCLabel);
        r.isEndPCInclusive = this.isEndPCInclusive;
        r.handlerPCLabel = prefix + this.ownerCodeAttribute.getCanonicalLabel(this.handlerPCLabel);
        r.catchType = this.catchType;
        return r;
    }

    public CFNode getParentNode() {
        return this.ownerCodeAttribute;
    }

    public CFNode[] getChildNodes() {
        return Constants.CF_NODE_ARRAY_0;
    }

    public String toString() {
        return "ExceptionHandler[" + this.catchType.toPlainString() + "]";
    }
}

