/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.cf;

import com.sap.engine.library.bytecode.cf.AttributeContainer;
import com.sap.engine.library.bytecode.cf.AttributeInfo;
import com.sap.engine.library.bytecode.cf.Attributed;
import com.sap.engine.library.bytecode.cf.CFException;
import com.sap.engine.library.bytecode.cf.CFFactory;
import com.sap.engine.library.bytecode.cf.CPInfo;
import com.sap.engine.library.bytecode.cf.Constants;
import com.sap.engine.library.bytecode.cf.ExceptionHandler;
import com.sap.engine.library.bytecode.cf.FieldInfo;
import com.sap.engine.library.bytecode.cf.Instruction;
import com.sap.engine.library.bytecode.cf.LocalVariable;
import com.sap.engine.library.bytecode.cf.LocalVariableTableAttribute;
import com.sap.engine.library.bytecode.cf.MethodInfo;
import com.sap.engine.library.bytecode.misc.Debug;
import java.util.Enumeration;
import java.util.Hashtable;

public final class CodeAttribute
extends AttributeInfo
implements Attributed {
    private CFFactory factory;
    private MethodInfo ownerMethod;
    private Instruction[] instructions = new Instruction[128];
    private int nInstructions;
    private ExceptionHandler[] exceptionHandlers = new ExceptionHandler[8];
    private int nExceptionHandlers;
    private AttributeContainer attributeContainer = new AttributeContainer();
    private int originalMaxStack;
    private int originalMaxLocals;
    private Hashtable hLabelToInstruction = new Hashtable();
    private Hashtable hInstructionToLabel = new Hashtable();

    CodeAttribute(CFFactory factory, MethodInfo ownerMethod) {
        this.factory = factory;
        this.ownerMethod = ownerMethod;
    }

    public int getOriginalMaxLocals() {
        return this.originalMaxLocals;
    }

    void setMaxLocals(int maxLocals) {
        this.originalMaxLocals = maxLocals;
    }

    public int getOriginalMaxStack() {
        return this.originalMaxStack;
    }

    void setOriginalMaxStack(int originalMaxStack) {
        this.originalMaxStack = originalMaxStack;
    }

    void addInstruction(Instruction x) {
        if (this.nInstructions == this.instructions.length) {
            Instruction[] old = this.instructions;
            this.instructions = new Instruction[this.nInstructions * 2];
            System.arraycopy(old, 0, this.instructions, 0, this.nInstructions);
        }
        x.setIndex(this.nInstructions);
        this.instructions[this.nInstructions] = x;
        ++this.nInstructions;
    }

    public int getNInstructions() {
        return this.nInstructions;
    }

    public Instruction[] getInstructionsArray() {
        Instruction[] r = new Instruction[this.nInstructions];
        System.arraycopy(this.instructions, 0, r, 0, this.nInstructions);
        return r;
    }

    public Instruction getInstructionByIndex(int index) {
        return this.instructions[index];
    }

    public int getNExceptionHandlers() {
        return this.nExceptionHandlers;
    }

    public ExceptionHandler getExceptionHandler(int index) {
        return this.exceptionHandlers[index];
    }

    public ExceptionHandler[] getExceptionHandlersArray() {
        ExceptionHandler[] r = new ExceptionHandler[this.nExceptionHandlers];
        System.arraycopy(this.exceptionHandlers, 0, r, 0, this.nExceptionHandlers);
        return r;
    }

    public void addExceptionHandler(ExceptionHandler handler) {
        if (this.nExceptionHandlers == this.exceptionHandlers.length) {
            ExceptionHandler[] old = this.exceptionHandlers;
            this.exceptionHandlers = new ExceptionHandler[this.nExceptionHandlers * 2];
            System.arraycopy(old, 0, this.exceptionHandlers, 0, this.nExceptionHandlers);
        }
        this.exceptionHandlers[this.nExceptionHandlers] = handler;
        ++this.nExceptionHandlers;
    }

    public ExceptionHandler addExceptionHandler(String startPCLabel, String endPCLabel, boolean isEndPCInclusive, String handlerPCLabel, CPInfo catchType) {
        ExceptionHandler handler;
        if (this.nExceptionHandlers == this.exceptionHandlers.length) {
            ExceptionHandler[] old = this.exceptionHandlers;
            this.exceptionHandlers = new ExceptionHandler[this.nExceptionHandlers * 2];
            System.arraycopy(old, 0, this.exceptionHandlers, 0, this.nExceptionHandlers);
        }
        this.exceptionHandlers[this.nExceptionHandlers] = handler = new ExceptionHandler(this, startPCLabel, endPCLabel, isEndPCInclusive, handlerPCLabel, catchType);
        ++this.nExceptionHandlers;
        return handler;
    }

    public MethodInfo getOwnerMethod() {
        return this.ownerMethod;
    }

    public String getName() {
        return "Code";
    }

    public int getNAttributes() {
        return this.attributeContainer.getNAttributes();
    }

    public AttributeInfo getAttribute(int index) {
        return this.attributeContainer.getAttribute(index);
    }

    public AttributeInfo getAttribute(String name) {
        return this.attributeContainer.getAttribute(name);
    }

    public void addAttribute(AttributeInfo a) {
        this.ownerMethod.getOwnerClassFile().createCPInfoUtf8(a.getName());
        this.attributeContainer.addAttribute(a);
    }

    public AttributeInfo[] getAttributesArray() {
        return this.attributeContainer.getAttributesArray();
    }

    public void removeAttribute(String name) {
        this.attributeContainer.removeAttribute(name);
    }

    public void removeAttribute(AttributeInfo a) {
        this.attributeContainer.removeAttribute(a);
    }

    public LocalVariableTableAttribute getLocalVariableTableAttribute() {
        return (LocalVariableTableAttribute)this.getAttribute("LocalVariableTable");
    }

    public LocalVariableTableAttribute createLocalVariableTableAttribute() {
        LocalVariableTableAttribute r = this.getLocalVariableTableAttribute();
        if (r == null) {
            r = new LocalVariableTableAttribute(this.factory, this);
            this.addAttribute(r);
        }
        return r;
    }

    public Instruction getFirstInstruction() {
        if (this.nInstructions == 0) {
            throw new CFException(4);
        }
        return this.instructions[0];
    }

    public Instruction getLastInstruction() {
        if (this.nInstructions == 0) {
            throw new CFException(4);
        }
        return this.instructions[this.nInstructions - 1];
    }

    Instruction createInstruction() {
        return new Instruction(this.factory, this);
    }

    public void insert(Instruction[] x, int start, int end, int index) {
        int requiredLength;
        if (Debug.DEBUG_CF) {
            if (x == null) {
                throw new CFException(14);
            }
            if (start < 0) {
                throw new CFException(14);
            }
            if (start >= end) {
                throw new CFException(14);
            }
            if (end >= x.length) {
                throw new CFException(14);
            }
            if (index < 0) {
                throw new CFException(14);
            }
            if (index > this.nInstructions) {
                throw new CFException(14);
            }
            int i = start;
            while (i < end) {
                if (x[i] == null) {
                    throw new CFException(14);
                }
                if (x[i].getOwnerCodeAttribute() != this) {
                    throw new CFException(14);
                }
                ++i;
            }
        }
        if (this.instructions.length < (requiredLength = this.nInstructions + end - start)) {
            Instruction[] old = this.instructions;
            this.instructions = new Instruction[requiredLength + 128];
            System.arraycopy(old, 0, this.instructions, 0, this.nInstructions);
        }
        System.arraycopy(this.instructions, index, this.instructions, index + end - start, this.nInstructions - index);
        System.arraycopy(x, start, this.instructions, index, end - start);
        this.nInstructions += end - start;
        int i = 0;
        while (i < this.nInstructions) {
            this.instructions[i].setIndex(i);
            ++i;
        }
    }

    public void insertBefore(Instruction[] x, int start, int end, Instruction refInstruction) {
        int i = 0;
        while (i < this.nInstructions) {
            if (this.instructions[i] == refInstruction) {
                this.insert(x, start, end, i);
                return;
            }
            ++i;
        }
        throw new CFException(78);
    }

    public void insertAfter(Instruction[] x, int start, int end, Instruction refInstruction) {
        int i = 0;
        while (i < this.nInstructions) {
            if (this.instructions[i] == refInstruction) {
                this.insert(x, start, end, i + 1);
                return;
            }
            ++i;
        }
        throw new CFException(78);
    }

    public void insertLast(Instruction[] x, int start, int end) {
        this.insert(x, start, end, this.nInstructions);
    }

    public int calculateMaxLocals() {
        int max = this.ownerMethod.getNInitialOccupiedLocalVariables();
        int i = 0;
        while (i < this.nInstructions) {
            int lv;
            Instruction x = this.instructions[i];
            int opcode = x.getOpcode();
            switch (opcode) {
                case 21: 
                case 23: 
                case 25: 
                case 54: 
                case 56: 
                case 58: 
                case 169: {
                    lv = x.getOperandLocalVariable().getIndex();
                    break;
                }
                case 22: 
                case 24: 
                case 55: 
                case 57: {
                    lv = x.getOperandLocalVariable().getIndex() + 1;
                    break;
                }
                case 26: 
                case 34: 
                case 42: 
                case 59: 
                case 67: 
                case 75: {
                    lv = 0;
                    break;
                }
                case 27: 
                case 30: 
                case 35: 
                case 38: 
                case 43: 
                case 60: 
                case 63: 
                case 68: 
                case 71: 
                case 76: {
                    lv = 1;
                    break;
                }
                case 28: 
                case 31: 
                case 36: 
                case 39: 
                case 44: 
                case 61: 
                case 64: 
                case 69: 
                case 72: 
                case 77: {
                    lv = 2;
                    break;
                }
                case 29: 
                case 32: 
                case 37: 
                case 40: 
                case 45: 
                case 62: 
                case 65: 
                case 70: 
                case 73: 
                case 78: {
                    lv = 3;
                    break;
                }
                case 33: 
                case 41: 
                case 66: 
                case 74: {
                    lv = 4;
                    break;
                }
                case 132: {
                    lv = x.getOperandLocalVariable().getIndex();
                    break;
                }
                default: {
                    lv = -1;
                }
            }
            max = lv + 1 > max ? lv + 1 : max;
            ++i;
        }
        return max;
    }

    CFFactory getFactory() {
        return this.factory;
    }

    public void addLabel(String label, Instruction x) {
        if (Debug.DEBUG_CF) {
            if (x == null || label == null || x.getOwnerCodeAttribute() != this) {
                throw new CFException(14);
            }
            if (this.hLabelToInstruction.containsKey(label)) {
                throw new CFException(21, label);
            }
        }
        this.hInstructionToLabel.put(x, label);
        this.hLabelToInstruction.put(label, x);
    }

    public Instruction getInstructionByLabel(String label) {
        if (Debug.DEBUG_CF && label == null) {
            throw new CFException(69, "label");
        }
        Instruction r = (Instruction)this.hLabelToInstruction.get(label);
        return r;
    }

    public Instruction getInstructionByLabel(String label, boolean mustResolve) {
        Instruction r = this.getInstructionByLabel(label);
        if (mustResolve && r == null) {
            throw new CFException(18, label);
        }
        return r;
    }

    public void transferLabels(Instruction x, Instruction y) {
        Object label;
        if (Debug.DEBUG_CF && (x == null || y == null || x.getOwnerCodeAttribute() != this || y.getOwnerCodeAttribute() != this || x == y)) {
            throw new CFException(14);
        }
        Enumeration enumeration = this.hInstructionToLabel.keys();
        while (enumeration.hasMoreElements()) {
            Object instruction = enumeration.nextElement();
            label = this.hInstructionToLabel.get(instruction);
            if (instruction != x) continue;
            this.hInstructionToLabel.put(y, label);
        }
        enum = this.hLabelToInstruction.keys();
        while (enum.hasMoreElements()) {
            label = enum.nextElement();
            Object instruction = this.hLabelToInstruction.get(label);
            if (instruction != x) continue;
            this.hLabelToInstruction.put(label, y);
        }
    }

    public String getCanonicalLabelOfInstruction(Instruction x) {
        return (String)this.hInstructionToLabel.get(x);
    }

    public String getCanonicalLabel(String label) {
        if (Debug.DEBUG_CF && label == null) {
            throw new CFException(69, "label");
        }
        Object x = this.hLabelToInstruction.get(label);
        if (Debug.DEBUG_CF && x == null) {
            throw new CFException(62, label);
        }
        String r = (String)this.hInstructionToLabel.get(x);
        if (Debug.DEBUG_CF && r == null) {
            throw new CFException(64, new Object[]{label, x});
        }
        return r;
    }

    public Instruction createNOP() {
        return this.createInstruction().init(0);
    }

    public Instruction createDUP() {
        return this.createInstruction().init(89);
    }

    public Instruction createDUP_X1() {
        return this.createInstruction().init(90);
    }

    public Instruction createDUP_X2() {
        return this.createInstruction().init(91);
    }

    public Instruction createDUP2() {
        return this.createInstruction().init(92);
    }

    public Instruction createDUP2_X1() {
        return this.createInstruction().init(93);
    }

    public Instruction createDUP2_X2() {
        return this.createInstruction().init(94);
    }

    public Instruction createPOP() {
        return this.createInstruction().init(87);
    }

    public Instruction createPOP2() {
        return this.createInstruction().init(88);
    }

    public Instruction createSWAP() {
        return this.createInstruction().init(95);
    }

    public Instruction createATHROW() {
        return this.createInstruction().init(191);
    }

    public Instruction createBASTORE() {
        return this.createInstruction().init(84);
    }

    public Instruction createCASTORE() {
        return this.createInstruction().init(85);
    }

    public Instruction createSASTORE() {
        return this.createInstruction().init(86);
    }

    public Instruction createIASTORE() {
        return this.createInstruction().init(79);
    }

    public Instruction createFASTORE() {
        return this.createInstruction().init(81);
    }

    public Instruction createLASTORE() {
        return this.createInstruction().init(80);
    }

    public Instruction createDASTORE() {
        return this.createInstruction().init(82);
    }

    public Instruction createAASTORE() {
        return this.createInstruction().init(83);
    }

    public Instruction createBALOAD() {
        return this.createInstruction().init(51);
    }

    public Instruction createCALOAD() {
        return this.createInstruction().init(52);
    }

    public Instruction createSALOAD() {
        return this.createInstruction().init(53);
    }

    public Instruction createIALOAD() {
        return this.createInstruction().init(46);
    }

    public Instruction createFALOAD() {
        return this.createInstruction().init(48);
    }

    public Instruction createLALOAD() {
        return this.createInstruction().init(47);
    }

    public Instruction createDALOAD() {
        return this.createInstruction().init(49);
    }

    public Instruction createAALOAD() {
        return this.createInstruction().init(50);
    }

    public Instruction createACONST_NULL() {
        return this.createInstruction().init(1);
    }

    public Instruction createILOAD(LocalVariable lv) {
        return this.createInstruction().init(21, lv);
    }

    public Instruction createLLOAD(LocalVariable lv) {
        return this.createInstruction().init(22, lv);
    }

    public Instruction createFLOAD(LocalVariable lv) {
        return this.createInstruction().init(23, lv);
    }

    public Instruction createDLOAD(LocalVariable lv) {
        return this.createInstruction().init(24, lv);
    }

    public Instruction createALOAD(LocalVariable lv) {
        return this.createInstruction().init(25, lv);
    }

    public Instruction createISTORE(LocalVariable lv) {
        return this.createInstruction().init(54, lv);
    }

    public Instruction createLSTORE(LocalVariable lv) {
        return this.createInstruction().init(55, lv);
    }

    public Instruction createFSTORE(LocalVariable lv) {
        return this.createInstruction().init(56, lv);
    }

    public Instruction createDSTORE(LocalVariable lv) {
        return this.createInstruction().init(57, lv);
    }

    public Instruction createASTORE(LocalVariable lv) {
        return this.createInstruction().init(58, lv);
    }

    public Instruction createRET() {
        return this.createInstruction().init(169);
    }

    public Instruction createMONITORENTER() {
        return this.createInstruction().init(194);
    }

    public Instruction createMONITOREXIT() {
        return this.createInstruction().init(195);
    }

    public Instruction createLOAD(LocalVariable lv, String descriptor) {
        FieldInfo.checkFieldDescriptor(descriptor);
        switch (descriptor.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return this.createILOAD(lv);
            }
            case 'J': {
                return this.createLLOAD(lv);
            }
            case 'F': {
                return this.createFLOAD(lv);
            }
            case 'D': {
                return this.createDLOAD(lv);
            }
            case 'L': 
            case '[': {
                return this.createALOAD(lv);
            }
        }
        throw new CFException(11, descriptor);
    }

    public Instruction createSTORE(LocalVariable lv, String descriptor) {
        FieldInfo.checkFieldDescriptor(descriptor);
        switch (descriptor.charAt(0)) {
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return this.createISTORE(lv);
            }
            case 'J': {
                return this.createLSTORE(lv);
            }
            case 'F': {
                return this.createFSTORE(lv);
            }
            case 'D': {
                return this.createDSTORE(lv);
            }
            case 'L': 
            case '[': {
                return this.createASTORE(lv);
            }
        }
        throw new CFException(11, descriptor);
    }

    public Instruction createInvokeStatic(CPInfo x) {
        if (Debug.DEBUG_CF) {
            if (x == null) {
                throw new CFException(69, "name");
            }
            if (x.getTag() != 10) {
                throw new CFException(16);
            }
        }
        return this.createInstruction().init(184, x);
    }

    public Instruction createInvokeStatic(String className, String methodName, String methodDescriptor) {
        return this.createInstruction().init(184, this.ownerMethod.getOwnerClassFile().createCPInfoMemberRef(10, className, methodName, methodDescriptor));
    }

    public Instruction createInvokeVirtual(CPInfo x) {
        if (Debug.DEBUG_CF && (x == null || x.getTag() != 10)) {
            throw new CFException(14);
        }
        return this.createInstruction().init(182, x);
    }

    public Instruction createInvokeVirtual(String className, String methodName, String methodDescriptor) {
        return this.createInstruction().init(182, this.ownerMethod.getOwnerClassFile().createCPInfoMemberRef(10, className, methodName, methodDescriptor));
    }

    public Instruction createInvokeSpecial(CPInfo x) {
        if (Debug.DEBUG_CF && (x == null || x.getTag() != 10)) {
            throw new CFException(14);
        }
        return this.createInstruction().init(183, x);
    }

    public Instruction createInvokeSpecial(String className, String methodName, String methodDescriptor) {
        return this.createInstruction().init(183, this.ownerMethod.getOwnerClassFile().createCPInfoMemberRef(10, className, methodName, methodDescriptor));
    }

    public Instruction createInvokeInterface(CPInfo x) {
        if (Debug.DEBUG_CF && (x == null || x.getTag() != 11)) {
            throw new CFException(14);
        }
        return this.createInstruction().init(185, x, MethodInfo.parseMethodDescriptorArguments(x.getValueNameAndType().getValueDescriptor().toPlainString()).length + 1);
    }

    public Instruction createInvokeInterface(String className, String methodName, String methodDescriptor) {
        return this.createInstruction().init(185, this.ownerMethod.getOwnerClassFile().createCPInfoMemberRef(11, className, methodName, methodDescriptor), MethodInfo.parseMethodDescriptorArguments(methodDescriptor).length + 1);
    }

    public Instruction createPutStatic(CPInfo x) {
        if (Debug.DEBUG_CF && (x == null || x.getTag() != 9)) {
            throw new CFException(14);
        }
        return this.createInstruction().init(179, x);
    }

    public Instruction createPutStatic(String className, String fieldName, String fieldDescriptor) {
        return this.createPutStatic(this.ownerMethod.getOwnerClassFile().createCPInfoMemberRef(9, className, fieldName, fieldDescriptor));
    }

    public Instruction createGetStatic(CPInfo x) {
        if (Debug.DEBUG_CF && (x == null || x.getTag() != 9)) {
            throw new CFException(14);
        }
        return this.createInstruction().init(178, x);
    }

    public Instruction createGetStatic(String className, String fieldName, String fieldDescriptor) {
        return this.createGetStatic(this.ownerMethod.getOwnerClassFile().createCPInfoMemberRef(9, className, fieldName, fieldDescriptor));
    }

    public Instruction createPutField(CPInfo x) {
        if (Debug.DEBUG_CF && (x == null || x.getTag() != 9)) {
            throw new CFException(14);
        }
        return this.createInstruction().init(181, x);
    }

    public Instruction createPutField(String className, String fieldName, String fieldDescriptor) {
        return this.createPutField(this.ownerMethod.getOwnerClassFile().createCPInfoMemberRef(9, className, fieldName, fieldDescriptor));
    }

    public Instruction createGetField(CPInfo x) {
        if (Debug.DEBUG_CF && (x == null || x.getTag() != 9)) {
            throw new CFException(14);
        }
        return this.createInstruction().init(180, x);
    }

    public Instruction createGetField(String className, String fieldName, String fieldDescriptor) {
        return this.createGetField(this.ownerMethod.getOwnerClassFile().createCPInfoMemberRef(9, className, fieldName, fieldDescriptor));
    }

    public Instruction createLDC(CPInfo x) {
        int opcode;
        if (Debug.DEBUG_CF && x == null) {
            throw new CFException(14);
        }
        switch (x.getTag()) {
            case 5: 
            case 6: {
                opcode = 20;
                break;
            }
            case 3: 
            case 4: 
            case 8: {
                opcode = x.getIndex() > 255 ? 19 : 18;
                break;
            }
            default: {
                throw new CFException(14);
            }
        }
        return this.createInstruction().init(opcode, x);
    }

    public Instruction createLDC(int x) {
        switch (x) {
            case -1: {
                return this.createInstruction().init(2);
            }
            case 0: {
                return this.createInstruction().init(3);
            }
            case 1: {
                return this.createInstruction().init(4);
            }
            case 2: {
                return this.createInstruction().init(5);
            }
            case 3: {
                return this.createInstruction().init(6);
            }
            case 4: {
                return this.createInstruction().init(7);
            }
            case 5: {
                return this.createInstruction().init(8);
            }
        }
        if (x >= -128 && x <= 127) {
            return this.createInstruction().init(16, x);
        }
        if (x >= Short.MIN_VALUE && x <= Short.MAX_VALUE) {
            return this.createInstruction().init(17, x);
        }
        return this.createLDC(this.ownerMethod.getOwnerClassFile().createCPInfoInteger(x));
    }

    public Instruction createLDC(String s) {
        return this.createLDC(this.ownerMethod.getOwnerClassFile().createCPInfoString(s));
    }

    public Instruction createGOTO(Instruction x) {
        return this.createBranch(167, x);
    }

    public Instruction createGOTO(String label) {
        return this.createBranch(167, label);
    }

    public Instruction createBranch(int opcode, Instruction x) {
        if (Debug.DEBUG_CF && (Constants.INSTRUCTION_OPERANDS[opcode] != 5 || x == null || x.getOwnerCodeAttribute() != this)) {
            throw new CFException(14);
        }
        return this.createInstruction().init(opcode, x);
    }

    public Instruction createBranch(int opcode, String label) {
        if (Debug.DEBUG_CF && (Constants.INSTRUCTION_OPERANDS[opcode] != 5 || label == null)) {
            throw new CFException(14);
        }
        return this.createInstruction().init(opcode, label);
    }

    public Instruction createRETURN() {
        switch (MethodInfo.parseMethodDescriptorReturnType(this.ownerMethod.getDescriptor()).charAt(0)) {
            case 'V': {
                return this.createInstruction().init(177);
            }
            case 'B': 
            case 'C': 
            case 'I': 
            case 'S': 
            case 'Z': {
                return this.createInstruction().init(172);
            }
            case 'J': {
                return this.createInstruction().init(173);
            }
            case 'F': {
                return this.createInstruction().init(174);
            }
            case 'D': {
                return this.createInstruction().init(175);
            }
        }
        return this.createInstruction().init(176);
    }

    public Instruction createCHECKCAST(CPInfo x) {
        if (Debug.DEBUG_CF && (x == null || x.getTag() != 7)) {
            throw new CFException(16);
        }
        return this.createInstruction().init(192, x);
    }

    public Instruction createCHECKCAST(String className) {
        return this.createInstruction().init(192, this.ownerMethod.getOwnerClassFile().createCPInfoClass(className));
    }

    public Instruction createINSTANCEOF(CPInfo x) {
        if (Debug.DEBUG_CF && (x == null || x.getTag() != 7)) {
            throw new CFException(14);
        }
        return this.createInstruction().init(193, x);
    }

    public Instruction createINSTANCEOF(String className) {
        return this.createInstruction().init(193, this.ownerMethod.getOwnerClassFile().createCPInfoClass(className));
    }

    public Instruction createANEWARRAY(CPInfo x) {
        if (Debug.DEBUG_CF && (x == null || x.getTag() != 7)) {
            throw new CFException(14);
        }
        return this.createInstruction().init(189, x);
    }

    public Instruction createANEWARRAY(String className) {
        return this.createInstruction().init(189, this.ownerMethod.getOwnerClassFile().createCPInfoClass(className));
    }

    public Instruction createNEWARRAY(String descriptor) {
        if (descriptor == null) {
            throw new CFException(14);
        }
        if (descriptor.length() == 1) {
            switch (descriptor.charAt(0)) {
                case 'Z': {
                    return this.createInstruction().init(188, 4);
                }
                case 'B': {
                    return this.createInstruction().init(188, 8);
                }
                case 'C': {
                    return this.createInstruction().init(188, 5);
                }
                case 'S': {
                    return this.createInstruction().init(188, 9);
                }
                case 'I': {
                    return this.createInstruction().init(188, 10);
                }
                case 'F': {
                    return this.createInstruction().init(188, 6);
                }
                case 'J': {
                    return this.createInstruction().init(188, 11);
                }
                case 'D': {
                    return this.createInstruction().init(188, 7);
                }
            }
        }
        throw new CFException(15, descriptor);
    }

    public Instruction createNEWARRAY(int atype) {
        switch (atype) {
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: {
                return this.createInstruction().init(188, atype);
            }
        }
        throw new CFException(2, new Integer(atype));
    }

    public Instruction createNEW(CPInfo x) {
        if (Debug.DEBUG_CF && (x == null || x.getTag() != 7)) {
            throw new CFException(14);
        }
        return this.createInstruction().init(187, x);
    }

    public Instruction createNEW(String className) {
        return this.createNEW(this.ownerMethod.getOwnerClassFile().createCPInfoClass(className));
    }

    public void checkBranches() {
        int i = 0;
        while (i < this.nInstructions) {
            this.instructions[i].checkBranches();
            ++i;
        }
    }
}

