/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.cf;

import com.sap.engine.library.bytecode.cf.AttributeContainer;
import com.sap.engine.library.bytecode.cf.AttributeInfo;
import com.sap.engine.library.bytecode.cf.Attributed;
import com.sap.engine.library.bytecode.cf.CFException;
import com.sap.engine.library.bytecode.cf.CFFactory;
import com.sap.engine.library.bytecode.cf.CFNode;
import com.sap.engine.library.bytecode.cf.CPInfo;
import com.sap.engine.library.bytecode.cf.Constants;
import com.sap.engine.library.bytecode.cf.FieldInfo;
import com.sap.engine.library.bytecode.cf.MethodInfo;
import com.sap.engine.library.bytecode.cf.SerialVersionUIDCalculator;
import com.sap.engine.library.bytecode.cf.SourceFileAttribute;
import com.sap.engine.library.bytecode.misc.ArrayUtils;
import com.sap.engine.library.bytecode.misc.Debug;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.PrintStream;

public final class ClassFile
extends CFNode
implements Attributed,
Constants {
    private final CFFactory factory;
    private final byte[] originalBytecode;
    private int minorVersion;
    private int majorVersion;
    private int ncp = 0;
    private CPInfo[] cp = new CPInfo[1024];
    private int accessFlags;
    private CPInfo thisClass;
    private CPInfo superClass;
    private int nInterfaces = 0;
    private CPInfo[] interfaces = Constants.CPINFO_ARRAY_0;
    private int nFields = 0;
    private FieldInfo[] fields = new FieldInfo[8];
    private int nMethods = 0;
    private MethodInfo[] methods = new MethodInfo[8];
    private AttributeContainer attributeContainer = new AttributeContainer();

    ClassFile(CFFactory factory, byte[] originalBytecode) {
        this.originalBytecode = originalBytecode;
        this.minorVersion = 3;
        this.majorVersion = 45;
        this.factory = factory;
        this.addCPInfo(new CPInfo(this, 0, 0, 0, null, 0));
    }

    public byte[] getOriginalBytecode() {
        return this.originalBytecode == null ? null : (byte[])this.originalBytecode.clone();
    }

    public int getMinorVersion() {
        return this.minorVersion;
    }

    public int getMajorVersion() {
        return this.majorVersion;
    }

    public int getAccessFlags() {
        return this.accessFlags;
    }

    public CPInfo getThisClass() {
        return this.thisClass;
    }

    public CPInfo getSuperClass() {
        return this.superClass;
    }

    public String getName() {
        return this.thisClass.getValueName().toPlainString();
    }

    public String getSuperClassName() {
        try {
            return this.superClass.getValueName().toPlainString();
        }
        catch (CFException cfe) {
            return "<CPInfo #" + this.superClass.getIndex() + ">";
        }
    }

    public int getCPSize() {
        return this.ncp;
    }

    public CPInfo[] getCPInfosArray() {
        CPInfo[] r = new CPInfo[this.ncp];
        System.arraycopy(this.cp, 0, r, 0, this.ncp);
        return r;
    }

    public CPInfo getCPInfo(int index) {
        if (Debug.DEBUG_CF && (index < 0 || index >= this.ncp)) {
            throw new CFException(17, new Object[]{"CPInfo", new Integer(index), new Integer(this.ncp - 1)});
        }
        return this.cp[index];
    }

    public int getCPIndex(CPInfo x) {
        int i = 0;
        while (i < this.ncp) {
            if (this.cp[i] == x) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public CPInfo getCPInfoUtf8(String s) {
        if (Debug.DEBUG_CF && s == null) {
            throw new CFException(69, "s");
        }
        int i = 0;
        while (i < this.ncp) {
            if (this.cp[i].getTag() == 1 && this.cp[i].getString().equals(s)) {
                return this.cp[i];
            }
            ++i;
        }
        return null;
    }

    public CPInfo createCPInfoUtf8(String s) {
        if (Debug.DEBUG_CF && s == null) {
            throw new CFException(69, "s");
        }
        CPInfo x = this.getCPInfoUtf8(s);
        if (x != null) {
            return x;
        }
        x = new CPInfo(this, 1, 0, 0, s, this.ncp);
        this.addCPInfo(x);
        if (Debug.DEBUG_CF && x.getTag() != 1) {
            throw new CFException(16);
        }
        return x;
    }

    public CPInfo getCPInfoString(String s) {
        if (Debug.DEBUG_CF && s == null) {
            throw new CFException(69, "s");
        }
        CPInfo y = this.getCPInfoUtf8(s);
        if (y == null) {
            return null;
        }
        int i = 0;
        while (i < this.ncp) {
            if (this.cp[i].getTag() == 8 && this.cp[i].getValueString() == y) {
                return this.cp[i];
            }
            ++i;
        }
        return null;
    }

    public CPInfo createCPInfoString(String s) {
        if (Debug.DEBUG_CF && s == null) {
            throw new CFException(69, "s");
        }
        CPInfo x = this.getCPInfoString(s);
        if (x != null) {
            return x;
        }
        CPInfo y = this.createCPInfoUtf8(s);
        x = new CPInfo(this, 8, y.getIndex(), 0, null, this.ncp);
        this.addCPInfo(x);
        if (Debug.DEBUG_CF && x.getTag() != 8) {
            throw new CFException(16);
        }
        return x;
    }

    public CPInfo getCPInfoClass(String className) {
        CPInfo y = this.getCPInfoUtf8(className);
        int i = 0;
        while (i < this.ncp) {
            if (this.cp[i].getTag() == 7 && this.cp[i].getValueName() == y) {
                return this.cp[i];
            }
            ++i;
        }
        return null;
    }

    public CPInfo createCPInfoClass(String className) {
        CPInfo x = this.getCPInfoClass(className);
        if (x != null) {
            return x;
        }
        CPInfo y = this.createCPInfoUtf8(className);
        x = new CPInfo(this, 7, y.getIndex(), 0, null, this.ncp);
        this.addCPInfo(x);
        if (Debug.DEBUG_CF && x.getTag() != 7) {
            throw new CFException(16);
        }
        return x;
    }

    public CPInfo getCPInfoInteger(int value) {
        int i = 0;
        while (i < this.ncp) {
            if (this.cp[i].getTag() == 3 && this.cp[i].getValueInt() == value) {
                return this.cp[i];
            }
            ++i;
        }
        return null;
    }

    public CPInfo createCPInfoInteger(int value) {
        CPInfo x = this.getCPInfoInteger(value);
        if (x != null) {
            return x;
        }
        x = new CPInfo(this, 3, value, 0, null, this.ncp);
        this.addCPInfo(x);
        return x;
    }

    public CPInfo getCPInfoLong(long value) {
        int i = 0;
        while (i < this.ncp) {
            if (this.cp[i].getTag() == 5 && this.cp[i].getValueLong() == value) {
                return this.cp[i];
            }
            ++i;
        }
        return null;
    }

    public CPInfo createCPInfoLong(long value) {
        CPInfo x = this.getCPInfoLong(value);
        if (x != null) {
            return x;
        }
        x = new CPInfo(this, 5, (int)(value >> 32), (int)value, null, this.ncp);
        this.addCPInfo(x);
        this.addCPInfo(x);
        return x;
    }

    public CPInfo getCPInfoFloat(float valueFloat) {
        int value = Float.floatToIntBits(valueFloat);
        int i = 0;
        while (i < this.ncp) {
            if (this.cp[i].getTag() == 4 && this.cp[i].getValueInt() == value) {
                return this.cp[i];
            }
            ++i;
        }
        return null;
    }

    public CPInfo createCPInfoFloat(float valueFloat) {
        CPInfo x = this.getCPInfoFloat(valueFloat);
        if (x != null) {
            return x;
        }
        x = new CPInfo(this, 4, Float.floatToIntBits(valueFloat), 0, null, this.ncp);
        this.addCPInfo(x);
        return x;
    }

    public CPInfo getCPInfoMemberRef(int tag, CPInfo valueClass, CPInfo valueNameAndType) {
        if (Debug.DEBUG_CF) {
            if (valueClass == null) {
                throw new CFException(69, "valueClass");
            }
            if (valueNameAndType == null) {
                throw new CFException(69, "valueNameAndType");
            }
            if (valueClass.getTag() != 7) {
                throw new CFException(16);
            }
            if (valueNameAndType.getTag() != 12) {
                throw new CFException(16);
            }
        }
        switch (tag) {
            case 9: 
            case 10: 
            case 11: {
                break;
            }
            default: {
                throw new CFException(16);
            }
        }
        int i = 0;
        while (i < this.ncp) {
            if (this.cp[i].getTag() == tag && this.cp[i].getValueClass() == valueClass && this.cp[i].getValueNameAndType() == valueNameAndType) {
                return this.cp[i];
            }
            ++i;
        }
        return null;
    }

    public CPInfo createCPInfoMemberRef(int tag, CPInfo valueClass, CPInfo valueNameAndType) {
        CPInfo x;
        if (Debug.DEBUG_CF) {
            if (valueClass == null || valueNameAndType == null) {
                throw new CFException(14);
            }
            if (valueClass.getTag() != 7) {
                throw new CFException(16);
            }
            if (valueNameAndType.getTag() != 12) {
                throw new CFException(16);
            }
        }
        if ((x = this.getCPInfoMemberRef(tag, valueClass, valueNameAndType)) != null) {
            return x;
        }
        x = new CPInfo(this, tag, valueClass.getIndex(), valueNameAndType.getIndex(), null, this.ncp);
        this.addCPInfo(x);
        return x;
    }

    public CPInfo createCPInfoMemberRef(int tag, String className, String memberName, String descriptorString) {
        CPInfo valueClass = this.createCPInfoClass(className);
        CPInfo valueName = this.createCPInfoUtf8(memberName);
        CPInfo valueDescriptor = this.createCPInfoUtf8(descriptorString);
        CPInfo valueNameAndType = this.createCPInfoNameAndType(valueName, valueDescriptor);
        return this.createCPInfoMemberRef(tag, valueClass, valueNameAndType);
    }

    public CPInfo createCPInfoMemberRef(int tag, CPInfo valueClass, String memberName, String descriptorString) {
        CPInfo valueName = this.createCPInfoUtf8(memberName);
        CPInfo valueDescriptor = this.createCPInfoUtf8(descriptorString);
        CPInfo valueNameAndType = this.createCPInfoNameAndType(valueName, valueDescriptor);
        return this.createCPInfoMemberRef(tag, valueClass, valueNameAndType);
    }

    public CPInfo getCPInfoNameAndType(CPInfo name, CPInfo descriptor) {
        int i = 0;
        while (i < this.ncp) {
            if (this.cp[i].getTag() == 12 && this.cp[i].getValueName() == name && this.cp[i].getValueDescriptor() == descriptor) {
                return this.cp[i];
            }
            ++i;
        }
        return null;
    }

    public CPInfo createCPInfoNameAndType(CPInfo name, CPInfo descriptor) {
        CPInfo x = this.getCPInfoNameAndType(name, descriptor);
        if (x != null) {
            return x;
        }
        x = new CPInfo(this, 12, name.getIndex(), descriptor.getIndex(), null, this.ncp);
        this.addCPInfo(x);
        return x;
    }

    public int getNInterfaces() {
        return this.nInterfaces;
    }

    public CPInfo getInterface(int index) {
        if (Debug.DEBUG_CF && (index < 0 || index >= this.nInterfaces)) {
            throw new IndexOutOfBoundsException("Interface index for this class must be in {0.." + (this.nInterfaces - 1) + "}.");
        }
        return this.interfaces[index];
    }

    public CPInfo[] getInterfacesArray() {
        if (this.nInterfaces == 0) {
            return Constants.CPINFO_ARRAY_0;
        }
        CPInfo[] r = new CPInfo[this.nInterfaces];
        System.arraycopy(this.interfaces, 0, r, 0, this.nInterfaces);
        return r;
    }

    public String[] getInterfaceNames() {
        if (this.nInterfaces == 0) {
            return ArrayUtils.STRING_ARRAY_0;
        }
        String[] r = new String[this.nInterfaces];
        int i = 0;
        while (i < this.nInterfaces) {
            r[i] = this.interfaces[i].getValueName().toPlainString();
            ++i;
        }
        return r;
    }

    public void addInterface(CPInfo x) {
        if (Debug.DEBUG_CF && (x == null || x.getTag() != 7)) {
            throw new CFException(14);
        }
        if (this.nInterfaces == this.interfaces.length) {
            CPInfo[] interfacesOld = this.interfaces;
            this.interfaces = new CPInfo[2 * this.nInterfaces + 8];
            System.arraycopy(interfacesOld, 0, this.interfaces, 0, this.nInterfaces);
        }
        this.interfaces[this.nInterfaces++] = x;
    }

    public int getNFields() {
        return this.nFields;
    }

    public FieldInfo getField(int index) {
        if (Debug.DEBUG_CF && (index < 0 || index >= this.nFields)) {
            throw new CFException(16);
        }
        return this.fields[index];
    }

    public FieldInfo[] getFieldsArray() {
        FieldInfo[] r = new FieldInfo[this.nFields];
        System.arraycopy(this.fields, 0, r, 0, this.nFields);
        return r;
    }

    void addFieldInfo(FieldInfo f) {
        if (this.nFields == this.fields.length) {
            FieldInfo[] fieldsOld = this.fields;
            this.fields = new FieldInfo[2 * this.nFields + 8];
            System.arraycopy(fieldsOld, 0, this.fields, 0, this.nFields);
        }
        this.fields[this.nFields++] = f;
    }

    public FieldInfo getField(String name) {
        int i = 0;
        while (i < this.nFields) {
            if (this.fields[i].getName().equals(name)) {
                return this.fields[i];
            }
            ++i;
        }
        return null;
    }

    public int getNMethods() {
        return this.nMethods;
    }

    public MethodInfo getMethod(int index) {
        if (Debug.DEBUG_CF && (index < 0 || index >= this.nMethods)) {
            throw new CFException(16);
        }
        return this.methods[index];
    }

    public MethodInfo[] getMethodsArray() {
        MethodInfo[] r = new MethodInfo[this.nMethods];
        System.arraycopy(this.methods, 0, r, 0, this.nMethods);
        return r;
    }

    void setVersion(int majorVersion, int minorVersion) {
        this.minorVersion = minorVersion;
        this.majorVersion = majorVersion;
    }

    void addCPInfo(CPInfo x) {
        if (this.ncp == this.cp.length) {
            CPInfo[] old = this.cp;
            this.cp = new CPInfo[this.ncp * 2];
            System.arraycopy(old, 0, this.cp, 0, this.ncp);
        }
        this.cp[this.ncp] = x;
        ++this.ncp;
    }

    void setAccessFlags(int accessFlags) {
        this.accessFlags = accessFlags;
    }

    public void setThisClass(CPInfo thisClass) {
        if (Debug.DEBUG_CF) {
            if (thisClass == null) {
                throw new CFException(69, "thisClass");
            }
            if (thisClass.getTag() != 7) {
                throw new CFException(16);
            }
        }
        this.thisClass = thisClass;
    }

    public void setThisClass(String className) {
        this.thisClass = this.createCPInfoClass(className);
    }

    public void setSuperClass(CPInfo superClass) {
        if (Debug.DEBUG_CF && !this.getName().equals("java/lang/Object") && (superClass == null || superClass.getTag() != 7)) {
            throw new CFException(14);
        }
        this.superClass = superClass;
    }

    public void setSuperClass(String className) {
        this.superClass = this.createCPInfoClass(className);
    }

    void addMethodInfo(MethodInfo m) {
        if (this.nMethods == this.methods.length) {
            MethodInfo[] methodsOld = this.methods;
            this.methods = new MethodInfo[2 * this.nMethods + 8];
            System.arraycopy(methodsOld, 0, this.methods, 0, this.nMethods);
        }
        this.methods[this.nMethods++] = m;
    }

    public MethodInfo getMethod(String name, String descriptor) {
        if (Debug.DEBUG_CF) {
            if (name == null) {
                throw new CFException(69, "name");
            }
            MethodInfo.checkMethodDescriptor(descriptor);
        }
        int i = 0;
        while (i < this.nMethods) {
            if (this.methods[i].getName().equals(name) && this.methods[i].getDescriptor().equals(descriptor)) {
                return this.methods[i];
            }
            ++i;
        }
        return null;
    }

    public MethodInfo createMethod(String name, String descriptor) {
        MethodInfo m;
        if (Debug.DEBUG_CF) {
            if (name == null) {
                throw new CFException(69, "name");
            }
            MethodInfo.checkMethodDescriptor(descriptor);
        }
        if ((m = this.getMethod(name, descriptor)) != null) {
            return m;
        }
        m = new MethodInfo(this.factory, this, 0, this.createCPInfoUtf8(name), this.createCPInfoUtf8(descriptor));
        this.addMethodInfo(m);
        return m;
    }

    public FieldInfo createField(String name, String descriptor) {
        FieldInfo f;
        if (Debug.DEBUG_CF) {
            if (name == null) {
                throw new CFException(69, "name");
            }
            FieldInfo.checkFieldDescriptor(descriptor);
        }
        if ((f = this.getField(name)) != null) {
            if (!f.getDescriptor().equals(descriptor)) {
                throw new CFException(9, new Object[]{name + ' ' + descriptor, f.getName() + ' ' + f.getDescriptor()});
            }
            return f;
        }
        f = new FieldInfo(this.factory, this, 0, this.createCPInfoUtf8(name), this.createCPInfoUtf8(descriptor));
        this.addFieldInfo(f);
        return f;
    }

    public SourceFileAttribute getSourceFileAttribute() {
        return (SourceFileAttribute)this.attributeContainer.getAttribute("SourceFile");
    }

    public SourceFileAttribute createSourceFileAttribute() {
        SourceFileAttribute sfa = this.getSourceFileAttribute();
        if (sfa != null) {
            return sfa;
        }
        sfa = new SourceFileAttribute();
        this.addAttribute(sfa);
        return sfa;
    }

    public String getSourceFile() {
        SourceFileAttribute sfa = this.getSourceFileAttribute();
        if (sfa == null) {
            return null;
        }
        CPInfo sf = sfa.getSourceFile();
        if (sf == null) {
            return null;
        }
        return sf.toPlainString();
    }

    public void setSourceFile(String sourceFile) {
        this.createSourceFileAttribute().setSourceFile(this.createCPInfoUtf8(sourceFile));
    }

    public boolean isPublic() {
        return (this.accessFlags & 1) != 0;
    }

    public boolean isFinal() {
        return (this.accessFlags & 0x10) != 0;
    }

    public boolean isInterface() {
        return (this.accessFlags & 0x200) != 0;
    }

    public boolean isAbstract() {
        return (this.accessFlags & 0x400) != 0;
    }

    public void setPublic(boolean b) {
        this.accessFlags = b ? (this.accessFlags |= 1) : (this.accessFlags &= 0xFFFFFFFE);
    }

    public void setFinal(boolean b) {
        this.accessFlags = b ? (this.accessFlags |= 0x10) : (this.accessFlags &= 0xFFFFFFEF);
    }

    public void setInterface(boolean b) {
        this.accessFlags = b ? (this.accessFlags |= 0x200) : (this.accessFlags &= 0xFFFFFDFF);
    }

    public void setAbstract(boolean b) {
        this.accessFlags = b ? (this.accessFlags |= 0x400) : (this.accessFlags &= 0xFFFFFBFF);
    }

    public String toString() {
        return "[CLASSFILE " + this.getName() + "]";
    }

    public byte[] serializeToByteArray() throws IOException {
        return this.factory.createCFSerializer().serializeToByteArray(this, null);
    }

    public void serialize(File file) throws IOException {
        this.factory.createCFSerializer().serialize(file, this, null);
    }

    public void serialize(String filename) throws IOException {
        this.factory.createCFSerializer().serialize(filename, this, null);
    }

    public void disassemble(File file) throws IOException {
        this.factory.createCFDisassembler().disassemble(file, this, null);
    }

    public void disassemble(String filename) throws IOException {
        this.factory.createCFDisassembler().disassemble(filename, this, null);
    }

    public void disassemble(PrintStream out) throws IOException {
        this.factory.createCFDisassembler().disassemble(out, this, null);
    }

    public void disassembleToSystemOut() throws IOException {
        this.factory.createCFDisassembler().disassemble(System.out, this, null);
    }

    public String disassembleToString() throws IOException {
        ByteArrayOutputStream out0 = new ByteArrayOutputStream();
        this.disassemble(new PrintStream(out0));
        return new String(out0.toByteArray());
    }

    public void addAttribute(AttributeInfo a) {
        this.createCPInfoUtf8(a.getName());
        this.attributeContainer.addAttribute(a);
    }

    public int getNAttributes() {
        return this.attributeContainer.getNAttributes();
    }

    public AttributeInfo getAttribute(int index) {
        return this.attributeContainer.getAttribute(index);
    }

    public AttributeInfo getAttribute(String name) {
        return this.attributeContainer.getAttribute(name);
    }

    public AttributeInfo[] getAttributesArray() {
        return this.attributeContainer.getAttributesArray();
    }

    public void removeAttribute(String name) {
        this.attributeContainer.removeAttribute(name);
    }

    public void removeAttribute(AttributeInfo a) {
        this.attributeContainer.removeAttribute(a);
    }

    public long computeSerialVersionUID() {
        return SerialVersionUIDCalculator.computeSerialVersionUID(this);
    }

    public CFNode getParentNode() {
        return null;
    }

    public CFNode[] getChildNodes() {
        AttributeInfo[] attributes = this.attributeContainer.getAttributesArray();
        int nAttributes = attributes.length;
        CFNode[] r = new CPInfo[this.ncp + this.nFields + this.nMethods + nAttributes];
        int i = 0;
        while (i < this.ncp) {
            r[i] = this.cp[i];
            ++i;
        }
        int i2 = 0;
        while (i2 < this.nFields) {
            r[this.ncp + i2] = this.fields[i2];
            ++i2;
        }
        int i3 = 0;
        while (i3 < this.nMethods) {
            r[this.ncp + this.nFields + i3] = this.methods[i3];
            ++i3;
        }
        int i4 = 0;
        while (i4 < nAttributes) {
            r[this.ncp + this.nFields + this.nMethods + i4] = attributes[i4];
            ++i4;
        }
        return r;
    }
}

