/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.cf;

import com.sap.engine.library.bytecode.cf.CFException;
import com.sap.engine.library.bytecode.cf.CFNode;
import com.sap.engine.library.bytecode.cf.ClassFile;
import com.sap.engine.library.bytecode.cf.Constants;
import com.sap.engine.library.bytecode.misc.Debug;

public final class CPInfo
extends CFNode
implements Constants {
    private ClassFile owner;
    private int tag;
    private int value0;
    private int value1;
    private String valueString;
    private int index;
    private String plainStringCache = null;

    CPInfo(ClassFile owner, int tag, int value0, int value1, String valueString, int index) {
        this.owner = owner;
        this.tag = tag;
        this.value0 = value0;
        this.value1 = value1;
        this.valueString = valueString;
        this.index = index;
    }

    public int getTag() {
        return this.tag;
    }

    public int getValueInt() {
        if (Debug.DEBUG_CF && this.tag != 3 && this.tag != 4) {
            throw new CFException(63);
        }
        return this.value0;
    }

    public long getValueLong() {
        if (Debug.DEBUG_CF && this.tag != 5 && this.tag != 6) {
            throw new CFException(65);
        }
        return (long)this.value0 << 32 | (long)this.value1 & 0xFFFFFFFFL;
    }

    public float getValueFloat() {
        if (Debug.DEBUG_CF && this.tag != 4) {
            throw new CFException(61);
        }
        return Float.intBitsToFloat(this.value0);
    }

    public double getValueDouble() {
        if (Debug.DEBUG_CF && this.tag != 6) {
            throw new CFException(60);
        }
        return Double.longBitsToDouble((long)this.value0 << 32 | (long)this.value1 & 0xFFFFFFFFL);
    }

    public CPInfo getValueString() {
        if (Debug.DEBUG_CF && this.tag != 8) {
            throw new CFException(68);
        }
        return this.owner.getCPInfo(this.value0);
    }

    public int getValueStringIndex() {
        if (Debug.DEBUG_CF && this.tag != 8) {
            throw new CFException(68);
        }
        return this.value0;
    }

    public String getString() {
        return this.valueString;
    }

    public CPInfo getValueName() {
        if (Debug.DEBUG_CF && this.tag != 7 && this.tag != 12) {
            throw new CFException(67);
        }
        return this.owner.getCPInfo(this.value0);
    }

    public int getValueNameIndex() {
        if (Debug.DEBUG_CF && this.tag != 7 && this.tag != 12) {
            throw new CFException(67);
        }
        return this.value0;
    }

    public CPInfo getValueClass() {
        if (Debug.DEBUG_CF && this.tag != 9 && this.tag != 10 && this.tag != 11) {
            throw new CFException(58);
        }
        return this.owner.getCPInfo(this.value0);
    }

    public int getValueClassIndex() {
        if (Debug.DEBUG_CF && this.tag != 9 && this.tag != 10 && this.tag != 11) {
            throw new CFException(58);
        }
        return this.value0;
    }

    public CPInfo getValueDescriptor() {
        if (Debug.DEBUG_CF && this.tag != 12) {
            throw new CFException(59);
        }
        return this.owner.getCPInfo(this.value1);
    }

    public int getValueDescriptorIndex() {
        if (Debug.DEBUG_CF && this.tag != 12) {
            throw new CFException(59);
        }
        return this.value1;
    }

    public CPInfo getValueNameAndType() {
        if (Debug.DEBUG_CF && this.tag != 9 && this.tag != 10 && this.tag != 11) {
            throw new CFException(66);
        }
        return this.owner.getCPInfo(this.value1);
    }

    public int getValueNameAndTypeIndex() {
        if (Debug.DEBUG_CF && this.tag != 9 && this.tag != 10 && this.tag != 11) {
            throw new CFException(66);
        }
        return this.value1;
    }

    public int getIndex() {
        return this.index;
    }

    public String toString() {
        switch (this.tag) {
            case 0: {
                return "<zeroth>";
            }
            case 7: {
                return "<class " + this.getValueName().getString() + ">";
            }
            case 9: {
                return "<field " + this.getValueClass().getValueName().getString() + '.' + this.getValueNameAndType().getValueName().getString() + " " + this.getValueNameAndType().getValueDescriptor().getString() + ">";
            }
            case 10: {
                return "<method " + this.getValueClass().getValueName().getString() + '.' + this.getValueNameAndType().getValueName().getString() + this.getValueNameAndType().getValueDescriptor().getString() + ">";
            }
            case 11: {
                return "<interface_method " + this.getValueClass().getValueName().getString() + '.' + this.getValueNameAndType().getValueName().getString() + this.getValueNameAndType().getValueDescriptor().getString() + ">";
            }
            case 12: {
                return "<name_and_type " + this.getValueName().getString() + " " + this.getValueDescriptor().getString() + ">";
            }
            case 8: {
                return "<string \"" + this.getValueString().getString() + "\">";
            }
            case 3: {
                return "<integer " + this.getValueInt() + ">";
            }
            case 5: {
                return "<long " + this.getValueLong() + ">";
            }
            case 6: {
                return "<double " + this.getValueDouble() + ">";
            }
            case 4: {
                return "<float " + this.getValueFloat() + ">";
            }
            case 1: {
                return "<utf8 \"" + this.getString() + "\">";
            }
        }
        return "<???>";
    }

    public String toPlainString() {
        if (this.plainStringCache != null) {
            return this.plainStringCache;
        }
        switch (this.tag) {
            case 0: {
                this.plainStringCache = "<zeroth>";
                break;
            }
            case 7: {
                this.plainStringCache = this.getValueName().getString();
                break;
            }
            case 9: {
                this.plainStringCache = this.getValueClass().getValueName().getString() + '.' + this.getValueNameAndType().getValueName().getString() + " " + this.getValueNameAndType().getValueDescriptor().getString();
                break;
            }
            case 10: {
                this.plainStringCache = this.getValueClass().getValueName().getString() + '.' + this.getValueNameAndType().getValueName().getString() + this.getValueNameAndType().getValueDescriptor().getString();
                break;
            }
            case 11: {
                this.plainStringCache = this.getValueClass().getValueName().getString() + '.' + this.getValueNameAndType().getValueName().getString() + this.getValueNameAndType().getValueDescriptor().getString();
                break;
            }
            case 12: {
                this.plainStringCache = this.getValueName().getString() + " " + this.getValueDescriptor();
                break;
            }
            case 8: {
                this.plainStringCache = this.getValueString().getString();
                break;
            }
            case 3: {
                this.plainStringCache = Integer.toString(this.getValueInt());
                break;
            }
            case 5: {
                this.plainStringCache = Long.toString(this.getValueLong());
                break;
            }
            case 6: {
                this.plainStringCache = Double.toString(this.getValueDouble());
                break;
            }
            case 4: {
                this.plainStringCache = Float.toString(this.getValueFloat());
                break;
            }
            case 1: {
                this.plainStringCache = this.getString();
                break;
            }
            default: {
                this.plainStringCache = "<???>";
            }
        }
        return this.plainStringCache;
    }

    public String toJasminString() {
        switch (this.tag) {
            case 0: {
                return "any";
            }
            case 7: {
                return this.getValueName().getString();
            }
            case 9: {
                return this.getValueClass().getValueName().getString() + '/' + this.getValueNameAndType().getValueName().getString() + " " + this.getValueNameAndType().getValueDescriptor().getString();
            }
            case 10: {
                return this.getValueClass().getValueName().getString() + '/' + this.getValueNameAndType().getValueName().getString() + this.getValueNameAndType().getValueDescriptor().getString();
            }
            case 11: {
                return this.getValueClass().getValueName().getString() + '/' + this.getValueNameAndType().getValueName().getString() + this.getValueNameAndType().getValueDescriptor().getString();
            }
            case 12: {
                return this.getValueName().getString() + " " + this.getValueDescriptor();
            }
            case 8: {
                return '\"' + this.getValueString().getString() + '\"';
            }
            case 3: {
                return Integer.toString(this.getValueInt());
            }
            case 5: {
                return Long.toString(this.getValueLong());
            }
            case 6: {
                return Double.toString(this.getValueDouble());
            }
            case 4: {
                return Float.toString(this.getValueFloat());
            }
            case 1: {
                return '\"' + this.getString() + '\"';
            }
        }
        return "???";
    }

    public ClassFile getOwner() {
        return this.owner;
    }

    public CFNode getParentNode() {
        return this.owner;
    }

    public CFNode[] getChildNodes() {
        return new CFNode[0];
    }
}

