/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.cf;

import com.sap.engine.library.bytecode.cf.AbstractSwitchTable;
import com.sap.engine.library.bytecode.cf.AttributeInfo;
import com.sap.engine.library.bytecode.cf.Attributed;
import com.sap.engine.library.bytecode.cf.CFException;
import com.sap.engine.library.bytecode.cf.CFFactory;
import com.sap.engine.library.bytecode.cf.CFSerializerOptions;
import com.sap.engine.library.bytecode.cf.CPInfo;
import com.sap.engine.library.bytecode.cf.ClassFile;
import com.sap.engine.library.bytecode.cf.CodeAttribute;
import com.sap.engine.library.bytecode.cf.ConstantValueAttribute;
import com.sap.engine.library.bytecode.cf.Constants;
import com.sap.engine.library.bytecode.cf.DeprecatedAttribute;
import com.sap.engine.library.bytecode.cf.ExceptionHandler;
import com.sap.engine.library.bytecode.cf.ExceptionsAttribute;
import com.sap.engine.library.bytecode.cf.FieldInfo;
import com.sap.engine.library.bytecode.cf.InnerClassesAttribute;
import com.sap.engine.library.bytecode.cf.InnerClassesAttributeEntry;
import com.sap.engine.library.bytecode.cf.Instruction;
import com.sap.engine.library.bytecode.cf.LineNumberTableAttribute;
import com.sap.engine.library.bytecode.cf.LocalVariableTableAttribute;
import com.sap.engine.library.bytecode.cf.LocalVariableTableEntry;
import com.sap.engine.library.bytecode.cf.LookupSwitchTable;
import com.sap.engine.library.bytecode.cf.MemberInfo;
import com.sap.engine.library.bytecode.cf.MethodInfo;
import com.sap.engine.library.bytecode.cf.SAPModifiedAttribute;
import com.sap.engine.library.bytecode.cf.SourceFileAttribute;
import com.sap.engine.library.bytecode.cf.SyntheticAttribute;
import com.sap.engine.library.bytecode.cf.TableSwitchTable;
import com.sap.engine.library.bytecode.cf.UnknownAttribute;
import com.sap.engine.library.bytecode.misc.Debug;
import java.io.ByteArrayOutputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public final class CFSerializer
implements Constants {
    private CFFactory factory;
    private Instruction[] instructions;
    private int[] offsetTable;

    CFSerializer(CFFactory factory) {
        this.factory = factory;
    }

    public void serialize(String filename, ClassFile cf, CFSerializerOptions options) throws IOException {
        this.serialize(new File(filename), cf, options);
    }

    public void serialize(File file, ClassFile cf, CFSerializerOptions options) throws IOException {
        file.getParentFile().mkdirs();
        this.serialize0(new DataOutputStream(new FileOutputStream(file)), cf, options);
    }

    public void serialize(DataOutput out, ClassFile cf, CFSerializerOptions options) throws IOException {
        this.serialize0(out, cf, options);
    }

    public void serialize(OutputStream out, ClassFile cf, CFSerializerOptions options) throws IOException {
        this.serialize0(new DataOutputStream(out), cf, options);
    }

    public byte[] serializeToByteArray(ClassFile cf, CFSerializerOptions options) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        DataOutputStream out1 = new DataOutputStream(out);
        this.serialize0(out1, cf, options);
        out1.flush();
        return out.toByteArray();
    }

    private void serialize0(DataOutput out, ClassFile cf, CFSerializerOptions options) throws IOException {
        options = options == null ? CFSerializerOptions.DEFAULT : options;
        out.writeInt(-889275714);
        out.writeShort(cf.getMinorVersion());
        out.writeShort(cf.getMajorVersion());
        CPInfo[] cp = cf.getCPInfosArray();
        int ncp = cp.length;
        out.writeShort(ncp);
        int i = 1;
        while (i < ncp) {
            CPInfo x = cp[i];
            int tag = x.getTag();
            out.writeByte(tag);
            switch (tag) {
                case 7: {
                    out.writeShort(x.getValueNameIndex());
                    break;
                }
                case 8: {
                    out.writeShort(x.getValueStringIndex());
                    break;
                }
                case 9: 
                case 10: 
                case 11: {
                    out.writeShort(x.getValueClassIndex());
                    out.writeShort(x.getValueNameAndTypeIndex());
                    break;
                }
                case 12: {
                    out.writeShort(x.getValueNameIndex());
                    out.writeShort(x.getValueDescriptorIndex());
                    break;
                }
                case 3: 
                case 4: {
                    out.writeInt(x.getValueInt());
                    break;
                }
                case 5: 
                case 6: {
                    out.writeLong(x.getValueLong());
                    ++i;
                    break;
                }
                case 1: {
                    out.writeUTF(x.getString());
                    break;
                }
                default: {
                    throw new CFException(81, new Integer(tag));
                }
            }
            ++i;
        }
        out.writeShort(cf.getAccessFlags());
        CPInfo thisClass = cf.getThisClass();
        if (Debug.DEBUG_CF && thisClass == null) {
            throw new CFException(84);
        }
        out.writeShort(thisClass.getIndex());
        CPInfo superClass = cf.getSuperClass();
        if (Debug.DEBUG_CF && superClass == null) {
            throw new CFException(83);
        }
        out.writeShort(superClass.getIndex());
        int nInterfaces = cf.getNInterfaces();
        out.writeShort(nInterfaces);
        int i2 = 0;
        while (i2 < nInterfaces) {
            out.writeShort(cf.getInterface(i2).getIndex());
            ++i2;
        }
        FieldInfo[] fields = cf.getFieldsArray();
        int nFields = fields.length;
        out.writeShort(nFields);
        int i3 = 0;
        while (i3 < nFields) {
            this.serializeMember(out, cf, fields[i3], options);
            ++i3;
        }
        MethodInfo[] methods = cf.getMethodsArray();
        int nMethods = methods.length;
        out.writeShort(nMethods);
        int i4 = 0;
        while (i4 < nMethods) {
            this.serializeMember(out, cf, methods[i4], options);
            ++i4;
        }
        this.serializeAttributes(out, cf, cf, options);
    }

    private void serializeMember(DataOutput out, ClassFile cf, MemberInfo x, CFSerializerOptions options) throws IOException {
        out.writeShort(x.getAccessFlags());
        out.writeShort(x.getNameCPInfo().getIndex());
        out.writeShort(x.getDescriptorCPInfo().getIndex());
        this.serializeAttributes(out, cf, x, options);
    }

    private void serializeAttributes(DataOutput out, ClassFile cf, Attributed attributed, CFSerializerOptions options) throws IOException {
        int nAttributes = attributed.getNAttributes();
        out.writeShort(nAttributes);
        AttributeInfo ca = attributed.getAttribute("Code");
        if (ca != null) {
            this.serializeAttribute(out, cf, attributed, ca, options);
        }
        int i = 0;
        while (i < nAttributes) {
            AttributeInfo a = attributed.getAttribute(i);
            if (a != ca) {
                this.serializeAttribute(out, cf, attributed, a, options);
            }
            ++i;
        }
    }

    private void serializeAttribute(DataOutput out, ClassFile cf, Attributed attributed, AttributeInfo a, CFSerializerOptions options) throws IOException {
        String name = a.getName();
        out.writeShort(cf.getCPInfoUtf8(name).getIndex());
        if (a instanceof CodeAttribute) {
            this.serializeCodeAttribute(out, cf, (CodeAttribute)a, options);
        } else if (a instanceof LineNumberTableAttribute) {
            if (!options.recomputeLineNumberTable) {
                LineNumberTableAttribute lineNumberTableAttribute = (LineNumberTableAttribute)a;
                Instruction[] startPCs = lineNumberTableAttribute.getStartPCsArray();
                int[] lineNumbers = lineNumberTableAttribute.getLineNumbersArray();
                int n = startPCs.length;
                out.writeInt(2 + 4 * n);
                out.writeShort(n);
                int i = 0;
                while (i < n) {
                    Instruction x = startPCs[i];
                    out.writeShort(x == null ? this.offsetTable[this.offsetTable.length - 1] : this.offsetTable[x.getIndex()]);
                    out.writeShort(lineNumbers[i]);
                    ++i;
                }
            } else {
                int n = 0;
                int[] startPCs = new int[this.instructions.length];
                int[] lineNumbers = new int[this.instructions.length];
                int lastLineNumber = -1;
                int i = 0;
                while (i < this.instructions.length) {
                    int lineNumber = this.instructions[i].getLineNumber();
                    if (lineNumber != lastLineNumber) {
                        startPCs[n] = this.offsetTable[i];
                        lineNumbers[n] = lastLineNumber = lineNumber;
                        ++n;
                    }
                    ++i;
                }
                out.writeInt(2 + 4 * n);
                out.writeShort(n);
                int i2 = 0;
                while (i2 < n) {
                    out.writeShort(startPCs[i2]);
                    out.writeShort(lineNumbers[i2]);
                    ++i2;
                }
            }
        } else if (a instanceof LocalVariableTableAttribute) {
            LocalVariableTableAttribute localVariableTableAttribute = (LocalVariableTableAttribute)a;
            LocalVariableTableEntry[] entries = localVariableTableAttribute.getEntriesArray();
            out.writeInt(2 + 10 * entries.length);
            out.writeShort(entries.length);
            int i = 0;
            while (i < entries.length) {
                int startOffset = this.offsetTable[entries[i].getStartPC().getIndex()];
                Instruction endPC = entries[i].getEndPC();
                int endOffset = endPC == null ? this.offsetTable[this.offsetTable.length - 1] : this.offsetTable[endPC.getIndex()];
                out.writeShort(startOffset);
                out.writeShort(endOffset - startOffset);
                out.writeShort(entries[i].getName().getIndex());
                out.writeShort(entries[i].getDescriptor().getIndex());
                out.writeShort(entries[i].getLocalVariable().getIndex());
                ++i;
            }
        } else if (a instanceof ExceptionsAttribute) {
            ExceptionsAttribute exceptionsAttribute = (ExceptionsAttribute)a;
            int nExceptions = exceptionsAttribute.getNExceptions();
            out.writeInt(2 * nExceptions + 2);
            out.writeShort(nExceptions);
            int i = 0;
            while (i < nExceptions) {
                out.writeShort(exceptionsAttribute.getException(i).getIndex());
                ++i;
            }
        } else if (a instanceof ConstantValueAttribute) {
            out.writeInt(2);
            out.writeShort(((ConstantValueAttribute)a).getConstantValue().getIndex());
        } else if (a instanceof SyntheticAttribute || a instanceof DeprecatedAttribute) {
            out.writeInt(0);
        } else if (a instanceof SourceFileAttribute) {
            out.writeInt(2);
            out.writeShort(((SourceFileAttribute)a).getSourceFile().getIndex());
        } else if (a instanceof InnerClassesAttribute) {
            InnerClassesAttributeEntry[] entries = ((InnerClassesAttribute)a).getEntries();
            int nEntries = entries.length;
            out.writeInt(8 * nEntries + 2);
            out.writeShort(nEntries);
            int i = 0;
            while (i < nEntries) {
                InnerClassesAttributeEntry entry = entries[i];
                out.writeShort(entry.getInnerClass().getIndex());
                out.writeShort(entry.getOuterClass().getIndex());
                out.writeShort(entry.getInnerNameCPInfo().getIndex());
                out.writeShort(entry.getInnerAccessFlags());
                ++i;
            }
        } else if (a instanceof SAPModifiedAttribute) {
            out.writeInt(2);
            out.writeShort(((SAPModifiedAttribute)a).getVersion());
        } else {
            byte[] value = ((UnknownAttribute)a).getValue();
            out.writeInt(value.length);
            out.write(value);
        }
    }

    private void serializeCodeAttribute(DataOutput out, ClassFile cf, CodeAttribute ca, CFSerializerOptions options) throws IOException {
        int maxLocals;
        int maxStack;
        ByteArrayOutputStream out0 = new ByteArrayOutputStream();
        DataOutputStream out1 = new DataOutputStream(out0);
        this.instructions = ca.getInstructionsArray();
        ExceptionHandler[] exceptionHandlers = ca.getExceptionHandlersArray();
        this.offsetTable = CFSerializer.calculateOffsets(this.instructions);
        int[][] successorTable = CFSerializer.calculateSuccessorsTable(this.instructions);
        int[] stackSizes = CFSerializer.calculateStackSizes(this.instructions, exceptionHandlers, successorTable);
        int nInstructions = this.instructions.length;
        int codeLength = this.offsetTable[nInstructions];
        int n = maxStack = options.recomputeMaxStack ? CFSerializer.calculateMaxStack(stackSizes) : ca.getOriginalMaxStack();
        if (options.recomputeMaxLocals) {
            maxLocals = ca.calculateMaxLocals();
            if (options.preserveOriginalMaxLocalsIfGreaterThanComputed) {
                maxLocals = Math.max(maxLocals, ca.getOriginalMaxLocals());
            }
        } else {
            maxLocals = ca.getOriginalMaxLocals();
        }
        out1.writeShort(maxStack);
        out1.writeShort(maxLocals);
        out1.writeInt(codeLength);
        int i = 0;
        while (i < nInstructions) {
            Instruction x = this.instructions[i];
            int opcode = x.getOpcode();
            block0 : switch (Constants.INSTRUCTION_OPERANDS[opcode]) {
                case 1: {
                    out1.writeByte(opcode);
                    break;
                }
                case 2: {
                    out1.writeByte(opcode);
                    int operand0 = x.getOperandInt();
                    switch (opcode) {
                        case 16: {
                            out1.writeByte(operand0);
                            break block0;
                        }
                        case 17: {
                            out1.writeShort(operand0);
                            break block0;
                        }
                        case 188: {
                            out1.writeByte(operand0);
                            break block0;
                        }
                    }
                    throw new CFException(85);
                }
                case 3: {
                    CPInfo operandCPInfo = x.getOperandCPInfo();
                    int operandIndex = operandCPInfo.getIndex();
                    if (opcode == 18 || opcode == 19 || opcode == 20) {
                        int tag = operandCPInfo.getTag();
                        if (tag == 6 || tag == 5) {
                            out1.writeByte(20);
                            out1.writeShort(operandIndex);
                            break;
                        }
                        if (operandIndex > 255) {
                            out1.writeByte(19);
                            out1.writeShort(operandIndex);
                            break;
                        }
                        out1.writeByte(18);
                        out1.writeByte(operandIndex);
                        break;
                    }
                    out1.writeByte(opcode);
                    out1.writeShort(operandIndex);
                    break;
                }
                case 4: {
                    int operand0 = x.getOperandLocalVariable().getIndex();
                    if (operand0 > 255) {
                        out1.writeByte(196);
                        out1.writeByte(opcode);
                        out1.writeShort(operand0);
                        break;
                    }
                    out1.writeByte(opcode);
                    out1.writeByte(operand0);
                    break;
                }
                case 5: {
                    Instruction branch = x.getOperandInstruction();
                    out1.writeByte(opcode);
                    out1.writeShort(this.offsetTable[branch.getIndex()] - this.offsetTable[x.getIndex()]);
                    break;
                }
                case 6: {
                    int xOffset = this.offsetTable[x.getIndex()];
                    out1.writeByte(opcode);
                    TableSwitchTable table = x.getOperandTableSwitchTable();
                    int padding = AbstractSwitchTable.getPadding(xOffset);
                    int j = 0;
                    while (j < padding) {
                        out1.writeByte(0);
                        ++j;
                    }
                    out1.writeInt(this.offsetTable[table.getDefaultBranch().getIndex()] - xOffset);
                    int low = table.getLowValue();
                    int high = table.getHighValue();
                    int nBranches = table.getNBranches();
                    out1.writeInt(low);
                    out1.writeInt(high);
                    int j2 = 0;
                    while (j2 < nBranches) {
                        out1.writeInt(this.offsetTable[table.getBranchByIndex(j2).getIndex()] - xOffset);
                        ++j2;
                    }
                    break;
                }
                case 7: {
                    int xOffset = this.offsetTable[x.getIndex()];
                    out1.writeByte(opcode);
                    LookupSwitchTable table = x.getOperandLookupSwitchTable();
                    int padding = AbstractSwitchTable.getPadding(xOffset);
                    int j = 0;
                    while (j < padding) {
                        out1.writeByte(0);
                        ++j;
                    }
                    out1.writeInt(this.offsetTable[table.getDefaultBranch().getIndex()] - xOffset);
                    int nBranches = table.getNBranches();
                    out1.writeInt(nBranches);
                    int j3 = 0;
                    while (j3 < nBranches) {
                        out1.writeInt(table.getMatch(j3));
                        out1.writeInt(this.offsetTable[table.getBranchByIndex(j3).getIndex()] - xOffset);
                        ++j3;
                    }
                    break;
                }
                case 8: {
                    int lvIndex = x.getOperandLocalVariable().getIndex();
                    int increment = x.getOperandInt();
                    if (lvIndex > 255 || increment > 255) {
                        out1.writeByte(196);
                        out1.writeByte(opcode);
                        out1.writeShort(lvIndex);
                        out1.writeShort(increment);
                        break;
                    }
                    out1.writeByte(opcode);
                    out1.writeByte(lvIndex);
                    out1.writeByte(increment);
                    break;
                }
                case 9: {
                    int cpIndex = x.getOperandCPInfo().getIndex();
                    int value = x.getOperandInt();
                    out1.writeByte(opcode);
                    out1.writeShort(cpIndex);
                    out1.writeByte(value);
                    if (opcode != 185) break;
                    out1.writeByte(0);
                    break;
                }
                default: {
                    throw new CFException(86, new Object[]{Constants.MNEMONIC[opcode], new Integer(opcode)});
                }
            }
            ++i;
        }
        int nExceptionHandlers = ca.getNExceptionHandlers();
        out1.writeShort(nExceptionHandlers);
        int i2 = 0;
        while (i2 < nExceptionHandlers) {
            ExceptionHandler handler = ca.getExceptionHandler(i2);
            out1.writeShort(this.offsetTable[handler.getStartPC().getIndex()]);
            Instruction endPCInclusive = handler.getEndPCInclusive();
            if (endPCInclusive == null) {
                throw new CFException(79, ca.getOwnerMethod());
            }
            Instruction endPCExclusive = endPCInclusive.getNextInstruction();
            out1.writeShort(endPCExclusive == null ? this.offsetTable[this.offsetTable.length - 1] : this.offsetTable[endPCExclusive.getIndex()]);
            out1.writeShort(this.offsetTable[handler.getHandlerPC().getIndex()]);
            out1.writeShort(handler.getCatchType().getIndex());
            ++i2;
        }
        this.serializeAttributes(out1, cf, ca, options);
        out1.flush();
        byte[] ba = out0.toByteArray();
        out.writeInt(ba.length);
        out.write(ba);
    }

    public static int[] calculateOffsets(Instruction[] instructions) {
        int nInstructions = instructions.length;
        int[] r = new int[nInstructions + 1];
        int offset = 0;
        int i = 0;
        while (i < nInstructions) {
            r[i] = offset;
            Instruction x = instructions[i];
            int opcode = x.getOpcode();
            switch (opcode) {
                case 21: 
                case 22: 
                case 23: 
                case 24: 
                case 25: 
                case 54: 
                case 55: 
                case 56: 
                case 57: 
                case 58: 
                case 169: {
                    int lvIndex = x.getOperandLocalVariable().getIndex();
                    offset += lvIndex > 255 ? 4 : 2;
                    break;
                }
                case 132: {
                    int lvIndex = x.getOperandLocalVariable().getIndex();
                    int increment = x.getOperandInt();
                    offset += lvIndex > 255 || increment > 255 ? 6 : 3;
                    break;
                }
                case 170: 
                case 171: {
                    AbstractSwitchTable table = x.getOperandAbstractSwitchTable();
                    int padding = 4 - (offset + 1 & 3) & 3;
                    offset += opcode == 170 ? padding + 13 + 4 * table.getNBranches() : padding + 9 + 8 * table.getNBranches();
                    break;
                }
                default: {
                    int l = Constants.INSTRUCTION_LENGTH[opcode];
                    if (l < 0) {
                        throw new CFException(75, new Object[]{Constants.MNEMONIC[opcode], new Integer(opcode)});
                    }
                    offset += l;
                    break;
                }
            }
            ++i;
        }
        r[nInstructions] = offset;
        return r;
    }

    public static int[][] calculateSuccessorsTable(Instruction[] instructions) {
        int nInstructions = instructions.length;
        int[][] r = new int[nInstructions][];
        int i = 0;
        while (i < nInstructions) {
            int opcode = instructions[i].getOpcode();
            switch (opcode) {
                case 169: 
                case 172: 
                case 173: 
                case 174: 
                case 175: 
                case 176: 
                case 177: 
                case 191: {
                    r[i] = Constants.INT_ARRAY_0;
                    break;
                }
                case 167: 
                case 200: {
                    r[i] = new int[]{instructions[i].getOperandInstruction().getIndex()};
                    break;
                }
                case 153: 
                case 154: 
                case 155: 
                case 156: 
                case 157: 
                case 158: 
                case 159: 
                case 160: 
                case 161: 
                case 162: 
                case 163: 
                case 164: 
                case 165: 
                case 166: 
                case 168: 
                case 198: 
                case 199: 
                case 201: {
                    r[i] = new int[]{instructions[i].getOperandInstruction().getIndex(), i + 1};
                    break;
                }
                case 170: 
                case 171: {
                    AbstractSwitchTable table = instructions[i].getOperandAbstractSwitchTable();
                    r[i] = table.getSuccessorIndicesArray();
                    break;
                }
                default: {
                    r[i] = i < nInstructions - 1 ? new int[]{i + 1} : Constants.INT_ARRAY_0;
                }
            }
            ++i;
        }
        return r;
    }

    public static int[] calculateStackSizes(Instruction[] instructions, ExceptionHandler[] exceptionHandlers, int[][] successorsTable) {
        boolean isFinished;
        int nInstructions = instructions.length;
        int nExceptionHandlers = exceptionHandlers.length;
        int[] stackSize = new int[nInstructions];
        int[] status = new int[nInstructions];
        int i = 0;
        while (i < nExceptionHandlers) {
            int h = exceptionHandlers[i].getHandlerPC().getIndex();
            stackSize[h] = 1;
            status[h] = 1;
            ++i;
        }
        stackSize[0] = 0;
        status[0] = 1;
        do {
            isFinished = true;
            int i2 = 0;
            while (i2 < nInstructions) {
                if (status[i2] == 1) {
                    isFinished = false;
                    status[i2] = 2;
                    int[] successors = successorsTable[i2];
                    int j = 0;
                    while (j < successors.length) {
                        int opcode;
                        int successor = successors[j];
                        int expectedStackSize = stackSize[i2] - instructions[i2].getStackDecrease() + instructions[i2].getStackIncrease();
                        if (j == 1 && ((opcode = instructions[i2].getOpcode()) == 168 || opcode == 201)) {
                            expectedStackSize = 0;
                        }
                        if (expectedStackSize < 0) {
                            if (Debug.DEBUG_CF) {
                                CFSerializer.dumpCode(instructions, successorsTable, status, stackSize);
                            }
                            throw new CFException(82, new Integer(i2));
                        }
                        if (status[successor] == 0) {
                            isFinished = false;
                            stackSize[successor] = expectedStackSize;
                            status[successor] = 1;
                        } else if (stackSize[successor] != expectedStackSize) {
                            if (Debug.DEBUG_CF) {
                                CFSerializer.dumpCode(instructions, successorsTable, status, stackSize);
                            }
                            throw new CFException(80, new Object[]{instructions[0].getOwnerCodeAttribute().getOwnerMethod(), new Integer(stackSize[successor]), new Integer(expectedStackSize), Constants.MNEMONIC[instructions[i2].getOpcode()], new Integer(successor), Constants.MNEMONIC[instructions[successor].getOpcode()]});
                        }
                        ++j;
                    }
                }
                ++i2;
            }
        } while (!isFinished);
        return stackSize;
    }

    private static void dumpCode(Instruction[] instructions, int[][] successorsTable, int[] status, int[] stackSize) {
        int nInstructions = instructions.length;
        int[] offsetTable = CFSerializer.calculateOffsets(instructions);
        System.out.println("DUMP === START STACK SIZES DUMP FOR " + instructions[0].getOwnerCodeAttribute().getOwnerMethod());
        int k = 0;
        while (k < nInstructions) {
            System.out.print("DUMP   [index:" + k + "] [offset: _" + offsetTable[k] + "] '" + instructions[k] + "' stack: " + stackSize[k] + (status[k] == 1 ? ", MARKED" : (status[k] == 0 ? ", NOT PROCESSED" : "")) + ", successors: (");
            int u = 0;
            while (u < successorsTable[k].length) {
                System.out.print(" " + successorsTable[k][u]);
                ++u;
            }
            System.out.println(" )");
            ++k;
        }
        System.out.println("DUMP === END STACK SIZES DUMP ");
    }

    public static int calculateMaxStack(int[] stackSizes) {
        int r = 0;
        int nInstructions = stackSizes.length;
        int i = 0;
        while (i < nInstructions) {
            if (r < stackSizes[i]) {
                r = stackSizes[i];
            }
            ++i;
        }
        return r;
    }
}

