/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.cf;

import com.sap.engine.library.bytecode.cf.AbstractSwitchTable;
import com.sap.engine.library.bytecode.cf.AttributeInfo;
import com.sap.engine.library.bytecode.cf.Attributed;
import com.sap.engine.library.bytecode.cf.ByteArrayDataInput;
import com.sap.engine.library.bytecode.cf.CFException;
import com.sap.engine.library.bytecode.cf.CFFactory;
import com.sap.engine.library.bytecode.cf.CFParserOptions;
import com.sap.engine.library.bytecode.cf.CPInfo;
import com.sap.engine.library.bytecode.cf.ClassFile;
import com.sap.engine.library.bytecode.cf.CodeAttribute;
import com.sap.engine.library.bytecode.cf.ConstantValueAttribute;
import com.sap.engine.library.bytecode.cf.Constants;
import com.sap.engine.library.bytecode.cf.DeprecatedAttribute;
import com.sap.engine.library.bytecode.cf.ExceptionHandler;
import com.sap.engine.library.bytecode.cf.ExceptionsAttribute;
import com.sap.engine.library.bytecode.cf.FieldInfo;
import com.sap.engine.library.bytecode.cf.InnerClassesAttribute;
import com.sap.engine.library.bytecode.cf.InnerClassesAttributeEntry;
import com.sap.engine.library.bytecode.cf.Instruction;
import com.sap.engine.library.bytecode.cf.LineNumberTableAttribute;
import com.sap.engine.library.bytecode.cf.LocalVariable;
import com.sap.engine.library.bytecode.cf.LocalVariableTableAttribute;
import com.sap.engine.library.bytecode.cf.LocalVariableTableEntry;
import com.sap.engine.library.bytecode.cf.LookupSwitchTable;
import com.sap.engine.library.bytecode.cf.MethodInfo;
import com.sap.engine.library.bytecode.cf.SAPModifiedAttribute;
import com.sap.engine.library.bytecode.cf.SourceFileAttribute;
import com.sap.engine.library.bytecode.cf.SyntheticAttribute;
import com.sap.engine.library.bytecode.cf.TableSwitchTable;
import com.sap.engine.library.bytecode.cf.UnknownAttribute;
import com.sap.engine.library.bytecode.misc.ArrayUtils;
import com.sap.engine.library.bytecode.misc.Debug;
import com.sap.engine.library.bytecode.misc.StringUtils;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;

public final class CFParser
implements Constants {
    private CFFactory factory;
    private Instruction[] offsetTable;

    CFParser(CFFactory factory) {
        this.factory = factory;
    }

    public ClassFile parse(byte[] bytecode, CFParserOptions options) throws IOException {
        return this.parse0((byte[])bytecode.clone(), options);
    }

    public ClassFile parse(String filename, CFParserOptions options) throws IOException {
        return this.parse(new FileInputStream(filename), options);
    }

    public ClassFile parse(File file, CFParserOptions options) throws IOException {
        return this.parse(new FileInputStream(file), options);
    }

    public ClassFile parse(InputStream in0, CFParserOptions options) throws IOException {
        return this.parse0(ArrayUtils.readFully(in0), options);
    }

    ClassFile parse0(byte[] bytecode, CFParserOptions options) throws IOException {
        options = options == null ? CFParserOptions.DEFAULT : options;
        ByteArrayDataInput in = new ByteArrayDataInput(bytecode);
        ClassFile cf = new ClassFile(this.factory, bytecode);
        cf.setOffsetStartAndEnd(0, bytecode.length);
        int magic = in.readInt();
        if (magic != -889275714) {
            throw new CFException(72, new Object[]{"0x" + StringUtils.toHexString(magic, 8), "0x" + StringUtils.toHexString(-889275714L, 8)});
        }
        int minorVersion = in.readUnsignedShort();
        int majorVersion = in.readUnsignedShort();
        cf.setVersion(majorVersion, minorVersion);
        int ncp = in.readUnsignedShort();
        int i = 1;
        while (i < ncp) {
            CPInfo x;
            int offsetStart = in.getPosition();
            int tag = in.readUnsignedByte();
            switch (tag) {
                case 7: 
                case 8: {
                    int value0 = in.readUnsignedShort();
                    x = new CPInfo(cf, tag, value0, 0, null, i);
                    break;
                }
                case 9: 
                case 10: 
                case 11: 
                case 12: {
                    int value0 = in.readUnsignedShort();
                    int value1 = in.readUnsignedShort();
                    x = new CPInfo(cf, tag, value0, value1, null, i);
                    break;
                }
                case 3: 
                case 4: {
                    int value0 = in.readInt();
                    x = new CPInfo(cf, tag, value0, 0, null, i);
                    break;
                }
                case 5: 
                case 6: {
                    int value0 = in.readInt();
                    int value1 = in.readInt();
                    x = new CPInfo(cf, tag, value0, value1, null, i);
                    cf.addCPInfo(x);
                    ++i;
                    break;
                }
                case 1: {
                    String s = in.readUTF();
                    x = new CPInfo(cf, tag, 0, 0, s, i);
                    break;
                }
                default: {
                    throw new CFException(74, new Object[]{new Integer(tag), new Integer(i)});
                }
            }
            int offsetEnd = in.getPosition();
            x.setOffsetStartAndEnd(offsetStart, offsetEnd);
            cf.addCPInfo(x);
            ++i;
        }
        cf.setAccessFlags(in.readUnsignedShort());
        cf.setThisClass(cf.getCPInfo(in.readUnsignedShort()));
        cf.setSuperClass(cf.getCPInfo(in.readUnsignedShort()));
        int nInterfaces = in.readUnsignedShort();
        int i2 = 0;
        while (i2 < nInterfaces) {
            cf.addInterface(cf.getCPInfo(in.readUnsignedShort()));
            ++i2;
        }
        int nFields = in.readUnsignedShort();
        int i3 = 0;
        while (i3 < nFields) {
            int offsetStart = in.getPosition();
            int accessFlags = in.readUnsignedShort();
            CPInfo name = cf.getCPInfo(in.readUnsignedShort());
            CPInfo descriptor = cf.getCPInfo(in.readUnsignedShort());
            FieldInfo f = new FieldInfo(this.factory, cf, accessFlags, name, descriptor);
            this.parseAttributes(in, cf, f, options);
            cf.addFieldInfo(f);
            int offsetEnd = in.getPosition();
            f.setOffsetStartAndEnd(offsetStart, offsetEnd);
            ++i3;
        }
        int nMethods = in.readUnsignedShort();
        int i4 = 0;
        while (i4 < nMethods) {
            int offsetStart = in.getPosition();
            int accessFlags = in.readUnsignedShort();
            CPInfo name = cf.getCPInfo(in.readUnsignedShort());
            CPInfo descriptor = cf.getCPInfo(in.readUnsignedShort());
            MethodInfo m = new MethodInfo(this.factory, cf, accessFlags, name, descriptor);
            this.parseAttributes(in, cf, m, options);
            cf.addMethodInfo(m);
            int offsetEnd = in.getPosition();
            m.setOffsetStartAndEnd(offsetStart, offsetEnd);
            ++i4;
        }
        this.parseAttributes(in, cf, cf, options);
        return cf;
    }

    private void parseAttributes(ByteArrayDataInput in, ClassFile cf, Attributed attributed, CFParserOptions options) throws IOException {
        int nAttributes = in.readUnsignedShort();
        int i = 0;
        while (i < nAttributes) {
            int offsetStart = in.getPosition();
            AttributeInfo a = this.parseAttributeInfo(in, cf, attributed, options);
            attributed.addAttribute(a);
            int offsetEnd = in.getPosition();
            a.setOffsetStartAndEnd(offsetStart, offsetEnd);
            ++i;
        }
    }

    private AttributeInfo parseAttributeInfo(ByteArrayDataInput in, ClassFile cf, Attributed attributed, CFParserOptions options) throws IOException {
        CPInfo name = cf.getCPInfo(in.readUnsignedShort());
        int attributeLength = in.readInt();
        if (options.whatToParse == 3) {
            return this.parseUnknownAttribute(in, name, attributeLength);
        }
        String s = name.getString();
        if (s.equals("Code")) {
            return this.parseCodeAttribute(in, cf, name, attributeLength, (MethodInfo)attributed, options);
        }
        if (s.equals("LineNumberTable")) {
            LineNumberTableAttribute lineNumberTableAttribute = new LineNumberTableAttribute(this.factory);
            int n = in.readUnsignedShort();
            int[] startPCs = new int[n];
            String[] startPCLabels = new String[n];
            int[] lineNumbers = new int[n];
            Instruction[] instructions = ((CodeAttribute)attributed).getInstructionsArray();
            int j = 0;
            int currentLineNumber = 0;
            int i = 0;
            while (i < n) {
                int offset;
                startPCs[i] = offset = in.readUnsignedShort();
                startPCLabels[i] = this.factory.createGeneratedLabel(offset);
                lineNumbers[i] = in.readUnsignedShort();
                while (j < instructions.length && instructions[j].getOriginalOffset() < offset) {
                    instructions[j].setLineNumber(currentLineNumber);
                    ++j;
                }
                currentLineNumber = lineNumbers[i];
                ++i;
            }
            while (j < instructions.length) {
                instructions[j].setLineNumber(currentLineNumber);
                ++j;
            }
            return lineNumberTableAttribute.init((CodeAttribute)attributed, startPCLabels, lineNumbers);
        }
        if (s.equals("SourceFile")) {
            SourceFileAttribute sourceFileAttribute = new SourceFileAttribute();
            if (attributeLength != 2) {
                throw new CFException(71, new Object[]{"SourceFile", new Integer(2), new Integer(attributeLength)});
            }
            sourceFileAttribute.setSourceFile(cf.getCPInfo(in.readUnsignedShort()));
            return sourceFileAttribute;
        }
        if (s.equals("Synthetic")) {
            SyntheticAttribute syntheticAttribute = new SyntheticAttribute();
            if (attributeLength != 0) {
                throw new CFException(71, new Object[]{"Synthetic", new Integer(0), new Integer(attributeLength)});
            }
            return syntheticAttribute;
        }
        if (s.equals("Deprecated")) {
            DeprecatedAttribute deprecatedAttribute = new DeprecatedAttribute();
            if (attributeLength != 0) {
                throw new CFException(71, new Object[]{"Deprecated", new Integer(0), new Integer(attributeLength)});
            }
            return deprecatedAttribute;
        }
        if (s.equals("ConstantValue")) {
            ConstantValueAttribute constantValueAttribute = new ConstantValueAttribute();
            if (attributeLength != 2) {
                throw new CFException(71, new Object[]{"ConstantValue", new Integer(2), new Integer(attributeLength)});
            }
            constantValueAttribute.setConstantValue(cf.getCPInfo(in.readUnsignedShort()));
            return constantValueAttribute;
        }
        if (s.equals("Exceptions")) {
            ExceptionsAttribute exceptionsAttribute = new ExceptionsAttribute();
            int n = in.readUnsignedShort();
            int i = 0;
            while (i < n) {
                exceptionsAttribute.addException(cf.getCPInfo(in.readUnsignedShort()));
                ++i;
            }
            return exceptionsAttribute;
        }
        if (s.equals("LocalVariableTable")) {
            LocalVariableTableAttribute localVariableTableAttribute = new LocalVariableTableAttribute(this.factory, (CodeAttribute)attributed);
            int n = in.readUnsignedShort();
            int i = 0;
            while (i < n) {
                int offsetStart = in.getPosition();
                int startPCOffset = in.readUnsignedShort();
                String startPCLabel = this.factory.createGeneratedLabel(startPCOffset);
                int endPCOffset = startPCOffset + in.readUnsignedShort();
                String endPCLabel = this.factory.createGeneratedLabel(endPCOffset);
                int nameIndex = in.readUnsignedShort();
                CPInfo variableName = cf.getCPInfo(nameIndex);
                int descriptorIndex = in.readUnsignedShort();
                CPInfo variableDescriptor = cf.getCPInfo(descriptorIndex);
                LocalVariable localVariable = this.factory.createLocalVariable(in.readUnsignedShort());
                LocalVariableTableEntry entry = localVariableTableAttribute.addEntry(startPCLabel, endPCLabel, variableName, variableDescriptor, localVariable);
                int offsetEnd = in.getPosition();
                entry.setOffsetStartAndEnd(offsetStart, offsetEnd);
                ++i;
            }
            return localVariableTableAttribute;
        }
        if (s.equals("InnerClasses")) {
            InnerClassesAttribute innerClassesAttribute = new InnerClassesAttribute(cf);
            int numberOfClasses = in.readUnsignedShort();
            int i = 0;
            while (i < numberOfClasses) {
                int offsetStart = in.getPosition();
                CPInfo innerClass = cf.getCPInfo(in.readUnsignedShort());
                CPInfo outerClass = cf.getCPInfo(in.readUnsignedShort());
                CPInfo innerName = cf.getCPInfo(in.readUnsignedShort());
                int innerAccessFlags = in.readUnsignedShort();
                InnerClassesAttributeEntry entry = innerClassesAttribute.addEntry(innerClass, outerClass, innerName, innerAccessFlags);
                int offsetEnd = in.getPosition();
                entry.setOffsetStartAndEnd(offsetStart, offsetEnd);
                ++i;
            }
            return innerClassesAttribute;
        }
        if (s.equals("COM.SAP.Modified")) {
            if (attributeLength == 2) {
                return new SAPModifiedAttribute(in.readUnsignedShort());
            }
            int i = 0;
            while (i < attributeLength) {
                in.readByte();
                ++i;
            }
            return new SAPModifiedAttribute(0);
        }
        return this.parseUnknownAttribute(in, name, attributeLength);
    }

    private AttributeInfo parseUnknownAttribute(ByteArrayDataInput in, CPInfo name, int attributeLength) throws IOException {
        byte[] value = new byte[attributeLength];
        in.readFully(value);
        return new UnknownAttribute(this.factory, name, value);
    }

    private AttributeInfo parseCodeAttribute(ByteArrayDataInput in, ClassFile cf, CPInfo attributeName, int attributeLength, MethodInfo m, CFParserOptions options) throws IOException {
        if (options.whatToParse == 2) {
            return this.parseUnknownAttribute(in, attributeName, attributeLength);
        }
        CodeAttribute codeAttribute = new CodeAttribute(this.factory, m);
        codeAttribute.setOriginalMaxStack(in.readUnsignedShort());
        codeAttribute.setMaxLocals(in.readUnsignedShort());
        int codeLength = in.readInt();
        this.offsetTable = new Instruction[codeLength];
        int offset = 0;
        boolean wide = false;
        while (offset < codeLength) {
            int offsetStart = in.getPosition();
            int opcode = in.readUnsignedByte();
            if (opcode == 196) {
                wide = true;
                continue;
            }
            int offset1 = wide ? offset + 2 : offset + 1;
            Instruction x = new Instruction(this.factory, codeAttribute);
            switch (Constants.INSTRUCTION_OPERANDS[opcode]) {
                case 1: {
                    x.init(opcode);
                    break;
                }
                case 3: {
                    int cpIndex = opcode == 18 ? in.readUnsignedByte() : in.readUnsignedShort();
                    offset1 += opcode == 18 ? 1 : 2;
                    CPInfo cpInfo = cf.getCPInfo(cpIndex);
                    x.init(opcode, cpInfo);
                    break;
                }
                case 9: {
                    int temp;
                    int cpIndex = in.readUnsignedShort();
                    CPInfo cpInfo = cf.getCPInfo(cpIndex);
                    int arg = in.readUnsignedByte();
                    if (opcode == 197) {
                        offset1 += 3;
                    } else if (opcode == 185) {
                        temp = in.readUnsignedByte();
                        if (temp != 0) {
                            throw new CFException(76, "invokeinterface");
                        }
                        offset1 += 4;
                    } else {
                        throw new CFException(70);
                    }
                    x.init(opcode, cpInfo, arg);
                    break;
                }
                case 5: {
                    int branchOffset = opcode == 200 || opcode == 201 ? in.readInt() : (int)in.readShort();
                    offset1 += opcode == 200 || opcode == 201 ? 4 : 2;
                    x.init(opcode, this.factory.createGeneratedLabel(branchOffset += offset));
                    break;
                }
                case 2: {
                    short arg = opcode == 17 ? in.readShort() : (short)in.readByte();
                    offset1 += opcode == 17 ? 2 : 1;
                    x.init(opcode, arg);
                    break;
                }
                case 4: {
                    int lvIndex = wide ? in.readUnsignedShort() : in.readUnsignedByte();
                    offset1 += wide ? 2 : 1;
                    x.init(opcode, this.factory.createLocalVariable(lvIndex));
                    break;
                }
                case 8: {
                    int lvIndex = wide ? in.readUnsignedShort() : in.readUnsignedByte();
                    short arg = wide ? in.readShort() : (short)in.readByte();
                    offset1 += wide ? 4 : 2;
                    x.init(opcode, this.factory.createLocalVariable(lvIndex), (int)arg);
                    break;
                }
                case 6: {
                    int temp;
                    TableSwitchTable table = new TableSwitchTable(this.factory);
                    int padding = AbstractSwitchTable.getPadding(offset);
                    int i = 0;
                    while (i < padding) {
                        temp = in.readUnsignedByte();
                        if (temp != 0) {
                            throw new CFException(76, "tableswitch");
                        }
                        ++i;
                    }
                    offset1 += padding;
                    String defaultBranchLabel = this.factory.createGeneratedLabel(in.readInt() + offset);
                    int low = in.readInt();
                    int high = in.readInt();
                    int n = high - low + 1;
                    offset1 += 12 + 4 * n;
                    String[] branchLabels = new String[n];
                    int i2 = 0;
                    while (i2 < n) {
                        branchLabels[i2] = this.factory.createGeneratedLabel(in.readInt() + offset);
                        ++i2;
                    }
                    table.init(x, low, high, defaultBranchLabel, branchLabels);
                    x.init(opcode, table);
                    break;
                }
                case 7: {
                    int temp;
                    LookupSwitchTable table = new LookupSwitchTable(this.factory);
                    int padding = AbstractSwitchTable.getPadding(offset);
                    int i = 0;
                    while (i < padding) {
                        temp = in.readUnsignedByte();
                        if (temp != 0) {
                            throw new CFException(76, "lookupswitch");
                        }
                        ++i;
                    }
                    offset1 += padding;
                    String defaultBranchLabel = this.factory.createGeneratedLabel(in.readInt() + offset);
                    int nPairs = in.readInt();
                    int[] matches = new int[nPairs];
                    String[] branchLabels = new String[nPairs];
                    offset1 += 8 + 8 * nPairs;
                    int i3 = 0;
                    while (i3 < nPairs) {
                        matches[i3] = in.readInt();
                        branchLabels[i3] = this.factory.createGeneratedLabel(in.readInt() + offset);
                        ++i3;
                    }
                    table.init(x, defaultBranchLabel, matches, branchLabels, nPairs);
                    x.init(opcode, table);
                    break;
                }
                default: {
                    throw new CFException(77, new Object[]{new Integer(opcode), Constants.MNEMONIC[opcode], m});
                }
            }
            x.addLabel(this.factory.createGeneratedLabel(offset));
            wide = false;
            this.offsetTable[offset] = x;
            x.setOriginalOffset(offset);
            codeAttribute.addInstruction(x);
            offset = offset1;
            int offsetEnd = in.getPosition();
            x.setOffsetStartAndEnd(offsetStart, offsetEnd);
        }
        if (offset != codeLength) {
            throw new CFException(73, new Object[]{new Integer(codeLength), new Integer(offset)});
        }
        int exceptionTableLength = in.readUnsignedShort();
        int i = 0;
        while (i < exceptionTableLength) {
            int offsetStart = in.getPosition();
            String startPCLabel = this.factory.createGeneratedLabel(in.readUnsignedShort());
            String endPCLabel = this.factory.createGeneratedLabel(in.readUnsignedShort());
            String handlerPCLabel = this.factory.createGeneratedLabel(in.readUnsignedShort());
            CPInfo catchType = cf.getCPInfo(in.readUnsignedShort());
            ExceptionHandler handler = codeAttribute.addExceptionHandler(startPCLabel, endPCLabel, false, handlerPCLabel, catchType);
            int offsetEnd = in.getPosition();
            handler.setOffsetStartAndEnd(offsetStart, offsetEnd);
            ++i;
        }
        this.parseAttributes(in, cf, codeAttribute, options);
        if (Debug.DEBUG_CF) {
            codeAttribute.checkBranches();
        }
        return codeAttribute;
    }
}

