/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.cf;

import com.sap.engine.library.bytecode.cf.CFDisassembler;
import com.sap.engine.library.bytecode.cf.CFException;
import com.sap.engine.library.bytecode.cf.CFParser;
import com.sap.engine.library.bytecode.cf.CFSerializer;
import com.sap.engine.library.bytecode.cf.ClassFile;
import com.sap.engine.library.bytecode.cf.LocalVariable;
import com.sap.engine.library.bytecode.misc.Debug;

public final class CFFactory {
    private static final boolean USE_GENERATED_LABELS_CACHE = true;
    private static final ThreadLocal threadLocalFactory = new ThreadLocal(){

        protected Object initialValue() {
            return new CFFactory();
        }
    };
    private LocalVariable[] localVariables = new LocalVariable[65536];
    private Integer[] integers = new Integer[1000];
    private CFParser parser = null;
    private CFSerializer serializer = null;
    private CFDisassembler disassembler = null;
    private static final int N_GENERATED_LABELS_CACHE = 256;
    private static final String GENERATED_LABELS_PREFIX = "_";
    private String[] generatedLabels = new String[256];

    public static CFFactory getThreadLocalInstance() {
        return (CFFactory)threadLocalFactory.get();
    }

    public CFParser createCFParser() {
        return this.parser == null ? (this.parser = new CFParser(this)) : this.parser;
    }

    public CFDisassembler createCFDisassembler() {
        return this.disassembler == null ? (this.disassembler = new CFDisassembler(this)) : this.disassembler;
    }

    public CFSerializer createCFSerializer() {
        return this.serializer == null ? (this.serializer = new CFSerializer(this)) : this.serializer;
    }

    public ClassFile createClassFile() {
        return new ClassFile(this, new byte[0]);
    }

    public LocalVariable createLocalVariable(int index) {
        if (Debug.DEBUG_CF && (index < 0 || index >= this.localVariables.length)) {
            throw new CFException(17, new Object[]{"Local variable", new Integer(index), new Integer(65535)});
        }
        if (this.localVariables[index] == null) {
            this.localVariables[index] = new LocalVariable(index);
        }
        return this.localVariables[index];
    }

    public Integer createInteger(int x) {
        return x < 0 || x >= this.integers.length ? new Integer(x) : new Integer(x);
    }

    public String createGeneratedLabel(int offset) {
        if (offset < 256) {
            if (this.generatedLabels[offset] == null) {
                this.generatedLabels[offset] = GENERATED_LABELS_PREFIX + offset;
                return this.generatedLabels[offset];
            }
            return this.generatedLabels[offset];
        }
        return GENERATED_LABELS_PREFIX + offset;
    }
}

