/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.cf;

import com.sap.engine.library.bytecode.cf.AbstractSwitchTable;
import com.sap.engine.library.bytecode.cf.AttributeInfo;
import com.sap.engine.library.bytecode.cf.Attributed;
import com.sap.engine.library.bytecode.cf.CFDisassemblerOptions;
import com.sap.engine.library.bytecode.cf.CFFactory;
import com.sap.engine.library.bytecode.cf.CFParser;
import com.sap.engine.library.bytecode.cf.CFSerializer;
import com.sap.engine.library.bytecode.cf.CPInfo;
import com.sap.engine.library.bytecode.cf.ClassFile;
import com.sap.engine.library.bytecode.cf.CodeAttribute;
import com.sap.engine.library.bytecode.cf.ConstantValueAttribute;
import com.sap.engine.library.bytecode.cf.Constants;
import com.sap.engine.library.bytecode.cf.ExceptionHandler;
import com.sap.engine.library.bytecode.cf.ExceptionsAttribute;
import com.sap.engine.library.bytecode.cf.FieldInfo;
import com.sap.engine.library.bytecode.cf.Instruction;
import com.sap.engine.library.bytecode.cf.LineNumberTableAttribute;
import com.sap.engine.library.bytecode.cf.LocalVariableTableAttribute;
import com.sap.engine.library.bytecode.cf.LocalVariableTableEntry;
import com.sap.engine.library.bytecode.cf.LookupSwitchTable;
import com.sap.engine.library.bytecode.cf.MethodInfo;
import com.sap.engine.library.bytecode.cf.TableSwitchTable;
import com.sap.engine.library.bytecode.misc.ArrayUtils;
import com.sap.engine.library.bytecode.misc.ResourceManager;
import com.sap.engine.library.bytecode.misc.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.URLEncoder;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Vector;

public final class CFDisassembler
implements Constants {
    private static final String[] NAMES_OF_RECOGNIZED_ATTRIBUTES = new String[]{"Code", "ConstantValue", "Exceptions", "LineNumberTable", "LocalVariableTable", "SourceFile"};
    private static final String CSS_CLASSES_PREFIX = "jasmin_";
    private static final String CSS_COMMENT = "jasmin_comment";
    private static final String CSS_DIRECTIVE = "jasmin_directive";
    private static final String CSS_INSTRUCTION = "jasmin_instruction";
    private static final String CSS_LINE_NUMBER = "jasmin_line_number";
    private static final String CSS_LABEL = "jasmin_label";
    private static final String CSS_LABEL_REF = "jasmin_label_ref";
    private static final String ANCHOR_PREFIX_METHOD = "method_";
    private static final String ANCHOR_PREFIX_LINE = "_line_";
    private static final String ANCHOR_PREFIX_LABEL = "_label_";
    private CFFactory factory;
    private CFDisassemblerOptions options;
    private StringBuffer buffer = new StringBuffer(4096);
    private HashSet targetedInstructions = new HashSet();
    private Hashtable targetToLabel = new Hashtable();
    private Hashtable instructionToLineNumber = new Hashtable();
    static /* synthetic */ Class class$com$sap$engine$library$bytecode$cf$CFDisassembler;

    CFDisassembler(CFFactory factory) {
        this.factory = factory;
    }

    public void disassemble(File file, ClassFile cf, CFDisassemblerOptions options) throws IOException {
        this.disassemble(new PrintStream(new FileOutputStream(file)), cf, options);
    }

    public void disassemble(String filename, ClassFile cf, CFDisassemblerOptions options) throws IOException {
        this.disassemble(new PrintStream(new FileOutputStream(filename)), cf, options);
    }

    public void disassemble(PrintStream out, ClassFile cf, CFDisassemblerOptions options) {
        this.options = options = options == null ? CFDisassemblerOptions.DEFAULT : options;
        if (options.html) {
            this.buffer.append("<html>\n<head>\n");
            if (options.htmlStylesheet != null) {
                this.buffer.append("<link rel=\"stylesheet\" type=\"text/css\" href=\"" + URLEncoder.encode(options.htmlStylesheet) + "\">\n");
            } else {
                this.buffer.append("<style>\n");
                this.buffer.append("  body {\n");
                this.buffer.append("    background-color: black;\n");
                this.buffer.append("    color: yellow;\n");
                this.buffer.append("    font-family: monospace;\n");
                this.buffer.append("  }\n");
                this.buffer.append("  .jasmin_comment {\n");
                this.buffer.append("    color: #00ff00;\n");
                this.buffer.append("  }\n");
                this.buffer.append("  .jasmin_directive {\n");
                this.buffer.append("    color: white;\n");
                this.buffer.append("  }\n");
                this.buffer.append("  .jasmin_instruction {\n");
                this.buffer.append("    color: yellow;\n");
                this.buffer.append("  }\n");
                this.buffer.append("  .jasmin_line_number {\n");
                this.buffer.append("    color: gray;\n");
                this.buffer.append("    text-decoration: none;\n");
                this.buffer.append("  }\n");
                this.buffer.append("  .jasmin_label {\n");
                this.buffer.append("    color: gray;\n");
                this.buffer.append("    text-decoration: none;\n");
                this.buffer.append("  }\n");
                this.buffer.append("  .jasmin_label_ref:hover {\n");
                this.buffer.append("    color: blue;\n");
                this.buffer.append("    text-decoration: underline;\n");
                this.buffer.append("  }\n");
                this.buffer.append("</style>\n");
            }
            this.buffer.append("</head>\n<body>\n");
        }
        this.appendFormattedText("; Jasmin decompiler output", CSS_COMMENT);
        this.appendNewLine();
        this.appendNewLine();
        String sourceFile = cf.getSourceFile();
        if (sourceFile != null) {
            this.appendFormattedText(".source ", CSS_DIRECTIVE);
            this.appendFormattedText(sourceFile, null);
            this.appendNewLine();
        }
        this.appendFormattedText(".class ", CSS_DIRECTIVE);
        this.disassembleAccessFlags(cf.getAccessFlags(), true);
        this.appendFormattedText(cf.getName(), null);
        this.disassembleUnrecognizedAttributeInfos(cf);
        this.appendNewLine();
        this.appendFormattedText(".super", CSS_DIRECTIVE);
        this.appendFormattedText(" " + cf.getSuperClassName(), null);
        this.appendNewLine();
        int nInterfaces = cf.getNInterfaces();
        int i = 0;
        while (i < nInterfaces) {
            this.appendFormattedText(".implements ", CSS_DIRECTIVE);
            this.appendFormattedText(cf.getInterface(i).toPlainString(), null);
            this.appendNewLine();
            ++i;
        }
        this.appendNewLine();
        int nFields = cf.getNFields();
        int i2 = 0;
        while (i2 < nFields) {
            FieldInfo f = cf.getField(i2);
            this.appendFormattedText(".field", CSS_DIRECTIVE);
            this.appendFormattedText(" ", null);
            this.disassembleAccessFlags(f.getAccessFlags(), false);
            this.appendFormattedText(f.getName() + " " + f.getDescriptor(), null);
            ConstantValueAttribute constantValueAttribute = f.getConstantValueAttribute();
            if (constantValueAttribute != null) {
                this.appendFormattedText(" = " + CFDisassembler.toJasminString(constantValueAttribute.getConstantValue()), null);
            }
            this.disassembleUnrecognizedAttributeInfos(f);
            this.appendNewLine();
            ++i2;
        }
        this.appendNewLine();
        int nMethods = cf.getNMethods();
        int i3 = 0;
        while (i3 < nMethods) {
            MethodInfo m = cf.getMethod(i3);
            this.disassembleMethod(m);
            ++i3;
        }
        this.appendNewLine();
        out.print(this.buffer.toString());
    }

    private void disassembleMethod(MethodInfo m) {
        String endOfCodeLabel;
        CodeAttribute ca;
        this.appendFormattedText(".method", CSS_DIRECTIVE);
        this.appendFormattedText(" ", null);
        this.disassembleAccessFlags(m.getAccessFlags(), false);
        this.appendFormattedText(m.getName() + m.getDescriptor(), null);
        this.disassembleUnrecognizedAttributeInfos(m);
        this.appendNewLine();
        ExceptionsAttribute exceptionsAttribute = m.getExceptionsAttribute();
        if (exceptionsAttribute != null) {
            int nExceptions = exceptionsAttribute.getNExceptions();
            int i = 0;
            while (i < nExceptions) {
                this.appendFormattedText("  ", null);
                this.appendFormattedText(".throws", CSS_DIRECTIVE);
                this.appendFormattedText(" ", null);
                this.appendFormattedText(exceptionsAttribute.getException(i).toPlainString(), null);
                this.appendNewLine();
                ++i;
            }
        }
        if ((ca = m.getCodeAttribute()) == null) {
            this.appendFormattedText("    ; " + ResourceManager.get(8), CSS_COMMENT);
            this.appendNewLine();
            this.appendFormattedText(".end method", CSS_DIRECTIVE);
            this.appendNewLine();
            this.appendNewLine();
            return;
        }
        Instruction[] instructions = ca.getInstructionsArray();
        ExceptionHandler[] exceptionHandlers = ca.getExceptionHandlersArray();
        int[][] successorsTable = CFSerializer.calculateSuccessorsTable(instructions);
        int[] stackSizes = CFSerializer.calculateStackSizes(instructions, exceptionHandlers, successorsTable);
        this.appendFormattedText("  .limit stack ", CSS_DIRECTIVE);
        this.appendFormattedText(Integer.toString(ca.getOriginalMaxStack()), null);
        if (this.options.calculateMaxStack) {
            int maxStack = CFSerializer.calculateMaxStack(stackSizes);
            this.appendFormattedText(" ; " + ResourceManager.get(7) + " = " + maxStack, CSS_COMMENT);
        }
        this.appendNewLine();
        this.appendFormattedText("  .limit locals ", CSS_DIRECTIVE);
        this.appendFormattedText(Integer.toString(ca.getOriginalMaxLocals()), null);
        this.appendNewLine();
        this.targetedInstructions.clear();
        boolean isEndOfCodeTargeted = false;
        this.targetToLabel.clear();
        this.instructionToLineNumber.clear();
        this.targetedInstructions.clear();
        int i = 0;
        while (i < instructions.length) {
            Instruction x = instructions[i];
            int opcode = x.getOpcode();
            switch (Constants.INSTRUCTION_OPERANDS[opcode]) {
                case 5: {
                    this.targetedInstructions.add(x.getOperandInstruction());
                    break;
                }
                case 6: 
                case 7: {
                    AbstractSwitchTable table = x.getOperandAbstractSwitchTable();
                    this.targetedInstructions.add(table.getDefaultBranch());
                    Instruction[] branches = table.getBranchesArray();
                    int j = 0;
                    while (j < branches.length) {
                        this.targetedInstructions.add(branches[j]);
                        ++j;
                    }
                    break;
                }
            }
            ++i;
        }
        int i2 = 0;
        while (i2 < exceptionHandlers.length) {
            this.targetedInstructions.add(exceptionHandlers[i2].getStartPC());
            Instruction endPC = exceptionHandlers[i2].getEndPCInclusive().getNextInstruction();
            if (endPC == null) {
                isEndOfCodeTargeted = true;
            } else {
                this.targetedInstructions.add(endPC);
            }
            this.targetedInstructions.add(exceptionHandlers[i2].getHandlerPC());
            ++i2;
        }
        LocalVariableTableAttribute localVariableTableAttribute = null;
        if (this.options.includeLocalVariables && (localVariableTableAttribute = ca.getLocalVariableTableAttribute()) != null) {
            LocalVariableTableEntry[] entries = localVariableTableAttribute.getEntriesArray();
            int i3 = 0;
            while (i3 < entries.length) {
                this.targetedInstructions.add(entries[i3].getStartPC());
                Instruction endPC = entries[i3].getEndPC();
                if (endPC == null) {
                    isEndOfCodeTargeted = true;
                } else {
                    this.targetedInstructions.add(endPC);
                }
                ++i3;
            }
        }
        int counter = 0;
        int i4 = 0;
        while (i4 < instructions.length) {
            if (this.targetedInstructions.contains(instructions[i4])) {
                this.targetToLabel.put(instructions[i4], "L" + counter);
                ++counter;
            }
            ++i4;
        }
        String string = endOfCodeLabel = isEndOfCodeTargeted ? "L" + counter : null;
        if (this.options.includeLineNumbers) {
            LineNumberTableAttribute lineNumberTableAttribute = null;
            try {
                lineNumberTableAttribute = (LineNumberTableAttribute)ca.getAttribute("LineNumberTable");
            }
            catch (ClassCastException cce) {
                // empty catch block
            }
            if (lineNumberTableAttribute != null) {
                Instruction[] startPCs = lineNumberTableAttribute.getStartPCsArray();
                int[] lineNumbers = lineNumberTableAttribute.getLineNumbersArray();
                int n = lineNumbers.length;
                int i5 = 0;
                while (i5 < n) {
                    this.instructionToLineNumber.put(startPCs[i5], Integer.toString(lineNumbers[i5]));
                    ++i5;
                }
            }
        }
        if (localVariableTableAttribute != null) {
            LocalVariableTableEntry[] entries = localVariableTableAttribute.getEntriesArray();
            int i6 = 0;
            while (i6 < entries.length) {
                LocalVariableTableEntry entry = entries[i6];
                this.appendFormattedText("  .var ", CSS_DIRECTIVE);
                this.appendFormattedText(Integer.toString(entry.getLocalVariable().getIndex()), null);
                this.appendFormattedText(" is ", CSS_DIRECTIVE);
                this.appendFormattedText(entry.getName().toPlainString() + " " + entry.getDescriptor().toPlainString(), null);
                this.appendFormattedText(" from ", CSS_DIRECTIVE);
                this.appendLabelRef(m, this.targetToLabel.get(entry.getStartPC()).toString());
                this.appendFormattedText(" to ", CSS_DIRECTIVE);
                Instruction endPC = entries[i6].getEndPC();
                if (endPC == null) {
                    this.appendLabelRef(m, endOfCodeLabel);
                } else {
                    this.appendLabelRef(m, this.targetToLabel.get(endPC).toString());
                }
                this.appendNewLine();
                ++i6;
            }
        }
        int i7 = 0;
        while (i7 < instructions.length) {
            Object label;
            Object lineNumber;
            if (this.options.includeLineNumbers && (lineNumber = this.instructionToLineNumber.get(instructions[i7])) != null) {
                this.appendFormattedText("  .line ", CSS_DIRECTIVE);
                if (this.options.html) {
                    this.buffer.append("<a id=\"" + URLEncoder.encode(ANCHOR_PREFIX_METHOD + m.getName() + m.getDescriptor() + ANCHOR_PREFIX_LINE + lineNumber.toString()) + "\">");
                }
                this.appendFormattedText(lineNumber.toString(), CSS_LINE_NUMBER);
                if (this.options.html) {
                    this.buffer.append("</a>");
                }
                this.appendNewLine();
            }
            if ((label = this.targetToLabel.get(instructions[i7])) != null) {
                this.appendLabel(m, label.toString());
                this.appendNewLine();
            }
            this.appendFormattedText("  ", null);
            Instruction x = instructions[i7];
            int opcode = x.getOpcode();
            switch (Constants.INSTRUCTION_OPERANDS[opcode]) {
                case 5: {
                    this.appendFormattedText(Constants.MNEMONIC[opcode] + " " + this.targetToLabel.get(x.getOperandInstruction()), CSS_INSTRUCTION);
                    this.appendNewLine();
                    break;
                }
                case 7: {
                    LookupSwitchTable table = x.getOperandLookupSwitchTable();
                    this.appendFormattedText(Constants.MNEMONIC[opcode], CSS_INSTRUCTION);
                    this.appendNewLine();
                    Instruction[] branches = table.getBranchesArray();
                    int[] matches = table.getMatchesArray();
                    int j = 0;
                    while (j < branches.length) {
                        this.appendFormattedText("                " + matches[j] + ": " + this.targetToLabel.get(branches[j]), CSS_INSTRUCTION);
                        this.appendNewLine();
                        ++j;
                    }
                    this.appendFormattedText("                default: " + this.targetToLabel.get(table.getDefaultBranch()), CSS_INSTRUCTION);
                    this.appendNewLine();
                    break;
                }
                case 6: {
                    TableSwitchTable table = x.getOperandTableSwitchTable();
                    this.appendFormattedText(Constants.MNEMONIC[opcode] + " " + table.getLowValue(), CSS_INSTRUCTION);
                    this.appendNewLine();
                    Instruction[] branches = table.getBranchesArray();
                    int j = 0;
                    while (j < branches.length) {
                        this.appendFormattedText("               " + this.targetToLabel.get(branches[j]), CSS_INSTRUCTION);
                        this.appendNewLine();
                        ++j;
                    }
                    this.appendFormattedText("                default: " + this.targetToLabel.get(table.getDefaultBranch()), CSS_INSTRUCTION);
                    this.appendNewLine();
                    break;
                }
                case 3: {
                    CPInfo y = x.getOperandCPInfo();
                    this.appendFormattedText(Constants.MNEMONIC[opcode] + " " + CFDisassembler.toJasminString(y), CSS_INSTRUCTION);
                    this.appendNewLine();
                    break;
                }
                case 2: {
                    if (opcode == 188) {
                        this.appendFormattedText(Constants.MNEMONIC[opcode] + " " + Constants.T_MNEMONICS[x.getOperandInt()], CSS_INSTRUCTION);
                    } else {
                        this.appendFormattedText(Constants.MNEMONIC[opcode] + " " + x.getOperandInt(), CSS_INSTRUCTION);
                    }
                    this.appendNewLine();
                    break;
                }
                case 9: {
                    this.appendFormattedText(Constants.MNEMONIC[opcode] + " " + x.getOperandCPInfo().toPlainString() + " " + x.getOperandInt(), CSS_INSTRUCTION);
                    this.appendNewLine();
                    break;
                }
                case 4: {
                    int lv = x.getOperandLocalVariable().getIndex();
                    this.appendFormattedText(Constants.MNEMONIC[opcode] + " " + lv, CSS_INSTRUCTION);
                    this.appendNewLine();
                    break;
                }
                case 8: {
                    int lv = x.getOperandLocalVariable().getIndex();
                    int d = x.getOperandInt();
                    this.appendFormattedText(Constants.MNEMONIC[opcode] + " " + lv + " " + d, CSS_INSTRUCTION);
                    this.appendNewLine();
                    break;
                }
                default: {
                    this.appendFormattedText(x.toString(), CSS_INSTRUCTION);
                    this.appendNewLine();
                }
            }
            ++i7;
        }
        if (isEndOfCodeTargeted) {
            this.appendLabel(m, endOfCodeLabel);
            this.appendNewLine();
        }
        int i8 = 0;
        while (i8 < exceptionHandlers.length) {
            CPInfo caught = exceptionHandlers[i8].getCatchType();
            Instruction endPCExclusive = exceptionHandlers[i8].getEndPCInclusive();
            this.appendFormattedText("  .catch ", CSS_DIRECTIVE);
            this.appendFormattedText(caught.getIndex() == 0 ? "all" : caught.toPlainString(), null);
            this.appendFormattedText(" from ", CSS_DIRECTIVE);
            this.appendLabelRef(m, this.targetToLabel.get(exceptionHandlers[i8].getStartPC()).toString());
            this.appendFormattedText(" to ", CSS_DIRECTIVE);
            this.appendLabelRef(m, (endPCExclusive == null ? "null" : this.targetToLabel.get(endPCExclusive.getNextInstruction())).toString());
            this.appendFormattedText(" using ", CSS_DIRECTIVE);
            this.appendLabelRef(m, this.targetToLabel.get(exceptionHandlers[i8].getHandlerPC()).toString());
            this.appendNewLine();
            ++i8;
        }
        this.appendFormattedText(".end method", CSS_DIRECTIVE);
        this.appendNewLine();
        this.appendNewLine();
    }

    private void disassembleAccessFlags(int accessFlags, boolean isClassFile) {
        int mask = 1;
        int i = 0;
        while (i < 12) {
            if (!((accessFlags & mask) == 0 || isClassFile && mask == 32)) {
                this.appendFormattedText(Constants.ACCESS_FLAG_MNEMONICS[i] + " ", null);
            }
            mask <<= 1;
            ++i;
        }
    }

    private void disassembleUnrecognizedAttributeInfos(Attributed a) {
        AttributeInfo[] attributeInfos = a.getAttributesArray();
        Vector<String> temp = new Vector<String>();
        int i = 0;
        while (i < attributeInfos.length) {
            boolean isRecognized = false;
            String name = attributeInfos[i].getName();
            int j = 0;
            while (j < NAMES_OF_RECOGNIZED_ATTRIBUTES.length) {
                if (name.equals(NAMES_OF_RECOGNIZED_ATTRIBUTES[j])) {
                    isRecognized = true;
                    break;
                }
                ++j;
            }
            if (!isRecognized) {
                temp.add(name);
            }
            ++i;
        }
        int nTemp = temp.size();
        if (nTemp > 1) {
            StringBuffer buffer1 = new StringBuffer();
            buffer1.append(temp.get(0));
            int i2 = 1;
            while (i2 < nTemp) {
                buffer1.append(", ").append(temp.get(i2));
                ++i2;
            }
            String listOfAttributeNames = buffer1.toString();
            this.appendFormattedText(" ; " + ResourceManager.get(5, listOfAttributeNames), CSS_COMMENT);
        } else if (nTemp == 1) {
            this.appendFormattedText(" ; " + ResourceManager.get(6, temp.get(0)), CSS_COMMENT);
        }
    }

    private static String toJasminString(CPInfo x) {
        switch (x.getTag()) {
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: {
                return x.toPlainString();
            }
            case 10: 
            case 11: {
                CPInfo nameAndType = x.getValueNameAndType();
                return x.getValueClass().toPlainString() + "/" + nameAndType.getValueName().toPlainString() + nameAndType.getValueDescriptor().toPlainString();
            }
            case 9: {
                CPInfo nameAndType = x.getValueNameAndType();
                return x.getValueClass().toPlainString() + "/" + nameAndType.getValueName().toPlainString() + " " + nameAndType.getValueDescriptor().toPlainString();
            }
            case 1: 
            case 8: {
                return "\"" + StringUtils.escapeString(x.toPlainString()) + "\"";
            }
        }
        return "??? ; Invalid CPInfo, tag=" + x.getTag() + ", index=" + x.getIndex() + ", ncp=" + x.getOwner().getCPSize();
    }

    private void appendFormattedText(String s, String t) {
        if (this.options.html) {
            if (t == null) {
                this.buffer.append(StringUtils.escapeToHTML(s));
            } else {
                this.buffer.append("<span class=\"" + t + "\">").append(StringUtils.escapeToHTML(s)).append("</span>");
            }
        } else {
            this.buffer.append(s);
        }
    }

    private void appendLabel(MethodInfo m, String label) {
        if (this.options.html) {
            this.buffer.append("<a id=\"" + URLEncoder.encode(ANCHOR_PREFIX_METHOD + m.getName() + m.getDescriptor() + ANCHOR_PREFIX_LABEL + label) + "\" class=\"" + CSS_LABEL + "\">" + label + ":</a>");
        } else {
            this.buffer.append(label).append(':');
        }
    }

    private void appendLabelRef(MethodInfo m, String label) {
        if (this.options.html) {
            this.buffer.append("<a href=\"#" + URLEncoder.encode(ANCHOR_PREFIX_METHOD + m.getName() + m.getDescriptor() + ANCHOR_PREFIX_LABEL + label) + "\" class=\"" + CSS_LABEL_REF + "\">" + label + "</a>");
        } else {
            this.buffer.append(label);
        }
    }

    private void appendNewLine() {
        if (this.options.html) {
            this.buffer.append("<br>\n");
        } else {
            this.buffer.append('\n');
        }
    }

    private static void printUsage() {
        System.out.println(ResourceManager.get(89) + ":");
        System.out.println("\tjava " + (class$com$sap$engine$library$bytecode$cf$CFDisassembler == null ? (class$com$sap$engine$library$bytecode$cf$CFDisassembler = CFDisassembler.class$("com.sap.engine.library.bytecode.cf.CFDisassembler")) : class$com$sap$engine$library$bytecode$cf$CFDisassembler).getName() + " filename");
        System.out.println("\tjava " + (class$com$sap$engine$library$bytecode$cf$CFDisassembler == null ? (class$com$sap$engine$library$bytecode$cf$CFDisassembler = CFDisassembler.class$("com.sap.engine.library.bytecode.cf.CFDisassembler")) : class$com$sap$engine$library$bytecode$cf$CFDisassembler).getName() + " -j filename");
    }

    public static void main(String[] args) throws Exception {
        Class<?> c = new Object(){}.getClass();
        byte[] data = ArrayUtils.readFully(c.getClassLoader().getResourceAsStream(c.getName().replace('.', '/') + ".class"));
        CFFactory factory = CFFactory.getThreadLocalInstance();
        CFParser parser = factory.createCFParser();
        ClassFile cf = parser.parse(data, null);
        CFDisassembler disassembler = factory.createCFDisassembler();
        String filename = "D:\\temp\\disassembler.html";
        FileOutputStream out = new FileOutputStream(filename);
        CFDisassemblerOptions disassemblerOptions = new CFDisassemblerOptions();
        disassemblerOptions.html = true;
        disassembler.disassemble(new PrintStream(out), cf, disassemblerOptions);
        out.close();
        Runtime.getRuntime().exec("explorer " + filename);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

