/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.cf;

import com.sap.engine.library.bytecode.cf.CFException;
import com.sap.engine.library.bytecode.misc.Debug;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.IOException;

final class ByteArrayDataInput
implements DataInput {
    private byte[] data;
    private int nData;
    private int pData;

    ByteArrayDataInput(byte[] data) {
        this.data = data;
        this.nData = data.length;
        this.pData = 0;
    }

    int getPosition() {
        return this.pData;
    }

    public void readFully(byte[] b) throws IOException {
        int length = b.length;
        System.arraycopy(this.data, this.pData, b, 0, length);
        this.pData += length;
        if (Debug.DEBUG_CF) {
            this.checkEOF();
        }
    }

    public void readFully(byte[] b, int off, int len) throws IOException {
        System.arraycopy(this.data, this.pData, b, off, len);
        this.pData += len;
        if (Debug.DEBUG_CF) {
            this.checkEOF();
        }
    }

    public int skipBytes(int n) throws IOException {
        throw new UnsupportedOperationException();
    }

    public boolean readBoolean() throws IOException {
        throw new UnsupportedOperationException();
    }

    public byte readByte() throws IOException {
        byte r = this.data[this.pData];
        ++this.pData;
        if (Debug.DEBUG_CF) {
            this.checkEOF();
        }
        return r;
    }

    public int readUnsignedByte() throws IOException {
        int r = this.data[this.pData++] & 0xFF;
        if (Debug.DEBUG_CF) {
            this.checkEOF();
        }
        return r;
    }

    public short readShort() throws IOException {
        short r = (short)(this.data[this.pData++] << 8 | this.data[this.pData++] & 0xFF);
        if (Debug.DEBUG_CF) {
            this.checkEOF();
        }
        return r;
    }

    public int readUnsignedShort() throws IOException {
        int r = (this.data[this.pData++] << 8 | this.data[this.pData++] & 0xFF) & 0xFFFF;
        if (Debug.DEBUG_CF) {
            this.checkEOF();
        }
        return r;
    }

    public char readChar() throws IOException {
        throw new UnsupportedOperationException();
    }

    public int readInt() throws IOException {
        int r = (this.data[this.pData++] & 0xFF) << 24 | (this.data[this.pData++] & 0xFF) << 16 | (this.data[this.pData++] & 0xFF) << 8 | this.data[this.pData++] & 0xFF;
        if (Debug.DEBUG_CF) {
            this.checkEOF();
        }
        return r;
    }

    public long readLong() throws IOException {
        throw new UnsupportedOperationException();
    }

    public float readFloat() throws IOException {
        throw new UnsupportedOperationException();
    }

    public double readDouble() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String readLine() throws IOException {
        throw new UnsupportedOperationException();
    }

    public String readUTF() throws IOException {
        String r = DataInputStream.readUTF(this);
        if (Debug.DEBUG_CF) {
            this.checkEOF();
        }
        return r;
    }

    private void checkEOF() {
        if (this.pData > this.nData) {
            throw new CFException(10);
        }
    }
}

