/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.cf;

import com.sap.engine.library.bytecode.cf.AttributeInfo;
import com.sap.engine.library.bytecode.cf.CFException;
import com.sap.engine.library.bytecode.misc.Debug;

final class AttributeContainer {
    private AttributeInfo[] attributes = new AttributeInfo[4];
    private int nAttributes;

    AttributeContainer() {
    }

    void addAttribute(AttributeInfo a) {
        if (Debug.DEBUG_CF) {
            String name = a.getName();
            int i = 0;
            while (i < this.nAttributes) {
                if (this.attributes[i].getName().equals(name)) {
                    throw new CFException(1, name);
                }
                ++i;
            }
        }
        if (this.nAttributes == this.attributes.length) {
            AttributeInfo[] old = this.attributes;
            this.attributes = new AttributeInfo[2 * this.nAttributes];
            System.arraycopy(old, 0, this.attributes, 0, this.nAttributes);
        }
        this.attributes[this.nAttributes] = a;
        ++this.nAttributes;
    }

    int getNAttributes() {
        return this.nAttributes;
    }

    AttributeInfo getAttribute(int index) {
        if (Debug.DEBUG_CF && (index < 0 || index >= this.nAttributes)) {
            throw new CFException(17, new Object[]{"AttributeInfo", new Integer(index), new Integer(this.nAttributes - 1)});
        }
        return this.attributes[index];
    }

    AttributeInfo getAttribute(String name) {
        int i = 0;
        while (i < this.nAttributes) {
            if (this.attributes[i].getName().equals(name)) {
                return this.attributes[i];
            }
            ++i;
        }
        return null;
    }

    AttributeInfo[] getAttributesArray() {
        AttributeInfo[] r = new AttributeInfo[this.nAttributes];
        System.arraycopy(this.attributes, 0, r, 0, this.nAttributes);
        return r;
    }

    void removeAttribute(AttributeInfo a) {
        int i = 0;
        while (i < this.nAttributes) {
            if (a == this.attributes[i]) {
                System.arraycopy(this.attributes, i + 1, this.attributes, i, this.nAttributes - i - 1);
                --this.nAttributes;
                return;
            }
            ++i;
        }
    }

    void removeAttribute(String name) {
        int i = 0;
        while (i < this.nAttributes) {
            if (this.attributes[i].getName().equals(name)) {
                System.arraycopy(this.attributes, i + 1, this.attributes, i, this.nAttributes - i - 1);
                --this.nAttributes;
                return;
            }
            ++i;
        }
    }
}

