/*
 * Decompiled with CFR 0.152.
 */
package com.sap.engine.library.bytecode.cf;

import com.sap.engine.library.bytecode.cf.CFException;
import com.sap.engine.library.bytecode.cf.CFFactory;
import com.sap.engine.library.bytecode.cf.CFNode;
import com.sap.engine.library.bytecode.cf.CodeAttribute;
import com.sap.engine.library.bytecode.cf.Constants;
import com.sap.engine.library.bytecode.cf.Instruction;
import com.sap.engine.library.bytecode.misc.Debug;

public abstract class AbstractSwitchTable
extends CFNode {
    private CFFactory factory;
    private CodeAttribute ownerCodeAttribute;
    private Instruction ownerInstruction;
    private String defaultBranchLabel;
    private String[] branchesLabels;
    private int nBranches;

    AbstractSwitchTable(CFFactory factory) {
        this.factory = factory;
    }

    protected final void init0(Instruction ownerInstruction, String defaultBranchLabel, String[] branchLabels, int nBranches) {
        this.ownerInstruction = ownerInstruction;
        this.ownerCodeAttribute = ownerInstruction.getOwnerCodeAttribute();
        this.defaultBranchLabel = defaultBranchLabel;
        this.branchesLabels = branchLabels;
        this.nBranches = nBranches;
    }

    public final Instruction getDefaultBranch() {
        return this.ownerCodeAttribute.getInstructionByLabel(this.defaultBranchLabel);
    }

    public final int getNBranches() {
        return this.nBranches;
    }

    public final Instruction getBranchByIndex(int index) {
        if (Debug.DEBUG_CF && (index < 0 || index >= this.nBranches)) {
            throw new CFException(17, new Object[]{"Switch branch", new Integer(index), new Integer(this.nBranches - 1)});
        }
        return this.ownerCodeAttribute.getInstructionByLabel(this.branchesLabels[index]);
    }

    public abstract Instruction getBranchByKey(int var1);

    public final Instruction[] getBranchesArray() {
        Instruction[] r = new Instruction[this.nBranches];
        int i = 0;
        while (i < this.nBranches) {
            r[i] = this.ownerCodeAttribute.getInstructionByLabel(this.branchesLabels[i]);
            ++i;
        }
        return r;
    }

    public final Instruction[] getSuccessorsArray() {
        Instruction[] r = new Instruction[this.nBranches + 1];
        int i = 0;
        while (i < this.nBranches) {
            r[i] = this.ownerCodeAttribute.getInstructionByLabel(this.branchesLabels[i]);
            ++i;
        }
        r[this.nBranches] = this.ownerCodeAttribute.getInstructionByLabel(this.defaultBranchLabel);
        return r;
    }

    public final int[] getSuccessorIndicesArray() {
        int[] r = new int[this.nBranches + 1];
        int i = 0;
        while (i < this.nBranches) {
            r[i] = this.ownerCodeAttribute.getInstructionByLabel(this.branchesLabels[i], true).getIndex();
            ++i;
        }
        r[this.nBranches] = this.ownerCodeAttribute.getInstructionByLabel(this.defaultBranchLabel, true).getIndex();
        return r;
    }

    public static int getPadding(int offset) {
        return 3 - (offset & 3);
    }

    CFFactory getFactory() {
        return this.factory;
    }

    protected void transferFields(AbstractSwitchTable r, Instruction x, String labelPrefix) {
        r.factory = this.factory;
        r.ownerCodeAttribute = this.ownerCodeAttribute;
        r.ownerInstruction = x;
        r.defaultBranchLabel = labelPrefix + this.ownerCodeAttribute.getCanonicalLabel(this.defaultBranchLabel);
        r.nBranches = this.nBranches;
        r.branchesLabels = new String[this.nBranches];
        int i = 0;
        while (i < this.nBranches) {
            r.branchesLabels[i] = labelPrefix + this.ownerCodeAttribute.getCanonicalLabel(this.branchesLabels[i]);
            ++i;
        }
    }

    abstract AbstractSwitchTable cloneAbstractSwitchTable(Instruction var1, String var2);

    void checkBranches() {
        this.ownerCodeAttribute.getInstructionByLabel(this.defaultBranchLabel, true);
        int i = 0;
        while (i < this.nBranches) {
            this.ownerCodeAttribute.getInstructionByLabel(this.branchesLabels[i], true);
            ++i;
        }
    }

    public final CFNode[] getChildNodes() {
        return Constants.CF_NODE_ARRAY_0;
    }

    public final CFNode getParentNode() {
        return this.ownerInstruction;
    }

    public abstract String toString();
}

