/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbs.client.impl;

import com.sap.tc.cbs.client.IActivityIntersection;
import com.sap.tc.cbs.client.IActivitySet;
import com.sap.tc.cbs.client.IImportRequest;
import com.sap.tc.cbs.client.error.ActivationCheckFailedException;
import com.sap.tc.cbs.client.error.CBSError;
import com.sap.tc.cbs.client.error.CBSServerException;
import com.sap.tc.cbs.client.error.CommunicationException;
import com.sap.tc.cbs.client.error.ErrorMapper;
import com.sap.tc.cbs.client.impl.ActivityIntersection;
import com.sap.tc.cbs.client.impl.ActivitySet;
import com.sap.tc.cbs.client.impl.BuildRequest;
import com.sap.tc.cbs.client.impl.BuildSpace;
import com.sap.tc.cbs.client.impl.HTTPClient;
import com.sap.tc.cbs.client.impl.SoapUtils;
import com.sap.tc.cbs.common.types.ErrorStrings;
import com.sap.tc.cbs.wsproxy.types.ActionResult;
import com.sap.tc.cbs.wsproxy.types.ActivationResult;
import com.sap.tc.logging.Location;
import java.io.InputStream;
import java.rmi.RemoteException;

class ImportRequest
extends BuildRequest
implements IImportRequest {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$cbs$client$IBuildRequest == null ? (class$com$sap$tc$cbs$client$IBuildRequest = ImportRequest.class$("com.sap.tc.cbs.client.IBuildRequest")) : class$com$sap$tc$cbs$client$IBuildRequest));
    private static final String LS = System.getProperty("line.separator", "\n");
    HTTPClient m_httpClient;
    static /* synthetic */ Class class$com$sap$tc$cbs$client$IBuildRequest;

    public ImportRequest(long requestID, BuildSpace bsProxy) {
        super(requestID, bsProxy);
        this.m_httpClient = bsProxy.getCbsProxy().getHttpProxy();
    }

    public void addDCArchive(String targetCompartment, String dcVendor, String dcName, String variant, InputStream archiveStream, long archiveSize) throws CommunicationException, CBSServerException {
        this.m_httpClient.putDCArchive(this.m_bsProxy.getName(), Long.toString(this.m_requestID), targetCompartment, dcVendor, dcName, variant, archiveStream, archiveSize);
    }

    public void addDC(String targetCompartment, String targetBuildVariant, String sourceBuildSpaceName, String sourceCompartment, String sourceBuildVariant, String dcVendor, String dcName) throws CommunicationException, CBSServerException {
        ActionResult result;
        String thisMethod = "addDC(String,String,String,String,String,String,String)";
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: addDCDeletionToImport,\n      build space:        " + this.m_bsProxy.getName() + LS + "      request:            " + this.m_requestID + LS + "      targetCompartment:  " + targetCompartment + LS + "      targetBuildVariant: " + targetBuildVariant + LS + "      sourceBuildSpace:   " + sourceBuildSpaceName + LS + "      sourceCompartment:  " + sourceCompartment + LS + "      sourceBuildVariant: " + sourceBuildVariant + LS + "      dcVendor:           " + dcVendor + LS + "      dcName:             " + dcName);
            result = this.m_soapPort.addDCtoImportForIntegration(this.m_bsProxy.getName(), this.m_requestID, targetCompartment, targetBuildVariant, sourceBuildSpaceName, sourceCompartment, sourceBuildVariant, dcVendor, dcName);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
    }

    public void addDCDeletion(String compartmentName, String dcVendor, String dcName) throws CommunicationException, CBSServerException {
        ActionResult result;
        String thisMethod = "addDCDeletion";
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: addDCDeletionToImport,\n      build space: " + this.m_bsProxy.getName() + "\n      request:     " + this.m_requestID + "\n      compartment: " + compartmentName + "\n      dcVendor:    " + dcVendor + "\n      dcName:      " + dcName);
            result = this.m_soapPort.addDCDeletionToImport(this.m_bsProxy.getName(), this.m_requestID, compartmentName, dcVendor, dcName);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
    }

    public void addDCInterfaceArchive(String targetCompartment, String dcVendor, String dcName, String buildVariant, InputStream archiveStream, long archiveSize) throws CommunicationException, CBSServerException {
        this.m_httpClient.putDCInterfaceArchive(this.m_bsProxy.getName(), Long.toString(this.m_requestID), targetCompartment, dcVendor, dcName, buildVariant, archiveStream, archiveSize);
    }

    public void addSCDescriptionArchive(String targetCompartment, InputStream archiveStream, long archiveSize) throws CommunicationException, CBSServerException {
        this.m_httpClient.putSCD(this.m_bsProxy.getName(), Long.toString(this.m_requestID), targetCompartment, archiveStream, archiveSize);
    }

    public void addSCDescriptionArchive(String targetCompartment, String sourceBuildSpaceName, String sourceCompartment) throws CommunicationException, CBSServerException {
        String thisMethod = "addSCDescriptionArchive(String,String,String,String,String,String,String)";
        Object result = null;
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: addSCDAtoImportForIntegration,\n      build space:        " + this.m_bsProxy.getName() + "\n      request:            " + this.m_requestID + "\n      targetCompartment:  " + targetCompartment + "\n      sourceBuildSpace:   " + sourceBuildSpaceName + "\n      sourceCompartment:  " + sourceCompartment);
            System.out.println("METHOD NOT IMPLEMENTED ON SERVER" + thisMethod);
        }
        catch (Exception e) {
            String msg = ErrorStrings.get((String)"COMMUNICATION_ERROR");
            throw new CommunicationException(msg, e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
    }

    public void commit() throws CommunicationException, CBSServerException {
        ActionResult result;
        String thisMethod = "commit";
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: commitImport, build space: " + this.m_bsProxy.getName() + " request: " + this.m_requestID);
            result = this.m_soapPort.commitImport(this.m_bsProxy.getName(), this.m_requestID);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
    }

    void addActivities(IActivitySet[] activities) throws CommunicationException, CBSServerException {
        ActivationResult result;
        String thisMethod = "addActivities(IActivitySet,boolean,boolean,boolean,ActivationCheckMode)";
        LOCATION.infoT(thisMethod, "  build space: " + this.m_bsProxy.getName());
        LOCATION.infoT(thisMethod, activities.toString());
        com.sap.tc.cbs.wsproxy.types.ActivitySet[] activitySet = ActivitySet.ArrayToSoapProxyArray(activities);
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: 'addActivitiesToImport' on  build space: " + this.m_bsProxy.getName() + " request: " + this.m_requestID);
            result = this.m_soapPort.addActivitiesToImport(this.m_bsProxy.getName(), this.m_requestID, activitySet);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            String error = result.getErrorCode();
            String message = ErrorStrings.get((String)error);
            if (error.equals("ACTV_CHECK_FAILED")) {
                IActivityIntersection[] intersections = ActivityIntersection.arrayFromProxy(result.getIntersections());
                throw new ActivationCheckFailedException(message, error, intersections);
            }
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
    }

    public IActivitySet[] getRequestActivities() throws CommunicationException, CBSServerException {
        return null;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

