/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbs.client.impl;

import com.sap.tc.cbs.client.CBSFactory;
import com.sap.tc.cbs.client.IArchiveResult;
import com.sap.tc.cbs.client.error.AuthorizationException;
import com.sap.tc.cbs.client.error.CBSError;
import com.sap.tc.cbs.client.error.CBSServerException;
import com.sap.tc.cbs.client.error.CommunicationException;
import com.sap.tc.cbs.client.error.DebugTrace;
import com.sap.tc.cbs.client.error.ErrorMapper;
import com.sap.tc.cbs.client.error.NotInResultQueueException;
import com.sap.tc.cbs.client.impl.ArchiveResult;
import com.sap.tc.cbs.client.impl.ArchiveUnpackResponseHandler;
import com.sap.tc.cbs.client.impl.BuildServer;
import com.sap.tc.cbs.client.impl.BuildspaceResponseHandler;
import com.sap.tc.cbs.client.impl.DummyResponseHandler;
import com.sap.tc.cbs.client.impl.ErrorResponseHandler;
import com.sap.tc.cbs.client.impl.IResponseHandler;
import com.sap.tc.cbs.client.impl.OutputStreamResponseHandler;
import com.sap.tc.cbs.client.impl.SimpleGetResponseHandler;
import com.sap.tc.cbs.client.impl.StringResultResponseHandler;
import com.sap.tc.cbs.util.Util;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.Connection;
import com.tssap.dtr.client.lib.protocol.HTTPException;
import com.tssap.dtr.client.lib.protocol.IConnection;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.IRequest;
import com.tssap.dtr.client.lib.protocol.IRequestEntity;
import com.tssap.dtr.client.lib.protocol.IResponse;
import com.tssap.dtr.client.lib.protocol.entities.StreamEntity;
import com.tssap.dtr.client.lib.protocol.requests.http.GetRequest;
import com.tssap.dtr.client.lib.protocol.requests.http.PostRequest;
import com.tssap.dtr.client.lib.protocol.requests.http.PutRequest;
import com.tssap.dtr.client.lib.protocol.util.Encoder;
import com.tssap.dtr.client.lib.protocol.util.Query;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PrintStream;
import java.net.SocketException;

public class HTTPClient {
    static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$cbs$client$impl$HTTPClient == null ? (class$com$sap$tc$cbs$client$impl$HTTPClient = HTTPClient.class$("com.sap.tc.cbs.client.impl.HTTPClient")) : class$com$sap$tc$cbs$client$impl$HTTPClient));
    private static final String CONTENT_TYPE_XML = "text/xml";
    private static final String CONTENT_TYPE_ZIP = "application/x-zip-compressed";
    private IConnection m_connection;
    private String m_currentCBSMethod;
    private BuildServer m_buildServer;
    static /* synthetic */ Class class$com$sap$tc$cbs$client$impl$HTTPClient;
    static /* synthetic */ Class class$com$sap$tc$cbs$wsproxy$CBSWebServiceVI_Rpc;

    public HTTPClient(IConnectionTemplate connectionTemplate, BuildServer buildServer) {
        this.m_connection = new Connection(connectionTemplate);
        this.m_buildServer = buildServer;
    }

    public String createBuildSpaceViaPutRequest(InputStream stream, long length, String repositoryUser, String repositoryPassword) throws CommunicationException, CBSServerException {
        String thisMethod = "createBuildSpace(InputStream ,long )";
        StreamEntity streamEntity = new StreamEntity(stream, CONTENT_TYPE_XML);
        streamEntity.setContentLength(length);
        PutRequest request = new PutRequest("", (IRequestEntity)streamEntity);
        String buildSpaceName = null;
        Query qry = new Query();
        this.m_currentCBSMethod = "CREATE_BS";
        qry.appendQueryParameter("METHOD", "CREATE_BS");
        qry.appendQueryParameter("REPOS_USER", repositoryUser);
        qry.appendQueryParameter("REPOS_PASS", repositoryPassword);
        request.setQuery(qry);
        try {
            BuildspaceResponseHandler handler = new BuildspaceResponseHandler();
            this.sendRequest((IRequest)request, handler);
            buildSpaceName = handler.getBuildspaceName();
        }
        catch (HttpCBSException e) {
            LOCATION.catching(thisMethod, (Throwable)e);
            ErrorMapper.throwError(LOCATION, thisMethod, e.getError());
        }
        return buildSpaceName;
    }

    public String createBuildSpace(InputStream stream, long length, String repositoryUser, String repositoryPassword) throws CommunicationException, CBSServerException {
        String thisMethod = "createBuildSpace()";
        if (!this.m_buildServer.supports(BuildServer.CBSFeature.SUPPORTS_CREATEBS_VIA_POST)) {
            return this.createBuildSpaceViaPutRequest(stream, length, repositoryUser, repositoryPassword);
        }
        PostRequest request = new PostRequest("");
        String buildSpaceName = null;
        this.m_currentCBSMethod = "CREATE_BS";
        request.addParameter("METHOD", "CREATE_BS");
        String id = Encoder.encodeBase64((String)(Encoder.encodeBase64((String)repositoryUser) + "-" + Encoder.encodeBase64((String)repositoryPassword)));
        request.addParameter("ID", id);
        try {
            if (length > Integer.MAX_VALUE) {
                throw new IOException("Input stream too long. length passed as Argument: " + length + " max: " + Integer.MAX_VALUE);
            }
            if (length < 0L) {
                throw new IOException("Cannot read input stream. Illegal value for announced length : " + length);
            }
            request.addParameter("CONFDEF", this.readAndEncodeBase64(stream, (int)length));
        }
        catch (IOException e1) {
            LOCATION.catching(thisMethod, (Throwable)e1);
            throw new CommunicationException("could not read input stream: " + e1.getMessage());
        }
        try {
            BuildspaceResponseHandler handler = new BuildspaceResponseHandler();
            this.sendRequest((IRequest)request, handler);
            buildSpaceName = handler.getBuildspaceName();
        }
        catch (HttpCBSException e) {
            LOCATION.catching(thisMethod, (Throwable)e);
            ErrorMapper.throwError(LOCATION, thisMethod, e.getError());
        }
        return buildSpaceName;
    }

    private String readAndEncodeBase64(InputStream stream, int length) throws IOException, CommunicationException {
        byte[] buf = new byte[length];
        int cnt = 0;
        int pos = 0;
        while (pos < length && (cnt = stream.read(buf, pos, length - pos)) != -1) {
            pos += cnt;
        }
        if (pos != length) {
            throw new IOException("Reading configuration failed. Could not read expected number of bytes. Read: " + pos + " announced: " + length);
        }
        String s = Encoder.encodeBase64((byte[])buf);
        return s;
    }

    public void ping(int maxRepeats, int connectTimeout, int readTimeout) throws CommunicationException, AuthorizationException {
        String thisMethod = "ping";
        String path = this.m_connection.getBasePath();
        if (path != null || path.endsWith("/")) {
            path = path.substring(0, path.length() - 1);
        }
        GetRequest getRequest = new GetRequest(path);
        Query query = new Query();
        query.appendQueryParameter("METHOD", "PING");
        getRequest.setQuery(query);
        Connection connection = new Connection((IConnectionTemplate)this.m_connection);
        connection.setFollowRedirects(false);
        connection.setSocketConnectTimeout(connectTimeout);
        connection.setSocketReadTimeout(readTimeout);
        connection.setRequestRepetitions(maxRepeats, true);
        try {
            IResponse response = getRequest.perform((IConnection)connection, true);
            int status = response.getStatus();
            if (status == 200) {
                return;
            }
            if (status == 401) {
                String msg = "Ping failed. (Unauthorized) " + status;
                LOCATION.infoT(thisMethod, msg);
                throw new AuthorizationException(msg, "USR_MISSING_PRIVILEGE");
            }
            String msg = "ping failed with status: " + status;
            LOCATION.infoT(thisMethod, msg);
            throw new CommunicationException(msg);
        }
        catch (HTTPException e) {
            String msg = "ping failed with exception : " + e.getMessage();
            LOCATION.infoT(thisMethod, msg);
            throw new CommunicationException(msg, e);
        }
        catch (IOException e) {
            String msg = "ping failed with exception : " + e.getMessage();
            LOCATION.infoT(thisMethod, msg);
            throw new CommunicationException(msg, e);
        }
    }

    public String updateBuildSpace(InputStream stream, long length) throws CommunicationException, CBSServerException {
        String thisMethod = "updateBuildSpace(InputStream ,long )";
        StreamEntity streamEntity = new StreamEntity(stream, CONTENT_TYPE_XML);
        streamEntity.setContentLength(length);
        PutRequest request = new PutRequest("", (IRequestEntity)streamEntity);
        String buildSpaceName = null;
        Query qry = new Query();
        this.m_currentCBSMethod = "UPDATE_BS_CONFIG";
        qry.appendQueryParameter("METHOD", "UPDATE_BS_CONFIG");
        request.setQuery(qry);
        try {
            BuildspaceResponseHandler handler = new BuildspaceResponseHandler();
            this.sendRequest((IRequest)request, handler);
            buildSpaceName = handler.getBuildspaceName();
        }
        catch (HttpCBSException e) {
            LOCATION.catching(thisMethod, (Throwable)e);
            ErrorMapper.throwError(LOCATION, thisMethod, e.getError());
        }
        return buildSpaceName;
    }

    public IArchiveResult getDCIA(String buildSpace, String compartment, String dcVendor, String dcName, String variant, OutputStream archiveStream) throws CommunicationException, CBSServerException {
        String thisMethod = "getDCIA(String,String,String,String,String,OutputStream)";
        try {
            PostRequest request = new PostRequest("");
            request.addParameter("METHOD", "GET_DCIA");
            request.addParameter("BUILDSPACE", buildSpace);
            request.addParameter("COMPARTMENT", compartment);
            request.addParameter("DC_VENDOR", dcVendor);
            request.addParameter("DC_NAME", dcName);
            request.addParameter("VARIANT", variant);
            return this.getArchive(request, archiveStream);
        }
        catch (NotInResultQueueException e) {
            String message = "Unexpected Error received when trying to get latest DC interface archive." + e.getMessage();
            LOCATION.infoT(thisMethod, message + "\n" + Util.printStackTraceToString((Throwable)e));
            throw new CommunicationException(message, e);
        }
    }

    public IArchiveResult getDCA(String buildSpace, String compartment, String dcVendor, String dcName, String variant, OutputStream archiveStream) throws CommunicationException, CBSServerException {
        String thisMethod = "getDCA(String,String,String,String,String,OutputStream)";
        try {
            PostRequest request = new PostRequest("");
            this.m_currentCBSMethod = "GET_DCA";
            request.addParameter("METHOD", "GET_DCA");
            request.addParameter("BUILDSPACE", buildSpace);
            request.addParameter("COMPARTMENT", compartment);
            request.addParameter("DC_VENDOR", dcVendor);
            request.addParameter("DC_NAME", dcName);
            request.addParameter("VARIANT", variant);
            return this.getArchive(request, archiveStream);
        }
        catch (NotInResultQueueException e) {
            String message = "Unexpected Error received when trying to get latest DC archive." + e.getMessage();
            LOCATION.infoT(thisMethod, message + "\n" + Util.printStackTraceToString((Throwable)e));
            throw new CommunicationException(message, e);
        }
    }

    public IArchiveResult getDCIA(String buildSpace, String compartment, String dcVendor, String dcName, String variant, long requestedBuildNumber, OutputStream archiveStream) throws CommunicationException, CBSServerException {
        PostRequest request = new PostRequest("");
        this.m_currentCBSMethod = "GET_DCIA";
        request.addParameter("METHOD", "GET_DCIA");
        request.addParameter("BUILDSPACE", buildSpace);
        request.addParameter("COMPARTMENT", compartment);
        request.addParameter("DC_VENDOR", dcVendor);
        request.addParameter("DC_NAME", dcName);
        request.addParameter("VARIANT", variant);
        request.addParameter("REQUEST", Long.toString(requestedBuildNumber));
        return this.getArchive(request, archiveStream);
    }

    public IArchiveResult getDCBuildLog(String buildSpace, String compartment, String dcVendor, String dcName, String variant, long requestedBuildNumber, OutputStream archiveStream) throws CommunicationException, CBSServerException {
        PostRequest request = new PostRequest("");
        this.m_currentCBSMethod = "GET_BUILDLOG";
        request.addParameter("METHOD", "GET_BUILDLOG");
        request.addParameter("BUILDSPACE", buildSpace);
        request.addParameter("COMPARTMENT", compartment);
        request.addParameter("DC_VENDOR", dcVendor);
        request.addParameter("DC_NAME", dcName);
        request.addParameter("VARIANT", variant);
        request.addParameter("REQUEST", Long.toString(requestedBuildNumber));
        return this.getArchive(request, archiveStream);
    }

    public IArchiveResult getRequestLog(String buildSpace, long requestedBuildNumber, OutputStream archiveStream) throws CommunicationException, CBSServerException {
        PostRequest request = new PostRequest("");
        this.m_currentCBSMethod = "GET_REQUESTLOG";
        request.addParameter("METHOD", "GET_REQUESTLOG");
        request.addParameter("BUILDSPACE", buildSpace);
        request.addParameter("REQUEST", Long.toString(requestedBuildNumber));
        return this.getArchive(request, archiveStream);
    }

    public IArchiveResult getDCA(String buildSpace, String compartment, String dcVendor, String dcName, String variant, long requestedBuildNumber, OutputStream archiveStream) throws CommunicationException, CBSServerException {
        PostRequest request = new PostRequest("");
        this.m_currentCBSMethod = "GET_DCA";
        request.addParameter("METHOD", "GET_DCA");
        request.addParameter("BUILDSPACE", buildSpace);
        request.addParameter("COMPARTMENT", compartment);
        request.addParameter("DC_VENDOR", dcVendor);
        request.addParameter("DC_NAME", dcName);
        request.addParameter("VARIANT", variant);
        request.addParameter("REQUEST", Long.toString(requestedBuildNumber));
        return this.getArchive(request, archiveStream);
    }

    public IArchiveResult getDCA(String buildSpace, String compartment, String dcVendor, String dcName, String variant, String targetfolder) throws CommunicationException, CBSServerException {
        PostRequest request = new PostRequest("");
        this.m_currentCBSMethod = "GET_DCA";
        request.addParameter("METHOD", "GET_DCA");
        request.addParameter("BUILDSPACE", buildSpace);
        request.addParameter("COMPARTMENT", compartment);
        request.addParameter("DC_VENDOR", dcVendor);
        request.addParameter("DC_NAME", dcName);
        request.addParameter("VARIANT", variant);
        return this.getArchive(request, targetfolder);
    }

    public IArchiveResult getDCDA(String buildSpace, String compartment, String dcVendor, String dcName, String buildVariant, OutputStream archiveStream) throws CommunicationException, CBSServerException {
        PostRequest request = new PostRequest("");
        this.m_currentCBSMethod = "GET_DCDA";
        request.addParameter("METHOD", "GET_DCDA");
        request.addParameter("BUILDSPACE", buildSpace);
        request.addParameter("COMPARTMENT", compartment);
        request.addParameter("DC_VENDOR", dcVendor);
        request.addParameter("DC_NAME", dcName);
        request.addParameter("VARIANT", buildVariant);
        return this.getArchive(request, archiveStream);
    }

    public IArchiveResult getDCDA(String buildSpace, String compartment, String dcVendor, String dcName, String buildVariant, String targetFolder) throws CommunicationException, CBSServerException {
        PostRequest request = new PostRequest("");
        this.m_currentCBSMethod = "GET_DCDA";
        request.addParameter("METHOD", "GET_DCDA");
        request.addParameter("BUILDSPACE", buildSpace);
        request.addParameter("COMPARTMENT", compartment);
        request.addParameter("DC_VENDOR", dcVendor);
        request.addParameter("DC_NAME", dcName);
        request.addParameter("VARIANT", buildVariant);
        return this.getArchive(request, targetFolder);
    }

    public IArchiveResult getPPA(String buildSpace, String compartment, String dcVendor, String dcName, String variant, String publicPartName, OutputStream archiveStream) throws CommunicationException, CBSServerException {
        PostRequest request = new PostRequest("");
        this.m_currentCBSMethod = "GET_PPA";
        request.addParameter("METHOD", "GET_PPA");
        request.addParameter("BUILDSPACE", buildSpace);
        request.addParameter("COMPARTMENT", compartment);
        request.addParameter("DC_VENDOR", dcVendor);
        request.addParameter("DC_NAME", dcName);
        request.addParameter("PP_NAME", publicPartName);
        request.addParameter("VARIANT", variant);
        return this.getArchive(request, archiveStream);
    }

    public IArchiveResult getPPA(String buildSpace, String compartment, String dcVendor, String dcName, String variant, String publicPartName, String targetFolder) throws CommunicationException, CBSServerException {
        PostRequest request = new PostRequest("");
        this.m_currentCBSMethod = "GET_PPA";
        request.addParameter("METHOD", "GET_PPA");
        request.addParameter("BUILDSPACE", buildSpace);
        request.addParameter("COMPARTMENT", compartment);
        request.addParameter("DC_VENDOR", dcVendor);
        request.addParameter("DC_NAME", dcName);
        request.addParameter("PP_NAME", publicPartName);
        request.addParameter("VARIANT", variant);
        return this.getArchive(request, targetFolder);
    }

    public IArchiveResult getSCDA(String buildSpace, String compartment, OutputStream archiveStream) throws CommunicationException, CBSServerException {
        PostRequest request = new PostRequest("");
        this.m_currentCBSMethod = "GET_SCDA";
        request.addParameter("METHOD", "GET_SCDA");
        request.addParameter("BUILDSPACE", buildSpace);
        request.addParameter("COMPARTMENT", compartment);
        return this.getArchive(request, archiveStream);
    }

    public IArchiveResult getSCDA(String buildSpace, String compartment, String targetFolder) throws CommunicationException, CBSServerException {
        PostRequest request = new PostRequest("");
        this.m_currentCBSMethod = "GET_SCDA";
        request.addParameter("METHOD", "GET_SCDA");
        request.addParameter("BUILDSPACE", buildSpace);
        request.addParameter("COMPARTMENT", compartment);
        return this.getArchive(request, targetFolder);
    }

    private void sendRequest(IRequest request, IResponseHandler handler) throws CommunicationException, HttpCBSException {
        String thisMethod = "sendRequest(IRequest,IResponseHandler)";
        IResponse response = null;
        long init = System.currentTimeMillis();
        try {
            response = this.m_connection.send(request);
            this.doSpecialRequestLogging(request, response);
            try {
                if (LOCATION.beDebug()) {
                    String url = this.m_connection.getUrl();
                    url = url + request.getPath();
                    LOCATION.debugT(thisMethod, "sending request: " + url);
                } else {
                    LOCATION.debugT(thisMethod, "sending HTTP request to server ");
                }
                int httpStatus = response.getStatus();
                LOCATION.infoT(thisMethod, "reveived status: " + response.getStatus() + ". Initial Response Time: " + response.getDuration() + " ms.");
                switch (httpStatus) {
                    case 200: {
                        handler.handleResponse(response);
                        break;
                    }
                    case 401: {
                        String msg = "Server resonse: Unauthorized ( HTTP Status 401)";
                        if (LOCATION.beInfo()) {
                            try {
                                StringResultResponseHandler contentHandler = new StringResultResponseHandler();
                                contentHandler.handleResponse(response);
                                String content = contentHandler.getResultString();
                                LOCATION.infoT(thisMethod, msg + "\nServer Response:\n" + content);
                            }
                            catch (IOException e) {
                                LOCATION.catching(thisMethod, (Throwable)e);
                                LOCATION.infoT(thisMethod, msg + "(no response content available): " + Util.printStackTraceToString((Throwable)e));
                            }
                            catch (CommunicationException e) {
                                LOCATION.catching(thisMethod, (Throwable)e);
                                LOCATION.infoT(thisMethod, msg + "(no response content available): " + Util.printStackTraceToString((Throwable)e));
                            }
                        }
                        CBSError error = new CBSError("SERVER_LOGIN_FAIL");
                        HttpCBSException e = new HttpCBSException(error);
                        LOCATION.infoT(thisMethod, "throwing: " + Util.printStackTraceToString((Throwable)e));
                        throw e;
                    }
                    case 404: {
                        ErrorResponseHandler errorReader = new ErrorResponseHandler();
                        errorReader.handleResponse(response);
                        String errorString = errorReader.getErrorCode();
                        String traceString = errorReader.getTrace();
                        if (errorString != null) {
                            String msg = "Received error code from server: " + errorString + " ( HTTP status " + httpStatus + ")";
                            if (traceString != null) {
                                msg = msg + "\nServer stack trace:\n" + traceString;
                            }
                            CBSError error = new CBSError(errorReader.getErrorCode(), errorReader.getTrace());
                            HttpCBSException e = new HttpCBSException(error);
                            LOCATION.infoT(thisMethod, msg + ". Throwing: " + Util.printStackTraceToString((Throwable)e));
                            throw e;
                        }
                        String msg = "Build Server request failed without CBS specific error code. HTTP status: " + httpStatus + " (" + response.getStatusDescription() + ")";
                        throw new CommunicationException(msg);
                    }
                    default: {
                        String msg = "Build Server request failed without CBS specific error code. HTTP status: " + httpStatus + " (" + response.getStatusDescription() + ")";
                        if (LOCATION.beInfo()) {
                            try {
                                StringResultResponseHandler contentHandler = new StringResultResponseHandler();
                                contentHandler.handleResponse(response);
                                String content = contentHandler.getResultString();
                                LOCATION.infoT(thisMethod, msg + "\nServer Response:\n" + content);
                            }
                            catch (IOException e) {
                                LOCATION.catching(thisMethod, (Throwable)e);
                                LOCATION.infoT(thisMethod, msg + "(no response content available): " + e.getMessage());
                            }
                            catch (CommunicationException e) {
                                LOCATION.catching(thisMethod, (Throwable)e);
                                LOCATION.infoT(thisMethod, msg + "(no response content available): " + e.getMessage());
                            }
                        }
                        CommunicationException e = new CommunicationException(msg);
                        LOCATION.throwing(thisMethod, (Throwable)e);
                        throw e;
                    }
                }
                Object var15_31 = null;
            }
            catch (Throwable throwable) {
                Object var15_32 = null;
                LOCATION.infoT(thisMethod, "Request Size: " + request.getContentLength() + " Response Size: " + response.getContentLength() + " . Total Request(send/recieve) Time: " + (System.currentTimeMillis() - init) + " ms.");
                response.releaseStream();
                throw throwable;
            }
            LOCATION.infoT(thisMethod, "Request Size: " + request.getContentLength() + " Response Size: " + response.getContentLength() + " . Total Request(send/recieve) Time: " + (System.currentTimeMillis() - init) + " ms.");
            response.releaseStream();
            {
            }
        }
        catch (HTTPException ex) {
            String msg = "Invalid or incomplete HTTP response from server.";
            LOCATION.infoT(thisMethod, msg + ": " + Util.printStackTraceToString((Throwable)ex));
            throw new CommunicationException(msg + "(HTTPException): " + ex.getMessage(), ex);
        }
        catch (SocketException ex) {
            String msg = "Socket Error occurred while communicating with server.";
            LOCATION.catching(thisMethod, (Throwable)ex);
            LOCATION.infoT(thisMethod, msg + ": " + Util.printStackTraceToString((Throwable)ex));
            throw new CommunicationException(msg + " : " + ex.getMessage(), ex);
        }
        catch (IOException ex) {
            String msg = "IO Error occurred while communicating with server.";
            LOCATION.infoT(thisMethod, msg + ": " + Util.printStackTraceToString((Throwable)ex));
            throw new CommunicationException(msg + " : " + ex.getMessage(), ex);
        }
    }

    private void doSpecialRequestLogging(IRequest request, IResponse response) {
        String url;
        if (!CBSFactory.SERVER_CALL_LOCATION.beDebug() && !CBSFactory.SERVER_CALL_STACK_LOCATION.beDebug()) {
            return;
        }
        int count = CBSFactory.getIncrementedCount();
        String reqPath = request.getPath();
        String string = url = this.m_connection != null ? this.m_connection.getUrl() : "";
        if (reqPath != null && reqPath.startsWith("/") && url.endsWith("/")) {
            reqPath = reqPath.substring(1);
        }
        PrintStream out = CBSFactory.getServerCallLogOutput();
        if (CBSFactory.SERVER_CALL_LOCATION.beDebug()) {
            if (out != null) {
                Class clazz = class$com$sap$tc$cbs$wsproxy$CBSWebServiceVI_Rpc == null ? (class$com$sap$tc$cbs$wsproxy$CBSWebServiceVI_Rpc = HTTPClient.class$("com.sap.tc.cbs.wsproxy.CBSWebServiceVI_Rpc")) : class$com$sap$tc$cbs$wsproxy$CBSWebServiceVI_Rpc;
                synchronized (clazz) {
                    out.print("CBS   Request#");
                    out.print(count);
                    out.print(" [");
                    out.print(Thread.currentThread().getName());
                    out.print("]:  http.");
                    out.print(request.getMethod());
                    out.print("  ");
                    out.print(url);
                    out.print(reqPath);
                    if (this.m_currentCBSMethod != null) {
                        out.print(" ");
                        out.print(this.m_currentCBSMethod);
                    }
                    out.print(" (");
                    out.print(response.getDuration());
                    out.print(" ms)");
                    out.print(" : ");
                    out.print(response.getStatus());
                    out.println();
                }
            }
            if (this.m_currentCBSMethod != null) {
                CBSFactory.SERVER_CALL_LOCATION.debugT("CBS   Request#{0} [{7}]:  http.{1}  {2}{3} {4} ({5} ms) : {6}", new Object[]{new Integer(count), request.getMethod(), url, reqPath, this.m_currentCBSMethod, new Long(response.getDuration()), new Integer(response.getStatus()), Thread.currentThread().getName()});
            } else {
                CBSFactory.SERVER_CALL_LOCATION.debugT("CBS   Request#{0} [{6}]:  http.{1}  {2}{3} ({4} ms) : {5}", new Object[]{new Integer(count), request.getMethod(), url, reqPath, new Long(response.getDuration()), new Integer(response.getStatus()), Thread.currentThread().getName()});
            }
        }
        if (CBSFactory.SERVER_CALL_STACK_LOCATION.beDebug()) {
            DebugTrace dummyException = new DebugTrace("CBS   Request Log");
            CBSFactory.SERVER_CALL_STACK_LOCATION.debugT(Util.printStackTraceToString((Throwable)dummyException));
        }
        this.m_currentCBSMethod = null;
    }

    public void putDCArchive(String buildSpace, String requestNumber, String targetCompartment, String dcVendor, String dcName, String variant, InputStream archiveStream, long archiveSize) throws CommunicationException, CBSServerException {
        Query query = new Query();
        this.m_currentCBSMethod = "ADD_DCA_TO_IMPORT";
        query.appendQueryParameter("METHOD", "ADD_DCA_TO_IMPORT");
        query.appendQueryParameter("BUILDSPACE", buildSpace);
        query.appendQueryParameter("COMPARTMENT", targetCompartment);
        query.appendQueryParameter("DC_NAME", dcName);
        query.appendQueryParameter("DC_VENDOR", dcVendor);
        query.appendQueryParameter("VARIANT", variant);
        query.appendQueryParameter("REQUEST", requestNumber);
        this.putArchive(query, archiveStream, archiveSize);
    }

    public void putDCInterfaceArchive(String buildSpace, String requestNumber, String targetCompartment, String dcVendor, String dcName, String variant, InputStream archiveStream, long archiveSize) throws CommunicationException, CBSServerException {
        Query query = new Query();
        this.m_currentCBSMethod = "ADD_DCA_TO_IMPORT";
        query.appendQueryParameter("METHOD", "ADD_DCIA_TO_IMPORT");
        query.appendQueryParameter("BUILDSPACE", buildSpace);
        query.appendQueryParameter("COMPARTMENT", targetCompartment);
        query.appendQueryParameter("DC_NAME", dcName);
        query.appendQueryParameter("DC_VENDOR", dcVendor);
        query.appendQueryParameter("VARIANT", variant);
        query.appendQueryParameter("REQUEST", requestNumber);
        this.putArchive(query, archiveStream, archiveSize);
    }

    public void putSCD(String buildSpace, String requestNumber, String targetCompartment, InputStream archiveStream, long archiveSize) throws CommunicationException, CBSServerException {
        Query query = new Query();
        this.m_currentCBSMethod = "ADD_SCDA_TO_IMPORT";
        query.appendQueryParameter("METHOD", "ADD_SCDA_TO_IMPORT");
        query.appendQueryParameter("BUILDSPACE", buildSpace);
        query.appendQueryParameter("COMPARTMENT", targetCompartment);
        query.appendQueryParameter("REQUEST", requestNumber);
        this.putArchive(query, archiveStream, archiveSize);
    }

    public long getConfiguration(String buildSpace, OutputStream targetStream) throws CommunicationException, CBSServerException {
        String thisMethod = "getConfiguration(String,OutputStream)";
        PostRequest request = new PostRequest("");
        this.m_currentCBSMethod = "GET_BS_CONFIG";
        request.addParameter("METHOD", "GET_BS_CONFIG");
        request.addParameter("BUILDSPACE", buildSpace);
        long bytesRead = 0L;
        try {
            SimpleGetResponseHandler handler = new SimpleGetResponseHandler(targetStream);
            this.sendRequest((IRequest)request, handler);
            bytesRead = handler.getBytesRead();
        }
        catch (HttpCBSException e) {
            CBSError error = e.getError();
            LOCATION.catching(thisMethod, (Throwable)e);
            ErrorMapper.throwError(LOCATION, thisMethod, error);
        }
        return bytesRead;
    }

    private void putArchive(Query query, InputStream stream, long length) throws CommunicationException, CBSServerException {
        String thisMethod = "putArchive(PutRequest,InputStream,long)";
        StreamEntity streamEntity = new StreamEntity(stream, CONTENT_TYPE_ZIP);
        streamEntity.setContentLength(length);
        PutRequest request = new PutRequest("", (IRequestEntity)streamEntity);
        request.setQuery(query);
        try {
            DummyResponseHandler handler = new DummyResponseHandler();
            this.sendRequest((IRequest)request, handler);
        }
        catch (HttpCBSException e) {
            LOCATION.catching(thisMethod, (Throwable)e);
            throw ErrorMapper.throwError(LOCATION, thisMethod, e.getError());
        }
    }

    private IArchiveResult getArchive(PostRequest request, OutputStream archiveStream) throws CommunicationException, CBSServerException {
        int bytesRead;
        long buildNumber;
        String thisMethod = "getArchive";
        try {
            OutputStreamResponseHandler handler = new OutputStreamResponseHandler(archiveStream);
            this.sendRequest((IRequest)request, handler);
            buildNumber = handler.getBuildNumber();
            bytesRead = handler.getBytesRead();
            LOCATION.debugT(thisMethod, "bytes received: {0}", new Object[]{Integer.toString(bytesRead)});
        }
        catch (HttpCBSException e) {
            LOCATION.catching(thisMethod, (Throwable)e);
            throw ErrorMapper.throwError(LOCATION, thisMethod, e.getError());
        }
        return new ArchiveResult(bytesRead, buildNumber);
    }

    private IArchiveResult getArchive(PostRequest request, String targetFolder) throws CommunicationException, CBSServerException {
        int bytesRead;
        long buildNumber;
        String thisMethod = "getArchive";
        File targetFolderFile = new File(targetFolder);
        if (!targetFolderFile.exists()) {
            try {
                boolean success = targetFolderFile.mkdirs();
                if (!success) {
                    String msg = "cannot create target folder (mkdirs returned false): " + targetFolder;
                    LOCATION.infoT(thisMethod, msg);
                    throw new CommunicationException(msg);
                }
            }
            catch (SecurityException e) {
                String msg = "cannot create target folder (no permission).";
                LOCATION.infoT(thisMethod, msg + " Caused by \n" + Util.printStackTraceToString((Throwable)e));
                throw new CommunicationException(msg, e);
            }
        }
        try {
            ArchiveUnpackResponseHandler handler = new ArchiveUnpackResponseHandler(targetFolder);
            this.sendRequest((IRequest)request, handler);
            buildNumber = handler.getBuildNumber();
            bytesRead = handler.getBytesRead();
        }
        catch (HttpCBSException e) {
            LOCATION.catching(thisMethod, (Throwable)e);
            throw ErrorMapper.throwError(LOCATION, thisMethod, e.getError());
        }
        return new ArchiveResult(bytesRead, buildNumber);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    static class HttpCBSException
    extends Exception {
        CBSError m_error;

        HttpCBSException(CBSError error) {
            this.m_error = error;
        }

        CBSError getError() {
            return this.m_error;
        }
    }
}

