/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbs.client.impl;

import com.sap.tc.cbs.client.IDCRef;
import com.sap.tc.cbs.client.IDCVariantState;
import com.sap.tc.cbs.client.impl.BuildSpace;
import com.sap.tc.cbs.client.impl.DCRef;
import com.sap.tc.cbs.common.types.LogURLCalculator;

public class DCVariantState
implements IDCVariantState {
    private DCRef m_DCRef;
    private long m_dcBuildNumber;
    private long m_variantBuildNumber;
    private boolean m_broken;
    private boolean m_dirty;
    private boolean m_deployable;
    private String m_variantName;
    private String[] m_publicParts;
    private BuildSpace m_bsProxy;
    private String m_Compartment;

    public DCVariantState() {
    }

    public DCVariantState(com.sap.tc.cbs.wsproxy.types.DCVariantState stateRecord, String variant, String compartment, BuildSpace bsProxy) {
        this.m_Compartment = compartment;
        this.m_bsProxy = bsProxy;
        this.m_DCRef = new DCRef(stateRecord.getDcVendor(), stateRecord.getDcName());
        this.m_broken = stateRecord.getBroken();
        this.m_dirty = stateRecord.getDirty();
        this.m_dcBuildNumber = stateRecord.getDcBuildNumber();
        this.m_variantBuildNumber = stateRecord.getVariantBuildNumber();
        this.m_variantName = variant;
        this.m_deployable = stateRecord.getDeployable();
        String[] ppArray = stateRecord.getPublicParts();
        this.m_publicParts = ppArray == null ? new String[0] : ppArray;
    }

    public IDCRef getDCRef() {
        return this.m_DCRef;
    }

    public long getDCBuildNumber() {
        return this.m_dcBuildNumber;
    }

    public long getVariantBuildNumber() {
        return this.m_variantBuildNumber;
    }

    public boolean isBroken() {
        return this.m_broken;
    }

    public boolean isDirty() {
        return this.m_dirty;
    }

    public String getVariantName() {
        return this.m_variantName;
    }

    public String[] getPublicParts() {
        return this.m_publicParts;
    }

    public boolean isDeployable() {
        return this.m_deployable;
    }

    public String getBuildLogURL() {
        String logURLPrefix = this.m_bsProxy.getCbsProxy().getServerURL() + LogURLCalculator.getBuildLogPrefix() + LogURLCalculator.getBuildspaceParam((String)this.m_bsProxy.getName()) + LogURLCalculator.getBuildNumberParam((long)this.m_variantBuildNumber);
        logURLPrefix = logURLPrefix + LogURLCalculator.getCompartmentName((String)this.m_Compartment) + LogURLCalculator.getDCVendorName((String)this.m_DCRef.getVendor(), (String)this.m_DCRef.getName());
        logURLPrefix = LogURLCalculator.addBVName((String)logURLPrefix, (String)this.m_variantName);
        return logURLPrefix;
    }

    public String getCBSBuildLogURL() {
        String logURLPrefix = this.m_bsProxy.getCbsProxy().getServerURL() + LogURLCalculator.getCBSBuildLogPrefix() + LogURLCalculator.getBuildspaceParam((String)this.m_bsProxy.getName()) + LogURLCalculator.getBuildNumberParam((long)this.m_variantBuildNumber);
        logURLPrefix = logURLPrefix + LogURLCalculator.getCompartmentName((String)this.m_Compartment) + LogURLCalculator.getDCVendorName((String)this.m_DCRef.getVendor(), (String)this.m_DCRef.getName());
        logURLPrefix = LogURLCalculator.addBVName((String)logURLPrefix, (String)this.m_variantName);
        return logURLPrefix;
    }
}

