/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbs.client.impl;

import com.sap.tc.cbs.client.IDCRef;
import com.sap.tc.cbs.wsproxy.types.DC;
import com.sap.tc.cbs.wsproxy.types.DCRefRec;

public class DCRef
implements IDCRef {
    protected String vendor;
    protected String name;

    private DCRef() {
    }

    public DCRef(String vendor, String name) {
        this.name = name;
        this.vendor = vendor;
    }

    public String getName() {
        return this.name;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public static IDCRef[] getArrayFromProxyArray(DC[] proxyArray) {
        if (proxyArray == null) {
            return new IDCRef[0];
        }
        IDCRef[] retVal = new IDCRef[proxyArray.length];
        int i = 0;
        while (i < proxyArray.length) {
            DC dc = proxyArray[i];
            retVal[i] = new DCRef(dc.getVendor(), dc.getName());
            ++i;
        }
        return retVal;
    }

    public static DCRefRec[] getArrayDCRefRec(IDCRef[] idcRefArray) {
        DCRefRec[] retVal = new DCRefRec[idcRefArray.length];
        int i = 0;
        while (i < idcRefArray.length) {
            DCRefRec dcRec = new DCRefRec();
            IDCRef dcRef = idcRefArray[i];
            dcRec.setVendor(dcRef.getVendor());
            dcRec.setName(dcRef.getName());
            retVal[i] = dcRec;
            ++i;
        }
        return retVal;
    }

    public String toString() {
        return this.vendor + "~" + this.name;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DCRef)) {
            return false;
        }
        DCRef ref = (DCRef)obj;
        if (this.name == null && ref.name != null) {
            return false;
        }
        if (this.vendor == null && ref.vendor != null) {
            return false;
        }
        if (this.vendor != null && !this.vendor.equals(ref.vendor)) {
            return false;
        }
        return this.name == null || this.name.equals(ref.name);
    }

    public int hashCode() {
        return (this.vendor + "#" + this.name).hashCode();
    }
}

