/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbs.client.impl;

import com.sap.tc.cbs.client.ActivationCheckMode;
import com.sap.tc.cbs.client.IActivityIntersection;
import com.sap.tc.cbs.client.IActivitySet;
import com.sap.tc.cbs.client.IArchiveResult;
import com.sap.tc.cbs.client.IBuildRequest;
import com.sap.tc.cbs.client.IBuildServer;
import com.sap.tc.cbs.client.IBuildSpace;
import com.sap.tc.cbs.client.IDC;
import com.sap.tc.cbs.client.IDCRef;
import com.sap.tc.cbs.client.IDCVariantState;
import com.sap.tc.cbs.client.IImportRequest;
import com.sap.tc.cbs.client.InputMode;
import com.sap.tc.cbs.client.error.ActivationCheckFailedException;
import com.sap.tc.cbs.client.error.AuthorizationException;
import com.sap.tc.cbs.client.error.CBSError;
import com.sap.tc.cbs.client.error.CBSServerException;
import com.sap.tc.cbs.client.error.CommunicationException;
import com.sap.tc.cbs.client.error.ErrorMapper;
import com.sap.tc.cbs.client.error.UnknownBuildSpaceException;
import com.sap.tc.cbs.client.error.UnknownCompartmentException;
import com.sap.tc.cbs.client.error.UnknownDCException;
import com.sap.tc.cbs.client.impl.ActivityIntersection;
import com.sap.tc.cbs.client.impl.ActivitySet;
import com.sap.tc.cbs.client.impl.BuildRequest;
import com.sap.tc.cbs.client.impl.BuildServer;
import com.sap.tc.cbs.client.impl.DCRef;
import com.sap.tc.cbs.client.impl.DCVariantState;
import com.sap.tc.cbs.client.impl.HTTPClient;
import com.sap.tc.cbs.client.impl.ImportRequest;
import com.sap.tc.cbs.client.impl.SoapUtils;
import com.sap.tc.cbs.common.types.ErrorStrings;
import com.sap.tc.cbs.common.types.RequestState;
import com.sap.tc.cbs.common.types.RequestType;
import com.sap.tc.cbs.wsproxy.CBSWebServiceVI_Rpc;
import com.sap.tc.cbs.wsproxy.types.ActionResult;
import com.sap.tc.cbs.wsproxy.types.ActivationResult;
import com.sap.tc.cbs.wsproxy.types.ActivityIntersectionResult;
import com.sap.tc.cbs.wsproxy.types.ActivityResult;
import com.sap.tc.cbs.wsproxy.types.DC;
import com.sap.tc.cbs.wsproxy.types.DCRefRec;
import com.sap.tc.cbs.wsproxy.types.DCVariantStateListResult;
import com.sap.tc.cbs.wsproxy.types.GetBooleanValueResult;
import com.sap.tc.cbs.wsproxy.types.GetDCListResult;
import com.sap.tc.cbs.wsproxy.types.GetNameResult;
import com.sap.tc.cbs.wsproxy.types.GetRequestListResult;
import com.sap.tc.cbs.wsproxy.types.GetShortValueResult;
import com.sap.tc.cbs.wsproxy.types.LongValueResult;
import com.sap.tc.cbs.wsproxy.types.RequestResult;
import com.sap.tc.logging.Location;
import java.io.InputStream;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.Date;

class BuildSpace
implements IBuildSpace {
    private static final int MAX_TRACE_ACTIVITIES = 3;
    private static final Location LOCATION = Location.getLocation((String)(class$com$sap$tc$cbs$client$impl$BuildSpace == null ? (class$com$sap$tc$cbs$client$impl$BuildSpace = BuildSpace.class$("com.sap.tc.cbs.client.impl.BuildSpace")) : class$com$sap$tc$cbs$client$impl$BuildSpace).getName());
    private static String NL = System.getProperty("line.separator");
    private BuildServer m_cbsProxy;
    private String m_buildSpaceName;
    private CBSWebServiceVI_Rpc m_soapPort;
    private HTTPClient m_httpClient;
    static /* synthetic */ Class class$com$sap$tc$cbs$client$impl$BuildSpace;

    public BuildSpace(String buildSpaceName, BuildServer cbsProxy) {
        this.m_cbsProxy = cbsProxy;
        this.m_soapPort = cbsProxy.getSoapPort();
        this.m_buildSpaceName = buildSpaceName;
        this.m_httpClient = this.m_cbsProxy.getHttpProxy();
    }

    public IBuildServer getBuildServer() {
        return this.m_cbsProxy;
    }

    public void remove() throws CommunicationException, CBSServerException {
        ActionResult result;
        String thisMethod = "remove()";
        try {
            result = this.m_soapPort.deleteBS(this.m_buildSpaceName);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
    }

    public String getCompartment(String dcVendor, String dcName) throws CommunicationException, CBSServerException {
        GetNameResult result;
        String thisMethod = "findCompartmentbyDCRef(String,String,String,String)";
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: getCompartment:\n  build space: " + this.m_buildSpaceName + "\n  DC vendor:" + dcVendor + "\n  DC Name:" + dcName);
            result = this.m_soapPort.getCompartment(this.m_buildSpaceName, dcVendor, dcName);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        String compartmentName = result.getName();
        if (compartmentName == null) {
            String message = "CBS Server call getCompartment returned illegal value: received 'null' as compartment name ";
            LOCATION.infoT(thisMethod, message);
            throw new CommunicationException(message);
        }
        return compartmentName;
    }

    public boolean isBuildProcessingEnabled() throws CommunicationException, CBSServerException {
        GetBooleanValueResult result;
        String thisMethod = "getBuildProcessMode()";
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: getBuildProcessMode:\n  build space: " + this.m_buildSpaceName);
            result = this.m_soapPort.isBuildProcessingAllowed(this.m_buildSpaceName);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        boolean enabled = result.getValue();
        return enabled;
    }

    public InputMode getInputMode() throws CommunicationException, CBSServerException {
        InputMode returnValue;
        GetShortValueResult result;
        String thisMethod = "getInputMode()";
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: getInputMode:\n  build space: " + this.m_buildSpaceName);
            result = this.m_soapPort.getInputMode(this.m_buildSpaceName);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        short mode = result.getValue();
        if (mode == com.sap.tc.cbs.common.types.InputMode.OPEN.toShort()) {
            returnValue = InputMode.OPEN;
        } else if (mode == com.sap.tc.cbs.common.types.InputMode.CLOSED.toShort()) {
            returnValue = InputMode.CLOSED;
        } else if (mode == com.sap.tc.cbs.common.types.InputMode.PRIVILEGED.toShort()) {
            returnValue = InputMode.PRIVILEGED;
        } else {
            String message = "Invalid return value received: " + mode;
            LOCATION.infoT(thisMethod, message);
            throw new CommunicationException(message);
        }
        return returnValue;
    }

    public boolean isOutputQueueingEnabled() throws CommunicationException, CBSServerException {
        GetBooleanValueResult result;
        String thisMethod = "isOutputQueueingEnabled()";
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: isOutputQueued:\n  build space: " + this.m_buildSpaceName);
            result = this.m_soapPort.isOutputQueued(this.m_buildSpaceName);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        return result.getValue();
    }

    public boolean isOutputLocked() throws CommunicationException, CBSServerException {
        GetBooleanValueResult result;
        String thisMethod = "isOutputLocked()";
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: isOutputLocked:\n  build space: " + this.m_buildSpaceName);
            result = this.m_soapPort.isOutputLocked(this.m_buildSpaceName);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        return result.getValue();
    }

    public void initializeCompartment(String compartmentName) throws CommunicationException, CBSServerException {
        ActionResult result;
        String thisMethod = "initializeCompartmentFromSource()";
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: initializeCompartmentFromSource:\n  build space: " + this.m_buildSpaceName + " compartment: " + compartmentName);
            result = this.m_soapPort.initializeCompartmentFromSource(this.m_buildSpaceName, compartmentName);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
    }

    public void setBuildProcessingEnabled(boolean enabled) throws CBSServerException, CommunicationException {
        ActionResult result;
        String thisMethod = "setBuildProcessingEnabled(boolean)";
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: setBuildProcessingAllowed:\n  build space: " + this.m_buildSpaceName + " to: " + enabled);
            result = this.m_soapPort.setBuildProcessingAllowed(this.m_buildSpaceName, enabled);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
    }

    public void setInputMode(InputMode mode) throws CommunicationException, CBSServerException {
        ActionResult result;
        short modeAsShort;
        String thisMethod = "setInputMode(RequestInputMode,boolean)";
        if (mode.equals(InputMode.CLOSED)) {
            modeAsShort = com.sap.tc.cbs.common.types.InputMode.CLOSED.toShort();
        } else if (mode.equals(InputMode.PRIVILEGED)) {
            modeAsShort = com.sap.tc.cbs.common.types.InputMode.PRIVILEGED.toShort();
        } else if (mode.equals(InputMode.OPEN)) {
            modeAsShort = com.sap.tc.cbs.common.types.InputMode.OPEN.toShort();
        } else {
            String msg = "Unexpected invalid value of RequestInputMode parameter: " + mode;
            LOCATION.infoT(thisMethod, msg);
            throw new CommunicationException(msg);
        }
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: setInputMode:\n  build space: " + this.m_buildSpaceName + " mode: " + modeAsShort);
            result = this.m_soapPort.setInputMode(this.m_buildSpaceName, modeAsShort, false);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
    }

    public void setOutputLockState(boolean locked) throws CommunicationException, CBSServerException {
        ActionResult result;
        String thisMethod = "setOutputLockState(boolean)";
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: setOutputLocked:\n  build space: " + this.m_buildSpaceName + " value:" + locked);
            result = this.m_soapPort.setOutputLocked(this.m_buildSpaceName, locked);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
    }

    public void setOutputQueueingEnabled(boolean enabled) throws CommunicationException, CBSServerException {
        ActionResult result;
        String thisMethod = "setOutputQueueingEnabled(boolean)";
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: setOutputQueued:\n  build space: " + this.m_buildSpaceName + " value:" + enabled);
            result = this.m_soapPort.setOutputQueued(this.m_buildSpaceName, enabled);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
    }

    public void updateConfiguration(InputStream configDefinitionInputStream, long length) throws CommunicationException, CBSServerException {
        this.updateHTTP(configDefinitionInputStream, length);
    }

    public void validate() throws CommunicationException, CBSServerException {
        ActionResult result;
        String thisMethod = "validate()";
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: validateBS:\n  build space: " + this.m_buildSpaceName);
            result = this.m_soapPort.validateBS(this.m_buildSpaceName);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
    }

    public long[] listOpenRequests() throws CommunicationException, CBSServerException {
        GetRequestListResult result;
        String thisMethod = "listOpenRequests()";
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: listOpenRequests:\n  build space: " + this.m_buildSpaceName);
            result = this.m_soapPort.getOpenRequests(this.m_buildSpaceName);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        return result.getList();
    }

    public long[] listQueuedResults() throws CommunicationException, CBSServerException {
        GetRequestListResult result;
        String thisMethod = "listQueuedResults";
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: getQueuedResults:\n  build space: " + this.m_buildSpaceName);
            result = this.m_soapPort.getQueuedResults(this.m_buildSpaceName);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        return result.getList();
    }

    public IDCRef[] listDCs(String compartment) throws CommunicationException, CBSServerException {
        GetDCListResult result;
        String thisMethod = "getDCsInCompartment(boolean)";
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: getDCsInCompartment:\n  build space: " + this.m_buildSpaceName + " compartment: " + compartment);
            result = this.m_soapPort.getDCs(this.m_buildSpaceName, compartment);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        return DCRef.getArrayFromProxyArray(result.getDcList());
    }

    public IDCRef[] listProblemDCs(String compartment) throws CommunicationException, CBSServerException {
        GetDCListResult result;
        String thisMethod = "listProblemDCs(String)";
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: getProlemDCs:\n  build space: " + this.m_buildSpaceName + " compartment: " + compartment);
            result = this.m_soapPort.getProblemDCs(this.m_buildSpaceName, compartment);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        return DCRef.getArrayFromProxyArray(result.getDcList());
    }

    public IDCRef[] listBrokenDCs(String compName, String variant) throws CommunicationException, CBSServerException {
        GetDCListResult result;
        String thisMethod = "getBrokenDCs(String,String)";
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: getBrokenDCs:\n  build space: " + this.m_buildSpaceName + " compartment: " + compName + " variant " + variant);
            result = this.m_soapPort.getBrokenDCs(this.m_buildSpaceName, compName, variant);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        return DCRef.getArrayFromProxyArray(result.getDcList());
    }

    public IDCRef[] listDirtyDCs(String compName, String buildVariant) throws CommunicationException, CBSServerException {
        GetDCListResult result;
        String thisMethod = "getDirtyDCs(String,String)";
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: getDirtyDCs:\n  build space: " + this.m_buildSpaceName + " compartment: " + compName + " variant " + buildVariant);
            result = this.m_soapPort.getDirtyDCs(this.m_buildSpaceName, compName, buildVariant);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        return DCRef.getArrayFromProxyArray(result.getDcList());
    }

    public IBuildRequest activate(IActivitySet[] activities, boolean ignoreComponentLevelIntersection, boolean integrateWinsIfCollision, boolean activateIfBuildFails, ActivationCheckMode intersectionCheckOption) throws CommunicationException, CBSServerException {
        ActivationResult result;
        String thisMethod = "activate(IActivitySet,boolean,boolean,boolean,ActivationCheckMode)";
        LOCATION.infoT(thisMethod, "  build space: " + this.m_buildSpaceName + "  ignoreComponentLevelIntersection: " + ignoreComponentLevelIntersection + "  queueIfValidationFails: " + intersectionCheckOption + "  integrateWinsIfCollision: " + integrateWinsIfCollision);
        LOCATION.infoT(thisMethod, activities.toString());
        int option = 0;
        if (intersectionCheckOption == ActivationCheckMode.QUEUE) {
            option |= 2;
        } else if (intersectionCheckOption == ActivationCheckMode.FORCE) {
            option |= 8;
        }
        if (ignoreComponentLevelIntersection) {
            option |= 1;
        }
        if (activateIfBuildFails) {
            option |= 0x10;
        }
        if (integrateWinsIfCollision) {
            option |= 4;
        }
        com.sap.tc.cbs.wsproxy.types.ActivitySet[] activitySet = ActivitySet.ArrayToSoapProxyArray(activities);
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: 'activate' on  build space: " + this.m_buildSpaceName + " option: " + option);
            result = this.m_soapPort.activate(this.m_buildSpaceName, activitySet, option);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            String error = result.getErrorCode();
            if (error.equals("ACTV_CHECK_FAILED")) {
                String message;
                String logMessage = message = ErrorStrings.get((String)error) + " (" + error + ")";
                String serverTrace = result.getTrace();
                if (serverTrace != null && serverTrace.length() > 0) {
                    logMessage = logMessage + NL + "... server trace:" + NL + serverTrace;
                }
                IActivityIntersection[] intersections = ActivityIntersection.arrayFromProxy(result.getIntersections());
                logMessage = logMessage + NL + "... " + intersections.length + " activities with intersecting activities found";
                int i = 0;
                while (i < intersections.length) {
                    int remaining;
                    int j;
                    IActivityIntersection intersection = intersections[i];
                    logMessage = logMessage + NL + "    activtion candidate: " + intersection.getActivityUID();
                    String[] intersectingActivities = intersection.getIntersectingActivitiesByComponent();
                    if (intersectingActivities != null) {
                        logMessage = logMessage + NL + "    intersections by component: ";
                        j = 0;
                        while (j < 3 && j < intersectingActivities.length) {
                            logMessage = logMessage + NL + "        " + intersectingActivities[j];
                            ++j;
                        }
                        remaining = intersectingActivities.length - 3;
                        if (remaining > 0) {
                            logMessage = logMessage + NL + "        " + remaining + " more ...";
                        }
                    }
                    if ((intersectingActivities = intersection.getIntersectingActivitiesByObject()) != null) {
                        logMessage = logMessage + NL + "    intersections by object: ";
                        j = 0;
                        while (j < 3 && j < intersectingActivities.length) {
                            logMessage = logMessage + NL + "        " + intersectingActivities[j];
                            ++j;
                        }
                        remaining = intersectingActivities.length - 3;
                        if (remaining > 0) {
                            logMessage = logMessage + NL + "        " + remaining + " more ...";
                        }
                    }
                    ++i;
                }
                throw new ActivationCheckFailedException(message, error, intersections);
            }
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        return new BuildRequest(result.getRequestNumber(), this);
    }

    public String[] listPendingActivities(String compartmentName, String user) throws CommunicationException, CBSServerException {
        ActivityResult result;
        String thisMethod = "getPendingActivities(String)";
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: getPendingActivities, build space: " + this.m_buildSpaceName + " user: " + user);
            result = this.m_soapPort.getPendingActivities(this.m_buildSpaceName, compartmentName, user);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        return result.getActivityUIDs();
    }

    public String[] listPendingActivitiesWithFiles(String compartmentName, String user) throws CommunicationException, CBSServerException {
        String thisMethod = "getPendingActivitiesWithFiles(String, String)";
        ActivityResult result = null;
        if (this.m_cbsProxy.supports(BuildServer.CBSFeature.SUPPORTS_630_SP7_CHANGES)) {
            try {
                LOCATION.infoT(thisMethod, "calling SOAP method: getPendingActivitiesWithFiles, build space: " + this.m_buildSpaceName + " user: " + user);
                result = this.m_soapPort.getPendingActivitiesWithFiles(this.m_buildSpaceName, compartmentName, user);
            }
            catch (RemoteException e) {
                throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
            }
        }
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: getPendingActivities, build space: " + this.m_buildSpaceName + " user: " + user);
            result = this.m_soapPort.getPendingActivities(this.m_buildSpaceName, compartmentName, user);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        return result.getActivityUIDs();
    }

    public IActivityIntersection listIntersections(String activityUID, String compartmentName, boolean ignoreComponentLevelIntersections) throws CommunicationException, CBSServerException {
        String thisMethod = "getIntersectingActivities(String,String,boolean)";
        ActivityIntersectionResult result = null;
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: getIntersectingActivities, build space: " + this.m_buildSpaceName + " activity: " + activityUID + " compartment: " + compartmentName);
            result = this.m_soapPort.getActivityIntersections(this.m_buildSpaceName, activityUID, compartmentName, ignoreComponentLevelIntersections);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        ActivityIntersection intersection = new ActivityIntersection();
        intersection.setActivityUID(activityUID);
        intersection.setIntersectingActivitiesByComponent(result.getIntersectActivitiesByComponent());
        intersection.setIntersectingActivitiesByObject(result.getIntersectActivitiesByObject());
        return intersection;
    }

    public boolean isActivated(String activityUID, String compartmentName) throws CommunicationException, CBSServerException {
        String thisMethod = "isActivated(String,String)";
        GetBooleanValueResult result = null;
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: getIntersectingActivities, build space: " + this.m_buildSpaceName + " activity: " + activityUID + " compartment: " + compartmentName);
            result = this.m_soapPort.isActivated(this.m_buildSpaceName, activityUID, compartmentName);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        return result.getValue();
    }

    public IBuildRequest buildAll(String compartment, String[] variants) throws CommunicationException, CBSServerException {
        RequestResult result;
        String thisMethod = "buildAll(String,String[])";
        LOCATION.infoT(thisMethod, "parameters: \n  build space: " + this.m_buildSpaceName + "\n  compartment: " + compartment);
        try {
            LOCATION.debugT(thisMethod, "calling SOAP method: buildAll");
            result = this.m_soapPort.buildAll(this.m_buildSpaceName, compartment, variants);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        return new BuildRequest(result.getRequest().getNumber(), this);
    }

    public IBuildRequest buildDC(String compartment, String dcVendor, String dcName, String[] variants) throws CommunicationException, CBSServerException {
        RequestResult result;
        String thisMethod = "buildDC(String,,String,String,String[])";
        LOCATION.infoT(thisMethod, "parameters: \n  build space: " + this.m_buildSpaceName + "\n  compartment: " + compartment + "\n  vendor: " + dcVendor + "\n  name: " + dcName);
        try {
            LOCATION.debugT(thisMethod, "calling SOAP method: buildDC");
            DC dc = new DC();
            dc.setCompName(compartment);
            dc.setName(dcName);
            dc.setVendor(dcVendor);
            result = this.m_soapPort.buildDC(this.m_buildSpaceName, dc, variants);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        return new BuildRequest(result.getRequest().getNumber(), this);
    }

    public IBuildRequest getBuildRequest(long buildRequestNumber) {
        return new BuildRequest(buildRequestNumber, this);
    }

    public IImportRequest getImportRequest(long buildRequestNumber) {
        return new ImportRequest(buildRequestNumber, this);
    }

    public IArchiveResult getDCArchive(String compartment, String dcVendor, String dcName, String buildVariant, long buildNumber, OutputStream archiveStream) throws CommunicationException, CBSServerException {
        return this.m_httpClient.getDCA(this.m_buildSpaceName, compartment, dcVendor, dcName, buildVariant, buildNumber, archiveStream);
    }

    public IArchiveResult getDCBuildLogArchive(String compartment, String dcVendor, String dcName, String buildVariant, long buildRequestNumber, OutputStream archiveStream) throws CommunicationException, CBSServerException {
        return this.m_httpClient.getDCBuildLog(this.m_buildSpaceName, compartment, dcVendor, dcName, buildVariant, buildRequestNumber, archiveStream);
    }

    public IArchiveResult getDCDescriptionArchive(String compartment, String dcVendor, String dcName, String buildVariant, OutputStream archiveStream) throws CommunicationException, CBSServerException {
        return this.m_httpClient.getDCDA(this.m_buildSpaceName, compartment, dcVendor, dcName, buildVariant, archiveStream);
    }

    public IArchiveResult getDCInterfaceArchive(String compartment, String dcVendor, String dcName, String variant, long buildNumber, OutputStream archiveStream) throws CommunicationException, CBSServerException {
        return this.m_httpClient.getDCIA(this.m_buildSpaceName, compartment, dcVendor, dcName, variant, buildNumber, archiveStream);
    }

    public IArchiveResult getDCInterfaceArchive(String compartment, String dcVendor, String dcName, String variant, OutputStream archiveStream) throws CommunicationException, CBSServerException {
        return this.m_httpClient.getDCIA(this.m_buildSpaceName, compartment, dcVendor, dcName, variant, archiveStream);
    }

    public IArchiveResult getDCArchive(String compartment, String dcVendor, String dcName, String buildVariant, OutputStream archiveStream) throws CommunicationException, CBSServerException {
        return this.m_httpClient.getDCA(this.m_buildSpaceName, compartment, dcVendor, dcName, buildVariant, archiveStream);
    }

    public long getLatestBuildNumber(String compartment, String dcVendor, String dcName) throws CommunicationException, UnknownBuildSpaceException, AuthorizationException, UnknownCompartmentException, UnknownDCException {
        System.out.println("NOT YET IMPLEMENTED: getLatestBuildNumber");
        return 0L;
    }

    public long getLatestBuildNumber(String compartment, String dcVendor, String dcName, String buildVariant) throws CommunicationException, CBSServerException {
        LongValueResult result;
        String thisMethod = "getLatestBuildNumber(String,String,String,String)";
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: getLatestBuildNumber, build space: " + this.m_buildSpaceName + " compartment: " + compartment + " dcVendor: " + dcVendor + " dcName: " + dcName + " variant: " + buildVariant);
            result = this.m_soapPort.getLatestBuildNumber(this.m_buildSpaceName, compartment, dcVendor, dcName, buildVariant);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        return result.getValue();
    }

    public IArchiveResult getPublicPartArchive(String compartment, String dcVendor, String dcName, String publicPartName, String buildVariant, OutputStream archiveStream) throws CommunicationException, CBSServerException {
        return this.m_httpClient.getPPA(this.m_buildSpaceName, compartment, dcVendor, dcName, buildVariant, publicPartName, archiveStream);
    }

    public IArchiveResult getSCDescriptionArchive(String compartment, OutputStream archiveStream) throws CommunicationException, CBSServerException {
        return this.m_httpClient.getSCDA(this.m_buildSpaceName, compartment, archiveStream);
    }

    public long getConfiguration(OutputStream targetStream) throws CommunicationException, CBSServerException {
        return this.m_httpClient.getConfiguration(this.m_buildSpaceName, targetStream);
    }

    public String getName() {
        return this.m_buildSpaceName;
    }

    private void updateHTTP(InputStream configDefinitionInputStream, long length) throws CommunicationException, CBSServerException {
        String thisMethod = "updateHTTP";
        String bsName = this.m_cbsProxy.getHttpProxy().updateBuildSpace(configDefinitionInputStream, length);
        if (bsName != this.m_buildSpaceName) {
            String msg = "Difference between old and new build space name (configuration name). Not detceted by server!";
            LOCATION.infoT(thisMethod, msg);
            throw new CommunicationException(msg);
        }
    }

    protected IArchiveResult getRequestLogArchive(long buildRequestNumber, OutputStream archiveStream) throws CommunicationException, CBSServerException {
        return this.m_httpClient.getRequestLog(this.m_buildSpaceName, buildRequestNumber, archiveStream);
    }

    public IImportRequest createImportRequest(IActivitySet[] activities, boolean ignoreComponentLevelIntersection, boolean integrateWinsIfCollision, boolean activateIfBuildFails, ActivationCheckMode intersectionCheckOption) throws CommunicationException, CBSServerException {
        short option = 0;
        if (intersectionCheckOption == ActivationCheckMode.QUEUE) {
            option = (short)(option | 2);
        } else if (intersectionCheckOption == ActivationCheckMode.FORCE) {
            option = (short)(option | 8);
        }
        if (ignoreComponentLevelIntersection) {
            option = (short)(option | 1);
        }
        if (activateIfBuildFails) {
            option = (short)(option | 0x10);
        }
        if (integrateWinsIfCollision) {
            option = (short)(option | 4);
        }
        return this.createImportRequest(activities, option);
    }

    public IImportRequest createImportRequest() throws CommunicationException, CBSServerException {
        return this.createImportRequest((short)0);
    }

    public IImportRequest createImportRequest(boolean forceArchiveUpdate) throws CommunicationException, CBSServerException {
        short option = 0;
        if (forceArchiveUpdate) {
            option = (short)(option | 0x40);
        }
        return this.createImportRequest(option);
    }

    public IImportRequest createImportRequest(IActivitySet[] activities, boolean ignoreComponentLevelIntersection, boolean activateIfBuildFails, ActivationCheckMode intersectionCheckOption) throws CommunicationException, CBSServerException {
        short option = 0;
        if (intersectionCheckOption == ActivationCheckMode.QUEUE) {
            option = (short)(option | 2);
        } else if (intersectionCheckOption == ActivationCheckMode.FORCE) {
            option = (short)(option | 8);
        }
        if (ignoreComponentLevelIntersection) {
            option = (short)(option | 1);
        }
        if (activateIfBuildFails) {
            option = (short)(option | 0x10);
        }
        return this.createImportRequest(activities, option);
    }

    public IImportRequest createImportRequest(IActivitySet[] activities, boolean ignoreComponentLevelIntersection, boolean activateIfBuildFails, ActivationCheckMode intersectionCheckOption, boolean forceArchiveUpdate) throws CommunicationException, CBSServerException {
        short option = 0;
        if (intersectionCheckOption == ActivationCheckMode.QUEUE) {
            option = (short)(option | 2);
        } else if (intersectionCheckOption == ActivationCheckMode.FORCE) {
            option = (short)(option | 8);
        }
        if (ignoreComponentLevelIntersection) {
            option = (short)(option | 1);
        }
        if (activateIfBuildFails) {
            option = (short)(option | 0x10);
        }
        if (forceArchiveUpdate) {
            option = (short)(option | 0x40);
        }
        return this.createImportRequest(activities, option);
    }

    private ImportRequest createImportRequest(IActivitySet[] activities, short options) throws CBSServerException, CommunicationException {
        ImportRequest request;
        block8: {
            String msg2;
            String thisMethod = "createImportRequest(IActivitySet[] activities,short options)";
            request = this.createImportRequest(options);
            boolean addingActivitiesFailed = true;
            try {
                request.addActivities(activities);
                addingActivitiesFailed = false;
                Object var7_6 = null;
                if (!addingActivitiesFailed) break block8;
                msg2 = "Adding activities failed. Cancelling request \"" + request.getRequestID() + "\"";
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                if (addingActivitiesFailed) {
                    String msg2 = "Adding activities failed. Cancelling request \"" + request.getRequestID() + "\"";
                    LOCATION.infoT(thisMethod, msg2);
                    try {
                        request.cancel();
                    }
                    catch (CBSServerException cancelException) {
                        LOCATION.traceThrowableT(300, thisMethod, "Cancelling request failed: \"{0}\". Caught exception when trying to cancel request because of another exception during creation (ignoring second exception):{1}", new Object[]{new Long(request.getRequestID()), cancelException.getMessage()}, (Throwable)cancelException);
                    }
                    catch (CommunicationException cancelException) {
                        LOCATION.traceThrowableT(300, thisMethod, "Cancelling request failed: \"{0}\". Caught exception when trying to cancel request because of another exception during creation (ignoring second exception):{1}", new Object[]{new Long(request.getRequestID()), cancelException.getMessage()}, (Throwable)cancelException);
                    }
                }
                throw throwable;
            }
            LOCATION.infoT(thisMethod, msg2);
            try {
                request.cancel();
            }
            catch (CBSServerException cancelException) {
                LOCATION.traceThrowableT(300, thisMethod, "Cancelling request failed: \"{0}\". Caught exception when trying to cancel request because of another exception during creation (ignoring second exception):{1}", new Object[]{new Long(request.getRequestID()), cancelException.getMessage()}, (Throwable)cancelException);
            }
            catch (CommunicationException cancelException) {
                LOCATION.traceThrowableT(300, thisMethod, "Cancelling request failed: \"{0}\". Caught exception when trying to cancel request because of another exception during creation (ignoring second exception):{1}", new Object[]{new Long(request.getRequestID()), cancelException.getMessage()}, (Throwable)cancelException);
            }
        }
        return request;
    }

    private ImportRequest createImportRequest(short options) throws CBSServerException, CommunicationException {
        RequestResult result;
        String thisMethod = "createImportRequest(short options)";
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: createImport, build space: " + this.m_buildSpaceName);
            result = this.m_soapPort.createImport(this.m_buildSpaceName, (int)options);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        return new ImportRequest(result.getRequest().getNumber(), this);
    }

    BuildServer getCbsProxy() {
        return this.m_cbsProxy;
    }

    public IDCRef[] listToplevelDCs(String compartment) throws CommunicationException, CBSServerException {
        GetDCListResult result;
        String thisMethod = "listToplevelDCs(String)";
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: createImport, build space: " + this.m_buildSpaceName);
            result = this.m_soapPort.getTopLevelDCs(this.m_buildSpaceName, compartment);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        return DCRef.getArrayFromProxyArray(result.getDcList());
    }

    public IDCRef[] listChildDCs(IDC component) throws CommunicationException, CBSServerException {
        return this.listChildDCs(component.getCompartment(), component.getVendor(), component.getName());
    }

    public IDCRef[] listChildDCs(String compartment, String dcVendor, String dcName) throws CommunicationException, CBSServerException {
        GetDCListResult result;
        String thisMethod = "listChildDCs(String)";
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: getChildDCs, build space: " + this.m_buildSpaceName + " compartment " + compartment + " vendor " + dcVendor + " name" + dcName);
            DC dc = new DC();
            dc.setCompName(compartment);
            dc.setName(dcName);
            dc.setVendor(dcVendor);
            result = this.m_soapPort.getChildDCs(this.m_buildSpaceName, dc);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        return DCRef.getArrayFromProxyArray(result.getDcList());
    }

    public IDCVariantState[] listDCVariantStates(String compartment, String buildVariant, IDCRef[] dcList) throws CommunicationException, CBSServerException {
        IDCVariantState[] retArray;
        DCVariantStateListResult result;
        String thisMethod = "listDCVariantStates(String)";
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: getDCVariantStates, build space: " + this.m_buildSpaceName + " compartment " + compartment + " buildVariant " + buildVariant);
            DCRefRec[] dcRefRecords = DCRef.getArrayDCRefRec(dcList);
            result = this.m_soapPort.getDCVariantStates(this.m_buildSpaceName, compartment, buildVariant, dcRefRecords);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        com.sap.tc.cbs.wsproxy.types.DCVariantState[] stateArray = result.getVariantStates();
        if (stateArray == null) {
            retArray = new IDCVariantState[]{};
        } else {
            int count = stateArray.length;
            retArray = new IDCVariantState[count];
            int i = 0;
            while (i < count) {
                retArray[i] = new DCVariantState(stateArray[i], buildVariant, compartment, this);
                ++i;
            }
        }
        return retArray;
    }

    public IArchiveResult getDCArchive(String compartment, String dcVendor, String dcName, String buildVariant, String targetFolder) throws CommunicationException, CBSServerException {
        return this.m_httpClient.getDCA(this.m_buildSpaceName, compartment, dcVendor, dcName, buildVariant, targetFolder);
    }

    public IArchiveResult getDCDescriptionArchive(String compartment, String dcVendor, String dcName, String buildVariant, String targetFolder) throws CommunicationException, CBSServerException {
        return this.m_httpClient.getDCDA(this.m_buildSpaceName, compartment, dcVendor, dcName, buildVariant, targetFolder);
    }

    public IArchiveResult getPublicPartArchive(String compartment, String dcVendor, String dcName, String publicPartName, String buildVariant, String targetFolder) throws CommunicationException, CBSServerException {
        return this.m_httpClient.getPPA(this.m_buildSpaceName, compartment, dcVendor, dcName, buildVariant, publicPartName, targetFolder);
    }

    public IArchiveResult getSCDescriptionArchive(String compartment, String targetFolder) throws CommunicationException, CBSServerException {
        return this.m_httpClient.getSCDA(this.m_buildSpaceName, compartment, targetFolder);
    }

    public void ping() throws CommunicationException, AuthorizationException, UnknownBuildSpaceException {
        String thisMethod = "ping()";
        try {
            if (LOCATION.beDebug()) {
                LOCATION.debugT(thisMethod, "calling ping (via SOAP) on build space " + this.m_buildSpaceName + " on server " + this.m_cbsProxy.getURL());
            }
            this.getInputMode();
            if (LOCATION.beDebug()) {
                LOCATION.debugT(thisMethod, "ping sucessful");
            }
        }
        catch (AuthorizationException e) {
            throw e;
        }
        catch (UnknownBuildSpaceException e) {
            throw e;
        }
        catch (CBSServerException e) {
            String msg = "ping failed on build space " + this.m_buildSpaceName + " on server " + this.m_cbsProxy.getURL();
            throw new CommunicationException(msg + " : " + e.getMessage(), e);
        }
        catch (CommunicationException e) {
            RemoteException re;
            Throwable innerException = e.getPreviousException();
            if (innerException != null && innerException instanceof RemoteException && SoapUtils.isUnauthorized(re = (RemoteException)innerException)) {
                String msg = "ping failed on build space " + this.m_buildSpaceName + " on server " + this.m_cbsProxy.getURL() + " : " + e.getMessage();
                LOCATION.traceThrowableT(100, thisMethod, msg, (Throwable)e);
                throw new AuthorizationException(msg, null);
            }
            throw e;
        }
    }

    public long getRequestNumber(long buildNumber) throws CommunicationException, CBSServerException {
        String thisMethod = "getRequestNumber(long)";
        return this.getRequestByBuildNumber(buildNumber).getRequestID();
    }

    public IBuildRequest getRequestByBuildNumber(long buildNumber) throws CommunicationException, CBSServerException {
        String thisMethod = "getRequestByBuildNumber(long)";
        if (!this.m_cbsProxy.supports(BuildServer.CBSFeature.SUPPORTS_630_SP7_CHANGES)) {
            throw new UnsupportedOperationException("The CBS Server to which the client is connected does not support the required operation.");
        }
        RequestResult result = null;
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: getRequestForBuildNumber, build space: " + this.m_buildSpaceName + " buildNumber " + buildNumber);
            result = this.m_soapPort.getRequestForBuildNumber(buildNumber, this.m_buildSpaceName);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        return new BuildRequest(result.getRequest().getNumber(), this);
    }

    public long getRequestCount(RequestState rqState, RequestType rqType, Date since, Date until, String user) throws CommunicationException, CBSServerException {
        String thisMethod = "getRequestCount(RequestState , RequestType , Date , Date , String )";
        if (!this.m_cbsProxy.supports(BuildServer.CBSFeature.SUPPORTS_630_SP7_CHANGES)) {
            throw new UnsupportedOperationException("The CBS Server to which the client is connected does not support the required operation.");
        }
        LongValueResult result = null;
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: getRequestCount, RequestState : " + rqState.toShort() + ", RequestType : " + rqType.toShort() + ", Since Date : " + since + ", Date : " + until + ", User : " + user);
            result = this.m_soapPort.getRequestCount(rqState.toShort(), rqType.toShort(), since.getTime(), until != null ? until.getTime() : -1L, user, this.m_buildSpaceName);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        return result.getValue();
    }

    public long getBuildKeyCounter() throws CBSServerException, CommunicationException {
        String thisMethod = "getBuildKeyCounter";
        if (!this.m_cbsProxy.supports(BuildServer.CBSFeature.SUPPORTS_LISTING_REQUEST_DCS)) {
            throw new UnsupportedOperationException("The CBS Server to which the client is connected does not support the required operation.");
        }
        LongValueResult result = null;
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: getBuildKeyCounter, Buildspace name : " + this.m_buildSpaceName);
            result = this.m_soapPort.getBuildKeyCounter(this.m_buildSpaceName);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        return result.getValue();
    }

    public void setBuildKeyCounter(long keyCounter) throws CommunicationException, CBSServerException {
        ActionResult result;
        String thisMethod = "setBuildKeyCounter(long)";
        if (!this.m_cbsProxy.supports(BuildServer.CBSFeature.SUPPORTS_LISTING_REQUEST_DCS)) {
            throw new UnsupportedOperationException("The CBS Server to which the client is connected does not support the required operation.");
        }
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: setBuildKeyCounter:\n  build space: " + this.m_buildSpaceName + " value:" + keyCounter);
            result = this.m_soapPort.setBuildKeyCounter(this.m_buildSpaceName, keyCounter);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

