/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbs.client.impl;

import com.sap.engine.services.webservices.jaxrpc.wsdl2java.BaseGeneratedStub;
import com.sap.security.core.client.ws.AuthenticationContext;
import com.sap.security.core.client.ws.SecurityProtocol;
import com.sap.tc.cbs.client.CBSFactory;
import com.sap.tc.cbs.client.IBuildServer;
import com.sap.tc.cbs.client.IBuildSpace;
import com.sap.tc.cbs.client.error.AuthorizationException;
import com.sap.tc.cbs.client.error.CBSError;
import com.sap.tc.cbs.client.error.CBSServerException;
import com.sap.tc.cbs.client.error.CommunicationException;
import com.sap.tc.cbs.client.error.DebugTrace;
import com.sap.tc.cbs.client.error.ErrorMapper;
import com.sap.tc.cbs.client.impl.BuildSpace;
import com.sap.tc.cbs.client.impl.HTTPClient;
import com.sap.tc.cbs.client.impl.SoapUtils;
import com.sap.tc.cbs.util.ChainedRuntimeException;
import com.sap.tc.cbs.util.Util;
import com.sap.tc.cbs.wsproxy.CBSWebServiceImpl;
import com.sap.tc.cbs.wsproxy.CBSWebServiceVI_Rpc;
import com.sap.tc.cbs.wsproxy.types.GetBuildSpaceListResult;
import com.sap.tc.logging.Location;
import com.tssap.dtr.client.lib.protocol.IAuthenticator;
import com.tssap.dtr.client.lib.protocol.IConnectionTemplate;
import com.tssap.dtr.client.lib.protocol.ISessionContext;
import com.tssap.dtr.client.lib.protocol.session.BasicAuthenticator;
import com.tssap.dtr.client.lib.protocol.session.Certificates;
import com.tssap.dtr.client.lib.protocol.session.Cookie;
import com.tssap.dtr.client.lib.protocol.session.Cookies;
import com.tssap.dtr.client.lib.protocol.session.SSO2Authenticator;
import com.tssap.dtr.client.lib.protocol.session.SessionContext;
import com.tssap.dtr.client.lib.protocol.templates.ConnectionTemplate;
import java.io.InputStream;
import java.io.PrintStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.rmi.RemoteException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class BuildServer
implements IBuildServer {
    public static final String DEFAULT_CBS_SERVLET_PATH = "tc.CBS.Appl/archiveapi2";
    public static final String SOAPSERVLET_DEFAULT = "CBSWebService/CBSHttpSOAP?style=rpc";
    public static final String BASIC_AUTHENTICATION_LEVEL = "BASIC";
    public static final String DEFAULT_AUTHENTICATION_LEVEL = "BASIC";
    public static final String PROXY_USER_PROPERTY = "proxyUser";
    public static final String PROXY_PASSWORD_PROPERTY = "proxyPassword";
    private static final Location LOCATION = Location.getLocation((String)(class$com$sap$tc$cbs$client$impl$BuildServer == null ? (class$com$sap$tc$cbs$client$impl$BuildServer = BuildServer.class$("com.sap.tc.cbs.client.impl.BuildServer")) : class$com$sap$tc$cbs$client$impl$BuildServer).getName());
    public static final String SOAPSERVLET_PROPERTY = "com.sap.tc.cbs.soapservlet";
    private static String soapservletName = null;
    private static String WS_PARAM_HTTP_PROXYHOST = "javax.xml.rpc.http.proxyhost";
    private static String WS_PARAM_HTTP_PROXYPORT = "javax.xml.rpc.http.proxyport";
    private String m_soapServletURL;
    private String m_serverURL;
    private String m_webUiURL;
    private String m_webUiPath;
    private String m_user;
    private String m_password;
    private String m_proxyUser;
    private String m_proxyPassword;
    private CBSWebServiceVI_Rpc m_soapPort;
    private CBSWebServiceVI_Rpc m_rawSoapPort;
    private HTTPClient m_httpClient;
    private ConnectionTemplate m_httpConnectionTemplate;
    private String m_serverVersion = null;
    private CBSFeatureList m_featurlist;
    static /* synthetic */ Class class$com$sap$tc$cbs$client$impl$BuildServer;
    static /* synthetic */ Class class$com$sap$tc$cbs$wsproxy$CBSWebServiceVI_Rpc;

    private BuildServer() {
    }

    public BuildServer(IConnectionTemplate connTemplate) throws IllegalStateException, CommunicationException {
        this.m_httpConnectionTemplate = new ConnectionTemplate(connTemplate);
        this.setCBSServletPath();
        this.m_user = this.m_httpConnectionTemplate.getSessionContext().getUser();
        this.m_password = this.m_httpConnectionTemplate.getSessionContext().getPassword();
        this.m_proxyUser = this.m_httpConnectionTemplate.getSessionContext().getProxyUser();
        this.m_proxyPassword = this.m_httpConnectionTemplate.getSessionContext().getProxyPassword();
        ISessionContext ctx = this.m_httpConnectionTemplate.getSessionContext();
        if (this.m_user != null && ctx.getAuthenticator() == null) {
            BasicAuthenticator login = new BasicAuthenticator(ctx);
            ctx.setAuthenticator((IAuthenticator)new SSO2Authenticator(ctx, (IAuthenticator)login));
        }
        this.m_serverURL = this.m_httpConnectionTemplate.getProtocol() + "://" + this.m_httpConnectionTemplate.getHost() + ":" + this.m_httpConnectionTemplate.getPort();
        this.m_soapServletURL = this.m_serverURL + "/" + BuildServer.getSoapServlet();
        this.m_webUiPath = "webdynpro/dispatcher/sap.com/tc.CBS.WebUI/WebUI";
        this.m_webUiURL = Util.concatenatePath((String)this.m_serverURL, (String)"webdynpro/dispatcher/sap.com/tc.CBS.WebUI/WebUI", (char)'/');
        this.initializeSOAP();
        this.m_httpClient = new HTTPClient((IConnectionTemplate)this.m_httpConnectionTemplate, this);
    }

    private String setCBSServletPath() {
        String path = this.m_httpConnectionTemplate.getBasePath();
        if (path != null && path.length() > 0 && !path.equals("/")) {
            LOCATION.debugT("setCBSServletPath", "ignoring servlet path {0} using standard path {1}", new Object[]{path, this.getDefaultCBSServletPATH()});
        }
        this.m_httpConnectionTemplate.setBasePath(this.getDefaultCBSServletPATH());
        return path;
    }

    private String getDefaultCBSServletPATH() {
        return DEFAULT_CBS_SERVLET_PATH;
    }

    public IBuildSpace createBuildSpace(InputStream configDefinitionInputStream, long length, String repositoryUser, String repositoryPassword) throws CommunicationException, CBSServerException {
        String bsName = this.m_httpClient.createBuildSpace(configDefinitionInputStream, length, repositoryUser, repositoryPassword);
        BuildSpace bsProxy = new BuildSpace(bsName, this);
        return bsProxy;
    }

    public IBuildSpace getBuildSpace(String configurationName) {
        BuildSpace bsProxy = new BuildSpace(configurationName, this);
        return bsProxy;
    }

    public String getPassword() {
        return this.m_password;
    }

    public String getURL() {
        return this.m_httpConnectionTemplate.getUrl();
    }

    public String getUser() {
        return this.m_user;
    }

    public void setUserAndPassword(String user, String password) {
        try {
            this.setCredentials(user, password, null, null);
        }
        catch (KeyStoreException e) {
            throw new ChainedRuntimeException("Unexpecetd KeyStoreException exception caught wehne setting user and password (but no key stores!)", (Throwable)e);
        }
    }

    public void setCredentials(String user, String password, KeyStore serverCertKeyStore, KeyStore clientCertKeyStore) throws KeyStoreException {
        SessionContext newSessionContext;
        String thisMethod = "setCredentials()";
        this.m_user = user;
        this.m_password = password;
        ISessionContext oldcontext = this.m_httpConnectionTemplate.getSessionContext();
        try {
            IAuthenticator authenticator = oldcontext.getAuthenticator();
            newSessionContext = authenticator != null ? new SessionContext(this.m_user, this.m_password, authenticator) : new SessionContext(this.m_user, this.m_password, "BASIC");
        }
        catch (NoSuchAlgorithmException e) {
            LOCATION.catching(thisMethod, (Throwable)e);
            String m = "Setting authentication on session context failed." + e.getMessage();
            ChainedRuntimeException ex = new ChainedRuntimeException(m, (Throwable)e);
            LOCATION.throwing(thisMethod, (Throwable)ex);
            throw ex;
        }
        this.setKeyStores((ISessionContext)newSessionContext, password, clientCertKeyStore, serverCertKeyStore);
        newSessionContext.setSendCookies(oldcontext.getSendCookies());
        newSessionContext.setSendAuthentication(oldcontext.getSendAuthentication());
        this.m_httpConnectionTemplate.setSessionContext((ISessionContext)newSessionContext);
        this.m_httpClient = new HTTPClient((IConnectionTemplate)this.m_httpConnectionTemplate, this);
        if (this.m_soapPort != null) {
            this.m_soapPort._setProperty("javax.xml.rpc.security.auth.username", (Object)this.m_user);
            this.m_soapPort._setProperty("javax.xml.rpc.security.auth.password", (Object)this.m_password);
            try {
                this.initializeSecurityProtocol(this.m_rawSoapPort, (IConnectionTemplate)this.m_httpConnectionTemplate);
            }
            catch (CommunicationException e1) {
                LOCATION.catching(thisMethod, (Throwable)e1);
                ChainedRuntimeException re = new ChainedRuntimeException(e1.getMessage(), (Throwable)e1);
                LOCATION.throwing(thisMethod, (Throwable)re);
                throw re;
            }
        }
    }

    public void setCredentials(String user, String password, String proxyUser, String proxyPassword, KeyStore serverCertKeyStore, KeyStore clientCertKeyStore) throws KeyStoreException {
        SessionContext newSessionContext;
        String thisMethod = "setCredentials()";
        this.m_user = user;
        this.m_password = password;
        this.m_proxyUser = proxyUser;
        this.m_proxyPassword = proxyPassword;
        ISessionContext oldcontext = this.m_httpConnectionTemplate.getSessionContext();
        try {
            IAuthenticator authenticator = oldcontext.getAuthenticator();
            IAuthenticator proxyAuthenticator = oldcontext.getProxyAuthenticator();
            newSessionContext = authenticator != null ? new SessionContext(this.m_user, this.m_password, authenticator) : new SessionContext(this.m_user, this.m_password, "BASIC");
            newSessionContext.setProxyUser(this.m_proxyUser);
            newSessionContext.setProxyPassword(this.m_proxyPassword);
            if (proxyAuthenticator != null) {
                newSessionContext.setProxyAuthenticator(proxyAuthenticator);
            }
        }
        catch (NoSuchAlgorithmException e) {
            LOCATION.catching(thisMethod, (Throwable)e);
            String m = "Setting authentication on session context failed." + e.getMessage();
            ChainedRuntimeException ex = new ChainedRuntimeException(m, (Throwable)e);
            LOCATION.throwing(thisMethod, (Throwable)ex);
            throw ex;
        }
        this.setKeyStores((ISessionContext)newSessionContext, password, clientCertKeyStore, serverCertKeyStore);
        newSessionContext.setSendCookies(oldcontext.getSendCookies());
        newSessionContext.setSendAuthentication(oldcontext.getSendAuthentication());
        this.m_httpConnectionTemplate.setSessionContext((ISessionContext)newSessionContext);
        this.m_httpClient = new HTTPClient((IConnectionTemplate)this.m_httpConnectionTemplate, this);
        if (this.m_soapPort != null) {
            this.m_soapPort._setProperty("javax.xml.rpc.security.auth.username", (Object)this.m_user);
            this.m_soapPort._setProperty("javax.xml.rpc.security.auth.password", (Object)this.m_password);
            this.m_soapPort._setProperty(PROXY_USER_PROPERTY, (Object)this.m_proxyUser);
            this.m_soapPort._setProperty(PROXY_PASSWORD_PROPERTY, (Object)proxyPassword);
            try {
                this.initializeSecurityProtocol(this.m_rawSoapPort, (IConnectionTemplate)this.m_httpConnectionTemplate);
            }
            catch (CommunicationException e1) {
                LOCATION.catching(thisMethod, (Throwable)e1);
                ChainedRuntimeException re = new ChainedRuntimeException(e1.getMessage(), (Throwable)e1);
                LOCATION.throwing(thisMethod, (Throwable)re);
                throw re;
            }
        }
    }

    public String getVersion() throws CommunicationException {
        try {
            return this._getVersion();
        }
        catch (AuthorizationException e) {
            throw new CommunicationException("Cannot get server version: " + e.getMessage(), e);
        }
    }

    public void ping(int maxRepeats, int connectTimeout, int readTimeout) throws CommunicationException, AuthorizationException {
        this.m_httpClient.ping(maxRepeats, connectTimeout, readTimeout);
    }

    public void ping(int maxRepeats, int millisToWaitForResponse) throws CommunicationException, AuthorizationException {
        this.m_httpClient.ping(maxRepeats, millisToWaitForResponse, millisToWaitForResponse);
    }

    public void ping() throws CommunicationException, AuthorizationException {
        String thisMethod = "ping()";
        try {
            LOCATION.debugT(thisMethod, "Calling soap method: ping");
            this.m_soapPort.ping();
        }
        catch (RemoteException e) {
            if (SoapUtils.isUnauthorized(e)) {
                String msg = "User not authorized to log into build server. ( " + e.getMessage() + " )";
                LOCATION.traceThrowableT(100, thisMethod, msg, (Throwable)e);
                throw new AuthorizationException(msg, null);
            }
            String msg = SoapUtils.getRemoteExceptionMessage(e);
            throw new CommunicationException(msg, e);
        }
    }

    private void initializeSOAP() throws CommunicationException {
        String thisMethod = "initializeSOAP()";
        CBSWebServiceImpl service = null;
        try {
            CBSWebServiceVI_Rpc rawSoapProxy;
            service = new CBSWebServiceImpl();
            this.m_rawSoapPort = rawSoapProxy = (CBSWebServiceVI_Rpc)service.getLogicalPort("CBSHttpSOAPPort_Rpc", class$com$sap$tc$cbs$wsproxy$CBSWebServiceVI_Rpc == null ? (class$com$sap$tc$cbs$wsproxy$CBSWebServiceVI_Rpc = BuildServer.class$("com.sap.tc.cbs.wsproxy.CBSWebServiceVI_Rpc")) : class$com$sap$tc$cbs$wsproxy$CBSWebServiceVI_Rpc);
            rawSoapProxy._setProperty("javax.xml.rpc.service.endpoint.address", (Object)this.m_soapServletURL);
            rawSoapProxy._setProperty("javax.xml.rpc.security.auth.username", (Object)this.m_user);
            rawSoapProxy._setProperty("javax.xml.rpc.security.auth.password", (Object)this.m_password);
            rawSoapProxy._setProperty(PROXY_USER_PROPERTY, (Object)this.m_proxyUser);
            rawSoapProxy._setProperty(PROXY_PASSWORD_PROPERTY, (Object)this.m_proxyPassword);
            String socketTimeoutAsString = Integer.toString(this.m_httpConnectionTemplate.getSocketReadTimeout());
            rawSoapProxy._setProperty("socketTimeout", (Object)socketTimeoutAsString);
            this.initializeSecurityProtocol(rawSoapProxy, (IConnectionTemplate)this.m_httpConnectionTemplate);
            if (this.m_httpConnectionTemplate.isUsingProxy()) {
                String proxy = this.m_httpConnectionTemplate.getProxyHost();
                int port = this.m_httpConnectionTemplate.getProxyPort();
                LOCATION.infoT(thisMethod, "setting HTTP proxy for  SOAP client: " + proxy + " port: " + Integer.toString(port));
                rawSoapProxy._setProperty(WS_PARAM_HTTP_PROXYHOST, (Object)proxy);
                rawSoapProxy._setProperty(WS_PARAM_HTTP_PROXYPORT, (Object)Integer.toString(port));
            }
            this.m_soapPort = (CBSWebServiceVI_Rpc)Proxy.newProxyInstance((class$com$sap$tc$cbs$wsproxy$CBSWebServiceVI_Rpc == null ? (class$com$sap$tc$cbs$wsproxy$CBSWebServiceVI_Rpc = BuildServer.class$("com.sap.tc.cbs.wsproxy.CBSWebServiceVI_Rpc")) : class$com$sap$tc$cbs$wsproxy$CBSWebServiceVI_Rpc).getClassLoader(), new Class[]{class$com$sap$tc$cbs$wsproxy$CBSWebServiceVI_Rpc == null ? (class$com$sap$tc$cbs$wsproxy$CBSWebServiceVI_Rpc = BuildServer.class$("com.sap.tc.cbs.wsproxy.CBSWebServiceVI_Rpc")) : class$com$sap$tc$cbs$wsproxy$CBSWebServiceVI_Rpc}, new InvocationHandler(){
                static /* synthetic */ Class class$com$sap$tc$cbs$wsproxy$CBSWebServiceVI_Rpc;

                public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                    Object result;
                    block10: {
                        result = null;
                        boolean debug = CBSFactory.SERVER_CALL_LOCATION.beDebug() || CBSFactory.SERVER_CALL_STACK_LOCATION.beDebug();
                        try {
                            if (method.getDeclaringClass() == (class$com$sap$tc$cbs$wsproxy$CBSWebServiceVI_Rpc == null ? (class$com$sap$tc$cbs$wsproxy$CBSWebServiceVI_Rpc = 1.class$("com.sap.tc.cbs.wsproxy.CBSWebServiceVI_Rpc")) : class$com$sap$tc$cbs$wsproxy$CBSWebServiceVI_Rpc) && debug) {
                                int count = CBSFactory.getIncrementedCount();
                                PrintStream out = CBSFactory.getServerCallLogOutput();
                                long startTime = System.currentTimeMillis();
                                result = method.invoke((Object)rawSoapProxy, args);
                                long duration = System.currentTimeMillis() - startTime;
                                if (CBSFactory.SERVER_CALL_LOCATION.beDebug()) {
                                    if (out != null) {
                                        Class clazz = class$com$sap$tc$cbs$wsproxy$CBSWebServiceVI_Rpc == null ? (class$com$sap$tc$cbs$wsproxy$CBSWebServiceVI_Rpc = 1.class$("com.sap.tc.cbs.wsproxy.CBSWebServiceVI_Rpc")) : class$com$sap$tc$cbs$wsproxy$CBSWebServiceVI_Rpc;
                                        synchronized (clazz) {
                                            out.print("CBS   Request#");
                                            out.print(count);
                                            out.print(" [");
                                            out.print(Thread.currentThread().getName());
                                            out.print("]:  WebServiceCall  ");
                                            out.print(method.getName());
                                            out.print(" (");
                                            out.print(duration);
                                            out.print(" ms)");
                                            out.println();
                                        }
                                    }
                                    CBSFactory.SERVER_CALL_LOCATION.debugT("CBS   Request#{0}:  WebServiceCall  {1} ({2} ms)", new Object[]{new Integer(count), method.getName(), new Long(duration)});
                                }
                                if (CBSFactory.SERVER_CALL_STACK_LOCATION.beDebug()) {
                                    DebugTrace dummyException = new DebugTrace("CBS Request Log");
                                    CBSFactory.SERVER_CALL_STACK_LOCATION.debugT(Util.printStackTraceToString((Throwable)dummyException));
                                }
                                break block10;
                            }
                            result = method.invoke((Object)rawSoapProxy, args);
                        }
                        catch (InvocationTargetException invocationTargetException) {
                            String thisMethod = "InvocationHandler.invoke()";
                            LOCATION.catching(thisMethod, (Throwable)invocationTargetException);
                            Throwable innerException = invocationTargetException.getTargetException();
                            if (innerException != null) {
                                throw innerException;
                            }
                            String m = "CBS web service inocation failed (InvocationTargetException with null target): " + invocationTargetException.getMessage();
                            ChainedRuntimeException runtimeEx = new ChainedRuntimeException(m, (Throwable)invocationTargetException);
                            LOCATION.infoT(thisMethod, m + " details: " + Util.printStackTraceToString((Throwable)invocationTargetException));
                            LOCATION.throwing(thisMethod, (Throwable)runtimeEx);
                            throw runtimeEx;
                        }
                    }
                    return result;
                }

                static /* synthetic */ Class class$(String x0) {
                    try {
                        return Class.forName(x0);
                    }
                    catch (ClassNotFoundException x1) {
                        throw new NoClassDefFoundError(x1.getMessage());
                    }
                }
            });
        }
        catch (Exception e) {
            String msg = "Cannot initilize SOAP layer: " + e.getMessage();
            throw new CommunicationException(msg, e);
        }
        if (this.m_soapPort == null) {
            String msg = "Cannot initialize SOAP layer: CbsreceiverServicePort is null";
            throw new CommunicationException(msg);
        }
        LOCATION.infoT(thisMethod, "created SOAP client for " + this.m_soapPort._getProperty("javax.xml.rpc.service.endpoint.address") + " with user: " + this.m_user);
    }

    public String getServerURL() {
        return this.m_httpConnectionTemplate.getProtocol() + "://" + this.m_httpConnectionTemplate.getHost() + ":" + this.m_httpConnectionTemplate.getPort();
    }

    public HTTPClient getHttpProxy() {
        return this.m_httpClient;
    }

    public CBSWebServiceVI_Rpc getSoapPort() {
        return this.m_soapPort;
    }

    private static String getSoapServlet() {
        if (soapservletName == null && (soapservletName = System.getProperty(SOAPSERVLET_PROPERTY)) == null) {
            soapservletName = SOAPSERVLET_DEFAULT;
        }
        return soapservletName;
    }

    public String getWebServiceUrl() {
        return this.m_soapServletURL;
    }

    public String getWebUIUrl() {
        return this.m_webUiURL;
    }

    public String getWebUIurlPath() {
        return null;
    }

    public void setWebUIurlPath(String path) {
        this.m_webUiPath = path;
        this.m_webUiURL = Util.concatenatePath((String)this.m_serverURL, (String)"webdynpro/dispatcher/sap.com/tc.CBS.WebUI/WebUI", (char)'/');
    }

    void setKeyStores(ISessionContext sessionContext, String clientKeyStorePassword, KeyStore clientKeyStore, KeyStore serverKeyStore) throws KeyStoreException {
        Certificates certs = sessionContext.certificates();
        if (serverKeyStore != null) {
            certs.setServerCertificates(serverKeyStore);
            certs.setAuthenticateThem(true);
        }
        if (clientKeyStore != null) {
            certs.setClientCertificates(clientKeyStore, clientKeyStorePassword);
            certs.setAuthenticateMe(true);
        }
    }

    public boolean supports(CBSFeature feature) throws AuthorizationException, CommunicationException {
        return this.getFeatureList().supports(feature);
    }

    public String _getVersion() throws CommunicationException, AuthorizationException {
        String methodString = "getServerVersion";
        if (this.m_serverVersion == null) {
            try {
                LOCATION.debugT(methodString, "Calling soap method: getVersion");
                this.m_serverVersion = this.m_soapPort.getVersion();
            }
            catch (IllegalArgumentException e) {
                LOCATION.catching(methodString, (Throwable)e);
                throw new CommunicationException("Initialization of CBS client failed. Could not read server version: " + e.getMessage(), e);
            }
            catch (RemoteException e) {
                if (SoapUtils.isUnauthorized(e)) {
                    LOCATION.traceThrowableT(100, methodString, "WebService call getVersion failed: Unauthorized: {}", (Throwable)e);
                    String msg = SoapUtils.getRemoteExceptionMessage(e);
                    throw new AuthorizationException(msg, null);
                }
                throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
            }
            LOCATION.debugT(methodString, "connected to build server. Server version is {0}", new Object[]{this.m_serverVersion});
        }
        return this.m_serverVersion;
    }

    private CBSFeatureList getFeatureList() throws AuthorizationException, CommunicationException {
        if (this.m_featurlist == null) {
            this.m_featurlist = new CBSFeatureList();
        }
        return this.m_featurlist;
    }

    private void initializeSecurityProtocol(CBSWebServiceVI_Rpc port, IConnectionTemplate connTemplate) throws CommunicationException {
        String thisMethod = "copyCertficatesToWebService";
        SecurityProtocol securityProtocol = (SecurityProtocol)((BaseGeneratedStub)port)._getGlobalProtocols().getProtocol("SecurityProtocol");
        ISessionContext session = connTemplate.getSessionContext();
        if (session != null) {
            List domainCookies;
            SSO2Authenticator auth;
            try {
                Certificates certs = session.certificates();
                KeyStore serverKs = certs.getServerCertificates();
                if (serverKs != null && (certs.authenticateThem() || certs.authenticateMe())) {
                    AuthenticationContext ctx = securityProtocol.getAuthenticationContext();
                    ctx.setIgnoreSSLServerCertificate(false);
                    Enumeration<String> iter = serverKs.aliases();
                    ArrayList<Certificate> serverCerts = new ArrayList<Certificate>();
                    while (iter.hasMoreElements()) {
                        String alias = iter.nextElement();
                        Certificate cert = serverKs.getCertificate(alias);
                        if (cert == null) continue;
                        serverCerts.add(cert);
                    }
                    ctx.setServerCertificateList(serverCerts);
                }
            }
            catch (KeyStoreException ex) {
                LOCATION.catching(thisMethod, (Throwable)ex);
                throw new CommunicationException("SSL setup for web service connection failed. Failed to copy certificates from connection template: " + ex.getMessage(), ex);
            }
            Cookies cookies = session.cookies();
            String domain = Cookie.getDomainOf((String)connTemplate.getHost());
            Cookie sso2Ticket = null;
            if (session.getAuthenticator() instanceof SSO2Authenticator && (auth = (SSO2Authenticator)session.getAuthenticator()).getTicket() != null) {
                sso2Ticket = new Cookie("MYSAPSSO2", auth.getTicket(), domain, "/");
                cookies.setCookie(sso2Ticket);
            }
            if ((domainCookies = cookies.getCookies(domain)).size() > 0) {
                String cookieHeader = this.applyCookies(domainCookies);
                securityProtocol.addHeader("Cookie", cookieHeader);
            }
        }
    }

    private String applyCookies(List cookies) {
        StringBuffer cookieHeader = new StringBuffer();
        int i = 0;
        while (i < cookies.size()) {
            Cookie cookie = (Cookie)cookies.get(i);
            if (i > 0) {
                cookieHeader.append(',');
            }
            cookieHeader.append(cookie.toString());
            ++i;
        }
        return cookieHeader.toString();
    }

    public IBuildSpace[] listBuildSpaces() throws CommunicationException, CBSServerException {
        GetBuildSpaceListResult result;
        String thisMethod = "listBuildSpaces()";
        if (!this.supports(CBSFeature.SUPPORTS_630_SP7_CHANGES)) {
            throw new UnsupportedOperationException("The CBS Server to which the client is connected does not support the required operation.");
        }
        try {
            LOCATION.infoT(thisMethod, "calling SOAP method: getBuildSpaces");
            result = this.m_soapPort.getBuildSpaces();
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        com.sap.tc.cbs.wsproxy.types.BuildSpace[] bsListResult = result.getBsList();
        IBuildSpace[] bsList = new IBuildSpace[bsListResult.length];
        int i = 0;
        while (i < bsListResult.length) {
            bsList[i] = new BuildSpace(bsListResult[i].getBsName(), this);
            ++i;
        }
        return bsList;
    }

    public String getProxyPassword() {
        return this.m_proxyPassword;
    }

    public String getProxyUser() {
        return this.m_proxyUser;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    public static class CBSVersion {
        public static final CBSVersion V1 = new CBSVersion("1");
        public static final CBSVersion V2 = new CBSVersion("2");
        public static final CBSVersion V3 = new CBSVersion("3");
        private final String m_name;

        String getVersion() {
            return this.m_name;
        }

        private CBSVersion(String s) {
            this.m_name = s;
        }
    }

    public static class CBSFeature {
        public static final CBSFeature SUPPORTS_CREATEBS_VIA_POST = new CBSFeature("SUPPORTS_CREATEBS_VIA_POST");
        public static final CBSFeature SUPPORTS_630_SP7_CHANGES = new CBSFeature("SUPPORTS_630_SP7_CHANGES");
        public static final CBSFeature SUPPORTS_LISTING_REQUEST_DCS = new CBSFeature("SUPPORTS_LISTING_REQUEST_DCS");
        public static final CBSFeature SUPPORTS_BUILD_KEYCOUNTER_ACCESS = new CBSFeature("SUPPORTS_BUILD_KEYCOUNTER_ACCESS");
        private final String m_name;

        private CBSFeature(String s) {
            this.m_name = s;
        }

        public String toString() {
            return this.m_name;
        }
    }

    private class CBSFeatureList {
        private HashSet m_supportedFeatures = new HashSet();
        private Map m_KnownFeatures = new HashMap();

        private CBSFeatureList() throws AuthorizationException, CommunicationException {
            this.m_KnownFeatures.put(CBSFeature.SUPPORTS_CREATEBS_VIA_POST, new CBSVersion[]{CBSVersion.V1});
            this.m_KnownFeatures.put(CBSFeature.SUPPORTS_630_SP7_CHANGES, new CBSVersion[]{CBSVersion.V2});
            this.m_KnownFeatures.put(CBSFeature.SUPPORTS_LISTING_REQUEST_DCS, new CBSVersion[]{CBSVersion.V3});
            this.m_KnownFeatures.put(CBSFeature.SUPPORTS_BUILD_KEYCOUNTER_ACCESS, new CBSVersion[]{CBSVersion.V3});
            String methodString = "CBSFeatureList";
            String serverVersion = BuildServer.this._getVersion().toLowerCase();
            if (serverVersion.startsWith("v")) {
                String version = serverVersion.substring(1);
                Iterator iter = this.m_KnownFeatures.keySet().iterator();
                block0: while (iter.hasNext()) {
                    CBSFeature feature = (CBSFeature)iter.next();
                    CBSVersion[] presentInVersion = (CBSVersion[])this.m_KnownFeatures.get(feature);
                    int i = 0;
                    while (i < presentInVersion.length) {
                        if (this.isVersionPredessesor(presentInVersion[i].getVersion(), version)) {
                            this.m_supportedFeatures.add(feature);
                            LOCATION.debugT(methodString, "Server supports feature : {0}", new Object[]{feature});
                            continue block0;
                        }
                        ++i;
                    }
                }
            }
        }

        private boolean isVersionPredessesor(String checkVersion, String version) {
            int[] versionSegments;
            if (checkVersion.equalsIgnoreCase(version)) {
                return true;
            }
            int[] checkVersionSegments = this.getVersionNumSegments(checkVersion);
            if (checkVersionSegments.length > (versionSegments = this.getVersionNumSegments(version)).length) {
                return false;
            }
            if (checkVersionSegments.length == 1) {
                return checkVersionSegments[0] <= versionSegments[0];
            }
            return version.startsWith(this.getBranchPath(checkVersion)) && checkVersionSegments[checkVersionSegments.length - 1] <= versionSegments[checkVersionSegments.length - 1];
        }

        private int[] getVersionNumSegments(String version) {
            int index = -1;
            ArrayList<String> listOfSegments = new ArrayList<String>();
            while ((index = version.indexOf(46)) != -1) {
                listOfSegments.add(version.substring(0, index));
                version = version.substring(index + 1);
            }
            if (version.length() != 0) {
                listOfSegments.add(version);
            }
            int[] segments = new int[listOfSegments.size()];
            int i = 0;
            while (i < listOfSegments.size()) {
                segments[i] = Integer.parseInt((String)listOfSegments.get(i));
                ++i;
            }
            return segments;
        }

        private String getBranchPath(String checkVersion) {
            int lastIndexOfDot = checkVersion.lastIndexOf(46);
            if (lastIndexOfDot == -1) {
                return "";
            }
            return checkVersion.substring(0, lastIndexOfDot);
        }

        public boolean supports(CBSFeature feature) {
            return this.m_supportedFeatures.contains(feature);
        }
    }
}

