/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbs.client.impl;

import com.sap.tc.cbs.client.BuildRequestStatus;
import com.sap.tc.cbs.client.IActivitySet;
import com.sap.tc.cbs.client.IArchiveResult;
import com.sap.tc.cbs.client.IBuildRequest;
import com.sap.tc.cbs.client.IBuildResult;
import com.sap.tc.cbs.client.IBuildSpace;
import com.sap.tc.cbs.client.IDC;
import com.sap.tc.cbs.client.error.CBSError;
import com.sap.tc.cbs.client.error.CBSServerException;
import com.sap.tc.cbs.client.error.CommunicationException;
import com.sap.tc.cbs.client.error.ErrorMapper;
import com.sap.tc.cbs.client.impl.ActivitySet;
import com.sap.tc.cbs.client.impl.BuildResult;
import com.sap.tc.cbs.client.impl.BuildServer;
import com.sap.tc.cbs.client.impl.BuildSpace;
import com.sap.tc.cbs.client.impl.DC;
import com.sap.tc.cbs.client.impl.SoapUtils;
import com.sap.tc.cbs.common.types.LogURLCalculator;
import com.sap.tc.cbs.common.types.RequestStateCodes;
import com.sap.tc.cbs.util.Util;
import com.sap.tc.cbs.wsproxy.CBSWebServiceVI_Rpc;
import com.sap.tc.cbs.wsproxy.types.ActionResult;
import com.sap.tc.cbs.wsproxy.types.ActivitySetResult;
import com.sap.tc.cbs.wsproxy.types.GetDCListResult;
import com.sap.tc.cbs.wsproxy.types.GetRequestListResult;
import com.sap.tc.cbs.wsproxy.types.GetShortValueResult;
import com.sap.tc.logging.Location;
import java.io.OutputStream;
import java.rmi.RemoteException;
import java.util.ArrayList;

class BuildRequest
implements IBuildRequest {
    private static final Location LOCATION = Location.getLocation((Class)(class$com$sap$tc$cbs$client$impl$BuildRequest == null ? (class$com$sap$tc$cbs$client$impl$BuildRequest = BuildRequest.class$("com.sap.tc.cbs.client.impl.BuildRequest")) : class$com$sap$tc$cbs$client$impl$BuildRequest));
    protected long m_requestID;
    protected CBSWebServiceVI_Rpc m_soapPort;
    protected BuildSpace m_bsProxy;
    static /* synthetic */ Class class$com$sap$tc$cbs$client$impl$BuildRequest;

    public BuildRequest(long requestID, BuildSpace bsProxy) {
        this.m_requestID = requestID;
        this.m_bsProxy = bsProxy;
        this.m_soapPort = bsProxy.getCbsProxy().getSoapPort();
    }

    public long getRequestID() {
        return this.m_requestID;
    }

    public void confirm() throws CommunicationException, CBSServerException {
        ActionResult result;
        String thisMethod = "confirmResultsFetched()";
        LOCATION.infoT(thisMethod, "parameters: \n  build space: " + this.m_bsProxy.getName() + " request: " + this.m_requestID);
        try {
            LOCATION.debugT(thisMethod, "calling SOAP method: confirmResultsFetched");
            result = this.m_soapPort.confirmResultsFetched(this.m_bsProxy.getName(), this.m_requestID);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
    }

    public void cancel() throws CommunicationException, CBSServerException {
        ActionResult result;
        String thisMethod = "cancel()";
        LOCATION.infoT(thisMethod, "parameters: \n  build space: " + this.m_bsProxy.getName() + " request: " + this.m_requestID);
        try {
            LOCATION.debugT(thisMethod, "calling SOAP method: cancel");
            result = this.m_soapPort.cancelRequest(this.m_bsProxy.getName(), this.m_requestID);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
    }

    public void resume() throws CBSServerException, CommunicationException {
        ActionResult result;
        String thisMethod = "resume()";
        LOCATION.infoT(thisMethod, "parameters: \n  build space: " + this.m_bsProxy.getName() + " request: " + this.m_requestID);
        try {
            LOCATION.debugT(thisMethod, "calling SOAP method: resume");
            result = this.m_soapPort.resumeRequest(this.m_bsProxy.getName(), this.m_requestID);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
    }

    public void suspend() throws CommunicationException, CBSServerException {
        ActionResult result;
        String thisMethod = "suspend()";
        LOCATION.infoT(thisMethod, "parameters: \n  build space: " + this.m_bsProxy.getName() + " request: " + this.m_requestID);
        try {
            LOCATION.debugT(thisMethod, "calling SOAP method: suspend");
            result = this.m_soapPort.suspendRequest(this.m_bsProxy.getName(), this.m_requestID);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
    }

    public BuildRequestStatus getStatus() throws CommunicationException, CBSServerException {
        BuildRequestStatus status;
        GetShortValueResult result;
        String thisMethod = "getRequestStatus()";
        LOCATION.infoT(thisMethod, "parameters: \n  build space: " + this.m_bsProxy.getName() + " request: " + this.m_requestID);
        try {
            LOCATION.debugT(thisMethod, "calling SOAP method: getStatus");
            result = this.m_soapPort.getRequestStatus(this.m_bsProxy.getName(), this.m_requestID);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        try {
            status = BuildRequestStatus.fromRequestStateCodes(RequestStateCodes.fromShort((short)result.getValue()));
        }
        catch (IllegalArgumentException e) {
            String message = "Invalid status value received";
            LOCATION.infoT(thisMethod, message + Util.printStackTraceToString((Throwable)e));
            throw new CommunicationException(message + result.getValue());
        }
        return status;
    }

    public IBuildResult getResult(boolean deployableOnly) throws CommunicationException, CBSServerException {
        com.sap.tc.cbs.wsproxy.types.BuildResult result;
        String thisMethod = "getResult(boolean,String[])";
        LOCATION.infoT(thisMethod, "parameters: \n  build space: " + this.m_bsProxy.getName() + " request: " + this.m_requestID + " deplyable only" + deployableOnly);
        try {
            LOCATION.debugT(thisMethod, "calling SOAP method: getResult");
            result = this.m_soapPort.getBuildResultInfo(this.m_bsProxy.getName(), this.m_requestID, deployableOnly);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        BuildResult buildResult = new BuildResult(result, this, this.m_bsProxy.getCbsProxy().getServerURL());
        return buildResult;
    }

    public IBuildSpace getBuildSpace() {
        return this.m_bsProxy;
    }

    public IActivitySet[] getRequestActivities() throws CommunicationException, CBSServerException {
        ActivitySetResult result;
        String thisMethod = "getRequestActivities()";
        LOCATION.infoT(thisMethod, "parameters: \n  build space: " + this.m_bsProxy.getName() + " request: " + this.m_requestID);
        try {
            LOCATION.debugT(thisMethod, "calling SOAP method: getRequestActivities");
            result = this.m_soapPort.getRequestActivities(this.m_bsProxy.getName(), this.m_requestID);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        ArrayList<ActivitySet> requestActivities = new ArrayList<ActivitySet>();
        com.sap.tc.cbs.wsproxy.types.ActivitySet[] acts = result.getActivities();
        if (acts != null) {
            int i = 0;
            while (i < acts.length) {
                ActivitySet act = new ActivitySet(acts[i]);
                requestActivities.add(act);
                ++i;
            }
        }
        return requestActivities.toArray(new IActivitySet[requestActivities.size()]);
    }

    public String[] getActivities(String compartment, String dcVendor, String dcName) throws CommunicationException, CBSServerException {
        System.out.println("Not yet implemented: getActivities");
        return new String[0];
    }

    public long[] listFollowUpRequests() throws CommunicationException, CBSServerException {
        GetRequestListResult result;
        String thisMethod = "listFollowUpRequests()";
        try {
            result = this.m_soapPort.getFollowUpRequests(this.m_bsProxy.getName(), this.m_requestID);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        long[] resArray = result.getList();
        if (resArray == null) {
            resArray = new long[]{};
        }
        return resArray;
    }

    public IArchiveResult getRequestLogArchive(OutputStream archiveStream) throws CommunicationException, CBSServerException {
        return this.m_bsProxy.getRequestLogArchive(this.m_requestID, archiveStream);
    }

    public String getRequestLogURL() {
        String requestLogURL = this.m_bsProxy.getCbsProxy().getServerURL() + LogURLCalculator.getRequestLogPrefix() + LogURLCalculator.getBuildspaceParam((String)this.getBuildSpace().getName()) + LogURLCalculator.getRequestIDParam((long)this.getRequestID());
        return requestLogURL;
    }

    public IDC[] listRequestDCs(String[] compartments) throws CommunicationException, CBSServerException {
        GetDCListResult result;
        String thisMethod = "listRequestDCs(String[] compartments)";
        if (!((BuildServer)this.m_bsProxy.getBuildServer()).supports(BuildServer.CBSFeature.SUPPORTS_LISTING_REQUEST_DCS)) {
            throw new UnsupportedOperationException("The CBS Server to which the client is connected does not support the required operation.");
        }
        try {
            if (compartments == null) {
                compartments = new String[]{};
            }
            result = this.m_soapPort.getRequestDCs(this.m_bsProxy.getName(), this.m_requestID, compartments);
        }
        catch (RemoteException e) {
            throw new CommunicationException(SoapUtils.getRemoteExceptionMessage(e), e);
        }
        if (!result.getSucceed()) {
            throw ErrorMapper.throwError(LOCATION, thisMethod, new CBSError(result.getErrorCode(), result.getTrace()));
        }
        return DC.getDCArrayFromProxyArray(result.getDcList());
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

