/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbs.client.impl;

import com.sap.tc.cbs.client.IBuildDCResult;
import com.sap.tc.cbs.client.IBuildVariantResult;
import com.sap.tc.cbs.client.impl.BuildVariantResult;
import com.sap.tc.cbs.client.impl.DC;
import com.sap.tc.cbs.common.types.LogURLCalculator;

public class BuildDCResult
extends DC
implements IBuildDCResult {
    private boolean deleted;
    private BuildVariantResult[] variants;

    public BuildDCResult(com.sap.tc.cbs.wsproxy.types.BuildDCResult soapDCBuildResult, String logURLPrefix) {
        super(soapDCBuildResult.getVendor(), soapDCBuildResult.getName(), soapDCBuildResult.getCompName());
        logURLPrefix = logURLPrefix + LogURLCalculator.getCompartmentName((String)this.compartment) + LogURLCalculator.getDCVendorName((String)this.vendor, (String)this.name);
        com.sap.tc.cbs.wsproxy.types.BuildVariantResult[] variantArray = soapDCBuildResult.getVariants();
        if (variantArray != null && variantArray != null) {
            int variantCount = variantArray.length;
            this.variants = new BuildVariantResult[variantCount];
            int i = 0;
            while (i < variantCount) {
                this.variants[i] = new BuildVariantResult(variantArray[i], logURLPrefix);
                ++i;
            }
        }
        if (this.variants == null) {
            this.variants = new BuildVariantResult[0];
        }
    }

    public boolean isDeleted() {
        return this.deleted;
    }

    public IBuildVariantResult[] getVariantResults() {
        return this.variants;
    }

    public void setDeleted(boolean deleted) {
        this.deleted = deleted;
    }

    public void setVariants(BuildVariantResult[] variants) {
        this.variants = variants;
    }
}

