/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbs.client.error;

import com.sap.tc.cbs.client.error.ArchiveException;
import com.sap.tc.cbs.client.error.AuthorizationException;
import com.sap.tc.cbs.client.error.BuildSpaceExistingException;
import com.sap.tc.cbs.client.error.BuildSpaceNotStoppedException;
import com.sap.tc.cbs.client.error.BuildSpaceOwnershipException;
import com.sap.tc.cbs.client.error.CBSError;
import com.sap.tc.cbs.client.error.CBSIllegalArgumentException;
import com.sap.tc.cbs.client.error.CBSServerException;
import com.sap.tc.cbs.client.error.CBSServerSideCommunicationException;
import com.sap.tc.cbs.client.error.CommunicationException;
import com.sap.tc.cbs.client.error.CompartmentNoArchiveStateException;
import com.sap.tc.cbs.client.error.CompartmentNoSourceStateException;
import com.sap.tc.cbs.client.error.CompartmentNotInInitializedStateException;
import com.sap.tc.cbs.client.error.ComponentNotInInitializedStateException;
import com.sap.tc.cbs.client.error.ConfigurationInvalidException;
import com.sap.tc.cbs.client.error.ConfigurationUpdateException;
import com.sap.tc.cbs.client.error.DCDependencyException;
import com.sap.tc.cbs.client.error.DCInconsistentException;
import com.sap.tc.cbs.client.error.DCNoArchiveStateException;
import com.sap.tc.cbs.client.error.DCNoSoureStateException;
import com.sap.tc.cbs.client.error.DuplicateDCException;
import com.sap.tc.cbs.client.error.DuplicateDCInImportException;
import com.sap.tc.cbs.client.error.InputDisabledException;
import com.sap.tc.cbs.client.error.InternalServerException;
import com.sap.tc.cbs.client.error.InvalidActivityException;
import com.sap.tc.cbs.client.error.NotInResultQueueException;
import com.sap.tc.cbs.client.error.OutputLockedException;
import com.sap.tc.cbs.client.error.RequestStatusException;
import com.sap.tc.cbs.client.error.SCDependencyException;
import com.sap.tc.cbs.client.error.UnknownActivityException;
import com.sap.tc.cbs.client.error.UnknownBuildSpaceException;
import com.sap.tc.cbs.client.error.UnknownCompartmentException;
import com.sap.tc.cbs.client.error.UnknownDCException;
import com.sap.tc.cbs.client.error.UnknownPublicPartException;
import com.sap.tc.cbs.client.error.UnknownRequestException;
import com.sap.tc.cbs.client.error.UnknownVariantException;
import com.sap.tc.cbs.client.error.UnresolvedSCAliasException;
import com.sap.tc.cbs.client.error.VariantMappingException;
import com.sap.tc.cbs.common.types.ErrorStrings;
import com.sap.tc.logging.Location;

public class ErrorMapper {
    private static final String COMMUNICATION_ERROR_SERVER = "COMMUNICATION_ERROR_SERVER";

    public static CBSServerException throwError(Location location, String caller, CBSError errorObject) throws CBSServerException, CommunicationException {
        String error = errorObject.getCode();
        String message = "CBS Server Error: " + ErrorStrings.get((String)error);
        String serverTrace = errorObject.getTrace();
        if (message == null || message.length() == 0) {
            message = "Received Error: " + error + "(no description available)";
        }
        if (serverTrace == null) {
            location.infoT(caller, message);
        } else {
            location.infoT(caller, message + "\nServer trace: \n" + serverTrace);
        }
        if (error.equals("BS_UNKNOWN")) {
            UnknownBuildSpaceException exception = new UnknownBuildSpaceException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("DUPLICATE_DC_IN_IMPORT_REQUEST")) {
            DuplicateDCInImportException exception = new DuplicateDCInImportException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("BS_ALREADY_EXISTED")) {
            BuildSpaceExistingException exception = new BuildSpaceExistingException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("COMP_UNKNOWN")) {
            UnknownCompartmentException exception = new UnknownCompartmentException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("BS_SC_META_DATA_NOT_AVAILABLE")) {
            CompartmentNotInInitializedStateException exception = new CompartmentNotInInitializedStateException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("BS_OUTPUT_LOCKED")) {
            OutputLockedException exception = new OutputLockedException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("INTERNAL_SERVER_ERROR")) {
            InternalServerException exception = new InternalServerException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("USR_MISSING_PRIVILEGE")) {
            AuthorizationException exception = new AuthorizationException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("SERVER_LOGIN_FAIL")) {
            AuthorizationException exception = new AuthorizationException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("DC_UNKNOWN")) {
            UnknownDCException exception = new UnknownDCException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("DC_INCONSISTENT")) {
            DCInconsistentException exception = new DCInconsistentException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("VRNT_UNKNOWN")) {
            UnknownVariantException exception = new UnknownVariantException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("REQ_NOT_IN_RESULT_Q")) {
            NotInResultQueueException exception = new NotInResultQueueException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("ACTV_UNKNOWN")) {
            UnknownActivityException exception = new UnknownActivityException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("ACTV_INPUT_DISABLED")) {
            InputDisabledException exception = new InputDisabledException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("ACTV_ALREADY_ACTTIVATED")) {
            InvalidActivityException exception = new InvalidActivityException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("ACTV_INVALID")) {
            InvalidActivityException exception = new InvalidActivityException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("BS_ALREADY_EXISTED")) {
            BuildSpaceExistingException exception = new BuildSpaceExistingException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("BS_NOT_IN_STOP_MODE")) {
            BuildSpaceNotStoppedException exception = new BuildSpaceNotStoppedException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("BS_UPDATE_IMPOSSIBLE")) {
            ConfigurationUpdateException exception = new ConfigurationUpdateException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("BS_UNSOLVED_SC_ALIASES")) {
            UnresolvedSCAliasException exception = new UnresolvedSCAliasException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("BS_BUILD_VARIANT_MAPPING_MISSING")) {
            VariantMappingException exception = new VariantMappingException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("BS_UNSOLVED_SC_DEPENDENCIES")) {
            SCDependencyException exception = new SCDependencyException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("BS_UNSOLVED_DC_DEPENDENCIES")) {
            DCDependencyException exception = new DCDependencyException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("BS_OUTPUT_LOCKED")) {
            OutputLockedException exception = new OutputLockedException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("CFG_UNKNOWN")) {
            UnknownBuildSpaceException exception = new UnknownBuildSpaceException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("CFG_VALIDATION_ERROR")) {
            ConfigurationInvalidException exception = new ConfigurationInvalidException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("COMP_ARCHIVE_ONLY_STATE")) {
            CompartmentNoSourceStateException exception = new CompartmentNoSourceStateException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("COMP_NO_ARCHIVE_STATE")) {
            CompartmentNoArchiveStateException exception = new CompartmentNoArchiveStateException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("DC_IN_ARCHIVE_STATE")) {
            DCNoSoureStateException exception = new DCNoSoureStateException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("DC_IN_TWO_SC_NOT_ALLOWED")) {
            DuplicateDCException exception = new DuplicateDCException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("DC_DIRTY")) {
            ComponentNotInInitializedStateException exception = new ComponentNotInInitializedStateException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("DC_BROKEN")) {
            DCInconsistentException exception = new DCInconsistentException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("DC_NO_ARCHIVE_STATE")) {
            DCNoArchiveStateException exception = new DCNoArchiveStateException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("DC_WITHOUT_DCA")) {
            DCNoArchiveStateException exception = new DCNoArchiveStateException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("PP_UNKNOWN")) {
            UnknownPublicPartException exception = new UnknownPublicPartException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("REQ_UNKNOWN")) {
            UnknownRequestException exception = new UnknownRequestException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("REQ_EMPTY")) {
            RequestStatusException exception = new RequestStatusException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("REQ_QUEUE_DISABLED")) {
            InputDisabledException exception = new InputDisabledException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("REQ_INVALID_STATE")) {
            RequestStatusException exception = new RequestStatusException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("ALIAS_UNKNOWN")) {
            UnresolvedSCAliasException exception = new UnresolvedSCAliasException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("MODE_INVALID")) {
            CBSIllegalArgumentException exception = new CBSIllegalArgumentException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("INVALID_PARAMETER")) {
            throw new CBSIllegalArgumentException(message, error);
        }
        if (error.equals("ACTV_CHECK_FAILED")) {
            CBSIllegalArgumentException exception = new CBSIllegalArgumentException("Activation error caught in generic handler (should not happen):" + message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("UNSUPPORTED_METHOD")) {
            throw new CommunicationException(message + "( Error Code: " + error + ")");
        }
        if (error.equals("COMMUNICATION_ERROR")) {
            message = "CBS Server Error: " + ErrorStrings.get((String)COMMUNICATION_ERROR_SERVER);
            CBSServerSideCommunicationException exception = new CBSServerSideCommunicationException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("BS_NOT_OWNED_WORKSPACE")) {
            BuildSpaceOwnershipException exception = new BuildSpaceOwnershipException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("ARCHIVE_INVALID_CONTENT")) {
            ArchiveException exception = new ArchiveException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        if (error.equals("ARCHIVE_TYPE_UNKNOWN")) {
            ArchiveException exception = new ArchiveException(message, error);
            exception.setServerTrace(serverTrace);
            throw exception;
        }
        message = "Received unknown CBS code: " + error + " Server Trace: " + serverTrace;
        location.infoT(caller, message);
        throw new CommunicationException(message);
    }
}

