/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.cbs.client;

import com.sap.tc.cbs.common.types.RequestStateCodes;
import java.util.HashMap;
import java.util.Map;

public class BuildRequestStatus {
    public static final BuildRequestStatus NEW = new BuildRequestStatus(RequestStateCodes.NEW);
    public static final BuildRequestStatus PENDING = new BuildRequestStatus(RequestStateCodes.PENDING);
    public static final BuildRequestStatus SUSPENDED = new BuildRequestStatus(RequestStateCodes.SUSPENDED);
    public static final BuildRequestStatus WAITING = new BuildRequestStatus(RequestStateCodes.WAITING);
    public static final BuildRequestStatus ABORTED = new BuildRequestStatus(RequestStateCodes.ABORTED);
    public static final BuildRequestStatus QUEUED = new BuildRequestStatus(RequestStateCodes.QUEUED);
    public static final BuildRequestStatus PROCESSING = new BuildRequestStatus(RequestStateCodes.PROCESSING);
    public static final BuildRequestStatus SUCCEEDED = new BuildRequestStatus(RequestStateCodes.SUCCEEDED);
    public static final BuildRequestStatus FAILED = new BuildRequestStatus(RequestStateCodes.FAILED);
    public static final BuildRequestStatus CANCELLED = new BuildRequestStatus(RequestStateCodes.CANCELED);
    public static final BuildRequestStatus INVALID = new BuildRequestStatus(RequestStateCodes.INVALID);
    private static Map g_instances = new HashMap();
    private RequestStateCodes m_code;

    private BuildRequestStatus() {
    }

    public static BuildRequestStatus fromRequestStateCodes(RequestStateCodes code) {
        BuildRequestStatus s = (BuildRequestStatus)g_instances.get(code);
        if (s == null) {
            throw new IllegalStateException("Internal Error: unknown RequestStateCodes value: " + code);
        }
        return s;
    }

    public boolean isTransientState() {
        return this != SUCCEEDED && this != FAILED && this != CANCELLED && this != INVALID && this != SUSPENDED;
    }

    public String toString() {
        return this.m_code.toString();
    }

    private BuildRequestStatus(RequestStateCodes code) {
        this.m_code = code;
    }

    static {
        g_instances.put(BuildRequestStatus.NEW.m_code, NEW);
        g_instances.put(BuildRequestStatus.PENDING.m_code, PENDING);
        g_instances.put(BuildRequestStatus.SUSPENDED.m_code, SUSPENDED);
        g_instances.put(BuildRequestStatus.WAITING.m_code, WAITING);
        g_instances.put(BuildRequestStatus.ABORTED.m_code, ABORTED);
        g_instances.put(BuildRequestStatus.QUEUED.m_code, QUEUED);
        g_instances.put(BuildRequestStatus.PROCESSING.m_code, PROCESSING);
        g_instances.put(BuildRequestStatus.SUCCEEDED.m_code, SUCCEEDED);
        g_instances.put(BuildRequestStatus.FAILED.m_code, FAILED);
        g_instances.put(BuildRequestStatus.CANCELLED.m_code, CANCELLED);
        g_instances.put(BuildRequestStatus.INVALID.m_code, INVALID);
    }
}

