/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.util0;

import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import java.io.ByteArrayOutputStream;
import java.io.PrintWriter;
import java.io.StringWriter;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Element;

public class LogUtil {
    public static final String EXPLANATION_FINALLY_EXCEPTION = "An exception was thrown in the FINALLY clause of the method. The original return value of the method was not changed because this exception did not affect the task of the method itself, but only a cleanup task afterwards. However, any following exceptions might be related to this exception.";
    static /* synthetic */ Class class$com$sap$security$core$server$util0$LogUtil;

    public static void exitMethodWithException(Location location, String method, Throwable throwable) {
        location.throwing(method, throwable);
    }

    public static void exceptionAudit(int severity, Location location, String sublocation, String explanationText, Throwable throwable) {
        if (explanationText == null) {
            Category.SYS_SERVER.logThrowableT(severity, location, sublocation, "Exception audit", throwable);
        } else {
            Category.SYS_SERVER.logThrowableT(severity, location, sublocation, "Exception audit: " + explanationText, throwable);
        }
    }

    public static String getStackTrace(Throwable throwable) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        throwable.printStackTrace(printWriter);
        return stringWriter.toString();
    }

    public static String makeXMLcompatible(String in) {
        String[] fromList = new String[]{"&", "<", ">", "'", "\""};
        String[] toList = new String[]{"&amp;", "&lt;", "&gt;", "&apos;", "&quot;"};
        if (in == null) {
            return null;
        }
        String currentString = in;
        int i = 0;
        while (i < fromList.length) {
            int pos;
            int start = 0;
            while ((pos = currentString.indexOf(fromList[i], start)) != -1) {
                StringBuffer buf = new StringBuffer(currentString);
                buf.replace(pos, pos + fromList[i].length(), toList[i]);
                currentString = buf.toString();
                start = pos + 1;
            }
            ++i;
        }
        return currentString;
    }

    public static String hexDump(byte[] in) {
        int ADDRESS_LENGTH = 8;
        int HEX_LENGTH = 52;
        int CHAR_LENGTH = 16;
        StringBuffer out = new StringBuffer();
        out.append("\n");
        out.append("Hexdump of " + in.length + " bytes\n");
        int offset = 0;
        StringBuffer address = new StringBuffer();
        address.setLength(8);
        StringBuffer hexLine = new StringBuffer();
        hexLine.setLength(52);
        StringBuffer charLine = new StringBuffer();
        charLine.setLength(16);
        int position = 0;
        while (position < in.length) {
            String byteAsHex;
            int byteAsInt;
            if (position % 16 == 0) {
                int i = 0;
                while (i < 8) {
                    address.setCharAt(i, '0');
                    ++i;
                }
                String posAsHex = Integer.toHexString(position);
                address.replace(8 - posAsHex.length(), 8, posAsHex);
                int i2 = 0;
                while (i2 < 52) {
                    hexLine.setCharAt(i2, ' ');
                    ++i2;
                }
                int i3 = 0;
                while (i3 < 16) {
                    charLine.setCharAt(i3, ' ');
                    ++i3;
                }
            }
            if ((byteAsInt = in[position]) < 0) {
                byteAsInt += 256;
            }
            if ((byteAsHex = Integer.toHexString(byteAsInt)).length() == 1) {
                byteAsHex = "0" + byteAsHex;
            }
            int startPos = 3 * offset;
            hexLine.replace(startPos += offset / 4, startPos + 2, byteAsHex);
            charLine.setCharAt(offset, byteAsInt >= 32 && byteAsInt <= 127 ? (char)byteAsInt : (char)'.');
            if (++offset == 16) {
                out.append((Object)address);
                out.append(": ");
                out.append((Object)hexLine);
                out.append("  ");
                out.append((Object)charLine);
                out.append("\n");
                offset = 0;
            }
            ++position;
        }
        if (offset != 0) {
            out.append((Object)address);
            out.append(": ");
            out.append((Object)hexLine);
            out.append("  ");
            out.append((Object)charLine);
            out.append("\n");
        }
        return out.toString();
    }

    public static String dumpXML(Element element) {
        try {
            Transformer tr;
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            StreamResult streamResult = new StreamResult(outputStream);
            DOMSource source = new DOMSource(element);
            ClassLoader oldContextClassLoader = Thread.currentThread().getContextClassLoader();
            try {
                Thread.currentThread().setContextClassLoader((class$com$sap$security$core$server$util0$LogUtil == null ? (class$com$sap$security$core$server$util0$LogUtil = LogUtil.class$("com.sap.security.core.server.util0.LogUtil")) : class$com$sap$security$core$server$util0$LogUtil).getClassLoader());
                tr = TransformerFactory.newInstance().newTransformer();
                Object var7_7 = null;
                Thread.currentThread().setContextClassLoader(oldContextClassLoader);
            }
            catch (Throwable throwable) {
                Object var7_8 = null;
                Thread.currentThread().setContextClassLoader(oldContextClassLoader);
                throw throwable;
            }
            tr.setOutputProperty("method", "xml");
            tr.setOutputProperty("omit-xml-declaration", "no");
            tr.setOutputProperty("standalone", "yes");
            tr.setOutputProperty("indent", "yes");
            tr.setOutputProperty("encoding", "UTF-8");
            tr.transform(source, streamResult);
            outputStream.close();
            byte[] outputBytes = outputStream.toByteArray();
            String result = new String(outputBytes, "UTF-8");
            return result;
        }
        catch (Exception t) {
            return "ERROR: XML node cannot be rendered into readable text: \"" + t.getMessage() + "\"";
        }
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

