/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.util0;

import java.io.Serializable;
import java.util.NoSuchElementException;

public class LinkedListDirectAccess
implements Serializable {
    static final long serialVersionUID = 2865946081260000955L;
    private Entry header = new Entry(null, null, null);
    private int size = 0;

    public LinkedListDirectAccess() {
        this.header.next = this.header.previous = this.header;
    }

    public Entry addFirst(Object o) {
        return this.addBefore(o, this.header.next, null);
    }

    public Object getLast() {
        if (this.size == 0) {
            throw new NoSuchElementException();
        }
        return this.header.previous.element;
    }

    public Object removeLast() {
        Object last = this.header.previous.element;
        this.remove(this.header.previous);
        return last;
    }

    public void moveToFront(Entry e) {
        this.remove(e);
        this.addBefore(e.element, this.header.next, e);
    }

    public void clear() {
        this.header.next = this.header.previous = this.header;
        this.size = 0;
    }

    public void remove(Entry e) {
        if (e == this.header) {
            throw new NoSuchElementException();
        }
        e.previous.next = e.next;
        e.next.previous = e.previous;
        --this.size;
    }

    private Entry addBefore(Object o, Entry e, Entry useThisEntry) {
        Entry newEntry;
        if (useThisEntry == null) {
            newEntry = new Entry(o, e, e.previous);
        } else {
            newEntry = useThisEntry;
            newEntry.element = o;
            newEntry.next = e;
            newEntry.previous = e.previous;
        }
        newEntry.previous.next = newEntry;
        newEntry.next.previous = newEntry;
        ++this.size;
        return newEntry;
    }

    public boolean isEmpty() {
        return this.size == 0;
    }

    public static class Entry
    implements Serializable {
        static final long serialVersionUID = -35557836220565307L;
        public Object element;
        public Entry next;
        public Entry previous;

        Entry(Object element, Entry next, Entry previous) {
            this.element = element;
            this.next = next;
            this.previous = previous;
        }
    }
}

