/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.util0;

import com.sap.security.core.server.util0.LinkedListDirectAccess;
import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public class LRUHashMap
extends HashMap {
    static final long serialVersionUID = 6557518079681878977L;
    private final int _maxSize;
    private LinkedListDirectAccess _LRUList;
    private String _unsupportedText = "This method is not implemented in class " + (class$com$sap$security$core$server$util0$LRUHashMap == null ? (class$com$sap$security$core$server$util0$LRUHashMap = LRUHashMap.class$("com.sap.security.core.server.util0.LRUHashMap")) : class$com$sap$security$core$server$util0$LRUHashMap).getName();
    static /* synthetic */ Class class$com$sap$security$core$server$util0$LRUHashMap;

    public LRUHashMap(int maxSize) {
        this._maxSize = maxSize;
        this._LRUList = new LinkedListDirectAccess();
    }

    public synchronized void xclear() {
        super.clear();
        this._LRUList.clear();
    }

    public void clear() {
        super.clear();
        this._LRUList.clear();
    }

    public Object get(Object key) {
        LRUMapEntry mapEntry = (LRUMapEntry)super.get(key);
        if (mapEntry == null) {
            return null;
        }
        LRUHashMap lRUHashMap = this;
        synchronized (lRUHashMap) {
            this._LRUList.moveToFront(mapEntry.LRUEntry);
        }
        return mapEntry.value;
    }

    public synchronized Object put(Object key, Object value) {
        if (super.containsKey(key)) {
            LRUMapEntry mapEntry = (LRUMapEntry)super.get(key);
            mapEntry.value = value;
            this._LRUList.moveToFront(mapEntry.LRUEntry);
            LRUMapEntry oldEntry = super.put(key, mapEntry);
            return oldEntry == null ? null : oldEntry.value;
        }
        if (super.size() == this._maxSize) {
            Object lastKey = this._LRUList.removeLast();
            super.remove(lastKey);
        }
        LRUMapEntry newEntry = new LRUMapEntry();
        newEntry.value = value;
        newEntry.LRUEntry = this._LRUList.addFirst(key);
        super.put(key, newEntry);
        return null;
    }

    public Object remove(Object key) {
        if (super.containsKey(key)) {
            LRUMapEntry entry = (LRUMapEntry)super.get(key);
            super.remove(key);
            this._LRUList.remove(entry.LRUEntry);
            return entry.value;
        }
        return null;
    }

    public Object clone() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this._unsupportedText);
    }

    public boolean containsValue(Object value) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this._unsupportedText);
    }

    public Set entrySet() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this._unsupportedText);
    }

    public void putAll(Map t) throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this._unsupportedText);
    }

    public Collection values() throws UnsupportedOperationException {
        throw new UnsupportedOperationException(this._unsupportedText);
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }

    private static class LRUMapEntry {
        public Object value;
        public LinkedListDirectAccess.Entry LRUEntry;

        private LRUMapEntry() {
        }
    }
}

