/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.util0;

import com.sap.exception.BaseException;
import com.sap.exception.IBaseException;
import com.sap.localization.LocalizableText;
import com.sap.security.core.server.util0.ExternalizableException;
import com.sap.security.core.server.util0.IDExceptionMessage;
import com.sap.security.core.server.util0.IDMessage;
import com.sap.tc.logging.Category;
import com.sap.tc.logging.Location;
import com.sap.tc.logging.LogController;
import java.util.Locale;
import java.util.TimeZone;

public abstract class IDException
extends BaseException {
    static final long serialVersionUID = 5509991256695688388L;
    private static final Location IDEXCEPTION_LOCATION = Location.getLocation((Class)(class$com$sap$security$core$server$util0$IDException == null ? (class$com$sap$security$core$server$util0$IDException = IDException.class$("com.sap.security.core.server.util0.IDException")) : class$com$sap$security$core$server$util0$IDException));
    static /* synthetic */ Class class$com$sap$security$core$server$util0$IDException;

    public IDException(IDMessage message, Throwable rootCause) {
        super(IDEXCEPTION_LOCATION, (LocalizableText)message, rootCause);
    }

    public IDException(Location location, IDMessage message, Throwable rootCause) {
        super(location, (LocalizableText)message, rootCause);
    }

    public IDException(Throwable wrappedThrowable) {
        super(IDEXCEPTION_LOCATION, wrappedThrowable);
    }

    public IDException(Location location, Throwable throwable) {
        super(location, throwable);
    }

    public String getLocalizedMessage() {
        return this.appendPrefix(super.getLocalizedMessage());
    }

    public String getLocalizedMessage(Locale loc, TimeZone timeZone) {
        return this.appendPrefix(super.getLocalizedMessage(loc, timeZone));
    }

    public String getLocalizedMessage(Locale loc) {
        return this.appendPrefix(super.getLocalizedMessage(loc));
    }

    public String getLocalizedMessage(TimeZone timeZone) {
        return this.appendPrefix(super.getLocalizedMessage(timeZone));
    }

    public String getMessage() {
        IDMessage message = (IDMessage)this.getLocalizableMessage();
        if (message != null) {
            return message.formatNonLocalized();
        }
        return this.getCause().getMessage();
    }

    private String appendPrefix(String originalMessage) {
        IDMessage message = (IDMessage)this.getLocalizableMessage();
        if (message == null) {
            return originalMessage;
        }
        StringBuffer output = new StringBuffer();
        output.append("[");
        output.append(message.getPrefixInOutput());
        output.append(message.getBaseMsg().getKey());
        output.append("] ");
        output.append(originalMessage);
        return output.toString();
    }

    public String getNestedNonLocalizedMessage() {
        Throwable cause = this.getCause();
        String causeString = cause != null ? (cause instanceof IDException ? ((IDException)((Object)cause)).getNestedNonLocalizedMessage() : (cause instanceof IBaseException ? ((IBaseException)cause).getNestedLocalizedMessage(Locale.US) : cause.getMessage())) : "No information about the cause of this problem is available";
        if (this.getLocalizableMessage() == null) {
            return causeString;
        }
        String ownMessageText = this.getMessage();
        if (cause == null) {
            return ownMessageText;
        }
        StringBuffer buffer = new StringBuffer();
        buffer.append(ownMessageText);
        buffer.append(": ");
        buffer.append(causeString);
        return buffer.toString();
    }

    public IDMessage getIDMessage() {
        IDMessage message = (IDMessage)this.getLocalizableMessage();
        if (message != null) {
            return message;
        }
        Throwable cause = this.getCause();
        if (cause instanceof IDException) {
            return ((IDException)((Object)cause)).getIDMessage();
        }
        return IDExceptionMessage.ID0000_NO_IDMESSAGE_AVAILABLE.create(cause != null ? cause.getClass().getName() : "No class available", cause != null ? cause.getMessage() : "No message available");
    }

    public String logIDException(int severity, Category category, Location location, String sublocation) {
        String defaultText;
        String logID;
        if (category.beLogged(severity, (LogController)location)) {
            String exceptionText = this.getNestedNonLocalizedMessage();
            IDMessage excMessage = IDExceptionMessage.ID0001_EXCEPTION_LOG.create(location.getName(), exceptionText);
            logID = excMessage.log(severity, category, location, sublocation);
            defaultText = "Log entry with identifier \"" + logID + "\" created";
        } else {
            defaultText = "No log entry created because category \"" + category.getName() + "\" is not active with sufficient severity";
            logID = "<" + defaultText + ">";
        }
        category.logThrowableT(severity, location, sublocation, "Stack trace of log message with ID \"" + logID + "\" written to trace", (Throwable)((Object)this));
        if (this.isExternalizable()) {
            return this.getNestedNonLocalizedMessage();
        }
        return defaultText;
    }

    public boolean isExternalizable() {
        if (this instanceof ExternalizableException) {
            return true;
        }
        if (this.getLocalizableMessage() != null) {
            return false;
        }
        Throwable cause = this.getCause();
        if (cause == null) {
            return false;
        }
        if (cause instanceof IDException) {
            return ((IDException)((Object)cause)).isExternalizable();
        }
        return cause instanceof ExternalizableException;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

