/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.util0;

import java.io.ByteArrayOutputStream;
import java.text.ParseException;

public class HexConvert {
    private static final char[] TO_HEX = new char[]{'0', '1', '2', '3', '4', '5', '6', '7', '8', '9', 'A', 'B', 'C', 'D', 'E', 'F'};

    public static String encode(byte[] bytesIn) {
        StringBuffer outputBuffer = new StringBuffer(bytesIn.length * 2);
        int i = 0;
        while (i < bytesIn.length) {
            int currentValue = bytesIn[i];
            if (currentValue < 0) {
                currentValue += 256;
            }
            int upperNibble = currentValue / 16;
            int lowerNibble = currentValue % 16;
            outputBuffer.append(TO_HEX[upperNibble]);
            outputBuffer.append(TO_HEX[lowerNibble]);
            ++i;
        }
        return outputBuffer.toString();
    }

    public static byte[] decode(String stringIn) throws ParseException {
        ByteArrayOutputStream outputBuffer = new ByteArrayOutputStream();
        boolean currentlyFirstNibble = true;
        int value = 0;
        int i = 0;
        while (i < stringIn.length()) {
            char currentChar = stringIn.charAt(i);
            if (!Character.isWhitespace(currentChar)) {
                int nibble = 0;
                switch (Character.toUpperCase(currentChar)) {
                    case '0': {
                        nibble = 0;
                        break;
                    }
                    case '1': {
                        nibble = 1;
                        break;
                    }
                    case '2': {
                        nibble = 2;
                        break;
                    }
                    case '3': {
                        nibble = 3;
                        break;
                    }
                    case '4': {
                        nibble = 4;
                        break;
                    }
                    case '5': {
                        nibble = 5;
                        break;
                    }
                    case '6': {
                        nibble = 6;
                        break;
                    }
                    case '7': {
                        nibble = 7;
                        break;
                    }
                    case '8': {
                        nibble = 8;
                        break;
                    }
                    case '9': {
                        nibble = 9;
                        break;
                    }
                    case 'A': {
                        nibble = 10;
                        break;
                    }
                    case 'B': {
                        nibble = 11;
                        break;
                    }
                    case 'C': {
                        nibble = 12;
                        break;
                    }
                    case 'D': {
                        nibble = 13;
                        break;
                    }
                    case 'E': {
                        nibble = 14;
                        break;
                    }
                    case 'F': {
                        nibble = 15;
                        break;
                    }
                    default: {
                        throw new ParseException("Input string contains invalid character " + currentChar, i);
                    }
                }
                if (currentlyFirstNibble) {
                    value = nibble * 16;
                    currentlyFirstNibble = false;
                } else {
                    outputBuffer.write(value += nibble);
                    currentlyFirstNibble = true;
                }
            }
            ++i;
        }
        if (!currentlyFirstNibble) {
            throw new ParseException("Input string has an odd number of hexadecimal characters", 0);
        }
        return outputBuffer.toByteArray();
    }
}

