/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.util0;

import java.io.ByteArrayOutputStream;
import java.text.ParseException;
import java.util.Arrays;

public class Base64 {
    private static final char[] _conversion = new char[]{'A', 'B', 'C', 'D', 'E', 'F', 'G', 'H', 'I', 'J', 'K', 'L', 'M', 'N', 'O', 'P', 'Q', 'R', 'S', 'T', 'U', 'V', 'W', 'X', 'Y', 'Z', 'a', 'b', 'c', 'd', 'e', 'f', 'g', 'h', 'i', 'j', 'k', 'l', 'm', 'n', 'o', 'p', 'q', 'r', 's', 't', 'u', 'v', 'w', 'x', 'y', 'z', '0', '1', '2', '3', '4', '5', '6', '7', '8', '9', '+', '/'};
    private static int[] _reverseConversion = null;

    public static String encode(byte[] inputBytes, int maxLineLength) {
        int inputLength = inputBytes.length;
        if (inputLength == 0) {
            return "";
        }
        int outputCharLength = 4 * ((inputLength - 1) / 3 + 1);
        if (maxLineLength != 0) {
            outputCharLength += outputCharLength / maxLineLength;
        }
        StringBuffer buffer = new StringBuffer(outputCharLength);
        int positionCounter = 0;
        int bytePosition = 0;
        int b0 = 0;
        int b1 = 0;
        int b2 = 0;
        int b3 = 0;
        int i = 0;
        while (i < inputLength) {
            int currentByte = inputBytes[i] & 0xFF;
            switch (bytePosition) {
                case 0: {
                    b0 = currentByte >>> 2;
                    b1 = (currentByte & 3) << 4;
                    break;
                }
                case 1: {
                    b1 |= currentByte >>> 4;
                    b2 = (currentByte & 0xF) << 2;
                    break;
                }
                case 2: {
                    b3 = currentByte & 0x3F;
                    positionCounter = Base64.appendChar(_conversion[b0], positionCounter, maxLineLength, buffer);
                    positionCounter = Base64.appendChar(_conversion[b1], positionCounter, maxLineLength, buffer);
                    positionCounter = Base64.appendChar(_conversion[b2 |= currentByte >>> 6], positionCounter, maxLineLength, buffer);
                    positionCounter = Base64.appendChar(_conversion[b3], positionCounter, maxLineLength, buffer);
                    break;
                }
                default: {
                    throw new RuntimeException("Byte position " + bytePosition + " cannot occur");
                }
            }
            if (++bytePosition == 3) {
                bytePosition = 0;
            }
            ++i;
        }
        switch (bytePosition) {
            case 0: {
                break;
            }
            case 1: {
                positionCounter = Base64.appendChar(_conversion[b0], positionCounter, maxLineLength, buffer);
                positionCounter = Base64.appendChar(_conversion[b1], positionCounter, maxLineLength, buffer);
                positionCounter = Base64.appendChar('=', positionCounter, maxLineLength, buffer);
                positionCounter = Base64.appendChar('=', positionCounter, maxLineLength, buffer);
                break;
            }
            case 2: {
                positionCounter = Base64.appendChar(_conversion[b0], positionCounter, maxLineLength, buffer);
                positionCounter = Base64.appendChar(_conversion[b1], positionCounter, maxLineLength, buffer);
                positionCounter = Base64.appendChar(_conversion[b2], positionCounter, maxLineLength, buffer);
                positionCounter = Base64.appendChar('=', positionCounter, maxLineLength, buffer);
                break;
            }
            default: {
                throw new RuntimeException("Byte position " + bytePosition + " cannot occur");
            }
        }
        return buffer.toString();
    }

    private static int appendChar(char c, int posCounter, int maxLength, StringBuffer buffer) {
        buffer.append(c);
        if (maxLength != 0 && ++posCounter == maxLength) {
            buffer.append('\n');
            posCounter = 0;
        }
        return posCounter;
    }

    public static byte[] decode(String inputString) throws ParseException {
        if (inputString == null) {
            return new byte[0];
        }
        int stringLength = inputString.length();
        if (stringLength == 0) {
            return new byte[0];
        }
        if (_reverseConversion == null) {
            Base64.createReverseLookupTable();
        }
        ByteArrayOutputStream outputBuffer = new ByteArrayOutputStream();
        char currentChar = '\u0000';
        int indexPos = 0;
        int maxIndex = _reverseConversion.length;
        int posCounter = 0;
        int b0 = 0;
        int b1 = 0;
        int b2 = 0;
        int charPos = 0;
        block12: while (charPos < stringLength) {
            currentChar = inputString.charAt(charPos);
            if (!Character.isWhitespace(currentChar)) {
                if (currentChar == '=') {
                    switch (posCounter) {
                        case 0: {
                            throw new ParseException("Equals-sign (=) detected at position 0 mod 4", charPos);
                        }
                        case 1: {
                            throw new ParseException("Equals-sign (=) detected at position 1 mod 4", charPos);
                        }
                        case 2: {
                            if (b1 == 0) break block12;
                            throw new ParseException("Equals-sign terminates input string, but final bits are not 0", charPos);
                        }
                        case 3: {
                            if (b2 == 0) break block12;
                            throw new ParseException("Equals-sign terminates input string, but final bits are not 0", charPos);
                        }
                        default: {
                            throw new RuntimeException("Position counter " + posCounter + " cannot occur");
                        }
                    }
                }
                int charIndex = currentChar & 0xFFFF;
                if (charIndex >= maxIndex || (indexPos = _reverseConversion[charIndex]) == -1) {
                    throw new ParseException("Input string contains character \"" + currentChar + "\" at position " + charPos + " which is not valid in Base64.", charPos);
                }
                switch (posCounter) {
                    case 0: {
                        b0 = indexPos << 2;
                        break;
                    }
                    case 1: {
                        outputBuffer.write(b0 |= indexPos >>> 4);
                        b1 = (indexPos & 0xF) << 4;
                        break;
                    }
                    case 2: {
                        outputBuffer.write(b1 |= indexPos >> 2);
                        b2 = (indexPos & 3) << 6;
                        break;
                    }
                    case 3: {
                        outputBuffer.write(b2 |= indexPos);
                        break;
                    }
                    default: {
                        throw new RuntimeException("Position counter " + posCounter + " cannot occur");
                    }
                }
                if (++posCounter == 4) {
                    posCounter = 0;
                }
            }
            ++charPos;
        }
        if (posCounter != 0 && currentChar != '=') {
            throw new ParseException("Base64 input data were terminated out-of-sync and without equals-sign", 0);
        }
        return outputBuffer.toByteArray();
    }

    private static synchronized void createReverseLookupTable() {
        if (_reverseConversion != null) {
            return;
        }
        int maxValue = 0;
        int i = 0;
        while (i < _conversion.length) {
            int charValue = _conversion[i] & 0xFFFF;
            if (charValue > maxValue) {
                maxValue = charValue;
            }
            ++i;
        }
        _reverseConversion = new int[maxValue + 1];
        Arrays.fill(_reverseConversion, -1);
        int i2 = 0;
        while (i2 < _conversion.length) {
            int charValue = _conversion[i2] & 0xFFFF;
            Base64._reverseConversion[charValue] = i2++;
        }
    }
}

