/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.likey.utils;

import com.sap.security.core.server.likey.LogAndTrace;
import com.sap.security.core.server.likey.StdLogAndTrace;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Vector;

public class utils {
    public static Vector parseLiKeyString(String arg, LogAndTrace lat) {
        Vector<String> erg = new Vector<String>();
        String rest = arg;
        while (rest.length() > 0) {
            String value;
            int size;
            String strSize;
            try {
                strSize = rest.substring(0, 4);
            }
            catch (StringIndexOutOfBoundsException ex) {
                lat.writeError("Internal error: substring \"" + rest + "\" of String \"" + arg + "\" should start with a four-digit " + "number, but it is too short.");
                throw ex;
            }
            try {
                size = new Integer(strSize);
            }
            catch (NumberFormatException ex) {
                lat.writeError("Internal error: substring \"" + rest + "\" of String \"" + arg + "\" should start with a four-digit " + "number, but it doesn't.");
                throw ex;
            }
            try {
                value = rest.substring(4, 4 + size);
            }
            catch (StringIndexOutOfBoundsException ex) {
                lat.writeError("Internal error: substring \"" + rest + "\" of String \"" + arg + "\" should be at least " + size + " characters long, but it isn't.");
                throw ex;
            }
            erg.addElement(value);
            rest = rest.substring(4 + size);
        }
        return erg;
    }

    public static String createLiKeyString(Vector arg, LogAndTrace lat) {
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < arg.size()) {
            sb.append(utils.encodeValue((String)arg.elementAt(i), lat));
            ++i;
        }
        return sb.toString();
    }

    public static String getFirstValue(String arg, LogAndTrace lat) {
        String value;
        int size;
        String strSize;
        try {
            strSize = arg.substring(0, 4);
        }
        catch (StringIndexOutOfBoundsException ex) {
            lat.writeError("Internal error: String \"" + arg + "\" should start with a four-digit " + "number, but it is too short.");
            throw ex;
        }
        try {
            size = new Integer(strSize);
        }
        catch (NumberFormatException ex) {
            lat.writeError("Internal error: String \"" + arg + "\" should start with a four-digit " + "number, but it doesn't.");
            throw ex;
        }
        try {
            value = arg.substring(4, 4 + size);
        }
        catch (StringIndexOutOfBoundsException ex) {
            lat.writeError("Internal error: String \"" + arg + "\" should be at least " + size + " characters long, but it isn't.");
            throw ex;
        }
        return value;
    }

    protected static String encodeValue(String value, LogAndTrace lat) {
        int size = value.length();
        if (size > 9999) {
            lat.writeError("Internal error ocurred: the string \"" + value + "\" is too long to be encoded " + "(longer than 9999 characters).");
            return null;
        }
        String sizeString = "0000" + size;
        sizeString = sizeString.substring(sizeString.length() - 4);
        return sizeString + value;
    }

    public static String fillup(String str, int count) {
        String blanks100 = "                                                                                                    ";
        String x = str + "                                                                                                    ";
        while (x.length() < count) {
            x = x + "                                                                                                    ";
        }
        return x.substring(0, count);
    }

    public static boolean consistsOfDigits(String string) {
        int index = 0;
        while (index < string.length()) {
            if (!Character.isDigit(string.charAt(index))) {
                return false;
            }
            ++index;
        }
        return true;
    }

    public static void logException(Throwable ex, LogAndTrace lat, boolean writeToTrace) {
        try {
            StringWriter sw = new StringWriter();
            PrintWriter pw = new PrintWriter(sw);
            ex.printStackTrace(pw);
            String input = sw.getBuffer().toString();
            StringReader sr = new StringReader(input);
            BufferedReader br = new BufferedReader(sr);
            String line = br.readLine();
            while (line != null) {
                if (writeToTrace) {
                    lat.writeTrace(line);
                } else {
                    lat.writeError(line);
                }
                line = br.readLine();
            }
            br.close();
            sr.close();
            pw.close();
            sw.close();
        }
        catch (IOException ioEx) {
            lat.writeError(ex.toString() + "(error printing stack trace)");
        }
    }

    public static void main(String[] args) {
        StdLogAndTrace lat = new StdLogAndTrace();
        System.out.println("----- test encodeValue  -------");
        System.out.println(utils.encodeValue("a", lat));
        System.out.println(utils.encodeValue("aaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", lat));
        System.out.println(utils.encodeValue("ayaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaaa", lat));
        System.out.println("----- test parseLiKeyString  -------");
        String input = "0003P500011L01468077630020ENTERPRISE PORTAL   0010000000012300082002123100100120007965";
        System.out.println("Input:\n" + input);
        Vector v = utils.parseLiKeyString(input, lat);
        int i = 0;
        while (i < v.size()) {
            System.out.println(v.elementAt(i));
            ++i;
        }
        System.out.println("----- test createLiKeyString -------");
        System.out.println(utils.createLiKeyString(v, lat));
        System.out.println("----- test firstValue -------");
        System.out.println(utils.getFirstValue(input, lat));
    }
}

