/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.likey;

import com.sap.security.core.server.likey.LogAndTrace;
import com.sap.security.core.server.likey.StdLogAndTrace;
import iaik.asn1.ASN1Object;
import iaik.asn1.CodingException;
import iaik.asn1.DerCoder;
import iaik.asn1.OCTET_STRING;
import iaik.asn1.ObjectID;
import iaik.asn1.SEQUENCE;
import iaik.asn1.SET;
import iaik.asn1.structures.AlgorithmID;
import iaik.asn1.structures.Attribute;
import iaik.pkcs.PKCSParsingException;
import iaik.pkcs.pkcs7.ContentInfo;
import iaik.pkcs.pkcs7.IssuerAndSerialNumber;
import iaik.pkcs.pkcs7.SignedData;
import iaik.pkcs.pkcs7.SignerInfo;
import iaik.security.dsa.RawDSA;
import iaik.security.provider.IAIK;
import iaik.utils.Base64Exception;
import iaik.utils.CryptoUtils;
import iaik.utils.Util;
import iaik.x509.X509Certificate;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.math.BigInteger;
import java.security.InvalidKeyException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.security.SignatureException;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;

public class P7Verifier {
    private static String sapRootCert = "MIIDJTCCAuSgAwIBAgICAaEwCQYHKoZIzjgEAzBSMQswCQYDVQQGEwJERTEcMBoGA1UEChMTbXlTQVAuY29tIFdvcmtwbGFjZTElMCMGA1UEAxMcbXlTQVAuY29tIFdvcmtwbGFjZSBDQSAoZHNhKTAeFw0wMDAxMDExMjAwMDBaFw0xMDAxMzExMjAwMDBaMEExCzAJBgNVBAYTAkRFMSQwIgYDVQQKExtTQVAgVHJ1c3QgQ29tbXVuaXR5IExpY2Vuc2UxDDAKBgNVBAMTA0xBUzCCAbYwggErBgcqhkjOOAQBMIIBHgKBgQD/8e1jxtAF9jpjgWHKJ9uYejDcW5rEsRW9teKPbxINreTHGqOMoUFUj7TQBK1w2hBhceTR2q6t/x0C6R+EwjH5ZXhZC5481khx99KFWVhlgegCyIcS01Qv1aNsf0hJvbHhhbERGODwPIvxF6AMK+xZPbu5ny389h6fOrNGSeqhbwIVAKRdd4hnXeSDkFacddVJf0Q8JYofAoGAOADyl+TiOp1gh5Vi/wg2AgzJkG6RLuFB+Q5E9rBcvKzp6vtB7YPxhAiRkg/EX40bxNgNgBVm2U7hnxf5YqTXjwHt6XpmFq573IaeTsXZBs7EOvGXOecbvxWafDGUhdVn5WnjxiCuzD8A8qlKXuqsGG4WuD8WOljHbo815HhfAwUDgYQAAoGAX+/oYbVFvImGQrRIt72/B/BsdV8UGCb6blIQr5EcrEkflxMSlaiWcVAdxu03LEH+IC+dg2bUdC9FkMgjz7pk9jTVByaH3/awIG9ebvt37yWqEibs33Ih1xTufYo4AAMo1cw8T6bcsxE0QWE/3E1Ejz8wa1327fHBVscamLhVbrujXTBbMAwGA1UdEwEB/wQCMAAwCwYDVR0PBAQDAgTwMB0GA1UdDgQWBBRpOegSX7ylr75r7GcvPvErPhC0zjAfBgNVHSMEGDAWgBSfgt+EduVRM5oI0Te9zV0GKf+o0TAJBgcqhkjOOAQDAzAAMC0CFDRDEPBcF+20KuDB0EpKY19bI/m4AhUAjTOOVvQwVWSHqEuHWRLDyHTnV2s=";
    private static BigInteger sapCertSerNumber = new BigInteger("417");
    private static String sapCertIssuer = "CN=mySAP.com Workplace CA (dsa),O=mySAP.com Workplace,C=DE";
    private static boolean providerAdded = false;
    static /* synthetic */ Class class$iaik$security$provider$IAIK;

    private static void addProvider(LogAndTrace lat) throws Exception {
        if (providerAdded) {
            return;
        }
        lat.writeTrace("Compiled with IAIK version 3.01, running with " + new IAIK());
        providerAdded = true;
        try {
            Method method = (class$iaik$security$provider$IAIK == null ? (class$iaik$security$provider$IAIK = P7Verifier.class$("iaik.security.provider.IAIK")) : class$iaik$security$provider$IAIK).getMethod("addAsJDK14Provider", null);
            method.invoke(null, new Object[0]);
            lat.writeTrace("addAsJDK14Provider () called dynamically.");
        }
        catch (NoSuchMethodException ex) {
            IAIK.addAsProvider();
            lat.writeTrace("addAsProvider () called.");
        }
    }

    public static boolean verify(byte[] licensekey, String signedtext, LogAndTrace lat) throws CertificateException, NoSuchAlgorithmException, InvalidKeyException, NoSuchProviderException, SignatureException, CertificateExpiredException, CertificateNotYetValidException, CodingException, PKCSParsingException, Base64Exception, IOException, Exception {
        P7Verifier.addProvider(lat);
        ByteArrayInputStream bais = new ByteArrayInputStream(Util.Base64Decode((byte[])licensekey));
        ContentInfo ci = new ContentInfo((InputStream)bais);
        if (!ci.getContentType().equals((Object)ObjectID.pkcs7_signedData)) {
            throw new Exception("LicenseKey expected as signature (got " + ci.getContentType() + ")");
        }
        AlgorithmID[] algIDs = new AlgorithmID[]{AlgorithmID.sha1, AlgorithmID.md5};
        SignedData signedData = new SignedData(signedtext.getBytes(), algIDs);
        try {
            signedData.decode(ci.getContentInputStream());
        }
        catch (IOException e) {
            // empty catch block
        }
        lat.writeTrace("--- SignedData Object ---");
        lat.writeTrace(signedData.toString());
        X509Certificate[] certs = signedData.getCertificates();
        lat.writeTrace("--- Certificates ---");
        if (certs != null) {
            int i = 0;
            while (i < certs.length) {
                lat.writeTrace(certs[i].toString());
                ++i;
            }
        }
        if (certs != null && certs.length != 0) {
            throw new Exception("No certificates expected within license key (found " + certs.length + ").");
        }
        SignerInfo[] signers = signedData.getSignerInfos();
        lat.writeTrace("--- Signers ---");
        if (signers != null) {
            int i = 0;
            while (i < signers.length) {
                lat.writeTrace("--- Start Signer [" + i + "] ---");
                lat.writeTrace(signers[i].toString());
                lat.writeTrace("--- End Signer [" + i + "] ---");
                ++i;
            }
        }
        if (signers.length != 1) {
            throw new Exception("Only one signer allowed. Contains: " + signers.length);
        }
        SignerInfo signer = signers[0];
        IssuerAndSerialNumber isn = signer.getIssuerAndSerialNumber();
        if (!sapCertSerNumber.equals(isn.getSerialNumber())) {
            throw new Exception("Incorrect issuer (SN=" + isn.getSerialNumber() + ")");
        }
        if (!sapCertIssuer.equals(isn.getIssuer().toString())) {
            throw new Exception("Incorrect issuer (DN=" + isn.getIssuer() + ")");
        }
        AlgorithmID encryptAlgoID = signer.getDigestEncryptionAlgorithm();
        String algoID = encryptAlgoID.getAlgorithm().getID();
        String algoName = encryptAlgoID.getName();
        lat.writeTrace("Algorithm-ID = \"" + algoID + "\", Name = \"" + algoName + "\"");
        if (!algoID.equals("1.2.840.10040.4.3")) {
            throw new Exception("Incorrect signature algorithm (\"" + algoID + "\"/\"" + algoName + "\")");
        }
        String mdString = signer.getDigestAlgorithm().getName();
        lat.writeTrace("Message Digest is \"" + mdString + "\"");
        MessageDigest md = MessageDigest.getInstance(mdString);
        md.update(signedtext.getBytes());
        byte[] digest_data = md.digest();
        Attribute[] attr = signer.getAuthenticatedAttributes();
        if (attr.length != 3) {
            throw new Exception("Incorrect number of attributes (" + attr.length + ")");
        }
        SEQUENCE msDigest = (SEQUENCE)attr[2].toASN1Object();
        OCTET_STRING osDigest = (OCTET_STRING)((SET)msDigest.getComponentAt(1)).getComponentAt(0);
        if (!CryptoUtils.equalsBlock((byte[])osDigest.getWholeValue(), (byte[])digest_data)) {
            throw new Exception("Message digest in authenticated attributes doesn't match.");
        }
        if (attr != null && attr.length > 0) {
            SET set = new SET();
            int j = 0;
            while (j < attr.length) {
                lat.writeTrace("attr [" + j + "] = " + attr[j]);
                set.addComponent(attr[j].toASN1Object());
                ++j;
            }
            digest_data = DerCoder.encode((ASN1Object)set);
        }
        md.reset();
        md.update(digest_data);
        byte[] digest = md.digest();
        byte[] encrypt_digest = signer.getEncryptedDigest();
        X509Certificate signerCert = new X509Certificate(sapRootCert.getBytes());
        RawDSA dsa = new RawDSA();
        dsa.initVerify(signerCert.getPublicKey());
        dsa.update(digest);
        boolean verify_ok = dsa.verify(encrypt_digest);
        lat.writeTrace(">>> DSA-Verify = " + verify_ok);
        if (!verify_ok) {
            throw new SignatureException("DSA verify of signature failed.");
        }
        return verify_ok;
    }

    public static void main(String[] args) throws Exception {
        String likey = "MIIBOwYJKoZIhvcNAQcCoIIBLDCCASgCAQExCzAJBgUrDgMCGgUAMAsGCSqGSIb3DQEHATGCAQcwggEDAgEBMFgwUjELMAkGA1UEBhMCREUxHDAaBgNVBAoTE215U0FQLmNvbSBXb3JrcGxhY2UxJTAjBgNVBAMTHG15U0FQLmNvbSBXb3JrcGxhY2UgQ0EgKGRzYSkCAgGhMAkGBSsOAwIaBQCgXTAYBgkqhkiG9w0BCQMxCwYJKoZIhvcNAQcBMBwGCSqGSIb3DQEJBTEPFw0wMjAxMTExMDIwMTJaMCMGCSqGSIb3DQEJBDEWBBS76hNeSO9rkhJu7BRUNGpZm+DQTDAJBgcqhkjOOAQDBC8wLQIUA7Z9UcnZ1DrwyeZf2m7El7de6usCFQCB0VAVa4ThCWBa/aksvm4vJVZHog==";
        String signedtext = "EP5L0146807763Portal              2147483647999912310020110842";
        System.out.println(P7Verifier.verify(likey.getBytes(), signedtext, new StdLogAndTrace()));
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

