/*
 * Decompiled with CFR 0.152.
 */
package com.sap.security.core.server.likey;

import com.sap.security.core.server.likey.LicenseChecker;
import com.sap.security.core.server.likey.LogAndTrace;
import com.sap.security.core.server.likey.P7Verifier;
import com.sap.security.core.server.likey.utils.Base64;
import com.sap.security.core.server.likey.utils.utils;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.text.ParseException;
import java.util.Date;
import java.util.Vector;

public class LicenseKey {
    private static final String Version = "2.0";
    private String systemId;
    private String hwKey;
    private String swProduct;
    private String swPLimit;
    private int _swPLimit;
    private String type;
    private String signature;
    private String installNo;
    private String beginDate;
    private String endDate;
    private String systemNo;
    private String lastSuccessfulCheck;
    private LogAndTrace lat;
    private String reason;

    public static String getVersion() {
        return Version;
    }

    static String convertDate(String dateIn) {
        if (dateIn.length() != 8) {
            return dateIn;
        }
        String result = dateIn.substring(6, 8) + "/";
        String month = dateIn.substring(4, 6);
        if (month.equals("01")) {
            result = result + "Jan";
        } else if (month.equals("02")) {
            result = result + "Feb";
        } else if (month.equals("03")) {
            result = result + "Mar";
        } else if (month.equals("04")) {
            result = result + "Apr";
        } else if (month.equals("05")) {
            result = result + "May";
        } else if (month.equals("06")) {
            result = result + "Jun";
        } else if (month.equals("07")) {
            result = result + "Jul";
        } else if (month.equals("08")) {
            result = result + "Aug";
        } else if (month.equals("09")) {
            result = result + "Sep";
        } else if (month.equals("10")) {
            result = result + "Oct";
        } else if (month.equals("11")) {
            result = result + "Nov";
        } else if (month.equals("12")) {
            result = result + "Dec";
        } else {
            return dateIn;
        }
        result = result + "/" + dateIn.substring(0, 4);
        return result;
    }

    public static String calculateFingerPrint(String s, LogAndTrace lat) {
        try {
            MessageDigest md = MessageDigest.getInstance("MD5");
            String salt = "72df24c1e2c7aaf24342b4de66024541";
            byte[] textBytes = (s + "72df24c1e2c7aaf24342b4de66024541").getBytes();
            byte[] digest = md.digest(textBytes);
            return Base64.encode(digest);
        }
        catch (NoSuchAlgorithmException ex) {
            lat.writeError("Message Digest Algorithm MD5 not found. Please update your JRE.");
            lat.writeError(ex.toString());
            return null;
        }
    }

    public LicenseKey(String psystemId, String pHwKey, String pSwProduct, String pSwPLimit, String pBeginDate, String pEndDate, String pType, String pSignature, String pInstallNo, String pSystemNo, LogAndTrace pLat) {
        this.systemId = psystemId;
        this.hwKey = pHwKey;
        this.swProduct = pSwProduct;
        int requiredZeroes = 10 - pSwPLimit.length();
        this.swPLimit = "0000000000".substring(0, requiredZeroes) + pSwPLimit;
        try {
            this._swPLimit = Integer.parseInt(pSwPLimit, 10);
        }
        catch (NumberFormatException ex) {
            this.lat.writeError("Invalid value read for the sw product limit: " + ex);
        }
        this.beginDate = pBeginDate;
        this.endDate = pEndDate;
        this.type = pType;
        this.signature = pSignature;
        this.installNo = pInstallNo;
        this.systemNo = pSystemNo;
        this.lat = pLat;
        this.reason = null;
    }

    public LicenseKey(String key, String value, LogAndTrace pLat) {
        Vector vKey = utils.parseLiKeyString(key, this.lat);
        if (vKey.size() < 4) {
            this.lat.writeError("The key \"" + key + "\" has incorrect format. There are " + vKey.size() + " fields in it (4 reqired).");
            return;
        }
        if (!((String)vKey.elementAt(0)).equals("LK")) {
            this.lat.writeError("The key \"" + key + "\" has incorrect format. It doesn't " + "start with \"LK\"!");
            return;
        }
        this.systemId = (String)vKey.elementAt(1);
        this.hwKey = (String)vKey.elementAt(2);
        this.swProduct = (String)vKey.elementAt(3);
        Vector vValue = utils.parseLiKeyString(value, this.lat);
        if (vValue.size() < 6) {
            this.lat.writeError("The value \"" + value + "\" has incorrect format. There are " + vValue.size() + " fields init (6 required), Key = \"" + key + "\".");
            return;
        }
        this.swPLimit = (String)vValue.elementAt(0);
        try {
            this._swPLimit = new Integer(this.swPLimit);
        }
        catch (NumberFormatException ex) {
            this.lat.writeError("The license key for system \"" + this.systemId + "\", hardware key \"" + this.hwKey + "\",  product \"" + this.swProduct + "\" contains an incorrect swPLimit " + "field (not a valid integer).");
        }
        this.type = (String)vValue.elementAt(1);
        this.signature = (String)vValue.elementAt(2);
        this.installNo = (String)vValue.elementAt(3);
        this.beginDate = (String)vValue.elementAt(4);
        this.endDate = (String)vValue.elementAt(5);
        this.systemNo = (String)vValue.elementAt(6);
        this.lat = pLat;
        this.reason = null;
    }

    private boolean expired() {
        String today = LicenseChecker.dateformatter.format(new Date());
        return this.endDate.compareTo(today) < 0;
    }

    private boolean validDate() {
        String today = LicenseChecker.dateformatter.format(new Date());
        return (this.beginDate.compareTo(today) <= 0 || this.beginDate.compareTo("00000000") == 0) && this.endDate.compareTo(today) >= 0;
    }

    boolean checkSignature() {
        String toBeSigned = this.isPermanent() && this.beginDate.equals("00000000") ? this.systemId + this.hwKey + utils.fillup(this.swProduct, 20) + this.swPLimit + this.endDate + this.installNo : this.systemId + this.hwKey + utils.fillup(this.swProduct, 20) + this.swPLimit + this.beginDate + this.endDate + this.installNo;
        if (this.isPermanent()) {
            boolean verify_ok;
            this.lat.writeTrace("Verifying signature of \"" + toBeSigned + "\"");
            try {
                verify_ok = P7Verifier.verify(this.signature.getBytes(), toBeSigned, this.lat);
            }
            catch (Throwable ex) {
                this.lat.writeError("Error during signature verification:");
                utils.logException(ex, this.lat, false);
                return false;
            }
            if (!verify_ok) {
                this.lat.writeTrace("Permanent license key is not properly signed for system \"" + this.systemId + "\", hardware key \"" + this.hwKey + "\", product \"" + this.swProduct + "\".");
            }
            return verify_ok;
        }
        this.lat.writeTrace("Verifying fingerprint of \"" + toBeSigned + "\"");
        if (!this.signature.equals(LicenseKey.calculateFingerPrint(toBeSigned, this.lat))) {
            this.lat.writeTrace("Temporary license key is not properly signed for system \"" + this.systemId + "\", hardware key \"" + this.hwKey + "\", product \"" + this.swProduct + "\".");
            return false;
        }
        return true;
    }

    public boolean preCheckWithoutExpiration(String systemId, String hwKey) {
        if (this.systemId.length() != 3) {
            this.lat.writeTrace("The license key for system \"" + this.systemId + "\", hardware key \"" + this.hwKey + "\",  product \"" + this.swProduct + "\" is invalid: the system Id is not 3 " + "characters long.");
            this.reason = "System Id not 3 chars long";
            return false;
        }
        if (this.hwKey.length() != 11) {
            this.lat.writeTrace("The license key for system \"" + this.systemId + "\", hardware key \"" + this.hwKey + "\",  product \"" + this.swProduct + "\" is invalid: the hardware key is not " + "11 characters long.");
            this.reason = "Hardware key not 11 chars long";
            return false;
        }
        if (this.swProduct.length() > 20) {
            this.lat.writeTrace("The license key for system \"" + this.systemId + "\", hardware key \"" + this.hwKey + "\",  product \"" + this.swProduct + "\" is invalid: the SW product is " + "longer than 20 characters.");
            this.reason = "SW product longer than 20 chars";
            return false;
        }
        if (this.installNo.length() != 10) {
            this.lat.writeTrace("The license key for system \"" + this.systemId + "\", hardware key \"" + this.hwKey + "\",  product \"" + this.swProduct + "\" is invalid: the installation number " + "is not 10 characters long.");
            this.reason = "Installation number not 10 chars long";
            return false;
        }
        if (this.systemNo.length() != 18) {
            this.lat.writeTrace("The license key for system \"" + this.systemId + "\", hardware key \"" + this.hwKey + "\",  product \"" + this.swProduct + "\" is invalid: the system number is " + "not 18 characters long.");
            this.reason = "Sytem number not 18 chars long";
            return false;
        }
        try {
            this._swPLimit = new Integer(this.swPLimit);
        }
        catch (NumberFormatException ex) {
            this.lat.writeTrace("The license key for system \"" + this.systemId + "\", hardware key \"" + this.hwKey + "\",  product \"" + this.swProduct + "\" contains an incorrect swPLimit " + "field (not a valid integer).");
            this.reason = "SW product limit not numeric";
            return false;
        }
        try {
            LicenseChecker.dateformatter.parse(this.beginDate);
        }
        catch (ParseException ex) {
            this.lat.writeTrace("The license key for system \"" + this.systemId + "\", hardware key \"" + this.hwKey + "\",  product \"" + this.swProduct + "\" contains an incorrect beginDate " + "field.");
            this.reason = "Bad format of validity date";
            return false;
        }
        try {
            LicenseChecker.dateformatter.parse(this.endDate);
        }
        catch (ParseException ex) {
            this.lat.writeTrace("The license key for system \"" + this.systemId + "\", hardware key \"" + this.hwKey + "\",  product \"" + this.swProduct + "\" contains an incorrect endDate " + "field.");
            this.reason = "Bad format of validity date";
            return false;
        }
        if (systemId == null) {
            this.lat.writeTrace("The license key for system \"" + this.systemId + "\", hardware key \"" + this.hwKey + "\",  product \"" + this.swProduct + "\" is invalid: the system Id of the " + "current system is unknown.");
            this.reason = "System Id unknown";
            return false;
        }
        if (!this.systemId.equals(systemId)) {
            this.lat.writeTrace("The license key for system \"" + this.systemId + "\", hardware key \"" + this.hwKey + "\",  product \"" + this.swProduct + "\" is invalid: the system ID doesn't " + "match \"" + systemId + "\".");
            this.reason = "Wrong system ID";
            return false;
        }
        if (hwKey == null) {
            this.lat.writeTrace("The license key for system \"" + this.systemId + "\", hardware key \"" + this.hwKey + "\",  product \"" + this.swProduct + "\" is invalid: the hardware key of the " + "current system is unknown.");
            this.reason = "Hardware key unknown";
            return false;
        }
        if (!this.hwKey.equals(hwKey)) {
            this.lat.writeTrace("The license key for system \"" + this.systemId + "\", hardware key \"" + this.hwKey + "\",  product \"" + this.swProduct + "\" is invalid: the hardware key doesn't " + "match \"" + hwKey + "\".");
            this.reason = "Wrong hardware key";
            return false;
        }
        if (!this.checkSignature()) {
            this.reason = "Signature not verified";
            return false;
        }
        this.lat.writeTrace("The license key for system \"" + this.systemId + "\", hardware key \"" + this.hwKey + "\",  product \"" + this.swProduct + "\" passed the preCheckWithoutExpiration.");
        this.reason = null;
        return true;
    }

    public boolean preCheck(String systemId, String hwKey) {
        if (!this.preCheckWithoutExpiration(systemId, hwKey)) {
            return false;
        }
        if (this.expired()) {
            this.lat.writeTrace("The license key for system \"" + this.systemId + "\", hardware key \"" + this.hwKey + "\",  product \"" + this.swProduct + "\" is invalid: it has expired.");
            this.reason = "Expired";
            return false;
        }
        this.lat.writeTrace("The license key for system \"" + this.systemId + "\", hardware key \"" + this.hwKey + "\",  product \"" + this.swProduct + "\" passed the preCheck (with expiration " + "check).");
        this.reason = null;
        return true;
    }

    public boolean check() {
        if (!this.validDate()) {
            this.lat.writeTrace("License key for " + this.swProduct + " not yet valid or not valid any more.");
            if (this.reason == null) {
                this.reason = this.expired() ? "Expired" : "Not valid yet";
            }
            return false;
        }
        this.lat.writeTrace("License key for " + this.swProduct + " passed check (without product).");
        return true;
    }

    public boolean check(String swProduct) {
        if (!this.swProduct.equals(swProduct)) {
            this.lat.writeTrace("This is a license key for product " + this.swProduct + ". Check on product " + swProduct + " not passed.");
            return false;
        }
        if (this._swPLimit != 0 && this._swPLimit != Integer.MAX_VALUE) {
            this.lat.writeError("Illegal license key check without swPLimit parameter for product " + swProduct + ".");
            return false;
        }
        if (!this.validDate()) {
            this.lat.writeTrace("License key for " + swProduct + " not yet valid or not valid any more.");
            return false;
        }
        this.lat.writeTrace("License key for " + swProduct + " passed check (without swPLimit).");
        return true;
    }

    public boolean check(String swProduct, int counter) {
        if (!this.swProduct.equals(swProduct)) {
            this.lat.writeTrace("This is a license key for product " + this.swProduct + ". Check on product " + swProduct + " not passed.");
            return false;
        }
        if (this._swPLimit == 0) {
            this.lat.writeError("Illegal license check with swPLimit " + counter + " for product " + swProduct + ".");
            return false;
        }
        if (this._swPLimit < counter) {
            this.lat.writeError("This is a license key for product " + this.swProduct + " with swPLimit " + this._swPLimit + ". Limit exceeded on check with " + counter + ".");
            return false;
        }
        if (!this.validDate()) {
            this.lat.writeTrace("License key for " + swProduct + " not yet valid or not valid any more.");
            return false;
        }
        this.lat.writeTrace("License key for " + swProduct + " passed check (with swPLimit " + counter + ").");
        return true;
    }

    public String getCheckReason() {
        if (this.reason == null) {
            return "";
        }
        return this.reason;
    }

    public String createKey(String type) {
        if (!"LK".equals(type) && !"LC".equals(type)) {
            this.lat.writeError("Internal error during creation of a key by LicenseKey: parameter type is \"" + type + "\", must be either \"LK\" or \"LC\".");
            return null;
        }
        Vector<String> vKey = new Vector<String>();
        vKey.addElement(type);
        vKey.addElement(this.systemId);
        vKey.addElement(this.hwKey);
        vKey.addElement(this.swProduct);
        return utils.createLiKeyString(vKey, this.lat);
    }

    public String createValue(String type) {
        Vector<String> vValue = new Vector<String>();
        if ("LK".equals(type)) {
            vValue.addElement(this.swPLimit);
            vValue.addElement(this.type);
            vValue.addElement(this.signature);
            vValue.addElement(this.installNo);
            vValue.addElement(this.beginDate);
            vValue.addElement(this.endDate);
            vValue.addElement(this.systemNo);
        } else if ("LC".equals(type)) {
            vValue.addElement(this.lastSuccessfulCheck);
            String toBeSigned = this.systemId + this.hwKey + this.swProduct + this.lastSuccessfulCheck;
            vValue.addElement(LicenseKey.calculateFingerPrint(toBeSigned, this.lat));
        } else {
            this.lat.writeError("Internal error during creation of a value by LicenseKey: parameter type is \"" + type + "\", must be either \"LK\" or \"LC\".");
            return null;
        }
        return utils.createLiKeyString(vValue, this.lat);
    }

    public String setLastSuccessfulCheck(String date) {
        String _lastSuccessfulCheck = this.lastSuccessfulCheck;
        this.lastSuccessfulCheck = date;
        return _lastSuccessfulCheck;
    }

    public String toString() {
        StringBuffer result = new StringBuffer();
        result.append(this.systemId);
        result.append("|");
        result.append(this.hwKey);
        result.append("|");
        result.append(utils.fillup(this.swProduct, 20));
        result.append(":");
        if (this._swPLimit == 0) {
            result.append("          ");
        } else {
            String numString = new Integer(this._swPLimit).toString();
            int requiredZeroes = 10 - numString.length();
            result.append("0000000000".substring(0, requiredZeroes));
            result.append(numString);
        }
        result.append("|");
        result.append(this.endDate);
        result.append("|");
        result.append(this.type);
        result.append("|");
        result.append(this.installNo);
        result.append("|");
        result.append(this.systemNo);
        result.append("|");
        if (this.lastSuccessfulCheck == null) {
            result.append("          ");
        } else {
            result.append(this.lastSuccessfulCheck);
        }
        return result.toString();
    }

    public boolean isPermanent() {
        return "P".equals(this.type);
    }

    public String getSystemId() {
        return this.systemId;
    }

    public String getHwKey() {
        return this.hwKey;
    }

    public String getSwProduct() {
        return this.swProduct;
    }

    public String getSwProductLimit() {
        if (this._swPLimit == 0) {
            return "None";
        }
        if (this._swPLimit == Integer.MAX_VALUE) {
            return "Unlimited";
        }
        return this.swPLimit;
    }

    public String getType() {
        if (this.type.equals("T")) {
            return "Temporary";
        }
        if (this.type.equals("P")) {
            return "Permanent";
        }
        return this.type;
    }

    public String getInstNo() {
        return this.installNo;
    }

    public String getBeginDate() {
        if (this.beginDate.equals("00000000")) {
            return null;
        }
        return LicenseKey.convertDate(this.beginDate);
    }

    public String getEndDate() {
        return LicenseKey.convertDate(this.endDate);
    }

    public Date getEndDateDate() {
        try {
            Date date = LicenseChecker.dateformatter.parse(this.endDate);
            return date;
        }
        catch (ParseException ex) {
            return null;
        }
    }

    public String getSysNo() {
        return this.systemNo;
    }

    public String getLastSuccessfulCheck() {
        return LicenseKey.convertDate(this.lastSuccessfulCheck);
    }
}

