/*
 * Decompiled with CFR 0.152.
 */
package com.sap.tc.buildplugin.techdev.engine.kernel;

import com.sap.tc.buildplugin.api.BuildActionResult;
import com.sap.tc.buildplugin.api.BuildActionSeverity;
import com.sap.tc.buildplugin.api.IBuildAction;
import com.sap.tc.buildplugin.api.IBuildInfo;
import com.sap.tc.buildplugin.api.IDevelopmentComponentInfo;
import com.sap.tc.buildplugin.techdev.ant.util.DirsAndFiles;
import com.sap.tc.buildplugin.techdev.ant.util.FileCreator;
import com.sap.tc.buildplugin.util.ComponentDependencies;
import com.sap.tc.buildplugin.util.JlinUtils;
import com.sap.tc.complib.ComponentType;
import com.sap.tc.complib.DCReference;
import com.sap.tc.complib.Dependency;
import com.sap.tc.complib.DevelopmentComponent;
import com.sap.tc.complib.PPReference;
import com.sap.tc.complib.PublicPart;
import com.sap.tc.logging.Location;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class CreateBuildFileAction
implements IBuildAction {
    BuildActionResult result;
    BuildActionSeverity severity;
    DirsAndFiles daf;
    FileCreator fCreator;
    String buildFileName;
    int br = 0;
    int currentStep;
    private IBuildInfo buildInfo;
    private static Location loc = Location.getLocation((Class)(class$com$sap$tc$buildplugin$techdev$engine$kernel$CreateBuildFileAction == null ? (class$com$sap$tc$buildplugin$techdev$engine$kernel$CreateBuildFileAction = CreateBuildFileAction.class$("com.sap.tc.buildplugin.techdev.engine.kernel.CreateBuildFileAction")) : class$com$sap$tc$buildplugin$techdev$engine$kernel$CreateBuildFileAction));
    JlinUtils jlinUtils;
    List externalCompPP = new ArrayList();
    static /* synthetic */ Class class$com$sap$tc$buildplugin$techdev$engine$kernel$CreateBuildFileAction;

    CreateBuildFileAction(FileCreator fc, int step, IBuildInfo buildInfo) {
        this.fCreator = fc;
        this.daf = fc.getDaf();
        this.currentStep = step;
        this.buildInfo = buildInfo;
        this.result = new BuildActionResult();
        this.severity = new BuildActionSeverity();
        this.severity.setStopOnError();
        this.jlinUtils = new JlinUtils(buildInfo);
    }

    public BuildActionResult execute() {
        switch (this.currentStep) {
            case 1: {
                this.daf.setBuildFile("prebuild.xml");
                this.fCreator.setMacroName("prebuild.vm");
                break;
            }
            case 2: {
                this.daf.setBuildFile("build.xml");
                this.fCreator.setMacroName("build.vm");
                break;
            }
            case 3: {
                this.daf.setBuildFile("postbuild.xml");
                this.fCreator.setMacroName("postbuild.vm");
                break;
            }
            default: {
                this.daf.setBuildFile("build.xml");
                this.fCreator.setMacroName("build.vm");
            }
        }
        this.setVelocityContext();
        if (this.br != 2 && this.br != 3) {
            this.fCreator.createBuildFile();
        }
        this.result.setBuildLogPath(this.daf.getLogFile());
        this.result.setBuildActionRC(this.br);
        return this.result;
    }

    private void setVelocityContext() {
        IDevelopmentComponentInfo componentInfo = this.buildInfo.getDevelopmentComponentInfo();
        ArrayList AntPropsDependJars = new ArrayList();
        ArrayList<ComponentDependencies> allDep = new ArrayList<ComponentDependencies>();
        String prebuildDir = this.daf.getTempDir() + File.separator + "pre";
        this.fCreator.setStrContext("dc_prebuild_Dir", prebuildDir);
        File prebuildDirF = new File(prebuildDir);
        if (prebuildDirF.exists()) {
            this.fCreator.setStrContext("dc_prebuild_Dir_exist", "true");
        }
        this.fCreator.setStrContext("dc_root_Dir", this.daf.getRootDir());
        this.fCreator.setListContext("dc_sourceDirs", this.daf.getSourceDirs());
        this.fCreator.setStrContext("dc_deployDir", this.daf.getGenDirDeploy());
        this.fCreator.setStrContext("dc_deployFile", this.daf.getDcFile());
        this.fCreator.setStrContext("dc_gen_tempDir", this.daf.getTempDir());
        this.fCreator.setStrContext("dc_gen_publicDir", this.daf.getGenDirPublic());
        List assDep = this.daf.getAssemblyDirs();
        this.fCreator.setListContext("dc_depend_assemblyDirs", assDep);
        this.jlinUtils.insertJlinContext(this.fCreator);
        String dcType = this.daf.getDCType();
        List compDep = this.daf.getDependencies();
        if (compDep != null) {
            Iterator it = compDep.iterator();
            while (it.hasNext()) {
                Dependency dep = (Dependency)it.next();
                if (dep.isForChildrenOnly()) continue;
                String name = dep.getComponent().getName();
                String vendor = dep.getComponent().getVendor();
                ComponentType type = null;
                DevelopmentComponent dc = this.daf.getReferencedComponent(dep);
                if (dc != null) {
                    type = dc.getComponentType();
                }
                if (type == null) {
                    allDep.add(new ComponentDependencies(name, vendor, dep.isAtDeployTime(), dep.isAtRunTime(), dep.getRuntimeQuialifier(), "", "", ""));
                } else {
                    allDep.add(new ComponentDependencies(name, vendor, dep.isAtDeployTime(), dep.isAtRunTime(), dep.getRuntimeQuialifier(), type.getVendor(), type.getType(), type.getSubType()));
                }
                boolean isCurrentDepDCExternal = dc.isExternal();
                boolean isAtBuildTimeDep = dep.isAtBuildTime();
                if (!isCurrentDepDCExternal || !isAtBuildTimeDep) continue;
                this.externalCompPP = this.collectExternalCompPP(dep);
            }
        }
        this.fCreator.setListContext("dc_jarSap_dep", allDep);
        this.fCreator.setStrContext("dc_jarSAP_scvendor", componentInfo.getCompartment().getScVendor());
        this.fCreator.setStrContext("dc_jarSAP_scname", componentInfo.getCompartment().getScName());
        this.fCreator.setListContext("dc_depend_externalCompileDirs", this.externalCompPP);
        this.fCreator.setStrContext("dc_jarSAP_name", this.daf.getDCName());
        this.fCreator.setStrContext("dc_jarSAP_vendor", this.daf.getDCVendor());
        this.fCreator.setStrContext("dc_jarSAP_scvendor", componentInfo.getCompartment().getScVendor());
        this.fCreator.setStrContext("dc_jarSAP_scname", componentInfo.getCompartment().getScName());
        this.fCreator.setStrContext("dc_jarSAP_location", this.daf.getCBSLocation());
        this.fCreator.setStrContext("dc_jarSAP_counter", this.daf.getCBSCounter());
        this.fCreator.setListContext("dc_jarSap_dep", allDep);
        String kernelFileName = this.daf.getRootDir() + File.separator + "cfg" + File.separator + "kernel.properties";
        this.readPropertiesFile(kernelFileName);
    }

    public BuildActionResult getBuildActionResult() {
        return this.result;
    }

    public BuildActionSeverity getBuildActionSeverity() {
        return this.severity;
    }

    public void setBuildActionSeverity(BuildActionSeverity _severity) {
        this.severity = _severity;
    }

    public String getCaption() {
        return "Create Build file";
    }

    private void readPropertiesFile(String fileName) {
        File file = new File(fileName);
        if (!file.exists()) {
            loc.infoT(fileName + " file doesn't exist - can not collect the needed information for building Engine Kernel DC");
        } else {
            try {
                FileInputStream in = new FileInputStream(file);
                Properties ppProps = new Properties();
                HashMap<String, String> serverJars = new HashMap<String, String>();
                HashMap<String, String> dispatcherJars = new HashMap<String, String>();
                ppProps.load(in);
                in.close();
                Enumeration<?> keys = ppProps.propertyNames();
                while (keys.hasMoreElements()) {
                    String key = (String)keys.nextElement();
                    String value = ppProps.getProperty(key).trim();
                    key = key.substring(0, key.lastIndexOf("."));
                    if (value.startsWith("server")) {
                        serverJars.put(key, value);
                        continue;
                    }
                    if (!value.startsWith("dispatcher")) continue;
                    dispatcherJars.put(key, value);
                }
                this.fCreator.setHashMapContext("dc_server_jarsLocations", serverJars);
                this.fCreator.setHashMapContext("dc_dispatcher_jarsLocations", dispatcherJars);
            }
            catch (FileNotFoundException fnf) {
                String msg = fileName + " file doesn't exist - can not collect the needed information for building Engine Kernel DC";
                loc.traceThrowableT(500, msg, (Throwable)fnf);
                this.br = 2;
            }
            catch (IOException ioe) {
                String msg = "problem occurred while reading " + fileName + " file";
                loc.traceThrowableT(500, msg, (Throwable)ioe);
            }
        }
    }

    private List collectExternalCompPP(Dependency dep) {
        DevelopmentComponent dc = this.daf.getReferencedComponent(dep);
        DCReference dcRef = dep.getComponent();
        Map pps = dc.getPublicParts();
        Iterator iter = pps.values().iterator();
        boolean isAssPPAvailable = false;
        while (iter.hasNext()) {
            PublicPart currentPp = (PublicPart)iter.next();
            if (currentPp != null && currentPp.getPurpose().equals(PublicPart.Purpose.ASSEMBLY)) {
                isAssPPAvailable = true;
                break;
            }
            PPReference ppRef = dep.getPublicPartDependency();
            if (pps == null) continue;
            if (ppRef != null && ppRef.getName() != null) {
                PublicPart pp = (PublicPart)pps.get(ppRef.getName());
                if (pp != null && pp.getPurpose().equals(PublicPart.Purpose.ASSEMBLY) || pp == null || !pp.getPurpose().equals(PublicPart.Purpose.COMPILATION) || isAssPPAvailable) continue;
                String externalPPRef = this.buildInfo.getDevelopmentComponentInfo().getUsedPublicPartGenFolder(ppRef);
                this.externalCompPP.add(externalPPRef);
                continue;
            }
            pps = dc.getPublicParts();
            Iterator ppiter = pps.values().iterator();
            while (ppiter.hasNext()) {
                PublicPart pp = (PublicPart)ppiter.next();
                ppRef = new PPReference(pp.getName(), dcRef);
                if (pp == null || !pp.getPurpose().equals(PublicPart.Purpose.COMPILATION) || isAssPPAvailable) continue;
                ppRef = new PPReference(pp.getName(), dcRef);
                String externalPPRef = this.buildInfo.getDevelopmentComponentInfo().getUsedPublicPartGenFolder(ppRef);
                this.externalCompPP.add(externalPPRef);
            }
        }
        return this.externalCompPP;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

