/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.ui.property.element.stereotype;

import com.tssap.selena.internal.model.ui.StereotypeRegistryReader;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.ui.property.element.stereotype.IStereotypeDescriptor;
import com.tssap.selena.model.ui.property.element.stereotype.IStereotypeSupport;
import com.tssap.selena.model.ui.property.element.stereotype.StereotypeCellEditor;
import com.tssap.selena.model.ui.property.element.stereotype.StereotypeLabelProvider;
import com.tssap.selena.ui.internal.PropertySupport;
import java.util.ArrayList;
import java.util.StringTokenizer;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.jface.viewers.CellEditor;
import org.eclipse.jface.viewers.ILabelProvider;
import org.eclipse.swt.widgets.Composite;

public class StereotypeSupport
extends PropertySupport
implements IStereotypeSupport {
    private String[] defaultValues = new String[0];
    private String myMetaclass = null;
    private ILabelProvider labelProvider = null;

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        super.setInitializationData(config, propertyName, data);
        this.myMetaclass = config.getAttribute("metaclass");
        String values = config.getAttribute("values");
        if (values != null) {
            ArrayList<String> list = new ArrayList<String>();
            StringTokenizer st = new StringTokenizer(values, ",");
            while (st.hasMoreTokens()) {
                String value = st.nextToken().trim();
                list.add(value);
            }
            if (!list.isEmpty()) {
                this.defaultValues = new String[list.size()];
                list.toArray(this.defaultValues);
            }
        }
    }

    public String[] getValues(Element element) {
        PropertyEnumeration naturesProperties = element.getModel().properties("$nature");
        ArrayList<String> naturesAL = new ArrayList<String>();
        while (naturesProperties.hasMoreElements()) {
            naturesAL.add(naturesProperties.next().getValue());
        }
        String[] natures = new String[naturesAL.size()];
        naturesAL.toArray(natures);
        String metaclass = element.getPropertyValue("$metaclass");
        IStereotypeDescriptor[] customValues = StereotypeRegistryReader.getInstance().getStereotypes(metaclass, natures);
        ArrayList<String> allValues = new ArrayList<String>();
        int i = 0;
        while (i < this.defaultValues.length) {
            allValues.add(this.defaultValues[i]);
            ++i;
        }
        int i2 = 0;
        while (i2 < customValues.length) {
            if (!allValues.contains(customValues[i2].getName())) {
                allValues.add(customValues[i2].getName());
            }
            ++i2;
        }
        String[] ret = new String[allValues.size()];
        allValues.toArray(ret);
        return ret;
    }

    public CellEditor createPropertyEditor(Composite parent) {
        StereotypeCellEditor editor = new StereotypeCellEditor(parent, this);
        return editor;
    }

    public ILabelProvider getLabelProvider() {
        if (this.labelProvider == null) {
            this.labelProvider = new StereotypeLabelProvider();
        }
        return this.labelProvider;
    }
}

