/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.ui.property.element.stereotype;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.ui.property.element.stereotype.DefaultStereotypePropertyValue;
import com.tssap.selena.model.ui.property.element.stereotype.IStereotypePropertyValue;
import com.tssap.selena.model.ui.property.element.stereotype.IStereotypeSupport;
import com.tssap.selena.model.ui.property.element.stereotype.Messages;
import com.tssap.selena.ui.internal.celleditor.LabelDialogCellEditor;
import com.tssap.selena.ui.internal.celleditor.StereotypeTableDialog;
import java.util.StringTokenizer;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class StereotypeCellEditor
extends LabelDialogCellEditor {
    private static final String DIVIDER = ",";
    private IStereotypeSupport support = null;
    private Element element;

    public StereotypeCellEditor(Composite parent, IStereotypeSupport support) {
        super(parent);
        this.support = support;
    }

    protected Object openDialogBox(Control cellEditorWindow) {
        StereotypeTableDialog dialog = new StereotypeTableDialog(cellEditorWindow.getShell(), Messages.getString("StereotypeCellEditor.Values_for_Property___stereotype__1"));
        dialog.setStereotypes(this.support.getValues(this.element));
        Object ovalue = this.getValue();
        String svalue = null;
        Object[] values = new String[]{};
        if (ovalue instanceof IStereotypePropertyValue) {
            svalue = ((IStereotypePropertyValue)ovalue).getValue();
        }
        if (svalue != null) {
            StringTokenizer st = new StringTokenizer(svalue, DIVIDER);
            if (st.countTokens() > 0) {
                values = new String[st.countTokens()];
            }
            int i = 0;
            while (st.hasMoreTokens()) {
                String str = st.nextToken().trim();
                values[i] = str;
                ++i;
            }
        }
        dialog.setValues(values);
        int res = dialog.open();
        if (res != 0) {
            return svalue;
        }
        values = (String[])dialog.getValues();
        String result = "";
        int i = 0;
        while (i < values.length) {
            String val = ((String)values[i]).trim();
            if (!"".equals(val)) {
                result = result + (String)values[i];
                if (i < values.length - 1) {
                    result = result + DIVIDER;
                }
            }
            ++i;
        }
        if (result.endsWith(DIVIDER)) {
            result = result.substring(0, result.length() - DIVIDER.length());
        }
        return new DefaultStereotypePropertyValue(result, this.element);
    }

    protected void doSetValue(Object value) {
        if (value instanceof IStereotypePropertyValue) {
            IStereotypePropertyValue stereotypeProperty = (IStereotypePropertyValue)value;
            this.text.setText(stereotypeProperty.toString());
            this.element = stereotypeProperty.getElement();
        } else {
            this.text.setText("");
        }
    }

    protected Object doGetValue() {
        String widgetText = this.text.getText();
        if ("".equals(widgetText)) {
            return null;
        }
        DefaultStereotypePropertyValue value = new DefaultStereotypePropertyValue(widgetText, this.element);
        return value;
    }
}

