/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.ui.property.element.stereotype;

import com.tssap.selena.internal.model.ui.StereotypeRegistryReader;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.extension.PropertyGetProvider;
import com.tssap.selena.model.ui.property.element.stereotype.IStereotypeDescriptor;
import com.tssap.selena.model.util.EmptyEnumeration;
import com.tssap.selena.model.util.EnumerationConverter;
import com.tssap.selena.model.util.PropertyAdapter;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;

public class MandatoryStereotypesProvider
implements PropertyGetProvider {
    private static boolean lockGuard = false;

    public boolean isPropertyProviderApplicable(Element element, String propertyName) {
        return true;
    }

    public String getPropertyValue(Element element, String propertyName) {
        PropertyEnumeration props = this.properties(element, propertyName);
        if (props.hasMoreElements()) {
            return props.next().getValue();
        }
        return null;
    }

    public Property getProperty(Element element, String propertyName) {
        String propertyValue = this.getPropertyValue(element, propertyName);
        if (propertyValue == null) {
            return null;
        }
        return new PropertyAdapter(propertyName, propertyValue, element);
    }

    public PropertyEnumeration properties(Element element) {
        ArrayList arl = new ArrayList();
        return this.properties(element, "@stereotype");
    }

    public PropertyEnumeration properties(Element element, String propertyName) {
        PropertyEnumeration propertyEnumeration;
        if (lockGuard) {
            return null;
        }
        lockGuard = true;
        try {
            ArrayList<PropertyAdapter> addedValues = new ArrayList<PropertyAdapter>();
            String metaclass = element.getPropertyValue("$metaclass");
            PropertyEnumeration naturesProperties = element.getModel().properties("$nature");
            ArrayList<String> naturesAL = new ArrayList<String>();
            while (naturesProperties.hasMoreElements()) {
                naturesAL.add(naturesProperties.next().getValue());
            }
            String[] natures = new String[naturesAL.size()];
            naturesAL.toArray(natures);
            IStereotypeDescriptor[] stereotypes = StereotypeRegistryReader.getInstance().getStereotypes(metaclass, natures);
            if (stereotypes.length == 0) {
                PropertyEnumeration propertyEnumeration2 = EmptyEnumeration.getPropertyEnumeration();
                Object var13_11 = null;
                lockGuard = false;
                return propertyEnumeration2;
            }
            Collection modelValues = this.getModelStereotypes(element);
            int i = 0;
            while (i < stereotypes.length) {
                IStereotypeDescriptor stereotype = stereotypes[i];
                if (stereotype.isMandatory() && !modelValues.contains(stereotype.getName())) {
                    addedValues.add(new PropertyAdapter(propertyName, stereotype.getName(), element));
                }
                ++i;
            }
            propertyEnumeration = EnumerationConverter.toPropertyEnumeration(((AbstractList)addedValues).iterator());
        }
        catch (Throwable throwable) {
            Object var13_13 = null;
            lockGuard = false;
            throw throwable;
        }
        Object var13_12 = null;
        lockGuard = false;
        return propertyEnumeration;
    }

    private Collection getModelStereotypes(Element element) {
        PropertyEnumeration modelProperties = element.properties("@stereotype");
        ArrayList<String> modelValues = new ArrayList<String>(3);
        while (modelProperties.hasMoreElements()) {
            modelValues.add(modelProperties.next().getValue());
        }
        return modelValues;
    }

    public boolean hasProperty(Element element, String propertyName) {
        return this.getPropertyValue(element, propertyName) != null;
    }

    public boolean hasPropertyValue(Element element, String propertyName, String propertyValue) {
        PropertyEnumeration propertyEnumeration = this.properties(element, propertyName);
        while (propertyEnumeration.hasMoreElements()) {
            Property property = propertyEnumeration.next();
            String value = property.getValue();
            if (!(value == null ? value == propertyValue : value.equals(propertyValue))) continue;
            return true;
        }
        return false;
    }
}

