/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.ui.property.element.clazz;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.ui.property.element.GenericStringElementProperty;
import com.tssap.selena.model.ui.property.element.clazz.Messages;

public class VisibilityProperty
extends GenericStringElementProperty {
    private final String PUBLIC = "public";
    private final String PRIVATE = "private";
    private final String PROTECTED = "protected";
    private final String PACKAGE_LOCAL = "package local";

    public Object getValue() {
        if (this.getObject() instanceof Element) {
            Element element = (Element)this.getObject();
            if (element.hasProperty("$public")) {
                return "public";
            }
            if (element.hasProperty("$protected")) {
                return "protected";
            }
            if (element.hasProperty("$private")) {
                return "private";
            }
            return "package local";
        }
        return null;
    }

    public void setValue(Object value) {
        if (this.getObject() instanceof Element && value instanceof String) {
            Element element = (Element)this.getObject();
            if ("public".equals(value)) {
                element.setPropertyValue("$public", Boolean.TRUE.toString());
            } else if ("protected".equals(value)) {
                element.setPropertyValue("$protected", Boolean.TRUE.toString());
            } else if ("private".equals(value)) {
                element.setPropertyValue("$private", Boolean.TRUE.toString());
            } else {
                element.setPropertyValue("$public", null);
                element.setPropertyValue("$private", null);
                element.setPropertyValue("$protected", null);
            }
        }
    }

    public String isValidValue(Object value) {
        if (value instanceof String || value == null) {
            Element element = (Element)this.getObject();
            if ("public".equals(value)) {
                return element.canSetPropertyValue("$public", Boolean.TRUE.toString()) ? null : Messages.getString("VisibilityProperty.Can__t_set_this_value");
            }
            if ("protected".equals(value)) {
                return element.canSetPropertyValue("$protected", Boolean.TRUE.toString()) ? null : Messages.getString("VisibilityProperty.Can__t_set_this_value");
            }
            if ("private".equals(value)) {
                return element.canSetPropertyValue("$private", Boolean.TRUE.toString()) ? null : Messages.getString("VisibilityProperty.Can__t_set_this_value");
            }
            if ("package local".equals(value)) {
                return element.canSetPropertyValue("$public", Boolean.TRUE.toString()) && element.canSetPropertyValue("$protected", Boolean.TRUE.toString()) && element.canSetPropertyValue("$private", Boolean.TRUE.toString()) ? null : Messages.getString("VisibilityProperty.Can__t_set_this_value");
            }
            return Messages.getString("VisibilityProperty.Can__t_set_this_value");
        }
        return Messages.getString("VisibilityProperty.It_shoud_be___java.lang.String___value._6");
    }

    public boolean isReadonly(Object id) {
        return super.isReadonly(id);
    }
}

