/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.ui.property.element;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.ui.property.element.ElementProperty;
import com.tssap.selena.model.util.various.ReferenceResolver;
import java.util.StringTokenizer;

public abstract class EntityProperty
extends ElementProperty {
    private Object[] myObjects;
    private static final char SEPARATOR = ':';
    private static final String PREFIX = "#";
    private static final String HAS_PROPERTY_PREFIX = "#hasProperty:";
    private static final String NOT_HAS_PROPERTY_PREFIX = "#!hasProperty:";
    private static final String HAS_PROPERTY_VALUE_PREFIX = "#hasPropertyValue:";
    private static final String NOT_HAS_PROPERTY_VALUE_PREFIX = "#!hasPropertyValue:";
    private static final String HAS_NATURE = "#hasNature:";
    private static final String NOT_HAS_NATURE = "#!hasNature:";

    public void setObjects(Object[] objects) {
        this.myObjects = new Object[objects.length];
        int i = 0;
        while (i < objects.length) {
            this.myObjects[i] = objects[i] instanceof Element ? this.resolve((Element)objects[i]) : null;
            ++i;
        }
    }

    public Object[] getObjects() {
        return this.myObjects;
    }

    public boolean isApplicable() {
        if (this.myObjects != null && this.myObjects.length == 1 && this.myObjects[0] instanceof Entity) {
            Entity entity = (Entity)this.myObjects[0];
            if (entity.isDeleted()) {
                return false;
            }
            boolean flag = true;
            if (this.myCondition != null) {
                flag = this.checkConditions(entity, this.myCondition);
            }
            return flag && this.checkFilters((Element)((Entity)this.myObjects[0]));
        }
        return false;
    }

    public boolean isReadonly(Object id) {
        Object obj = this.getObject();
        if (obj != null && !((Element)obj).hasProperty(this.myReadOnlyFlagProperty)) {
            return super.isReadonly(id);
        }
        return true;
    }

    protected Object getObject() {
        if (this.myObjects != null && this.myObjects.length > 0) {
            return this.myObjects[0];
        }
        return null;
    }

    private boolean checkConditions(Entity entity, String conditions) {
        StringTokenizer st = new StringTokenizer(conditions, ",");
        while (st.hasMoreTokens()) {
            String condition = st.nextToken().trim();
            if (this.checkCondition(entity, condition)) continue;
            return false;
        }
        return true;
    }

    private boolean checkCondition(Entity entity, String condition) {
        if ("#class#".equals(condition)) {
            return !entity.hasProperty("$interface");
        }
        if ("#interface#".equals(condition)) {
            return entity.hasProperty("$interface");
        }
        if ("#inClass#".equals(condition)) {
            return !(entity = entity.getParent()).hasProperty("$interface");
        }
        if ("#inInterface#".equals(condition)) {
            entity = entity.getParent();
            return entity.hasProperty("$interface");
        }
        if ("#inner_element#".equals(condition)) {
            return entity.hasProperty("$innerElement");
        }
        if ("#!inner_element#".equals(condition)) {
            return !entity.hasProperty("$innerElement");
        }
        if ("#constructor#".equals(condition)) {
            return entity.hasProperty("$constructor");
        }
        if ("#!constructor#".equals(condition)) {
            return !entity.hasProperty("$constructor");
        }
        if ("#!primitive#".equals(condition)) {
            return entity.hasProperty("$typeReferencedElement");
        }
        if ("#!readOnly#".equals(condition)) {
            return !entity.hasProperty("$readOnly");
        }
        if (condition != null && condition.startsWith(HAS_PROPERTY_PREFIX)) {
            return EntityProperty.hasPropertyHelper(entity, condition, HAS_PROPERTY_PREFIX.length());
        }
        if (condition != null && condition.startsWith(NOT_HAS_PROPERTY_PREFIX)) {
            return !EntityProperty.hasPropertyHelper(entity, condition, NOT_HAS_PROPERTY_PREFIX.length());
        }
        if (condition != null && condition.startsWith(HAS_PROPERTY_VALUE_PREFIX)) {
            return EntityProperty.hasPropertyValueHelper(entity, condition, HAS_PROPERTY_VALUE_PREFIX.length());
        }
        if (condition != null && condition.startsWith(NOT_HAS_PROPERTY_VALUE_PREFIX)) {
            return !EntityProperty.hasPropertyValueHelper(entity, condition, NOT_HAS_PROPERTY_VALUE_PREFIX.length());
        }
        if (condition != null && condition.startsWith(HAS_NATURE)) {
            return EntityProperty.hasNatureHelper(entity.getModel(), condition, HAS_NATURE.length());
        }
        if (condition != null && condition.startsWith(NOT_HAS_NATURE)) {
            return !EntityProperty.hasNatureHelper(entity.getModel(), condition, HAS_NATURE.length());
        }
        return true;
    }

    private static boolean hasPropertyHelper(Entity entity, String condition, int offset) {
        int endIndex = condition.indexOf(PREFIX, offset);
        if (endIndex <= offset) {
            return false;
        }
        String name = condition.substring(offset, endIndex).trim();
        if (name.length() == 0) {
            return false;
        }
        return entity.hasProperty(name);
    }

    private static boolean hasPropertyValueHelper(Entity entity, String condition, int offset) {
        int endIndex = condition.indexOf(PREFIX, offset);
        if (endIndex <= offset) {
            return false;
        }
        String nameValue = condition.substring(offset, endIndex);
        int sepIndex = nameValue.indexOf(58);
        if (sepIndex < 1) {
            return false;
        }
        String name = nameValue.substring(0, sepIndex).trim();
        if (name.length() == 0) {
            return false;
        }
        String value = sepIndex == nameValue.length() - 1 ? null : nameValue.substring(sepIndex + 1);
        return entity.hasPropertyValue(name, value);
    }

    private static boolean hasNatureHelper(Model model, String condition, int offset) {
        int endIndex = condition.indexOf(PREFIX, offset);
        if (endIndex <= offset) {
            return false;
        }
        String nature = condition.substring(offset, endIndex).trim();
        if (nature.length() == 0) {
            return false;
        }
        return model.hasPropertyValue("$nature", nature);
    }

    private Entity resolve(Element element) {
        if (element instanceof Entity) {
            return (Entity)element;
        }
        return ReferenceResolver.resolve((Reference)((Reference)element));
    }
}

