/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.ui.property.element;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.ui.property.ConfigurableProperty;
import com.tssap.selena.model.util.ModelUinSupport;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;

public abstract class ElementProperty
extends ConfigurableProperty {
    private String myNature;
    private String myStereotype;
    private int myOverrideRank;

    public void setConfigurationElement(Object element) {
        super.setConfigurationElement(element);
        IConfigurationElement[] filterConfigElements = this.myConfigurationElement.getChildren("filter");
        int i = 0;
        while (i < filterConfigElements.length) {
            String attribute = filterConfigElements[i].getAttribute("nature");
            if (attribute != null) {
                this.myNature = attribute;
            }
            if ((attribute = filterConfigElements[i].getAttribute("stereotype")) != null) {
                this.myStereotype = attribute;
            }
            ++i;
        }
    }

    public Integer getOverrideRank() {
        return new Integer(this.myOverrideRank);
    }

    protected boolean checkFilters(Element element) {
        this.myOverrideRank = 0;
        if (this.myNature != null) {
            boolean hasNature;
            IProject project = ModelUinSupport.getProject((UniqueName)element.getModel().getUniqueName());
            try {
                hasNature = project.hasNature(this.myNature);
            }
            catch (CoreException e) {
                hasNature = false;
            }
            if (hasNature) {
                ++this.myOverrideRank;
            } else {
                return false;
            }
        }
        if (this.myStereotype != null) {
            boolean hasStereotype = false;
            PropertyEnumeration stereotypes = element.properties("@stereotype");
            while (stereotypes.hasMoreElements()) {
                if (!this.myStereotype.equals(stereotypes.next().getValue())) continue;
                hasStereotype = true;
                break;
            }
            if (hasStereotype) {
                ++this.myOverrideRank;
            } else {
                return false;
            }
        }
        return true;
    }
}

