/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.ui.property;

import com.tssap.selena.internal.model.ui.Util;
import com.tssap.selena.model.ui.property.ConfigurableProperySet;
import com.tssap.selena.model.ui.property.IPropertySet;

public abstract class ConfigurableProperty
extends ConfigurableProperySet {
    private String myName = "no name";
    private String myAlias = null;
    private String mySupport;
    private String myGroup;
    private boolean myIsReadOnly = false;
    protected String myCondition;
    protected String myReadOnlyFlagProperty = "$readOnly";
    private String myDescription;
    private String[] myFilterFlags;
    private String myHelpContextIds;
    private static String CONDITION = "condition";
    private static String READ_ONLY_FLAG_PROPERTY = "readOnlyFlagProperty";

    public void setConfigurationElement(Object element) {
        super.setConfigurationElement(element);
        String attribute = this.myConfigurationElement.getAttribute("name");
        if (attribute != null) {
            this.myName = attribute;
        } else {
            Util.skippedMsg("name", this);
        }
        attribute = this.myConfigurationElement.getAttribute("support");
        if (attribute != null) {
            this.mySupport = attribute;
        }
        if ((attribute = this.myConfigurationElement.getAttribute("group")) != null) {
            this.myGroup = attribute;
        }
        if ((attribute = this.myConfigurationElement.getAttribute("readOnly")) != null) {
            this.myIsReadOnly = "true".equals(attribute);
        }
        if ((attribute = this.myConfigurationElement.getAttribute("description")) != null) {
            this.myDescription = attribute;
        }
        if ((attribute = this.myConfigurationElement.getAttribute(CONDITION)) != null) {
            this.myCondition = attribute;
        }
        if ((attribute = this.myConfigurationElement.getAttribute(READ_ONLY_FLAG_PROPERTY)) != null) {
            this.myReadOnlyFlagProperty = attribute;
        }
        if ((attribute = this.myConfigurationElement.getAttribute("filterFlags")) != null) {
            this.myFilterFlags = Util.str2Array(attribute);
        }
        if ((attribute = this.myConfigurationElement.getAttribute("helpContextIds")) != null) {
            this.myHelpContextIds = attribute;
        }
        if ((attribute = this.myConfigurationElement.getAttribute("alias")) != null) {
            this.myAlias = attribute;
        }
    }

    public boolean equalsTo(IPropertySet propertySet) {
        if (propertySet instanceof ConfigurableProperty) {
            ConfigurableProperty cPropertySet = (ConfigurableProperty)propertySet;
            if (this.myName.equals("alias") || cPropertySet.myName.equals("alias")) {
                boolean bl = false;
            }
            return cPropertySet.myName.equals(this.myName) && cPropertySet.myGroup.equals(this.myGroup);
        }
        return false;
    }

    public String getCategory(Object id) {
        return this.myGroup;
    }

    public String getDescription(Object id) {
        return this.myDescription;
    }

    public String getDisplayName(Object id) {
        if (this.myAlias != null) {
            return this.myAlias;
        }
        return this.myName;
    }

    public String[] getFilterFlags(Object id) {
        return this.myFilterFlags;
    }

    public String getHelpContextIds(Object id) {
        return this.myHelpContextIds;
    }

    public String getSupport(Object id) {
        return this.mySupport;
    }

    public boolean isReadonly(Object id) {
        return this.isReadonly();
    }

    public boolean isReadonly() {
        return this.myIsReadOnly;
    }

    public Object[] getIds() {
        return new Object[]{new Integer(this.hashCode())};
    }

    public Object getValue(Object id) {
        return this.getValue();
    }

    public String isValidValue(Object id, Object value) {
        return this.isValidValue(value);
    }

    public abstract Object getValue();

    public abstract String isValidValue(Object var1);

    public abstract void setValue(Object var1);

    public void setValue(Object id, Object value) {
        this.setValue(value);
    }
}

