/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.ui.preferences;

import com.tssap.selena.model.ui.ModelUIOptionsSupport;
import com.tssap.selena.model.ui.preferences.Messages;
import com.tssap.selena.ui.prefpages.PreferenceTabPage;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.ui.IWorkbench;

public class DeletePreferencePage
extends PreferenceTabPage {
    private Button myAlwaysDeleteFromModel;
    private Button myAlwaysDeleteFromView;
    private Button myShowConfirmation;

    public void init(IWorkbench workbench) {
    }

    protected IPreferenceStore doGetPreferenceStore() {
        return ModelUIOptionsSupport.getOptionsSupport().getPreferencesStore();
    }

    public boolean isValid() {
        if (this.myAlwaysDeleteFromView == null || this.myAlwaysDeleteFromModel == null) {
            return false;
        }
        return !this.myAlwaysDeleteFromView.getSelection() || !this.myAlwaysDeleteFromModel.getSelection();
    }

    public void performDefaults() {
        ModelUIOptionsSupport.getOptionsSupport().setBooleanOption("model.ui.option.delete_from_model", false);
        ModelUIOptionsSupport.getOptionsSupport().setBooleanOption("model.ui.option.delete_from_view", false);
        ModelUIOptionsSupport.getOptionsSupport().setBooleanOption("model.ui.option.skip_delete_confirmation", false);
        this.myAlwaysDeleteFromModel.setSelection(false);
        this.myAlwaysDeleteFromView.setSelection(false);
        this.myShowConfirmation.setSelection(true);
        this.myAlwaysDeleteFromModel.setEnabled(true);
        this.myAlwaysDeleteFromView.setEnabled(true);
        this.updateApplyButton();
    }

    public boolean performOk() {
        ModelUIOptionsSupport.getOptionsSupport().setBooleanOption("model.ui.option.delete_from_model", this.myAlwaysDeleteFromModel.getSelection());
        ModelUIOptionsSupport.getOptionsSupport().setBooleanOption("model.ui.option.delete_from_view", this.myAlwaysDeleteFromView.getSelection());
        ModelUIOptionsSupport.getOptionsSupport().setBooleanOption("model.ui.option.skip_delete_confirmation", !this.myShowConfirmation.getSelection());
        return true;
    }

    private Composite createGroup(Composite parent, String name) {
        Group group = new Group(parent, 0);
        group.setLayoutData((Object)new GridData(768));
        GridLayout layout = new GridLayout();
        group.setLayout((Layout)layout);
        group.setText(name);
        Composite result = new Composite((Composite)group, 0);
        result.setLayoutData((Object)new GridData(1808));
        layout = new GridLayout();
        layout.marginHeight = 0;
        layout.marginWidth = 0;
        result.setLayout((Layout)layout);
        return result;
    }

    protected Control createContents(Composite parent) {
        Composite confirms = this.createGroup(parent, Messages.getString("DeletePreferencePage.Confirmations"));
        this.myShowConfirmation = new Button(confirms, 32);
        this.myShowConfirmation.setText(Messages.getString("DeletePreferencePage.Show_confirmation_when_element_is_about_to_be_deleted"));
        this.myShowConfirmation.setSelection(!DeletePreferencePage.checkOption("model.ui.option.skip_delete_confirmation"));
        Control deletionModeGroup = this.createDeletionModeGroup(parent);
        return parent;
    }

    private Control createDeletionModeGroup(Composite parent) {
        Composite deletion = this.createGroup(parent, Messages.getString("DeletePreferencePage.Always_delete_from"));
        this.myAlwaysDeleteFromModel = new Button(deletion, 32);
        this.myAlwaysDeleteFromModel.setText(Messages.getString("DeletePreferencePage.Model"));
        this.myAlwaysDeleteFromModel.setSelection(DeletePreferencePage.checkOption("model.ui.option.delete_from_model"));
        this.myAlwaysDeleteFromView = new Button(deletion, 32);
        this.myAlwaysDeleteFromView.setText(Messages.getString("DeletePreferencePage.View_only"));
        this.myAlwaysDeleteFromView.setSelection(DeletePreferencePage.checkOption("model.ui.option.delete_from_view"));
        this.alwaysDeleteFromModelSelected();
        this.alwaysDeleteFromViewSelected();
        this.myAlwaysDeleteFromModel.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget == DeletePreferencePage.this.myAlwaysDeleteFromModel) {
                    DeletePreferencePage.this.alwaysDeleteFromModelSelected();
                }
            }
        });
        this.myAlwaysDeleteFromView.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                if (e.widget == DeletePreferencePage.this.myAlwaysDeleteFromView) {
                    DeletePreferencePage.this.alwaysDeleteFromViewSelected();
                }
            }
        });
        return deletion;
    }

    private void alwaysDeleteFromModelSelected() {
        if (this.myAlwaysDeleteFromModel.getSelection()) {
            this.myAlwaysDeleteFromView.setSelection(false);
        }
        this.myAlwaysDeleteFromView.setEnabled(!this.myAlwaysDeleteFromModel.getSelection());
    }

    private void alwaysDeleteFromViewSelected() {
        if (this.myAlwaysDeleteFromView.getSelection()) {
            this.myAlwaysDeleteFromModel.setSelection(false);
        }
        this.myAlwaysDeleteFromModel.setEnabled(!this.myAlwaysDeleteFromView.getSelection());
    }

    private static boolean checkOption(String optionKey) {
        return ModelUIOptionsSupport.getOptionsSupport().getBooleanOption(optionKey);
    }
}

