/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.ui.actions.common;

import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.enum.ReferenceEnumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class TreeReferenceTemplate {
    private Reference myTemplate;
    private HashMap mySubTemplates;

    TreeReferenceTemplate(Reference reference) {
        this.myTemplate = reference.getModel().createReferenceTemplate(reference);
        ReferenceEnumeration subReferences = reference.references();
        while (subReferences.hasMoreElements()) {
            ReferenceTemplateMatcher key;
            Reference next = subReferences.next();
            if (this.mySubTemplates == null) {
                this.mySubTemplates = new HashMap();
            }
            if ((key = new ReferenceTemplateMatcher(next)).isEmpty()) continue;
            this.mySubTemplates.put(key, new TreeReferenceTemplate(next));
        }
    }

    public Reference getReferenceTemplate() {
        return this.myTemplate;
    }

    public TreeReferenceTemplate getMatchedSubTemplate(Entity shouldMatch) {
        if (shouldMatch == null || this.mySubTemplates == null || this.mySubTemplates.isEmpty()) {
            return null;
        }
        Iterator entries = this.mySubTemplates.entrySet().iterator();
        while (entries.hasNext()) {
            Map.Entry nextEntry = entries.next();
            ReferenceTemplateMatcher nextMatcher = (ReferenceTemplateMatcher)nextEntry.getKey();
            if (!nextMatcher.match(shouldMatch)) continue;
            return (TreeReferenceTemplate)nextEntry.getValue();
        }
        return null;
    }

    private static class ReferenceTemplateMatcher {
        private Entity myEntityTemplate = null;

        public ReferenceTemplateMatcher(Reference reference) {
            Entity originalEntity = reference.getEntity();
            Model model = reference.getModel();
            if (model != null && originalEntity != null) {
                this.myEntityTemplate = model.createEntityTemplate(originalEntity);
                if (!this.myEntityTemplate.properties().hasMoreElements()) {
                    this.myEntityTemplate = null;
                }
            }
        }

        public final boolean equals(Object obj) {
            return obj == this;
        }

        public final int hashCode() {
            return System.identityHashCode(this);
        }

        public boolean isEmpty() {
            return this.myEntityTemplate == null;
        }

        public boolean match(Entity entity) {
            if (this.myEntityTemplate == null) {
                return false;
            }
            PropertyEnumeration cachedProperties = this.myEntityTemplate.properties();
            while (cachedProperties.hasMoreElements()) {
                Property nextCached = cachedProperties.next();
                if (entity.hasPropertyValue(nextCached.getName(), nextCached.getValue())) continue;
                return false;
            }
            return true;
        }
    }
}

