/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.ui.actions.common;

import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Property;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.enum.PropertyEnumeration;
import com.tssap.selena.model.enum.ReferenceEnumeration;
import com.tssap.selena.model.ui.IElementWrapper;
import com.tssap.selena.model.ui.actions.AbstractSelectionAwareAction;
import com.tssap.selena.model.ui.actions.common.TreeReferenceTemplate;
import com.tssap.selena.model.util.ReferencesUinSupport;
import com.tssap.selena.ui.IPropertyMarshaler;
import com.tssap.selena.ui.internal.ChromePlugin;
import java.util.HashMap;
import org.eclipse.draw2d.geometry.Point;
import org.eclipse.draw2d.geometry.Rectangle;

public class ReferencePropertyRestorer {
    private HashMap myCachedRectangles = new HashMap();
    private static ReferencePropertyRestorer ourInstance;
    static /* synthetic */ Class class$org$eclipse$draw2d$geometry$Rectangle;

    private ReferencePropertyRestorer() {
    }

    public static ReferencePropertyRestorer getInstance() {
        if (ourInstance == null) {
            ourInstance = new ReferencePropertyRestorer();
        }
        return ourInstance;
    }

    public TreeReferenceTemplate createTreeReferenceTemplate(Reference reference) {
        return reference == null ? null : new TreeReferenceTemplate(reference);
    }

    public TreeReferenceTemplate createTreeReferenceTemplate(IElementWrapper wrapper) {
        if (wrapper.getOriginalElement() instanceof Reference) {
            return new TreeReferenceTemplate((Reference)wrapper.getOriginalElement());
        }
        return null;
    }

    public Reference restoreReferenceProperties(ReferenceCollection collection, Entity copy, TreeReferenceTemplate originalTemplate, String newBoundsAsString) {
        Rectangle newBounds = this.getBounds(newBoundsAsString);
        return this.restoreReferenceProperties(collection, copy, originalTemplate, newBounds == null ? (Point)null : newBounds.getTopLeft());
    }

    public Reference restoreReferenceProperties(ReferenceCollection collection, Entity copy, TreeReferenceTemplate originalTemplate, Point newTopLeft) {
        if (collection == null || copy == null || originalTemplate == null) {
            return null;
        }
        this.translateTemplatePositions(originalTemplate, newTopLeft);
        Reference pastedReference = null;
        if (AbstractSelectionAwareAction.shouldAddShortcut(collection, copy)) {
            originalTemplate.getReferenceTemplate().setPropertyValue("$shortcutReference", Boolean.TRUE.toString());
            pastedReference = collection.addReference(copy, originalTemplate.getReferenceTemplate());
        } else {
            originalTemplate.getReferenceTemplate().setPropertyValue("$shortcutReference", null);
            pastedReference = ReferencesUinSupport.findReference((ReferenceCollection)collection, (Entity)copy);
        }
        if (pastedReference != null) {
            this.recursiveRestoreSubReferences(pastedReference, originalTemplate);
        }
        return pastedReference;
    }

    public Reference restoreReferenceProperties(Reference pastedReference, TreeReferenceTemplate originalTemplate, String newBoundsAsString) {
        Rectangle newBounds = this.getBounds(newBoundsAsString);
        return this.restoreReferenceProperties(pastedReference, originalTemplate, newBounds == null ? (Point)null : newBounds.getTopLeft());
    }

    public Reference restoreReferenceProperties(Reference pastedReference, TreeReferenceTemplate originalTemplate, Point newTopLeft) {
        if (pastedReference != null && originalTemplate != null) {
            this.translateTemplatePositions(originalTemplate, newTopLeft);
            this.recursiveRestoreSubReferences(pastedReference, originalTemplate);
        }
        return pastedReference;
    }

    private void recursiveRestoreSubReferences(Reference base, TreeReferenceTemplate cachedTreeTemplate) {
        if (base == null || cachedTreeTemplate == null) {
            return;
        }
        this.restoreSingleReferenceProperties(base, cachedTreeTemplate.getReferenceTemplate());
        ReferenceEnumeration baseChildren = base.references();
        while (baseChildren.hasMoreElements()) {
            Reference nextChild = baseChildren.next();
            TreeReferenceTemplate nextTreeTemplate = cachedTreeTemplate.getMatchedSubTemplate(nextChild.getEntity());
            if (nextTreeTemplate == null) continue;
            this.recursiveRestoreSubReferences(nextChild, nextTreeTemplate);
        }
    }

    private void restoreSingleReferenceProperties(Reference target, Reference cachedTemplate) {
        PropertyEnumeration cachedProperties = cachedTemplate.properties();
        while (cachedProperties.hasMoreElements()) {
            Property nextProperty = cachedProperties.next();
            String name = nextProperty.getName();
            String value = nextProperty.getValue();
            if (name == null || value == null) continue;
            if (!target.hasProperty(name)) {
                target.setPropertyValue(name, value);
                continue;
            }
            if (target.hasPropertyValue(name, value)) continue;
            target.addProperty(name, value);
        }
    }

    private void translateTemplatePositions(TreeReferenceTemplate treeTemplate, Point newTopLeft) {
        Rectangle cachedTemplateBounds;
        IPropertyMarshaler boundsMarshaller = ChromePlugin.getInstance().getPropertyMarshaler((Object)(class$org$eclipse$draw2d$geometry$Rectangle == null ? (class$org$eclipse$draw2d$geometry$Rectangle = ReferencePropertyRestorer.class$("org.eclipse.draw2d.geometry.Rectangle")) : class$org$eclipse$draw2d$geometry$Rectangle).getName());
        if (boundsMarshaller != null && newTopLeft != null && (cachedTemplateBounds = this.getBounds(treeTemplate.getReferenceTemplate().getPropertyValue("bounds"))) != null) {
            Rectangle newBounds = new Rectangle(newTopLeft, cachedTemplateBounds.getSize());
            treeTemplate.getReferenceTemplate().setPropertyValue("bounds", boundsMarshaller.marshal((Object)newBounds));
            return;
        }
        if (treeTemplate != null && treeTemplate.getReferenceTemplate() != null) {
            treeTemplate.getReferenceTemplate().setPropertyValue("bounds", null);
            treeTemplate.getReferenceTemplate().setPropertyValue("bounds_setted_by_user", null);
        }
    }

    private void translateTemplatePositions(TreeReferenceTemplate treeTemplate, Rectangle newBounds) {
        if (newBounds == null) {
            this.translateTemplatePositions(treeTemplate, (Point)null);
        } else {
            this.translateTemplatePositions(treeTemplate, newBounds.getTopLeft());
        }
    }

    public Rectangle getBounds(String asString) {
        if (asString == null) {
            return null;
        }
        Rectangle result = (Rectangle)this.myCachedRectangles.get(asString);
        if (result != null) {
            return result;
        }
        IPropertyMarshaler boundsMarshaller = ChromePlugin.getInstance().getPropertyMarshaler((Object)(class$org$eclipse$draw2d$geometry$Rectangle == null ? (class$org$eclipse$draw2d$geometry$Rectangle = ReferencePropertyRestorer.class$("org.eclipse.draw2d.geometry.Rectangle")) : class$org$eclipse$draw2d$geometry$Rectangle).getName());
        if (boundsMarshaller == null) {
            return null;
        }
        result = (Rectangle)boundsMarshaller.unmarshal(asString);
        if (result != null) {
            if (this.myCachedRectangles.size() >= 7) {
                this.myCachedRectangles.clear();
            }
            this.myCachedRectangles.put(asString, result);
        }
        return result;
    }

    static /* synthetic */ Class class$(String x0) {
        try {
            return Class.forName(x0);
        }
        catch (ClassNotFoundException x1) {
            throw new NoClassDefFoundError(x1.getMessage());
        }
    }
}

