/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.ui.actions.common;

import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.ui.DefaultElementWrapper;
import com.tssap.selena.model.ui.IElementWrapper;
import com.tssap.selena.model.ui.actions.AbstractSelectionAwareAction;
import com.tssap.selena.model.ui.actions.UnaryWrapperCondition;
import com.tssap.selena.model.ui.actions.common.ClipBoardBuffer;
import com.tssap.selena.model.ui.actions.common.ReferencePropertyRestorer;
import java.util.Iterator;
import org.eclipse.draw2d.geometry.Rectangle;
import org.eclipse.jface.action.IAction;

public class PasteShortcutAction
extends AbstractSelectionAwareAction {
    public void run(IAction action) {
        ModelAccess.runCommand((Runnable)new Runnable(){

            public void run() {
                Entity originalEntity = ClipBoardBuffer.getOriginalEntity();
                if (originalEntity == null || originalEntity.isDeleted()) {
                    return;
                }
                Iterator wrappers = PasteShortcutAction.super.selectedWrappersIterator();
                while (wrappers.hasNext()) {
                    UniqueName diagramUin;
                    String diagramUinStr;
                    IElementWrapper cur = (IElementWrapper)wrappers.next();
                    Entity selected = cur.getResolvedElement();
                    Reference shortcutTemplate = PasteShortcutAction.getShortcutTemplate(selected.getModel());
                    if (!(selected instanceof ReferenceCollection)) continue;
                    if ("Package".equals(originalEntity.getPropertyValue("$metaclass")) && (diagramUinStr = originalEntity.getPropertyValue("DiagramUIN")) != null && (diagramUin = ModelAccess.createUniqueName((String)diagramUinStr)) != null) {
                        originalEntity = originalEntity.getModel().findReferenceCollection(diagramUin);
                    }
                    if (originalEntity == null) continue;
                    Reference pastedReference = ((ReferenceCollection)selected).addReference(originalEntity, shortcutTemplate);
                    Rectangle pastedBounds = ReferencePropertyRestorer.getInstance().getBounds(cur.getUserProperty("bounds"));
                    ReferencePropertyRestorer.getInstance().restoreReferenceProperties(pastedReference, ClipBoardBuffer.getTreeReferenceTemplate(), pastedBounds == null ? null : pastedBounds.getTopLeft());
                }
            }
        });
    }

    protected boolean customIsChecked() {
        return false;
    }

    protected boolean customIsEnabled() {
        if (this.getSelection() == null || this.getSelection().isEmpty()) {
            return false;
        }
        Entity originalEntity = ClipBoardBuffer.getOriginalEntity();
        if (originalEntity == null || originalEntity.isDeleted()) {
            return false;
        }
        final Model originalModel = originalEntity.getModel();
        return this.checkConditionForAllSelected(new UnaryWrapperCondition(){

            public boolean check(DefaultElementWrapper wrapper) {
                String diagramUinStr;
                Entity originalEntity = ClipBoardBuffer.getOriginalEntity();
                if (originalEntity == null) {
                    return false;
                }
                if (originalEntity.getParent() != null && originalEntity.getParent().hasProperty("$design:entity_type")) {
                    return false;
                }
                Entity selected = wrapper.getResolvedElement();
                if (selected == null) {
                    return false;
                }
                if (!originalModel.equals(selected.getModel())) {
                    return false;
                }
                if ("Package".equals(originalEntity.getPropertyValue("$metaclass")) && (diagramUinStr = originalEntity.getPropertyValue("DiagramUIN")) == null) {
                    return false;
                }
                Reference shortcutTemplate = PasteShortcutAction.getShortcutTemplate(selected.getModel());
                if (selected instanceof ReferenceCollection && ((ReferenceCollection)selected).canAddReference(originalEntity, shortcutTemplate)) {
                    Entity diagramNode = selected.getParent();
                    return diagramNode.canCreateChildEntity(originalEntity.getPropertyValue("$metaclass"), null);
                }
                return false;
            }
        });
    }

    private static Reference getShortcutTemplate(Model model) {
        Reference result = model.createReferenceTemplate();
        result.setPropertyValue("$shortcutReference", Boolean.TRUE.toString());
        result.setPropertyValue("$imported", Boolean.TRUE.toString());
        return result;
    }
}

