/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.ui.actions.common;

import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.UniqueName;
import com.tssap.selena.model.ui.DefaultElementWrapper;
import com.tssap.selena.model.ui.IElementWrapper;
import com.tssap.selena.model.ui.actions.AbstractSelectionAwareAction;
import com.tssap.selena.model.ui.actions.UnaryElementCondition;
import com.tssap.selena.model.ui.actions.common.ClipBoardBuffer;
import com.tssap.selena.model.ui.actions.common.ReferencePropertyRestorer;
import com.tssap.selena.model.ui.actions.common.TreeReferenceTemplate;
import java.util.Iterator;
import org.eclipse.jface.action.IAction;

public class PasteElementAction
extends AbstractSelectionAwareAction {
    public void run(IAction action) {
        ModelAccess.runCommand((Runnable)new Runnable(){

            public void run() {
                Iterator wrappers = PasteElementAction.super.selectedWrappersIterator();
                while (wrappers.hasNext()) {
                    UniqueName diagramUin;
                    String diagramUinStr;
                    DefaultElementWrapper wrapper = (DefaultElementWrapper)wrappers.next();
                    Entity selected = wrapper.getResolvedElement();
                    Entity copiesParent = null;
                    if (selected instanceof ReferenceCollection) {
                        copiesParent = selected.getParent();
                        copiesParent.setPropertyValue("$ActiveDiagramUIN", selected.getUniqueName().toString());
                    } else if (selected instanceof Entity) {
                        copiesParent = selected;
                    }
                    Entity toPaste = ClipBoardBuffer.getClipboardCopy();
                    Element justCreatedCopy = copiesParent.paste((Element)toPaste);
                    copiesParent.setPropertyValue("$ActiveDiagramUIN", null);
                    if (!(justCreatedCopy instanceof Entity)) continue;
                    if ("Package".equals(justCreatedCopy.getPropertyValue("$metaclass")) && (diagramUinStr = justCreatedCopy.getPropertyValue("DiagramUIN")) != null && (diagramUin = ModelAccess.createUniqueName((String)diagramUinStr)) != null) {
                        justCreatedCopy = justCreatedCopy.getModel().findReferenceCollection(diagramUin);
                    }
                    if (justCreatedCopy == null) continue;
                    PasteElementAction.restoreReferenceProperties(wrapper, (Entity)justCreatedCopy);
                    PasteElementAction.super.setInplaceProperty((Entity)justCreatedCopy, wrapper);
                }
            }
        });
    }

    protected boolean customIsChecked() {
        return false;
    }

    protected boolean customIsEnabled() {
        if (this.changesIsDisabled()) {
            return false;
        }
        if (this.getSelection() == null || this.getSelection().size() != 1) {
            return false;
        }
        if (ClipBoardBuffer.isEmpty()) {
            return false;
        }
        return this.checkConditionForAllSelected(new UnaryElementCondition(){

            public boolean check(Element selected) {
                Entity copiesParent = null;
                if (selected instanceof ReferenceCollection) {
                    if (selected.equals(ClipBoardBuffer.getOriginalEntity())) {
                        return false;
                    }
                    copiesParent = selected.getParent();
                } else if (selected instanceof Entity) {
                    copiesParent = (Entity)selected;
                }
                return copiesParent instanceof Entity && copiesParent.canPaste((Element)ClipBoardBuffer.getClipboardCopy());
            }
        });
    }

    private static void restoreReferenceProperties(IElementWrapper targetWrapper, Entity copy) {
        ReferenceCollection collection = AbstractSelectionAwareAction.getTargetCollection(targetWrapper);
        if (collection == null) {
            return;
        }
        TreeReferenceTemplate originalTemplate = ClipBoardBuffer.getTreeReferenceTemplate();
        if (originalTemplate == null) {
            return;
        }
        originalTemplate.getReferenceTemplate().setPropertyValue("$imported", null);
        ReferencePropertyRestorer.getInstance().restoreReferenceProperties(collection, copy, originalTemplate, targetWrapper.getUserProperty("bounds"));
    }
}

