/*
 * Decompiled with CFR 0.152.
 */
package com.tssap.selena.model.ui.actions.common;

import com.tssap.selena.internal.model.ui.ModelUIPlugin;
import com.tssap.selena.model.elements.Element;
import com.tssap.selena.model.elements.Entity;
import com.tssap.selena.model.elements.Model;
import com.tssap.selena.model.elements.ModelAccess;
import com.tssap.selena.model.elements.Reference;
import com.tssap.selena.model.elements.ReferenceCollection;
import com.tssap.selena.model.elements.ReferenceContainer;
import com.tssap.selena.model.ui.IElementWrapper;
import com.tssap.selena.model.ui.actions.AbstractSelectionAwareAction;
import com.tssap.selena.model.ui.actions.UnaryElementCondition;
import java.util.Iterator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExecutableExtension;
import org.eclipse.jface.action.IAction;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;

public class NewElementAction
extends AbstractSelectionAwareAction
implements IExecutableExtension {
    public static final String ATTR_ADD_SHORTCUT = "addShortcut";
    public static final String ATTR_METACLASS = "metaclass";
    public static final String ATTR_NAVIGATE = "navigate";
    private String myElementMetaclass;
    private boolean myAlwaysAddShortcut;
    private String myNavigate;
    private String myPredefinedName = null;
    private IWorkbenchPage myActivePage;
    private static String NEVER = "never";
    private static String DEPEND = "depend";
    private static String ALWAYS = "always";

    protected boolean customIsEnabled() {
        if (this.changesIsDisabledForCreation()) {
            return false;
        }
        if (this.getSelection() == null || this.getSelection().size() != 1) {
            return false;
        }
        if (this.myElementMetaclass == null) {
            return false;
        }
        return this.checkConditionForAllSelected(new UnaryElementCondition(){

            public boolean check(Element element) {
                Entity container = NewElementAction.this.getContainer(element);
                return container != null && container.canCreateChildEntity(NewElementAction.this.myElementMetaclass, null);
            }
        });
    }

    protected boolean customIsChecked() {
        return false;
    }

    public void setActivePart(IAction action, IWorkbenchPart targetPart) {
        super.setActivePart(action, targetPart);
        this.myActivePage = targetPart.getSite().getPage();
    }

    public void run(IAction action) {
        ModelAccess.runCommand((Runnable)new Runnable(){

            public void run() {
                Iterator it = NewElementAction.super.selectedWrappersIterator();
                while (it.hasNext()) {
                    Object var10_10;
                    long startTime = System.currentTimeMillis();
                    IElementWrapper nextWrapper = (IElementWrapper)it.next();
                    Entity nextElement = nextWrapper.getResolvedElement();
                    Entity container = NewElementAction.this.getContainer((Element)nextElement);
                    if (nextElement instanceof ReferenceCollection) {
                        container.setPropertyValue("$ActiveDiagramUIN", nextElement.getUniqueName().toString());
                    }
                    Entity createdNode = null;
                    try {
                        Entity template;
                        if (NewElementAction.this.myPredefinedName != null) {
                            template = container.getModel().createEntityTemplate();
                            NewElementAction.this.configureTemplate(template);
                            createdNode = container.createChildEntity(NewElementAction.this.getElementMetaclass(), template);
                        } else {
                            template = NewElementAction.this.createTemplate(container.getModel());
                            createdNode = container.createChildEntity(NewElementAction.this.getElementMetaclass(), template);
                        }
                        var10_10 = null;
                    }
                    catch (Throwable throwable) {
                        var10_10 = null;
                        container.setPropertyValue("$ActiveDiagramUIN", null);
                        throw throwable;
                    }
                    container.setPropertyValue("$ActiveDiagramUIN", null);
                    System.err.println("entity created : " + (System.currentTimeMillis() - startTime));
                    startTime = System.currentTimeMillis();
                    if (createdNode == null) continue;
                    ReferenceContainer targetContainer = NewElementAction.access$301(nextWrapper);
                    NewElementAction.this.setProperties(createdNode, nextWrapper);
                    NewElementAction.this.navigateToMember(createdNode);
                    if (NewElementAction.getDefaultRC((Element)createdNode) != null) {
                        createdNode = NewElementAction.getDefaultRC((Element)createdNode);
                    }
                    Reference template = nextElement.getModel().createReferenceTemplate();
                    if (targetContainer instanceof Reference && ((Reference)targetContainer).getEntity() instanceof ReferenceCollection) {
                        ReferenceCollection targetCollection = (ReferenceCollection)((Reference)targetContainer).getEntity();
                        if (AbstractSelectionAwareAction.shouldAddShortcut(targetCollection, createdNode)) {
                            template.setPropertyValue("$shortcutReference", Boolean.TRUE.toString());
                        }
                        targetContainer = targetCollection;
                    } else if (targetContainer instanceof ReferenceCollection && AbstractSelectionAwareAction.shouldAddShortcut((ReferenceCollection)targetContainer, createdNode)) {
                        template.setPropertyValue("$shortcutReference", Boolean.TRUE.toString());
                    }
                    if (targetContainer != null) {
                        NewElementAction.this.addBoundsToReferenceTemplate(template, nextWrapper);
                        targetContainer.addReference(createdNode, template);
                    }
                    System.err.println("reference added : " + (System.currentTimeMillis() - startTime));
                }
            }
        });
    }

    protected void configureTemplate(Entity template) {
        template.setPropertyValue("$nametemplate", this.myPredefinedName);
    }

    protected Entity createTemplate(Model model) {
        return null;
    }

    public void setInitializationData(IConfigurationElement config, String propertyName, Object data) throws CoreException {
        IConfigurationElement[] entityName;
        this.myElementMetaclass = config.getAttribute(ATTR_METACLASS);
        this.myAlwaysAddShortcut = Boolean.TRUE.toString().equals(config.getAttribute(ATTR_ADD_SHORTCUT));
        this.myNavigate = NEVER;
        String attribute = config.getAttribute(ATTR_NAVIGATE);
        if (attribute != null) {
            this.myNavigate = attribute;
        }
        if ((entityName = config.getChildren("nametemplate")).length > 0) {
            this.myPredefinedName = entityName[0].getAttribute("value");
        }
    }

    protected Entity getContainer(Element element) {
        if (element instanceof ReferenceCollection) {
            return element.getParent();
        }
        return (Entity)element;
    }

    protected String getElementMetaclass() {
        return this.myElementMetaclass;
    }

    protected void setProperties(Entity justCreatedEntity, IElementWrapper parentWrapper) {
        this.setInplaceProperty(justCreatedEntity, parentWrapper);
    }

    protected void navigateToMember(Entity justCreatedEntity) {
        if (!NEVER.equals(this.myNavigate)) {
            if (DEPEND.equals(this.myNavigate)) {
                ModelUIPlugin.getDefault().openEditor((Element)justCreatedEntity, this.myActivePage, false);
            } else if (ALWAYS.equals(this.myNavigate)) {
                ModelUIPlugin.getDefault().openEditor((Element)justCreatedEntity, this.myActivePage, true);
            }
        }
    }

    protected void addBoundsToReferenceTemplate(Reference template, IElementWrapper wrapper) {
        if (template != null && wrapper != null && wrapper.getUserProperty("bounds") != null) {
            String bounds = wrapper.getUserProperty("bounds");
            template.setPropertyValue("bounds", bounds);
        }
    }

    private static ReferenceCollection getDefaultRC(Element element) {
        String defaultDiagramUin = element.getPropertyValue("DiagramUIN");
        if (defaultDiagramUin != null) {
            return element.getModel().findReferenceCollection(ModelAccess.createUniqueName((String)defaultDiagramUin));
        }
        return null;
    }

    static /* synthetic */ ReferenceContainer access$301(IElementWrapper x0) {
        return AbstractSelectionAwareAction.getTargetReferenceContainer(x0);
    }
}

